/*
 * Decompiled with CFR 0.152.
 */
package com.sun.midp.io.j2me.sms;

import java.io.ByteArrayOutputStream;

public class TextEncoder {
    protected static byte[] chars7Bit = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127};
    protected static byte[] escaped7BitChars = new byte[]{20, 40, 41, 47, 60, 61, 62, 64, 101};
    protected static char[] charsUCS2 = new char[]{'@', '\u00a3', '$', '\u00a5', '\u00e8', '\u00e9', '\u00f9', '\u00ec', '\u00f2', '\u00c7', '\n', '\u00d8', '\u00f8', '\r', '\u00c5', '\u00e5', '\u0394', '_', '\u03a6', '\u0393', '\u039b', '\u03a9', '\u03a0', '\u03a8', '\u03a3', '\u0398', '\u039e', '\u001b', '\u00c6', '\u00e6', '\u00df', '\u00c9', ' ', '!', '\"', '#', '\u00a4', '%', '&', '\'', '(', ')', '*', '+', ',', '-', '.', '/', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', ':', ';', '<', '=', '>', '?', '\u00a1', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '\u00c4', '\u00d6', '\u00d1', '\u00dc', '\u00a7', '\u00bf', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '\u00e4', '\u00f6', '\u00f1', '\u00fc', '\u00e0'};
    protected static char[] escapedUCS2 = new char[]{'^', '{', '}', '\\', '[', '~', ']', '|', '\u20ac'};

    public static byte[] encode(byte[] ucsbytes) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(ucsbytes.length);
        for (int i = 0; i < ucsbytes.length; i += 2) {
            int k;
            int j;
            for (j = 0; j < charsUCS2.length; ++j) {
                if (ucsbytes[i] != charsUCS2[j] >> 8 || ucsbytes[i + 1] != (charsUCS2[j] & 0xFF)) continue;
                bos.write(chars7Bit[j]);
                break;
            }
            if (j != charsUCS2.length) continue;
            for (k = 0; k < escapedUCS2.length; ++k) {
                if (ucsbytes[i] != escapedUCS2[k] >> 8 || ucsbytes[i + 1] != (escapedUCS2[k] & 0xFF)) continue;
                bos.write(27);
                bos.write(escaped7BitChars[k]);
                break;
            }
            if (k != escapedUCS2.length) continue;
            return null;
        }
        return bos.toByteArray();
    }

    public static byte[] decode(byte[] gsm7bytes) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(gsm7bytes.length * 2);
        block0: for (int i = 0; i < gsm7bytes.length; ++i) {
            int j;
            if (gsm7bytes[i] == 27) {
                ++i;
                for (j = 0; j < escaped7BitChars.length; ++j) {
                    if (gsm7bytes[i] != escaped7BitChars[j]) continue;
                    bos.write(escapedUCS2[j] >> 8);
                    bos.write(escapedUCS2[j] & 0xFF);
                    continue block0;
                }
                continue;
            }
            for (j = 0; j < chars7Bit.length; ++j) {
                if (gsm7bytes[i] != chars7Bit[j]) continue;
                bos.write(charsUCS2[j] >> 8);
                bos.write(charsUCS2[j] & 0xFF);
                continue block0;
            }
        }
        return bos.toByteArray();
    }

    public static String toString(byte[] ucsbytes) {
        char[] c = new char[ucsbytes.length / 2];
        for (int i = 0; i < ucsbytes.length; i += 2) {
            c[i / 2] = (char)((ucsbytes[i] << 8) + (ucsbytes[i + 1] & 0xFF));
        }
        return new String(c);
    }

    public static byte[] toByteArray(String data) {
        char[] c = data.toCharArray();
        ByteArrayOutputStream bos = new ByteArrayOutputStream(data.length());
        for (int i = 0; i < c.length; ++i) {
            bos.write(c[i] >> 8);
            bos.write(c[i] & 0xFF);
        }
        return bos.toByteArray();
    }
}

