/*
 * Decompiled with CFR 0.152.
 */
package com.sun.midp.lcdui;

class RecordedEvent {
    static final byte KEY_EVENT = 1;
    static final byte INPUT_METHOD_EVENT = 2;
    static final byte MENU_EVENT = 3;
    static final byte PEN_EVENT = 4;
    static final byte COMMAND_EVENT = 5;
    static final byte DELAY_DUMMY_EVENT = 6;
    byte type;
    int timeDelay;
    String inputString;
    int val1;
    int val2;
    int val3;
    private int lengthInBytes;

    RecordedEvent(int timeDelay) {
        this.type = (byte)6;
        this.timeDelay = timeDelay;
        this.lengthInBytes = 5;
    }

    RecordedEvent(int timeDelay, String input) {
        this.type = (byte)2;
        this.timeDelay = timeDelay;
        this.inputString = input;
        this.lengthInBytes = 5 + input.length();
    }

    RecordedEvent(int timeDelay, int type, int code) {
        this.type = 1;
        this.timeDelay = timeDelay;
        this.val1 = type;
        this.val2 = code;
        this.lengthInBytes = 13;
    }

    RecordedEvent(int timeDelay, int type, int x, int y) {
        this.type = (byte)4;
        this.timeDelay = timeDelay;
        this.val1 = type;
        this.val2 = x;
        this.val3 = y;
        this.lengthInBytes = 17;
    }

    RecordedEvent(int timeDelay, int type) {
        this.type = (byte)5;
        this.timeDelay = timeDelay;
        this.val1 = type;
        this.lengthInBytes = 9;
    }

    public byte[] getAsByte() {
        byte[] rawBytes = new byte[this.lengthInBytes];
        rawBytes[0] = this.type;
        int indexInByteArray = 1;
        indexInByteArray += RecordedEvent.intIntoBytes(rawBytes, this.timeDelay, indexInByteArray);
        switch (this.type) {
            case 1: {
                indexInByteArray += RecordedEvent.intIntoBytes(rawBytes, this.val1, indexInByteArray);
                indexInByteArray += RecordedEvent.intIntoBytes(rawBytes, this.val2, indexInByteArray);
                break;
            }
            case 2: {
                indexInByteArray += RecordedEvent.stringIntoBytes(rawBytes, this.inputString, indexInByteArray);
                break;
            }
            case 3: {
                for (int i = 0; i < this.lengthInBytes - 5; ++i) {
                    rawBytes[indexInByteArray++] = 0;
                }
                break;
            }
            case 4: {
                indexInByteArray += RecordedEvent.intIntoBytes(rawBytes, this.val1, indexInByteArray);
                indexInByteArray += RecordedEvent.intIntoBytes(rawBytes, this.val2, indexInByteArray);
                indexInByteArray += RecordedEvent.intIntoBytes(rawBytes, this.val3, indexInByteArray);
                break;
            }
            case 5: {
                indexInByteArray += RecordedEvent.intIntoBytes(rawBytes, this.val1, indexInByteArray);
                break;
            }
            case 6: {
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return rawBytes;
    }

    static RecordedEvent recreateRecordedEvent(byte[] byteArray, int offset, int length) {
        RecordedEvent returnEvent = null;
        int timeDelay = RecordedEvent.bytesToInt(byteArray, offset + 1);
        switch (byteArray[offset + 0]) {
            case 1: {
                returnEvent = new RecordedEvent(timeDelay, RecordedEvent.bytesToInt(byteArray, offset + 5), RecordedEvent.bytesToInt(byteArray, offset + 9));
                break;
            }
            case 2: {
                returnEvent = new RecordedEvent(timeDelay, new String(byteArray, offset + 5, length));
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                returnEvent = new RecordedEvent(timeDelay, RecordedEvent.bytesToInt(byteArray, offset + 5), RecordedEvent.bytesToInt(byteArray, offset + 9), RecordedEvent.bytesToInt(byteArray, offset + 13));
                break;
            }
            case 5: {
                returnEvent = new RecordedEvent(timeDelay, RecordedEvent.bytesToInt(byteArray, offset + 5));
                break;
            }
            case 6: {
                returnEvent = new RecordedEvent(timeDelay);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return returnEvent;
    }

    int lengthOfByteRep() {
        return this.lengthInBytes;
    }

    byte getType() {
        return this.type;
    }

    int getTimeDelay() {
        return this.timeDelay;
    }

    private static int intIntoBytes(byte[] byteArray, int intToConvert, int indexInByteArray) {
        byteArray[indexInByteArray] = (byte)(intToConvert >> 24 & 0xFF);
        byteArray[indexInByteArray + 1] = (byte)(intToConvert >> 16 & 0xFF);
        byteArray[indexInByteArray + 2] = (byte)(intToConvert >> 8 & 0xFF);
        byteArray[indexInByteArray + 3] = (byte)(intToConvert >> 0 & 0xFF);
        return 4;
    }

    private static int stringIntoBytes(byte[] byteArray, String string, int offsetInByteArray) {
        System.arraycopy(string.getBytes(), 0, byteArray, offsetInByteArray, string.length());
        return string.length();
    }

    private static int bytesToInt(byte[] byteArray, int offsetInByteArray) {
        int retVal = 0;
        retVal = (byteArray[offsetInByteArray] & 0xFF) << 24 | (byteArray[offsetInByteArray + 1] & 0xFF) << 16 | (byteArray[offsetInByteArray + 2] & 0xFF) << 8 | (byteArray[offsetInByteArray + 3] & 0xFF) << 0;
        return retVal;
    }
}

