/*
 * Decompiled with CFR 0.152.
 */
package com.sun.midp.midletsuite;

import com.sun.j2me.payment.PaymentException;
import com.sun.j2me.payment.PaymentInfo;
import com.sun.j2me.payment.PaymentModule;
import com.sun.kvem.payment.KvemPaymentModule;
import com.sun.midp.content.CHManager;
import com.sun.midp.io.Base64;
import com.sun.midp.io.HttpUrl;
import com.sun.midp.io.Util;
import com.sun.midp.io.j2me.push.PushRegistryImpl;
import com.sun.midp.io.j2me.storage.File;
import com.sun.midp.io.j2me.storage.RandomAccessStream;
import com.sun.midp.lcdui.Resource;
import com.sun.midp.main.Configuration;
import com.sun.midp.midlet.MIDletInfo;
import com.sun.midp.midlet.MIDletSuite;
import com.sun.midp.midlet.Scheduler;
import com.sun.midp.midletsuite.InstallListener;
import com.sun.midp.midletsuite.InstallState;
import com.sun.midp.midletsuite.InvalidJadException;
import com.sun.midp.midletsuite.JadProperties;
import com.sun.midp.midletsuite.JarReader;
import com.sun.midp.midletsuite.MIDletSuiteImpl;
import com.sun.midp.midletsuite.ManifestProperties;
import com.sun.midp.midletsuite.SecureInstaller;
import com.sun.midp.rms.RecordStoreFile;
import com.sun.midp.security.Permissions;
import com.sun.midp.security.SecurityToken;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Vector;
import javax.microedition.io.Connection;
import javax.microedition.io.ConnectionNotFoundException;
import javax.microedition.io.Connector;
import javax.microedition.io.HttpConnection;

public class Installer {
    public static final int DOWNLOADING_JAD = 1;
    public static final int DOWNLOADED_1K_OF_JAD = 2;
    public static final int DOWNLOADING_JAR = 3;
    public static final int DOWNLOADED_1K_OF_JAR = 4;
    public static final int VERIFYING_SUITE = 5;
    public static final int STORING_SUITE = 6;
    public static final String JAR_MANIFEST = "META-INF/MANIFEST.MF";
    public static final String DATA_SIZE_PROP = "MIDlet-Data-Size";
    public static final String JAR_SIZE_PROP = "MIDlet-Jar-Size";
    public static final String JAR_URL_PROP = "MIDlet-Jar-URL";
    public static final String SUITE_NAME_PROP = "MIDlet-Name";
    public static final String VENDOR_PROP = "MIDlet-Vendor";
    public static final String VERSION_PROP = "MIDlet-Version";
    public static final String DESC_PROP = "MIDlet-Description";
    public static final String NOTIFY_PROP = "MIDlet-Install-Notify";
    public static final String DELETE_PROP = "MIDlet-Delete-Notify";
    public static final String CONFIGURATION_PROP = "MicroEdition-Configuration";
    public static final String EXE_ENV_PROP = "Runtime-Execution-Environment";
    public static final String DEFAULT_ENVIRONMENT = "MIDP.CLDC";
    public static final String PROFILE_PROP = "MicroEdition-Profile";
    public static final String PERMISSIONS_PROP = "MIDlet-Permissions";
    public static final String PERMISSIONS_OPT_PROP = "MIDlet-Permissions-Opt";
    public static final String JAD_MT = "text/vnd.sun.j2me.app-descriptor";
    public static final String JAR_MT_1 = "application/java";
    public static final String JAR_MT_2 = "application/java-archive";
    private static final int MAX_DL_SIZE = 1024;
    private static final int RESENDING_ATTEMPTS = 5;
    private static final String BASIC_TAG = "basic";
    static final String CA_FILENAME = "CA.utf";
    static final String JAD_URL_FILENAME = "jadUrl.utf";
    static final String JAR_URL_FILENAME = "jarUrl.utf";
    static final String JAD_ENCODING_FILENAME = "jadEncoding.utf";
    static final String SETTINGS_FILENAME = "settings.bin";
    static final String JAR_FILENAME = "suite.jar";
    static final String JAD_FILENAME = "suite.jad";
    static final String PAY_FILENAME = "suite.pay";
    static final String JPP_FILENAME = "suite.jpp";
    static final String DELETE_NOTIFY_FILENAME = "_delete_notify.utf";
    static final String TMP_FILENAME = "installer.tmp";
    static final String MANIFEST_FILENAME = "suite.mf";
    public static final String ICON_FILENAME = "icon.png";
    static final String SUITE_LIST_FILENAME = "suites.utf";
    static final String SUCCESS_MSG = "900 Success";
    static final String INSUFFICIENT_MEM_MSG = "901 Insufficient Memory";
    static final String USER_CANCELLED_MSG = "902 User Cancelled";
    static final String JAR_SIZE_MISMATCH_MSG = "904 JAR size mismatch";
    static final String ATTRIBUTE_MISMATCH_MSG = "905 Attribute Mismatch";
    static final String INVALID_JAD_MSG = "906 Invalid Descriptor";
    static final String INVALID_JAR_MSG = "907 Invalid JAR";
    static final String INCOMPATIBLE_MSG = "908 Incompatible Configuration or Profile";
    static final String AUTHENTICATION_FAILURE_MSG = "909 Application authentication failure";
    static final String AUTHORIZATION_FAILURE_MSG = "910 Application authorization failure";
    static final String PUSH_REG_FAILURE_MSG = "911 Push registration failure";
    static final String DELETE_NOTIFICATION_MSG = "912 Deletion Notification";
    static final String CONTENT_HANDLER_CONFLICT = "938 Content handler conflicts with other handlers";
    static final String INVALID_CONTENT_HANDLER = "939 Content handler install failed";
    static final String UNSUPPORTED_PAYMENT_INFO = "944 Unsupported payment information";
    static final String INVALID_PAYMENT_INFO = "945 Invalid payment information";
    static final String UNTRUSTED_PAYMENT_SUITE = "946 Untrusted payment application";
    private static Installer myInstaller;
    private static SecurityToken classSecurityToken;
    private String nextMidletSuiteToRun;
    private String nextMidletToRun;
    private Vector midletSuiteList;
    private Vector deleteNotifyURLList;
    private HttpConnection httpConnection;
    private InputStream httpInputStream;
    protected InstallStateImpl state;
    private String cldcConfig;
    private Vector supportedProfiles;
    private String unsignedSecurityDomain = Permissions.UNTRUSTED_DOMAIN_NAME;
    private static final String PROPERTY_DIR_PRIVATE = "fileconn.dir.private";
    public static final String FILESYSTEM = "filesystem";
    public static final String PRIV_DIR_KEYWORD = "privdir";
    public static final String ROOT_DIR = "root1";

    public static void initSecurityToken(SecurityToken token) {
        if (classSecurityToken != null) {
            return;
        }
        classSecurityToken = token;
        MIDletSuiteImpl.initSecurityToken(classSecurityToken);
    }

    public static void saveSuiteSettings(SecurityToken token, String suiteStorageRoot, byte pushInterruptSetting, byte[][] permissions, boolean trusted) throws IOException {
        Installer.saveSuiteSettings(new RandomAccessStream(token), suiteStorageRoot, pushInterruptSetting, permissions, trusted);
    }

    public static void saveSuiteSettings(String suiteStorageRoot, byte pushInterruptSetting, byte[][] permissions, boolean trusted) throws IOException {
        Installer.saveSuiteSettings(new RandomAccessStream(), suiteStorageRoot, pushInterruptSetting, permissions, trusted);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void saveSuiteSettings(RandomAccessStream storage, String suiteStorageRoot, byte pushInterruptSetting, byte[][] permissions, boolean trusted) throws IOException {
        byte[] maximums = permissions[0];
        byte[] currentLevels = permissions[1];
        storage.connect(suiteStorageRoot + SETTINGS_FILENAME, -3);
        try {
            int i;
            DataOutputStream storageStream = storage.openDataOutputStream();
            storageStream.writeByte(1);
            storageStream.writeBoolean(trusted);
            storageStream.writeByte(pushInterruptSetting);
            storageStream.writeByte(currentLevels.length);
            for (i = 0; i < currentLevels.length; ++i) {
                storageStream.writeByte(currentLevels[i]);
            }
            storageStream.writeByte(maximums.length);
            for (i = 0; i < maximums.length; ++i) {
                storageStream.writeByte(maximums[i]);
            }
        }
        finally {
            try {
                storage.disconnect();
            }
            catch (IOException e) {}
        }
    }

    public static Installer getInstaller() throws SecurityException {
        MIDletSuite midletSuite = Scheduler.getScheduler().getMIDletSuite();
        if (midletSuite != null) {
            midletSuite.checkIfPermissionAllowed(1);
        }
        return Installer.getInstallerCommon();
    }

    public static Installer getInstaller(SecurityToken securityToken) throws SecurityException {
        securityToken.checkIfPermissionAllowed(1);
        return Installer.getInstallerCommon();
    }

    private static Installer getInstallerCommon() {
        if (myInstaller != null) {
            return myInstaller;
        }
        String nameOfInstaller = Configuration.getProperty("com.sun.midp.midletsuite.installer");
        if (nameOfInstaller == null) {
            myInstaller = new SecureInstaller();
            return myInstaller;
        }
        try {
            myInstaller = (Installer)Class.forName(nameOfInstaller).newInstance();
            return myInstaller;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public static String makeStorageName(String vendorName, String appName) {
        return File.unicodeToAsciiFilename(vendorName) + '_' + File.unicodeToAsciiFilename(appName) + '_';
    }

    protected Installer() {
        if (myInstaller != null) {
            throw new SecurityException("Illegal instantiation of the Installer");
        }
    }

    public String installJad(String location, boolean force, boolean removeRMS, InstallListener installListener) throws IOException, InvalidJadException, SecurityException {
        this.state = new InstallStateImpl();
        this.state.jadUrl = location;
        this.state.force = force;
        this.state.removeRMS = removeRMS;
        this.state.nextStep = 1;
        this.state.listener = installListener;
        this.state.chinstaller = CHManager.newInstance();
        return this.performInstall();
    }

    public String installJar(String location, boolean force, boolean removeRMS, InstallListener installListener) throws IOException, InvalidJadException, SecurityException {
        if (location == null || location.length() == 0) {
            throw new IllegalArgumentException("Must specify URL of .jar file");
        }
        this.state = new InstallStateImpl();
        this.state.jarUrl = location;
        this.state.force = force;
        this.state.removeRMS = removeRMS;
        this.state.nextStep = 4;
        this.state.listener = installListener;
        this.state.chinstaller = CHManager.newInstance();
        return this.performInstall();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized String performInstall() throws IOException, InvalidJadException {
        PushRegistryImpl.enablePushLaunch(classSecurityToken, false);
        try {
            this.state.startTime = System.currentTimeMillis();
            while (this.state.nextStep < 7) {
                this.state.exception = null;
                if (this.state.stopInstallation) {
                    this.postInstallMsgBackToProvider(USER_CANCELLED_MSG);
                    throw new IOException("stopped");
                }
                switch (this.state.nextStep) {
                    case 1: {
                        this.installStep1();
                        break;
                    }
                    case 2: {
                        this.installStep2();
                        break;
                    }
                    case 3: {
                        this.installStep3();
                        break;
                    }
                    case 4: {
                        this.installStep4();
                        break;
                    }
                    case 5: {
                        this.installStep5();
                        break;
                    }
                    case 6: {
                        this.installStep6();
                    }
                }
                if (this.state.exception == null) continue;
                if (this.state.listener == null) {
                    throw this.state.exception;
                }
                if (this.state.listener.warnUser(this.state)) continue;
                this.state.stopInstallation = true;
                this.postInstallMsgBackToProvider(USER_CANCELLED_MSG);
                throw this.state.exception;
            }
        }
        finally {
            PushRegistryImpl.enablePushLaunch(classSecurityToken, true);
        }
        return this.state.storageName;
    }

    private void installStep1() throws IOException, InvalidJadException {
        if (this.state.jadUrl == null || this.state.jadUrl.length() == 0) {
            throw new IllegalArgumentException("Must specify URL of .jad file");
        }
        this.state.jad = this.downloadJAD();
        if (this.state.exception != null) {
            return;
        }
        this.state.jadProps = new JadProperties();
        try {
            this.state.jadProps.load(new ByteArrayInputStream(this.state.jad), this.state.jadEncoding);
        }
        catch (InvalidJadException ije) {
            this.postInstallMsgBackToProvider(INVALID_JAD_MSG);
            throw ije;
        }
        this.state.suiteName = this.state.jadProps.getProperty(SUITE_NAME_PROP);
        if (this.state.suiteName == null || this.state.suiteName.length() == 0) {
            this.postInstallMsgBackToProvider(INVALID_JAD_MSG);
            throw new InvalidJadException(13);
        }
        this.state.vendor = this.state.jadProps.getProperty(VENDOR_PROP);
        if (this.state.vendor == null || this.state.vendor.length() == 0) {
            this.postInstallMsgBackToProvider(INVALID_JAD_MSG);
            throw new InvalidJadException(14);
        }
        this.state.version = this.state.jadProps.getProperty(VERSION_PROP);
        if (this.state.version == null || this.state.version.length() == 0) {
            this.postInstallMsgBackToProvider(INVALID_JAD_MSG);
            throw new InvalidJadException(15);
        }
        this.state.storageName = Installer.makeStorageName(this.state.vendor, this.state.suiteName);
        this.checkPreviousVersion();
        ++this.state.nextStep;
    }

    private void installStep2() {
        ++this.state.nextStep;
        if (this.state.isPreviousVersion) {
            this.checkForDifferentDomains(this.state.jadUrl);
        }
    }

    private void installStep3() throws IOException, InvalidJadException {
        int dataSize;
        String sizeString = this.state.jadProps.getProperty(JAR_SIZE_PROP);
        if (sizeString == null) {
            this.postInstallMsgBackToProvider(INVALID_JAD_MSG);
            throw new InvalidJadException(21);
        }
        try {
            this.state.expectedJarSize = Integer.parseInt(sizeString);
        }
        catch (NumberFormatException e) {
            this.postInstallMsgBackToProvider(INVALID_JAD_MSG);
            throw new InvalidJadException(29);
        }
        sizeString = this.state.jadProps.getProperty(DATA_SIZE_PROP);
        if (sizeString == null) {
            dataSize = 0;
        } else {
            try {
                dataSize = Integer.parseInt(sizeString);
            }
            catch (NumberFormatException e) {
                this.postInstallMsgBackToProvider(INVALID_JAD_MSG);
                throw new InvalidJadException(29);
            }
        }
        int suiteSize = this.state.expectedJarSize + this.state.jad.length * 2 + this.state.jadUrl.length() * 3 + dataSize;
        this.state.file = new File(classSecurityToken);
        if (suiteSize > this.state.file.getBytesAvailableForFiles()) {
            this.postInstallMsgBackToProvider(INSUFFICIENT_MEM_MSG);
            throw new InvalidJadException(30, Integer.toString((suiteSize + 1023) / 1024));
        }
        this.state.jarUrl = this.state.jadProps.getProperty(JAR_URL_PROP);
        if (this.state.jarUrl == null || this.state.jarUrl.length() == 0) {
            this.postInstallMsgBackToProvider(INVALID_JAD_MSG);
            throw new InvalidJadException(18);
        }
        if (this.state.jadProps.getProperty("Pay-Version") != null && System.getProperty("sun.payment.latevalidation") == null) {
            try {
                PaymentInfo.validateJadProperties(this.state.jadProps);
            }
            catch (PaymentException e) {
                switch (e.getReason()) {
                    case 0: 
                    case 3: {
                        this.postInstallMsgBackToProvider(UNSUPPORTED_PAYMENT_INFO);
                        throw new InvalidJadException(56, e.getMessage());
                    }
                }
                this.postInstallMsgBackToProvider(INVALID_PAYMENT_INFO);
                throw new InvalidJadException(57, e.getMessage());
            }
        }
        if (this.state.listener != null && !this.state.listener.confirmJarDownload(this.state)) {
            this.state.stopInstallation = true;
            this.postInstallMsgBackToProvider(USER_CANCELLED_MSG);
            throw new IOException("stopped");
        }
        ++this.state.nextStep;
    }

    private void installStep4() throws IOException, InvalidJadException {
        block36: {
            this.state.storageRoot = File.getStorageRoot();
            this.state.tempFilename = this.state.storageRoot + TMP_FILENAME;
            int bytesDownloaded = this.downloadJAR(this.state.tempFilename);
            if (this.state.exception != null) {
                return;
            }
            if (this.state.listener != null) {
                this.state.listener.updateStatus(5, this.state);
            }
            try {
                String midlet;
                this.state.storage = new RandomAccessStream(classSecurityToken);
                try {
                    this.verifyJar(this.state.storage, this.state.tempFilename);
                }
                catch (InvalidJadException ije) {
                    this.postInstallMsgBackToProvider(AUTHENTICATION_FAILURE_MSG);
                    throw ije;
                }
                try {
                    this.state.manifest = JarReader.readJarEntry(classSecurityToken, this.state.tempFilename, JAR_MANIFEST);
                    if (this.state.manifest == null) {
                        this.postInstallMsgBackToProvider(INVALID_JAR_MSG);
                        throw new InvalidJadException(36, JAR_MANIFEST);
                    }
                    this.state.jarProps = new ManifestProperties();
                    this.state.jarProps.load(new ByteArrayInputStream(this.state.manifest));
                    String suiteIconPath = this.state.getProperty("MIDlet-Icon");
                    if (suiteIconPath != null) {
                        if (suiteIconPath.startsWith("/")) {
                            suiteIconPath = suiteIconPath.substring(1);
                        }
                        this.state.suiteIcon = JarReader.readJarEntry(classSecurityToken, this.state.tempFilename, suiteIconPath);
                    }
                }
                catch (IOException ioe) {
                    this.postInstallMsgBackToProvider(INVALID_JAR_MSG);
                    throw new InvalidJadException(36, JAR_MANIFEST);
                }
                int i = 1;
                while ((midlet = this.state.getAppProperty("MIDlet-" + i)) != null) {
                    try {
                        MIDletInfo midletInfo = new MIDletInfo(midlet);
                        this.verifyMIDlet(midletInfo.classname);
                    }
                    catch (InvalidJadException ije) {
                        if (ije.getReason() == 29) {
                            this.postInstallMsgBackToProvider(INVALID_JAD_MSG);
                        } else {
                            this.postInstallMsgBackToProvider(INVALID_JAR_MSG);
                        }
                        throw ije;
                    }
                    ++i;
                }
                ++this.state.nextStep;
                if (this.state.jadUrl != null) {
                    if (bytesDownloaded != this.state.expectedJarSize) {
                        this.postInstallMsgBackToProvider(JAR_SIZE_MISMATCH_MSG);
                        throw new InvalidJadException(31);
                    }
                    if (!this.state.suiteName.equals(this.state.jarProps.getProperty(SUITE_NAME_PROP))) {
                        this.postInstallMsgBackToProvider(ATTRIBUTE_MISMATCH_MSG);
                        throw new InvalidJadException(25);
                    }
                    if (!this.state.version.equals(this.state.jarProps.getProperty(VERSION_PROP))) {
                        this.postInstallMsgBackToProvider(ATTRIBUTE_MISMATCH_MSG);
                        throw new InvalidJadException(26);
                    }
                    if (!this.state.vendor.equals(this.state.jarProps.getProperty(VENDOR_PROP))) {
                        this.postInstallMsgBackToProvider(ATTRIBUTE_MISMATCH_MSG);
                        throw new InvalidJadException(27);
                    }
                    if (this.state.ca != null) {
                        String strProp = System.getProperty("com.sun.midp.installer.checkJarPermissions");
                        boolean checkJarPermissions = strProp == null || !strProp.equals("false");
                        String permissionsProps = this.state.jadProps.getProperty(PERMISSIONS_PROP);
                        if (permissionsProps != null) {
                            if (!permissionsProps.equals(this.state.jarProps.getProperty(PERMISSIONS_PROP))) {
                                this.postInstallMsgBackToProvider(ATTRIBUTE_MISMATCH_MSG);
                                throw new InvalidJadException(59);
                            }
                        } else {
                            permissionsProps = this.state.jarProps.getProperty(PERMISSIONS_PROP);
                            if (checkJarPermissions && permissionsProps != null && permissionsProps.length() > 0) {
                                this.postInstallMsgBackToProvider(ATTRIBUTE_MISMATCH_MSG);
                                throw new InvalidJadException(59);
                            }
                        }
                        if ((permissionsProps = this.state.jadProps.getProperty(PERMISSIONS_OPT_PROP)) != null) {
                            if (!permissionsProps.equals(this.state.jarProps.getProperty(PERMISSIONS_OPT_PROP))) {
                                this.postInstallMsgBackToProvider(ATTRIBUTE_MISMATCH_MSG);
                                throw new InvalidJadException(59);
                            }
                        } else {
                            permissionsProps = this.state.jarProps.getProperty(PERMISSIONS_OPT_PROP);
                            if (checkJarPermissions && permissionsProps != null && permissionsProps.length() > 0) {
                                this.postInstallMsgBackToProvider(ATTRIBUTE_MISMATCH_MSG);
                                throw new InvalidJadException(59);
                            }
                        }
                    }
                    break block36;
                }
                this.state.file = new File(classSecurityToken);
                this.state.suiteName = this.state.jarProps.getProperty(SUITE_NAME_PROP);
                if (this.state.suiteName == null || this.state.suiteName.length() == 0) {
                    this.postInstallMsgBackToProvider(INVALID_JAR_MSG);
                    throw new InvalidJadException(13);
                }
                this.state.vendor = this.state.jarProps.getProperty(VENDOR_PROP);
                if (this.state.vendor == null || this.state.vendor.length() == 0) {
                    this.postInstallMsgBackToProvider(INVALID_JAR_MSG);
                    throw new InvalidJadException(14);
                }
                this.state.version = this.state.jarProps.getProperty(VERSION_PROP);
                if (this.state.version == null || this.state.version.length() == 0) {
                    this.postInstallMsgBackToProvider(INVALID_JAR_MSG);
                    throw new InvalidJadException(15);
                }
                try {
                    this.checkVersionFormat(this.state.version);
                }
                catch (NumberFormatException nfe) {
                    this.postInstallMsgBackToProvider(INVALID_JAR_MSG);
                    throw new InvalidJadException(16);
                }
                this.state.storageName = Installer.makeStorageName(this.state.vendor, this.state.suiteName);
                this.checkPreviousVersion();
            }
            catch (Exception e) {
                this.state.file.delete(this.state.tempFilename);
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
                throw (RuntimeException)e;
            }
        }
    }

    private void installStep5() {
        ++this.state.nextStep;
        if (this.state.jadUrl == null && this.state.isPreviousVersion) {
            this.checkForDifferentDomains(this.state.jarUrl);
        }
    }

    private void checkRuntimeEnvironment() throws InvalidJadException {
        String envValue = this.state.getAppProperty(EXE_ENV_PROP);
        if (envValue == null) {
            return;
        }
        if (envValue.equals(DEFAULT_ENVIRONMENT)) {
            return;
        }
        this.postInstallMsgBackToProvider(ATTRIBUTE_MISMATCH_MSG);
        throw new InvalidJadException(50);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void installStep6() throws IOException, InvalidJadException {
        String suiteStorageRoot;
        int paymentID = -1;
        try {
            String securityDomain = this.state.ca != null ? this.getSecurityDomainName(this.state.storageRoot, this.state.ca) : this.unsignedSecurityDomain;
            if (Permissions.UNTRUSTED_DOMAIN_NAME.equals(securityDomain)) {
                if (this.state.isPreviousVersion && this.state.previousSuite.isTrusted()) {
                    this.postInstallMsgBackToProvider(AUTHORIZATION_FAILURE_MSG);
                    throw new InvalidJadException(52, this.state.previousCA);
                }
                InstallStateImpl.access$202(this.state, Permissions.forDomain(classSecurityToken, securityDomain));
                this.state.ca = null;
            } else {
                if (this.state.jadUrl != null) {
                    this.checkForJadManifestMismatches();
                }
                this.state.trusted = true;
                InstallStateImpl.access$202(this.state, this.getInitialPermissions(securityDomain));
            }
            if (this.state.isPreviousVersion) {
                this.applyCurrentUserLevelPermissions(this.state.previousSuite.getPermissions()[1], this.state.permissions[0], this.state.permissions[1]);
                if (this.state.removeRMS) {
                    RecordStoreFile.removeRecordStoresForSuite(classSecurityToken, this.state.storageRoot + this.state.storageName);
                } else {
                    this.processPreviousRMS();
                }
                this.processPreviousPrivate();
            }
            this.state.securityToken = new SecurityToken(Installer.classSecurityToken, this.state.permissions, this.state);
            this.checkConfiguration();
            this.matchProfile();
            this.checkRuntimeEnvironment();
            try {
                this.state.chinstaller.preInstall(this, this.state, this.state, this.state.ca);
            }
            catch (InvalidJadException jex) {
                String msg = INVALID_CONTENT_HANDLER;
                if (jex.getReason() == 55) {
                    msg = CONTENT_HANDLER_CONFLICT;
                }
                this.postInstallMsgBackToProvider(msg);
                throw jex;
            }
            catch (SecurityException se) {
                this.postInstallMsgBackToProvider(AUTHORIZATION_FAILURE_MSG);
                throw new InvalidJadException(49, se.getMessage());
            }
            if (this.state.jadProps != null && this.state.jadProps.getProperty("Pay-Version") != null) {
                String payDebugStr;
                if (System.getProperty("sun.payment.latevalidation") == null) {
                    try {
                        PaymentInfo paymentInfo = PaymentInfo.createFromProperties(this.state.jadProps, this.state.jarProps);
                    }
                    catch (PaymentException e) {
                        switch (e.getReason()) {
                            case 0: 
                            case 3: 
                            case 4: 
                            case 5: {
                                this.postInstallMsgBackToProvider(UNSUPPORTED_PAYMENT_INFO);
                                throw new InvalidJadException(56, e.getMessage());
                            }
                        }
                        this.postInstallMsgBackToProvider(INVALID_PAYMENT_INFO);
                        throw new InvalidJadException(57, e.getMessage());
                    }
                }
                if (!("yes".equals(payDebugStr = this.state.jadProps.getProperty("Pay-Debug-DemoMode")) || this.state.ca != null && this.state.trusted)) {
                    this.postInstallMsgBackToProvider(UNTRUSTED_PAYMENT_SUITE);
                    throw new InvalidJadException(58);
                }
                if (!this.state.file.exists(this.state.storageRoot + this.state.storageName + PAY_FILENAME)) {
                    paymentID = PaymentModule.getInstance().getNextApplicationID();
                }
            }
            suiteStorageRoot = this.state.storageRoot + this.state.storageName;
            String dirPrivate = this.getPrivDirName();
            String dirRelative = this.getPrivDirRelName();
            File storage = new File(classSecurityToken);
            Vector content = storage.filenamesThatStartWith(dirPrivate);
            if (content.size() <= 0) {
                storage.mkdir(dirPrivate);
            }
            String propertyURL = "file://" + dirRelative;
            propertyURL = propertyURL.replace('\\', '/');
            this.state.addProperty(PROPERTY_DIR_PRIVATE, propertyURL);
            String propertyString = "fileconn.dir.private: " + propertyURL + "\n";
            byte[] propertyStringByteArray = propertyString.getBytes();
            if (this.state.jad != null) {
                byte[] b = new byte[this.state.jad.length + propertyString.length()];
                System.arraycopy(this.state.jad, 0, b, 0, this.state.jad.length);
                System.arraycopy(propertyStringByteArray, 0, b, this.state.jad.length, propertyStringByteArray.length);
                this.state.jad = b;
            } else {
                this.state.jad = propertyStringByteArray;
            }
            while (System.currentTimeMillis() - this.state.startTime < 1000L) {
            }
            InstallStateImpl installStateImpl = this.state;
            synchronized (installStateImpl) {
                if (this.state.stopInstallation) {
                    this.postInstallMsgBackToProvider(USER_CANCELLED_MSG);
                    throw new IOException("stopped");
                }
                if (this.state.listener != null) {
                    this.state.listener.updateStatus(6, this.state);
                }
                this.state.writingSuite = true;
            }
            this.registerPushConnections();
            this.state.chinstaller.install();
        }
        catch (Exception e) {
            this.state.file.delete(this.state.tempFilename);
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw (RuntimeException)e;
        }
        try {
            DataOutputStream storageStream;
            this.state.file.rename(this.state.tempFilename, suiteStorageRoot + JAR_FILENAME);
            this.state.storage.connect(suiteStorageRoot + MANIFEST_FILENAME, -3);
            this.state.storage.writeBytes(this.state.manifest, 0, this.state.manifest.length);
            this.state.storage.disconnect();
            try {
                if (this.state.suiteIcon != null) {
                    this.state.storage.connect(suiteStorageRoot + ICON_FILENAME, -3);
                    this.state.storage.writeBytes(this.state.suiteIcon, 0, this.state.suiteIcon.length);
                    this.state.storage.disconnect();
                }
            }
            catch (Exception e) {
                System.out.println("Creating the icon file has been faild");
            }
            if (this.state.file.exists(suiteStorageRoot + JAD_URL_FILENAME)) {
                this.state.file.delete(suiteStorageRoot + JAD_URL_FILENAME);
                this.state.file.delete(suiteStorageRoot + JAD_FILENAME);
            }
            if (this.state.jadUrl != null) {
                this.state.storage.connect(suiteStorageRoot + JAD_FILENAME, -3);
                this.state.storage.writeBytes(this.state.jad, 0, this.state.jad.length);
                this.state.storage.disconnect();
                this.state.storage.connect(suiteStorageRoot + JAD_URL_FILENAME, -3);
                storageStream = this.state.storage.openDataOutputStream();
                storageStream.writeUTF(this.state.jadUrl);
                storageStream.close();
                this.state.storage.disconnect();
            }
            this.state.storage.connect(suiteStorageRoot + JAR_URL_FILENAME, -3);
            storageStream = this.state.storage.openDataOutputStream();
            storageStream.writeUTF(this.state.jarUrl);
            storageStream.close();
            this.state.storage.disconnect();
            if (this.state.jadEncoding != null) {
                this.state.storage.connect(suiteStorageRoot + JAD_ENCODING_FILENAME, -3);
                storageStream = this.state.storage.openDataOutputStream();
                storageStream.writeUTF(this.state.jadEncoding);
                storageStream.close();
                this.state.storage.disconnect();
            } else if (this.state.file.exists(suiteStorageRoot + JAD_ENCODING_FILENAME)) {
                this.state.file.delete(suiteStorageRoot + JAD_ENCODING_FILENAME);
            }
            if (this.state.ca != null) {
                this.state.storage.connect(suiteStorageRoot + CA_FILENAME, -3);
                storageStream = this.state.storage.openDataOutputStream();
                storageStream.writeUTF(this.state.ca);
                storageStream.close();
                this.state.storage.disconnect();
            } else {
                try {
                    this.state.file.delete(suiteStorageRoot + CA_FILENAME);
                }
                catch (IOException ioe) {
                    // empty catch block
                }
            }
            if (paymentID != -1) {
                this.state.storage.connect(suiteStorageRoot + PAY_FILENAME, -3);
                storageStream = this.state.storage.openDataOutputStream();
                storageStream.writeInt(paymentID);
                storageStream.close();
                this.state.storage.disconnect();
            }
            if (this.state.file.exists(suiteStorageRoot + JPP_FILENAME)) {
                this.state.file.delete(suiteStorageRoot + JPP_FILENAME);
            }
            Installer.saveSuiteSettings(classSecurityToken, suiteStorageRoot, this.state.pushInterruptSetting, this.state.permissions, this.state.trusted);
            this.addToSuiteList(this.state.storageName);
            ++this.state.nextStep;
            try {
                this.postInstallMsgBackToProvider(SUCCESS_MSG);
            }
            catch (RuntimeException re) {
                // empty catch block
            }
            return;
        }
        catch (Exception e) {
            try {
                this.state.storage.disconnect();
            }
            catch (IOException ex) {
                // empty catch block
            }
            this.cleanUp(this.state.storageName);
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw (RuntimeException)e;
        }
    }

    String getPrivDirName() {
        return this.state.storageRoot + FILESYSTEM + this.getPrivDirRelName();
    }

    String getPrivDirRelName() {
        char slash = this.state.storageRoot.charAt(this.state.storageRoot.length() - 1);
        String storageName = this.state.storageName.replace('%', '_');
        storageName = storageName.replace('#', '_');
        return slash + ROOT_DIR + slash + storageName + PRIV_DIR_KEYWORD + slash;
    }

    public void verifyMIDlet(String classname) throws InvalidJadException {
        if (classname == null || classname.length() == 0) {
            throw new InvalidJadException(29);
        }
        String file = classname.replace('.', '/').concat(".class");
        try {
            if (JarReader.readJarEntry(classSecurityToken, this.state.tempFilename, file) != null) {
                return;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        throw new InvalidJadException(36, file);
    }

    private byte[] downloadJAD() throws IOException {
        String[] encoding = new String[1];
        ByteArrayOutputStream bos = new ByteArrayOutputStream(1024);
        String[] acceptableTypes = new String[]{JAD_MT};
        String[] extraFieldKeys = new String[3];
        String[] extraFieldValues = new String[3];
        String prof = System.getProperty("microedition.profiles");
        int space = prof.indexOf(32);
        if (space != -1) {
            prof = prof.substring(0, space);
        }
        extraFieldKeys[0] = "User-Agent";
        extraFieldValues[0] = "Profile/" + prof + " Configuration/" + System.getProperty("microedition.configuration");
        extraFieldKeys[1] = "Accept-Charset";
        extraFieldValues[1] = "UTF-8, " + System.getProperty("microedition.encoding");
        String locale = System.getProperty("microedition.locale");
        if (locale != null) {
            extraFieldKeys[2] = "Accept-Language";
            extraFieldValues[2] = locale;
        }
        this.state.beginTransferDataStatus = 1;
        this.state.transferStatus = 2;
        this.downloadResource(this.state.jadUrl, extraFieldKeys, extraFieldValues, acceptableTypes, false, false, bos, encoding, 43, 1, 2, 37);
        this.state.jadEncoding = encoding[0];
        return bos.toByteArray();
    }

    private int downloadJAR(String filename) throws IOException {
        String url;
        String[] acceptableTypes = new String[]{JAR_MT_1, JAR_MT_2};
        RandomAccessStream jarOutputStream = null;
        OutputStream outputStream = null;
        HttpUrl parsedUrl = new HttpUrl(this.state.jarUrl);
        if (parsedUrl.authority == null && this.state.jadUrl != null) {
            try {
                parsedUrl.addBaseUrl(this.state.jadUrl);
            }
            catch (IOException e) {
                this.postInstallMsgBackToProvider(INVALID_JAD_MSG);
                throw new InvalidJadException(44);
            }
            this.state.jarUrl = url = parsedUrl.toString();
        } else {
            url = this.state.jarUrl;
        }
        jarOutputStream = new RandomAccessStream(classSecurityToken);
        jarOutputStream.connect(filename, -3);
        outputStream = jarOutputStream.openOutputStream();
        try {
            int jarSize;
            this.state.beginTransferDataStatus = 3;
            this.state.transferStatus = 4;
            int e = jarSize = this.downloadResource(url, null, null, acceptableTypes, true, true, outputStream, null, 44, 19, 20, 38);
            return e;
        }
        catch (InvalidJadException ije) {
            switch (ije.getReason()) {
                case 19: 
                case 20: {
                    this.postInstallMsgBackToProvider(INVALID_JAD_MSG);
                    break;
                }
                case 38: {
                    this.postInstallMsgBackToProvider(INVALID_JAR_MSG);
                }
            }
            throw ije;
        }
        finally {
            try {
                jarOutputStream.disconnect();
            }
            catch (Exception e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int downloadResource(String url, String[] extraFieldKeys, String[] extraFieldValues, String[] acceptableTypes, boolean sendAcceptableTypes, boolean allowNoMediaType, OutputStream output, String[] encoding, int invalidURLCode, int serverNotFoundCode, int resourceNotFoundCode, int invalidMediaTypeCode) throws IOException {
        int responseCode;
        Connection conn;
        block50: {
            conn = null;
            do {
                block51: {
                    String retryAfterField;
                    int i;
                    try {
                        conn = Connector.open((String)url, (int)1);
                    }
                    catch (IllegalArgumentException e) {
                        throw new InvalidJadException(invalidURLCode, url);
                    }
                    catch (ConnectionNotFoundException e) {
                        throw new InvalidJadException(invalidURLCode, url);
                    }
                    if (!(conn instanceof HttpConnection)) {
                        throw new InvalidJadException(invalidURLCode, url);
                    }
                    this.httpConnection = (HttpConnection)conn;
                    if (extraFieldKeys != null) {
                        for (i = 0; i < extraFieldKeys.length && extraFieldKeys[i] != null; ++i) {
                            this.httpConnection.setRequestProperty(extraFieldKeys[i], extraFieldValues[i]);
                        }
                    }
                    StringBuffer acceptField = new StringBuffer(256);
                    if (sendAcceptableTypes) {
                        acceptField.append(acceptableTypes[0]);
                        for (i = 1; i < acceptableTypes.length; ++i) {
                            acceptField.append(", ");
                            acceptField.append(acceptableTypes[i]);
                        }
                        this.httpConnection.setRequestProperty("Accept", acceptField.toString());
                    }
                    this.httpConnection.setRequestMethod("GET");
                    if (this.state.username != null && this.state.password != null) {
                        this.httpConnection.setRequestProperty("Authorization", Installer.formatAuthCredentials(this.state.username, this.state.password));
                    }
                    if (this.state.proxyUsername != null && this.state.proxyPassword != null) {
                        this.httpConnection.setRequestProperty("Proxy-Authorization", Installer.formatAuthCredentials(this.state.proxyUsername, this.state.proxyPassword));
                    }
                    try {
                        responseCode = this.httpConnection.getResponseCode();
                    }
                    catch (IOException ioe) {
                        if (this.httpConnection.getHost() == null) {
                            throw new InvalidJadException(invalidURLCode, url);
                        }
                        throw new InvalidJadException(serverNotFoundCode, url);
                    }
                    if (responseCode != 503 || (retryAfterField = this.httpConnection.getHeaderField("Retry-After")) == null) break block50;
                    try {
                        int retryInterval = Integer.parseInt(retryAfterField);
                        if (retryInterval <= 0) break block51;
                        if (retryInterval > 60) {
                            retryInterval = 60;
                        }
                        Thread.sleep(retryInterval * 1000);
                    }
                    catch (InterruptedException ie) {
                        break block50;
                    }
                    catch (NumberFormatException ne) {
                        break block50;
                    }
                }
                this.httpConnection.close();
            } while (!this.state.stopInstallation);
            this.postInstallMsgBackToProvider(USER_CANCELLED_MSG);
            throw new IOException("stopped");
        }
        if (responseCode == 404) {
            throw new InvalidJadException(resourceNotFoundCode);
        }
        if (responseCode == 406) {
            throw new InvalidJadException(invalidMediaTypeCode, "");
        }
        if (responseCode == 401) {
            this.checkIfBasicAuthSupported(this.httpConnection.getHeaderField("WWW-Authenticate"));
            this.state.exception = new InvalidJadException(33);
            int ne = 0;
            return ne;
        }
        if (responseCode == 407) {
            this.checkIfBasicAuthSupported(this.httpConnection.getHeaderField("WWW-Authenticate"));
            this.state.exception = new InvalidJadException(51);
            int ne = 0;
            return ne;
        }
        if (responseCode != 200) {
            throw new IOException("Failed to download " + url + " HTTP response code: " + responseCode);
        }
        String mediaType = Installer.getMediaType(this.httpConnection.getType());
        if (mediaType != null) {
            boolean goodType = false;
            for (int i = 0; i < acceptableTypes.length; ++i) {
                if (!mediaType.equals(acceptableTypes[i])) continue;
                goodType = true;
                break;
            }
            if (!goodType) {
                throw new InvalidJadException(invalidMediaTypeCode, mediaType);
            }
        } else if (!allowNoMediaType) {
            throw new InvalidJadException(invalidMediaTypeCode, "");
        }
        if (encoding != null) {
            encoding[0] = Installer.getCharset(this.httpConnection.getType());
        }
        this.httpInputStream = this.httpConnection.openInputStream();
        int n = this.transferData(this.httpInputStream, output);
        return n;
        finally {
            try {
                this.httpInputStream.close();
            }
            catch (Exception e) {}
            try {
                conn.close();
            }
            catch (Exception e) {}
        }
    }

    private void checkForDifferentDomains(String url) {
        if (this.state.ca == null && this.state.previousUrl != null) {
            HttpUrl old = new HttpUrl(this.state.previousUrl);
            HttpUrl current = new HttpUrl(url);
            if (current.domain != null && old.domain == null || current.domain == null && old.domain != null || current.domain != null && old.domain != null && !current.domain.regionMatches(true, 0, old.domain, 0, old.domain.length())) {
                this.state.exception = new InvalidJadException(34, this.state.previousUrl == null ? "none" : this.state.previousUrl);
                return;
            }
        }
    }

    private void checkPreviousVersion() throws InvalidJadException {
        MIDletSuite midletSuite = this.getMIDletSuite(this.state.storageName);
        try {
            this.checkVersionFormat(this.state.version);
            if (midletSuite == null) {
                return;
            }
            this.state.isPreviousVersion = true;
            this.state.previousSuite = midletSuite;
            this.state.previousJadUrl = midletSuite.getJadUrl();
            this.state.previousJarUrl = midletSuite.getJarUrl();
            this.state.previousUrl = midletSuite.getDownloadUrl();
            this.state.previousCA = midletSuite.getCA();
            if (this.state.previousCA == null) {
                this.state.previousCA = Resource.getString("the manufacturer");
            }
            if (this.state.force) {
                return;
            }
            String installedVersion = midletSuite.getProperty(VERSION_PROP);
            int cmpResult = this.vercmp(this.state.version, installedVersion);
            if (cmpResult < 0) {
                this.state.exception = new InvalidJadException(17, installedVersion);
                return;
            }
            if (cmpResult == 0) {
                this.state.exception = new InvalidJadException(39, installedVersion);
                return;
            }
            this.state.exception = new InvalidJadException(32, installedVersion);
            return;
        }
        catch (NumberFormatException nfe) {
            this.postInstallMsgBackToProvider(INVALID_JAD_MSG);
            throw new InvalidJadException(16);
        }
    }

    private void processPreviousRMS() throws IOException {
        HttpUrl originalUrl;
        HttpUrl newUrl;
        String suiteStorageRoot = this.state.storageRoot + this.state.storageName;
        if (!RecordStoreFile.suiteHasRmsData(classSecurityToken, suiteStorageRoot)) {
            return;
        }
        if (this.state.previousCA != null && this.state.ca != null && this.state.ca.equals(this.state.previousCA)) {
            return;
        }
        try {
            newUrl = new HttpUrl(this.state.jadUrl);
            originalUrl = new HttpUrl(this.state.previousJadUrl);
            if (newUrl.scheme.equals(originalUrl.scheme) && newUrl.host.equals(originalUrl.host) && newUrl.path.equals(originalUrl.path)) {
                return;
            }
        }
        catch (NullPointerException npe) {
            // empty catch block
        }
        try {
            newUrl = new HttpUrl(this.state.jarUrl);
            originalUrl = new HttpUrl(this.state.previousJarUrl);
            if (newUrl.scheme.equals(originalUrl.scheme) && newUrl.host.equals(originalUrl.host) && newUrl.path.equals(originalUrl.path)) {
                return;
            }
        }
        catch (NullPointerException npe) {
            // empty catch block
        }
        if (this.state.listener != null && this.state.listener.keepRMS(this.state)) {
            return;
        }
        if (this.state.stopInstallation) {
            this.postInstallMsgBackToProvider(USER_CANCELLED_MSG);
            throw new IOException("stopped");
        }
        RecordStoreFile.removeRecordStoresForSuite(classSecurityToken, suiteStorageRoot);
    }

    void removePrivateDirData(String storageName) {
        File storage = new File();
        String dirPrivate = this.getPrivDirName();
        Vector content = storage.filenamesThatStartWith(dirPrivate);
        if (content == null || content.size() <= 0) {
            return;
        }
        Enumeration enumerator = content.elements();
        while (enumerator.hasMoreElements()) {
            String file = (String)enumerator.nextElement();
            try {
                storage.delete(file);
            }
            catch (IOException ex) {}
        }
    }

    private void processPreviousPrivate() throws IOException {
        HttpUrl originalUrl;
        HttpUrl newUrl;
        String suiteStorageRoot = this.state.storageRoot + this.state.storageName;
        if (this.state.previousCA != null && this.state.ca != null && this.state.ca.equals(this.state.previousCA)) {
            return;
        }
        try {
            newUrl = new HttpUrl(this.state.jadUrl);
            originalUrl = new HttpUrl(this.state.previousJadUrl);
            if (newUrl.scheme.equals(originalUrl.scheme) && newUrl.host.equals(originalUrl.host) && newUrl.path.equals(originalUrl.path)) {
                return;
            }
        }
        catch (NullPointerException npe) {
            // empty catch block
        }
        try {
            newUrl = new HttpUrl(this.state.jarUrl);
            originalUrl = new HttpUrl(this.state.previousJarUrl);
            if (newUrl.scheme.equals(originalUrl.scheme) && newUrl.host.equals(originalUrl.host) && newUrl.path.equals(originalUrl.path)) {
                return;
            }
        }
        catch (NullPointerException npe) {
            // empty catch block
        }
        if (this.state.listener != null && this.state.listener.keepPrivate(this.state)) {
            return;
        }
        if (this.state.stopInstallation) {
            this.postInstallMsgBackToProvider(USER_CANCELLED_MSG);
            throw new IOException("stopped");
        }
        this.removePrivateDirData(this.state.storageName);
    }

    private void checkIfBasicAuthSupported(String wwwAuthField) throws InvalidJadException {
        if (!(wwwAuthField = wwwAuthField.trim()).regionMatches(true, 0, BASIC_TAG, 0, BASIC_TAG.length())) {
            throw new InvalidJadException(35);
        }
    }

    private static String getMediaType(String contentType) {
        if (contentType == null) {
            return null;
        }
        int semiColon = contentType.indexOf(59);
        if (semiColon < 0) {
            return contentType.toLowerCase();
        }
        return contentType.substring(0, semiColon).toLowerCase();
    }

    private static String getCharset(String contentType) {
        int end;
        if (contentType == null) {
            return null;
        }
        int start = contentType.indexOf("charset");
        if (start < 0) {
            return null;
        }
        if ((start = contentType.indexOf(61, start)) < 0) {
            return null;
        }
        if ((end = contentType.indexOf(59, ++start)) < 0) {
            end = contentType.length();
        }
        return contentType.substring(start, end).trim();
    }

    private static String formatAuthCredentials(String username, String password) {
        byte[] data = new byte[username.length() + password.length() + 1];
        int j = 0;
        int i = 0;
        while (i < username.length()) {
            data[j] = (byte)username.charAt(i);
            ++i;
            ++j;
        }
        data[j] = 58;
        ++j;
        i = 0;
        while (i < password.length()) {
            data[j] = (byte)password.charAt(i);
            ++i;
            ++j;
        }
        return "Basic " + Base64.encode(data, 0, data.length);
    }

    private void postInstallMsgBackToProvider(String message) {
        this.postQueuedDeleteMsgsBackToProvider();
        String url = this.state.getAppProperty(NOTIFY_PROP);
        this.postMsgBackToProvider(message, url);
    }

    private void postQueuedDeleteMsgsBackToProvider() {
        Vector deleteNotifyList = this.getDeleteNotifyURLList();
        Enumeration e = deleteNotifyList.elements();
        while (e.hasMoreElements()) {
            String url = (String)e.nextElement();
            this.postMsgBackToProvider(DELETE_NOTIFICATION_MSG, url);
            this.removeFromDeleteNotifyURLList(url);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void postMsgBackToProvider(String message, String url) {
        if (url == null) {
            return;
        }
        boolean responseReceived = false;
        for (int i = 5; !responseReceived && i > 0; --i) {
            try {
                HttpConnection transaction = (HttpConnection)Connector.open((String)url, (int)2);
                try {
                    transaction.setRequestMethod("POST");
                    if (this.state != null && this.state.proxyUsername != null && this.state.proxyPassword != null) {
                        transaction.setRequestProperty("Proxy-Authorization", Installer.formatAuthCredentials(this.state.proxyUsername, this.state.proxyPassword));
                    }
                    OutputStream out = transaction.openOutputStream();
                    try {
                        out.write(message.getBytes());
                    }
                    finally {
                        out.close();
                    }
                    if (transaction.getResponseCode() != 200) continue;
                    responseReceived = true;
                    continue;
                }
                finally {
                    transaction.close();
                }
            }
            catch (IOException ioe) {
                continue;
            }
            catch (IllegalArgumentException iae) {
                continue;
            }
            catch (ClassCastException cce) {
                // empty catch block
            }
        }
    }

    private void addToDeleteNotifyURLList(String url) {
        if (url == null) {
            return;
        }
        Vector deleteNotifyList = this.getDeleteNotifyURLList();
        deleteNotifyList.addElement(url);
        this.saveDeleteNotifyURLList(deleteNotifyList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Vector getDeleteNotifyURLList() {
        if (this.deleteNotifyURLList != null) {
            return this.deleteNotifyURLList;
        }
        this.deleteNotifyURLList = new Vector();
        try {
            RandomAccessStream storage = new RandomAccessStream(classSecurityToken);
            storage.connect(File.getStorageRoot() + DELETE_NOTIFY_FILENAME, 1);
            try {
                String line;
                DataInputStream in = storage.openDataInputStream();
                while ((line = in.readUTF()) != null) {
                    this.deleteNotifyURLList.addElement(line);
                }
            }
            finally {
                storage.disconnect();
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        return this.deleteNotifyURLList;
    }

    private void removeFromDeleteNotifyURLList(String url) {
        Vector deleteNotifyList = this.getDeleteNotifyURLList();
        deleteNotifyList.removeElement(url);
        this.saveDeleteNotifyURLList(deleteNotifyList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveDeleteNotifyURLList(Vector list) {
        File file = new File(classSecurityToken);
        RandomAccessStream storage = new RandomAccessStream(classSecurityToken);
        String filename = File.getStorageRoot() + DELETE_NOTIFY_FILENAME;
        try {
            file.delete(filename);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            storage.connect(filename, -3);
            try {
                DataOutputStream out = storage.openDataOutputStream();
                for (int i = 0; i < list.size(); ++i) {
                    String line = (String)list.elementAt(i);
                    out.writeUTF(line);
                }
            }
            finally {
                storage.disconnect();
            }
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int transferData(InputStream in, OutputStream out) throws IOException {
        byte[] buffer = new byte[1024];
        int totalBytesWritten = 0;
        if (this.state.listener != null) {
            this.state.listener.updateStatus(this.state.beginTransferDataStatus, this.state);
        }
        try {
            int nextUpdate = totalBytesWritten + 1024;
            while (true) {
                int bytesRead = in.read(buffer);
                if (this.state.listener != null && (bytesRead == -1 || totalBytesWritten + bytesRead >= nextUpdate)) {
                    InstallStateImpl installStateImpl = this.state;
                    synchronized (installStateImpl) {
                        if (this.state.stopInstallation) {
                            throw new IOException("stopped");
                        }
                        this.state.listener.updateStatus(this.state.transferStatus, this.state);
                    }
                    nextUpdate = totalBytesWritten + 1024;
                }
                if (bytesRead == -1) {
                    return totalBytesWritten;
                }
                out.write(buffer, 0, bytesRead);
                totalBytesWritten += bytesRead;
            }
        }
        catch (IOException ioe) {
            if (this.state.stopInstallation) {
                this.postInstallMsgBackToProvider(USER_CANCELLED_MSG);
                throw new IOException("stopped");
            }
            throw ioe;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean stopInstalling() {
        if (this.state == null) {
            return false;
        }
        InstallStateImpl installStateImpl = this.state;
        synchronized (installStateImpl) {
            if (this.state.writingSuite) {
                return false;
            }
            this.state.stopInstallation = true;
            try {
                this.httpInputStream.close();
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                this.httpConnection.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return true;
        }
    }

    public boolean wasStopped() {
        if (this.state == null) {
            return false;
        }
        return this.state.stopInstallation;
    }

    public void setUnsignedSecurityDomain(String domain) {
        MIDletSuite midletSuite = Scheduler.getScheduler().getMIDletSuite();
        if (midletSuite != null) {
            midletSuite.checkIfPermissionAllowed(0);
        }
        this.unsignedSecurityDomain = domain;
    }

    protected void checkForJadManifestMismatches() throws InvalidJadException {
        for (int i = 0; i < this.state.jarProps.size(); ++i) {
            String key = this.state.jarProps.getKeyAt(i);
            String value = this.state.jarProps.getValueAt(i);
            String dup = this.state.jadProps.getProperty(key);
            if (dup == null || dup.equals(value)) continue;
            this.postInstallMsgBackToProvider(ATTRIBUTE_MISMATCH_MSG);
            throw new InvalidJadException(50, key);
        }
    }

    protected byte[][] getInitialPermissions(String domain) throws InvalidJadException {
        byte[][] domainPermissions = Permissions.forDomain(classSecurityToken, domain);
        byte[] permissions = Permissions.getEmptySet();
        this.getRequestedPermissions(PERMISSIONS_PROP, domainPermissions[1], permissions, true);
        this.getRequestedPermissions(PERMISSIONS_OPT_PROP, domainPermissions[1], permissions, false);
        domainPermissions[1] = permissions;
        return domainPermissions;
    }

    private void getRequestedPermissions(String propName, byte[] domainPermissions, byte[] permissions, boolean required) throws InvalidJadException {
        String reqPermissionLine = this.state.getAppProperty(propName);
        if (reqPermissionLine == null) {
            return;
        }
        Vector manifestPermissions = Util.getCommaSeparatedValues(reqPermissionLine);
        if (manifestPermissions.size() == 0) {
            this.postInstallMsgBackToProvider(INVALID_JAD_MSG);
            throw new InvalidJadException(29);
        }
        for (int j = 0; j < manifestPermissions.size(); ++j) {
            int i;
            String permission = (String)manifestPermissions.elementAt(j);
            if (permission.length() == 0) {
                this.postInstallMsgBackToProvider(INVALID_JAD_MSG);
                throw new InvalidJadException(29);
            }
            boolean found = false;
            for (i = 0; i < 56; ++i) {
                if (!Permissions.getName(i).equals(permission)) continue;
                if (domainPermissions[i] == 0) break;
                found = true;
                break;
            }
            if (!found) {
                if (!required) continue;
                this.postInstallMsgBackToProvider(AUTHORIZATION_FAILURE_MSG);
                throw new InvalidJadException(49, permission);
            }
            permissions[i] = domainPermissions[i];
        }
    }

    private void applyCurrentUserLevelPermissions(byte[] current, byte[] domainPermissions, byte[] next) {
        block8: for (int i = 0; i < current.length && i < next.length; ++i) {
            switch (current[i]) {
                case 1: 
                case 64: {
                    continue block8;
                }
                default: {
                    switch (domainPermissions[i]) {
                        case 1: 
                        case 64: {
                            continue block8;
                        }
                        case 16: {
                            if (current[i] == 8 || current[i] == 32) continue block8;
                        }
                        case 8: {
                            if (current[i] == 4 || current[i] == 2) continue block8;
                        }
                        default: {
                            next[i] = current[i];
                        }
                    }
                }
            }
        }
    }

    protected String getSecurityDomainName(String storageName, String ca) {
        return Permissions.UNTRUSTED_DOMAIN_NAME;
    }

    protected void verifyJar(RandomAccessStream jarStorage, String jarFilename) throws IOException, InvalidJadException {
    }

    private int vercmp(String ver1, String ver2) throws NumberFormatException {
        int idx1 = 0;
        int idx2 = 0;
        if (ver1 == null && ver2 == null) {
            return 0;
        }
        if (ver1 == null) {
            return -1;
        }
        if (ver2 == null) {
            return 1;
        }
        for (int i = 0; i < 3; ++i) {
            int intVal2;
            int intVal1;
            int newidx;
            String strVal1 = "0";
            String strVal2 = "0";
            if (idx1 >= 0) {
                newidx = ver1.indexOf(46, idx1);
                strVal1 = newidx < 0 ? ver1.substring(idx1) : ver1.substring(idx1, newidx);
                idx1 = ++newidx;
            }
            if (idx2 >= 0) {
                newidx = ver2.indexOf(46, idx2);
                strVal2 = newidx < 0 ? ver2.substring(idx2) : ver2.substring(idx2, newidx);
                idx2 = ++newidx;
            }
            if ((intVal1 = Integer.parseInt(strVal1)) > (intVal2 = Integer.parseInt(strVal2))) {
                return 1;
            }
            if (intVal1 >= intVal2) continue;
            return -1;
        }
        return 0;
    }

    private void checkVersionFormat(String ver) throws NumberFormatException {
        int start = 0;
        int length = ver.length();
        int i = 0;
        while (true) {
            if (i == 3 || start == length) {
                throw new NumberFormatException();
            }
            int end = ver.indexOf(46, start);
            if (end == -1) {
                end = length;
            }
            Integer.parseInt(ver.substring(start, end));
            if (end == length) {
                return;
            }
            start = end + 1;
            ++i;
        }
    }

    private boolean matchVersion(String name1, String name2) {
        String base2;
        String base1 = name1.substring(0, name1.indexOf(45));
        if (base1.equals(base2 = name2.substring(0, name1.indexOf(45)))) {
            String ver2;
            String ver1 = name1.substring(name1.indexOf(45) + 1, name1.length());
            return this.vercmp(ver1, ver2 = name2.substring(name2.indexOf(45) + 1, name2.length())) >= 0;
        }
        return false;
    }

    private void checkConfiguration() throws InvalidJadException {
        String config = this.state.getAppProperty(CONFIGURATION_PROP);
        if (config == null || config.length() == 0) {
            this.postInstallMsgBackToProvider(INVALID_JAR_MSG);
            throw new InvalidJadException(41);
        }
        if (this.cldcConfig == null) {
            this.cldcConfig = System.getProperty("microedition.configuration").trim();
        }
        if (this.matchVersion(this.cldcConfig, config)) {
            return;
        }
        this.postInstallMsgBackToProvider(INCOMPATIBLE_MSG);
        throw new InvalidJadException(40);
    }

    private void matchProfile() throws InvalidJadException {
        String profiles = this.state.getAppProperty(PROFILE_PROP);
        if (profiles == null || profiles.length() == 0) {
            this.postInstallMsgBackToProvider(INVALID_JAR_MSG);
            throw new InvalidJadException(42);
        }
        if (this.supportedProfiles == null) {
            int nextSpace = -1;
            String meProfiles = System.getProperty("microedition.profiles").trim();
            this.supportedProfiles = new Vector();
            while (true) {
                int start;
                if ((nextSpace = meProfiles.indexOf(32, start = nextSpace + 1)) == start) {
                    continue;
                }
                if (nextSpace < 0) {
                    this.supportedProfiles.addElement(meProfiles.substring(start, meProfiles.length()));
                    break;
                }
                this.supportedProfiles.addElement(meProfiles.substring(start, nextSpace));
            }
        }
        int current = 0;
        int nextSeparatorIndex = 0;
        boolean supported = false;
        StringBuffer tmp = new StringBuffer(profiles);
        boolean modified = false;
        while ((nextSeparatorIndex = profiles.indexOf(9, current)) != -1) {
            tmp.setCharAt(nextSeparatorIndex, ' ');
            ++current;
            modified = true;
        }
        if (modified) {
            profiles = tmp.toString();
        }
        nextSeparatorIndex = 0;
        current = 0;
        do {
            String requestedProfile;
            if ((nextSeparatorIndex = profiles.indexOf(32, current)) == current) {
                ++current;
                continue;
            }
            if (nextSeparatorIndex == -1) {
                requestedProfile = profiles.substring(current, profiles.length());
            } else {
                requestedProfile = profiles.substring(current, nextSeparatorIndex);
                current = nextSeparatorIndex + 1;
            }
            supported = false;
            for (int i = 0; i < this.supportedProfiles.size(); ++i) {
                String supportedProfile = (String)this.supportedProfiles.elementAt(i);
                if (!this.matchVersion(supportedProfile, requestedProfile)) continue;
                supported = true;
                break;
            }
            if (!supported) break;
        } while (nextSeparatorIndex != -1);
        if (supported) {
            return;
        }
        this.postInstallMsgBackToProvider(INCOMPATIBLE_MSG);
        throw new InvalidJadException(40);
    }

    private void registerPushConnections() throws InvalidJadException {
        String pushProp;
        byte[] curLevels = this.state.permissions[1];
        if (this.state.isPreviousVersion) {
            PushRegistryImpl.unregisterConnections(classSecurityToken, this.state.storageName);
        }
        int i = 1;
        while ((pushProp = this.state.getAppProperty("MIDlet-Push-" + i)) != null) {
            int comma1 = pushProp.indexOf(44, 0);
            int comma2 = pushProp.indexOf(44, comma1 + 1);
            String conn = pushProp.substring(0, comma1).trim();
            String midlet = pushProp.substring(comma1 + 1, comma2).trim();
            String filter = pushProp.substring(comma2 + 1).trim();
            try {
                PushRegistryImpl.registerConnectionInternal(classSecurityToken, this.state, conn, midlet, filter, false);
            }
            catch (Exception e) {
                PushRegistryImpl.unregisterConnections(classSecurityToken, this.state.storageName);
                if (this.state.isPreviousVersion) {
                    this.redoPreviousPushConnections();
                }
                if (e instanceof SecurityException) {
                    this.postInstallMsgBackToProvider(AUTHORIZATION_FAILURE_MSG);
                    throw new InvalidJadException(49, e.getMessage());
                }
                this.postInstallMsgBackToProvider(PUSH_REG_FAILURE_MSG);
                if (e instanceof IllegalArgumentException) {
                    throw new InvalidJadException(46, pushProp);
                }
                if (e instanceof ConnectionNotFoundException) {
                    throw new InvalidJadException(47, pushProp);
                }
                if (e instanceof IOException) {
                    throw new InvalidJadException(45, pushProp);
                }
                if (e instanceof ClassNotFoundException) {
                    throw new InvalidJadException(48, pushProp);
                }
                throw (RuntimeException)e;
            }
            ++i;
        }
        if (this.state.isPreviousVersion) {
            this.state.pushInterruptSetting = (byte)this.state.previousSuite.getPushInterruptSetting();
            if (this.state.pushInterruptSetting != 0) {
                return;
            }
        }
        if (curLevels[10] == 0) {
            this.state.pushInterruptSetting = (byte)0;
        } else if (curLevels[10] == 1) {
            this.state.pushInterruptSetting = (byte)4;
        } else {
            this.state.pushInterruptSetting = curLevels[10];
        }
    }

    private void redoPreviousPushConnections() {
        String pushProp;
        int i = 1;
        while ((pushProp = this.state.previousSuite.getProperty("MIDlet-Push-" + i)) != null) {
            int comma1 = pushProp.indexOf(44, 0);
            int comma2 = pushProp.indexOf(44, comma1 + 1);
            String conn = pushProp.substring(0, comma1).trim();
            String midlet = pushProp.substring(comma1 + 1, comma2).trim();
            String filter = pushProp.substring(comma2 + 1).trim();
            try {
                PushRegistryImpl.registerConnectionInternal(classSecurityToken, this.state, conn, midlet, filter, true);
            }
            catch (IOException e) {
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
            ++i;
        }
    }

    public MIDletSuite getMIDletSuite(String storageName) {
        return this.getMIDletSuite(storageName, null);
    }

    public MIDletSuite getMIDletSuite(String storageName, String midletToRun) {
        File file = new File(classSecurityToken);
        String storageRoot = File.getStorageRoot() + storageName;
        if (!this.suiteExists(storageName)) {
            return null;
        }
        String ca = this.getCA(storageRoot);
        return new MIDletSuiteImpl(classSecurityToken, storageRoot, storageName, ca, midletToRun);
    }

    public MIDletSuite getMIDletSuite(String storageName, int midletToRun) {
        File file = new File(classSecurityToken);
        String storageRoot = File.getStorageRoot() + storageName;
        if (!this.suiteExists(storageName)) {
            return null;
        }
        String ca = this.getCA(storageRoot);
        return new MIDletSuiteImpl(classSecurityToken, storageRoot, storageName, ca, midletToRun);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(String storageName) {
        MIDletSuite suiteToDelete = this.getMIDletSuite(storageName, null);
        String deleteURL = null;
        Installer installer = myInstaller;
        synchronized (installer) {
            PushRegistryImpl.enablePushLaunch(classSecurityToken, false);
            try {
                suiteToDelete = this.getMIDletSuite(storageName, null);
                if (suiteToDelete != null) {
                    deleteURL = suiteToDelete.getProperty(DELETE_PROP);
                    this.addToDeleteNotifyURLList(deleteURL);
                }
                if (!this.removeFromSuiteList(storageName)) {
                    throw new IllegalArgumentException("Could not find " + storageName);
                }
                String dirProp = suiteToDelete.getProperty(PROPERTY_DIR_PRIVATE);
                if (dirProp != null) {
                    String storageRoot = File.getStorageRoot();
                    char slash = storageRoot.charAt(storageRoot.length() - 1);
                    dirProp = dirProp.substring(7, dirProp.length());
                    if (slash != '/') {
                        dirProp = dirProp.replace('/', slash);
                    }
                    String dirPrivate = storageRoot + FILESYSTEM + dirProp;
                    int notDeleted = 0;
                    File storage = new File();
                    Vector content = storage.filenamesThatStartWith(dirPrivate);
                    if (content.size() > 0) {
                        Enumeration enumerator = content.elements();
                        while (enumerator.hasMoreElements()) {
                            String file = (String)enumerator.nextElement();
                            try {
                                storage.delete(file);
                            }
                            catch (IOException ex) {
                                ++notDeleted;
                            }
                        }
                    }
                    if (notDeleted == 0) {
                        storage.rmdir(dirPrivate);
                    }
                }
                this.cleanUp(storageName);
            }
            finally {
                PushRegistryImpl.enablePushLaunch(classSecurityToken, true);
            }
        }
    }

    private void cleanUp(String storageName) {
        File file = new File(classSecurityToken);
        String storageRoot = File.getStorageRoot() + storageName;
        PushRegistryImpl.unregisterConnections(classSecurityToken, storageName);
        CHManager chinstaller = CHManager.newInstance();
        chinstaller.uninstall(storageName);
        int paymentID = MIDletSuiteImpl.getPaymentID(storageRoot);
        if (paymentID != -1) {
            KvemPaymentModule paymentModule = (KvemPaymentModule)PaymentModule.getInstance();
            paymentModule.uninstallFromStore(classSecurityToken, paymentID);
        }
        Vector files = file.filenamesThatStartWith(storageRoot);
        int numberOfFiles = files.size();
        for (int i = 0; i < numberOfFiles; ++i) {
            try {
                file.delete((String)files.elementAt(i));
                continue;
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
    }

    public boolean execute(String storageName, String midlet) throws SecurityException {
        Scheduler scheduler = Scheduler.getScheduler();
        MIDletSuite msuite = scheduler.getMIDletSuite();
        if (midlet != null && msuite != null && scheduler.isScheduled(midlet) && storageName.equals(msuite.getStorageName())) {
            return false;
        }
        this.nextMidletSuiteToRun = storageName;
        this.nextMidletToRun = midlet;
        return true;
    }

    public String getNextMIDletSuiteToRun() {
        return this.nextMidletSuiteToRun;
    }

    public String getNextMIDletToRun() {
        return this.nextMidletToRun;
    }

    public String[] list() {
        Vector suiteList = this.getSuiteList();
        String[] array = new String[suiteList.size()];
        for (int i = 0; i < suiteList.size(); ++i) {
            array[i] = (String)suiteList.elementAt(i);
        }
        return array;
    }

    public boolean suiteExists(String storageName) {
        Vector suiteList = this.getSuiteList();
        for (int i = 0; i < suiteList.size(); ++i) {
            if (!suiteList.elementAt(i).equals(storageName)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Vector getSuiteList() {
        if (this.midletSuiteList != null) {
            return this.midletSuiteList;
        }
        this.midletSuiteList = new Vector();
        try {
            RandomAccessStream storage = new RandomAccessStream(classSecurityToken);
            storage.connect(File.getStorageRoot() + SUITE_LIST_FILENAME, 1);
            try {
                String line;
                DataInputStream in = storage.openDataInputStream();
                while ((line = in.readUTF()) != null) {
                    this.midletSuiteList.addElement(line);
                }
            }
            finally {
                storage.disconnect();
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        return this.midletSuiteList;
    }

    private void addToSuiteList(String storageName) {
        if (this.suiteExists(storageName)) {
            return;
        }
        Vector suiteList = this.getSuiteList();
        suiteList.addElement(storageName);
        this.saveSuiteList(suiteList);
    }

    private boolean removeFromSuiteList(String storageName) {
        if (!this.suiteExists(storageName)) {
            return false;
        }
        Vector suiteList = this.getSuiteList();
        suiteList.removeElement(storageName);
        this.saveSuiteList(suiteList);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveSuiteList(Vector list) {
        File file = new File(classSecurityToken);
        RandomAccessStream storage = new RandomAccessStream(classSecurityToken);
        String filename = File.getStorageRoot() + SUITE_LIST_FILENAME;
        try {
            file.delete(filename);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            storage.connect(filename, -3);
            try {
                DataOutputStream out = storage.openDataOutputStream();
                for (int i = 0; i < list.size(); ++i) {
                    String line = (String)list.elementAt(i);
                    out.writeUTF(line);
                }
            }
            finally {
                storage.disconnect();
            }
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    public String getCAFromJad() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getCA(String storageRoot) {
        RandomAccessStream myStorage = new RandomAccessStream(classSecurityToken);
        try {
            String ca;
            myStorage.connect(storageRoot + CA_FILENAME, 1);
            try {
                DataInputStream dataStream = myStorage.openDataInputStream();
                ca = dataStream.readUTF();
            }
            finally {
                myStorage.disconnect();
            }
            return ca;
        }
        catch (IOException ioe) {
            return null;
        }
    }

    protected class InstallStateImpl
    implements InstallState,
    MIDletSuite {
        protected InstallListener listener;
        protected long startTime;
        protected int nextStep;
        protected boolean stopInstallation;
        protected boolean writingSuite;
        protected InvalidJadException exception;
        protected String jadUrl;
        protected boolean force;
        protected boolean removeRMS;
        protected byte[] jad;
        protected String jadEncoding;
        protected JadProperties jadProps;
        protected ManifestProperties jarProps;
        protected File file;
        protected String username;
        protected String password;
        protected String proxyUsername;
        protected String proxyPassword;
        protected String suiteName;
        protected String vendor;
        protected String version;
        protected String description;
        protected String storageName;
        protected String ca;
        protected int expectedJarSize;
        protected String jarUrl;
        protected int beginTransferDataStatus;
        protected int transferStatus;
        private byte pushInterruptSetting;
        private byte[][] permissions;
        private SecurityToken securityToken;
        private boolean trusted;
        protected byte[] manifest;
        protected String tempFilename;
        protected RandomAccessStream storage;
        protected String storageRoot;
        protected boolean isPreviousVersion;
        protected MIDletSuite previousSuite;
        protected String previousUrl;
        protected String previousJadUrl;
        protected String previousJarUrl;
        private String previousCA;
        private CHManager chinstaller;
        protected byte[] suiteIcon = null;

        protected InstallStateImpl() {
        }

        public InvalidJadException getLastException() {
            return this.exception;
        }

        public String getStorageName() {
            return this.storageName;
        }

        public void setUsername(String theUsername) {
            this.username = theUsername;
        }

        public void setPassword(String thePassword) {
            this.password = thePassword;
        }

        public void setProxyUsername(String theUsername) {
            this.proxyUsername = theUsername;
        }

        public void setProxyPassword(String thePassword) {
            this.proxyPassword = thePassword;
        }

        public String getAppProperty(String key) {
            String value;
            if (Installer.this.state.jadProps != null && (value = Installer.this.state.jadProps.getProperty(key)) != null) {
                return value;
            }
            if (Installer.this.state.jarProps != null && (value = Installer.this.state.jarProps.getProperty(key)) != null) {
                return value;
            }
            return null;
        }

        public String getJarUrl() {
            return this.jarUrl;
        }

        public int getJarSize() {
            return (this.expectedJarSize + 1023) / 1024;
        }

        public void checkForPermission(int permission, String resource, String extraValue) throws InterruptedException {
            this.securityToken.checkForPermission(permission, Permissions.getTitle(permission), Permissions.getQuestion(permission), Installer.this.state.suiteName, resource, extraValue, Permissions.getName(permission));
        }

        public void checkForPermission(int permission, String resource) throws InterruptedException {
            this.checkForPermission(permission, resource, null);
        }

        public boolean isRegistered(String midletName) {
            int i = 1;
            String midlet;
            while ((midlet = this.getAppProperty("MIDlet-" + i)) != null) {
                MIDletInfo midletInfo = new MIDletInfo(midlet);
                if (midletInfo.classname.equals(midletName)) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        public String getProperty(String key) {
            return this.getAppProperty(key);
        }

        public String getDownloadUrl() {
            if (this.jadUrl != null) {
                return this.jadUrl;
            }
            return this.jarUrl;
        }

        public String getCA() {
            return this.ca;
        }

        public int getPushInterruptSetting() {
            return this.pushInterruptSetting;
        }

        public boolean isTrusted() {
            return this.trusted;
        }

        public void setTrusted(boolean trusted) {
        }

        public String getJadUrl() {
            return this.jadUrl;
        }

        public String getStorageRoot() {
            return this.storageRoot + this.storageName;
        }

        public void addProperty(String key, String value) {
            if (key == null || value == null) {
                return;
            }
            if (this.jadProps != null) {
                this.jadProps.setProperty(key, value);
            }
            if (this.jarProps != null) {
                this.jarProps.setProperty(key, value);
            }
        }

        public int getNumberOfMIDlets() {
            throw new RuntimeException("Not Implemented");
        }

        public String getInitialMIDletClassname() {
            throw new RuntimeException("Not Implemented");
        }

        public void checkIfPermissionAllowed(int permission) {
            throw new RuntimeException("Not Implemented");
        }

        public int checkPermission(String permission) {
            throw new RuntimeException("Not Implemented");
        }

        public byte[] getResource(String name) {
            throw new RuntimeException("Not Implemented");
        }

        public int getStorageUsed() {
            throw new RuntimeException("Not Implemented");
        }

        public byte[][] getPermissions() {
            throw new RuntimeException("Not Implemented");
        }

        public void saveSettings() {
            throw new RuntimeException("Not Implemented");
        }

        public boolean permissionToInterrupt(String connection) {
            return this.permissionToInterrupt(connection, false);
        }

        public boolean permissionToInterrupt(String connection, boolean isBluetooth) {
            throw new RuntimeException("Not Implemented");
        }

        public PaymentInfo getPaymentInfo() {
            return null;
        }

        public void savePaymentInfo() throws IOException {
        }

        public int getPaymentID() {
            return -1;
        }

        static /* synthetic */ byte[][] access$202(InstallStateImpl x0, byte[][] x1) {
            x0.permissions = x1;
            return x1;
        }
    }
}

