/*
 * Decompiled with CFR 0.152.
 */
package com.sun.midp.midletsuite;

import com.sun.j2me.payment.PaymentException;
import com.sun.j2me.payment.PaymentInfo;
import com.sun.j2me.payment.PaymentModule;
import com.sun.kvem.io.j2me.push.BTPushAdaptor;
import com.sun.kvem.payment.KvemPaymentModule;
import com.sun.midp.io.j2me.storage.File;
import com.sun.midp.io.j2me.storage.RandomAccessStream;
import com.sun.midp.lcdui.Resource;
import com.sun.midp.midlet.MIDletInfo;
import com.sun.midp.midlet.MIDletSuite;
import com.sun.midp.midlet.Scheduler;
import com.sun.midp.midletsuite.Installer;
import com.sun.midp.midletsuite.JadProperties;
import com.sun.midp.midletsuite.JarReader;
import com.sun.midp.midletsuite.ManifestProperties;
import com.sun.midp.security.Permissions;
import com.sun.midp.security.SecurityToken;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Vector;

public class MIDletSuiteImpl
implements MIDletSuite {
    static final String PUSH_INTERRUPT_DIALOG_TITLE = "Is it OK to Automatically Start?";
    protected static final String PUSH_INTERRUPT_QUESTION = "Information is arriving for %1. Is it OK for %1 to startup and receive this information? The currently running application will exit.\n\nIs it OK to start up?";
    protected static final String PUSH_INTERRUPT_QUESTION_FOR_BT_1 = "Information is arriving from device ";
    protected static final String PUSH_INTERRUPT_QUESTION_FOR_BT_2 = ", for %1. Is it OK for %1 to startup and receive this information? The currently running application will exit.\n\nIs it OK to start up?";
    private static SecurityToken classSecurityToken;
    private JadProperties bufferedJadProps;
    private ManifestProperties bufferedJarProps;
    private SecurityToken securityToken;
    private byte[][] permissions;
    private int pushInterruptSetting;
    private String storageRoot;
    private String storageName;
    private String ca;
    private boolean trusted;
    private String initialMIDletClassName;
    private int numberOfMidlets = -1;
    private BTPushAdaptor btPushAdaptor = null;
    private PaymentInfo paymentInfo;
    private int paymentID = -1;

    static void initSecurityToken(SecurityToken token) {
        if (classSecurityToken != null) {
            return;
        }
        classSecurityToken = token;
    }

    protected MIDletSuiteImpl(SecurityToken callerSecurityToken, byte[][] suitePermissions, int pushSetting, boolean trustedFlag, String theStorageName) {
        callerSecurityToken.checkIfPermissionAllowed(0);
        this.permissions = suitePermissions;
        this.securityToken = new SecurityToken(classSecurityToken, this.permissions, this);
        this.pushInterruptSetting = pushSetting;
        this.trusted = trustedFlag;
        this.storageName = theStorageName;
    }

    MIDletSuiteImpl(SecurityToken callerSecurityToken, String theStorageRoot, String theStorageName, String theCA, String midletToRun) {
        callerSecurityToken.checkIfPermissionAllowed(0);
        this.storageRoot = theStorageRoot;
        this.storageName = theStorageName;
        this.ca = theCA;
        this.readSettings();
        this.permissions[0][35] = 16;
        this.permissions[1][35] = 16;
        this.permissions[1][54] = 16;
        this.permissions[0][54] = 16;
        this.permissions[0][51] = 16;
        this.permissions[1][51] = 16;
        this.permissions[0][55] = 16;
        this.permissions[1][55] = 16;
        this.securityToken = new SecurityToken(classSecurityToken, this.permissions, this);
        if (midletToRun != null) {
            this.initialMIDletClassName = this.getMIDletClassName(midletToRun);
        }
    }

    MIDletSuiteImpl(SecurityToken callerSecurityToken, String theStorageRoot, String theStorageName, String theCA, int midletToRun) {
        this(callerSecurityToken, theStorageRoot, theStorageName, theCA, null);
        String temp = this.getProperty("MIDlet-" + midletToRun);
        if (temp == null) {
            return;
        }
        this.initialMIDletClassName = new MIDletInfo((String)temp).classname;
    }

    public String getProperty(String key) {
        String prop;
        if (this.bufferedJadProps == null) {
            this.getPropertiesFromStorage();
            if (this.bufferedJadProps == null) {
                return null;
            }
        }
        if ((prop = this.bufferedJadProps.getProperty(key)) != null) {
            return prop;
        }
        if (this.bufferedJarProps == null) {
            return null;
        }
        return this.bufferedJarProps.getProperty(key);
    }

    public void addProperty(String key, String value) {
        MIDletSuite current = Scheduler.getScheduler().getMIDletSuite();
        if (current != null) {
            current.checkIfPermissionAllowed(0);
        }
        if (this.bufferedJadProps != null) {
            this.bufferedJadProps.addProperty(key, value);
            return;
        }
        this.bufferedJarProps.addProperty(key, value);
    }

    public int getNumberOfMIDlets() {
        if (this.numberOfMidlets <= 0) {
            this.numberOfMidlets = this.countMIDlets();
        }
        return this.numberOfMidlets;
    }

    public String getInitialMIDletClassname() {
        if (this.initialMIDletClassName != null) {
            return this.initialMIDletClassName;
        }
        if (this.getNumberOfMIDlets() == 1) {
            return new MIDletInfo((String)this.getProperty((String)"MIDlet-1")).classname;
        }
        return "com.sun.midp.midlet.Selector";
    }

    public void checkIfPermissionAllowed(int permission) {
        this.securityToken.checkIfPermissionAllowed(permission);
    }

    public void checkForPermission(int permission, String resource) throws InterruptedException {
        this.checkForPermission(permission, this.getProperty("MIDlet-Name"), resource, null);
    }

    public void checkForPermission(int permission, String resource, String extraValue) throws InterruptedException {
        this.checkForPermission(permission, this.getProperty("MIDlet-Name"), resource, extraValue);
    }

    protected void checkForPermission(int permission, String name, String resource, String extraValue) throws InterruptedException {
        this.securityToken.checkForPermission(permission, Permissions.getTitle(permission), Permissions.getQuestion(permission), name, resource, extraValue);
    }

    public int checkPermission(String permission) {
        return this.securityToken.checkPermission(permission);
    }

    public String getStorageRoot() {
        return this.storageRoot;
    }

    public String getStorageName() {
        return this.storageName;
    }

    public byte[] getResource(String name) {
        if (name.charAt(0) == '/') {
            name = name.substring(1, name.length());
        }
        try {
            return JarReader.readJarEntry(classSecurityToken, this.getStorageRoot() + "suite.jar", name);
        }
        catch (IOException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getStorageUsed() {
        File file = new File(classSecurityToken);
        RandomAccessStream stream = new RandomAccessStream(classSecurityToken);
        int storageUsed = 0;
        Vector files = file.filenamesThatStartWith(this.getStorageRoot());
        for (int i = 0; i < files.size(); ++i) {
            try {
                stream.connect((String)files.elementAt(i), 1);
                try {
                    storageUsed += stream.getSizeOf();
                    continue;
                }
                finally {
                    stream.disconnect();
                }
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
        if (this.getPaymentInfo() != null) {
            KvemPaymentModule paymentModule = (KvemPaymentModule)PaymentModule.getInstance();
            storageUsed += paymentModule.getSizeUsedInStore(this.getPaymentID());
        }
        return storageUsed;
    }

    public String getDownloadUrl() {
        String url = this.getJadUrl();
        if (url != null) {
            return url;
        }
        return this.getJarUrl();
    }

    public String getCA() {
        return this.ca;
    }

    protected int countMIDlets() {
        int i = 1;
        while (this.getProperty("MIDlet-" + i) != null) {
            ++i;
        }
        return i - 1;
    }

    protected String getMIDletClassName(String midletName) {
        int i = 1;
        while (true) {
            String midlet;
            if ((midlet = this.getProperty("MIDlet-" + i)) == null) {
                try {
                    Class.forName(midletName);
                    return midletName;
                }
                catch (Exception e) {
                    return null;
                }
            }
            MIDletInfo midletInfo = new MIDletInfo(midlet);
            if (midletInfo.name.equals(midletName)) {
                return midletInfo.classname;
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getPropertiesFromStorage() {
        ByteArrayInputStream is;
        byte[] buffer;
        int size;
        DataInputStream dis;
        String jadEncoding = null;
        RandomAccessStream myStorage = new RandomAccessStream(classSecurityToken);
        try {
            myStorage.connect(this.storageRoot + "jadEncoding.utf", 1);
            try {
                dis = myStorage.openDataInputStream();
                try {
                    jadEncoding = dis.readUTF();
                }
                finally {
                    dis.close();
                }
            }
            finally {
                myStorage.disconnect();
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        this.bufferedJadProps = new JadProperties();
        try {
            myStorage.connect(this.storageRoot + "suite.jad", 1);
            try {
                size = myStorage.getSizeOf();
                buffer = new byte[size];
                dis = myStorage.openDataInputStream();
                try {
                    dis.readFully(buffer);
                    is = new ByteArrayInputStream(buffer);
                    this.bufferedJadProps.load(is, jadEncoding);
                    buffer = null;
                    is = null;
                }
                finally {
                    dis.close();
                }
            }
            finally {
                myStorage.disconnect();
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            myStorage.connect(this.storageRoot + "suite.mf", 1);
            try {
                size = myStorage.getSizeOf();
                buffer = new byte[size];
                dis = myStorage.openDataInputStream();
                try {
                    dis.readFully(buffer);
                    is = new ByteArrayInputStream(buffer);
                    this.bufferedJarProps = new ManifestProperties();
                    this.bufferedJarProps.load(is);
                    buffer = null;
                    is = null;
                }
                finally {
                    dis.close();
                }
            }
            finally {
                myStorage.disconnect();
            }
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    public int getPushInterruptSetting() {
        return this.pushInterruptSetting;
    }

    public byte[][] getPermissions() {
        return this.copyPermissions(this.permissions);
    }

    protected byte[][] copyPermissions(byte[][] permissions) {
        if (permissions == null) {
            return null;
        }
        byte[][] copy = new byte[2][];
        for (int i = 0; i < 2; ++i) {
            copy[i] = new byte[permissions[i].length];
            System.arraycopy(permissions[i], 0, copy[i], 0, permissions[i].length);
        }
        return copy;
    }

    public void saveSettings() {
        try {
            Installer.saveSuiteSettings(classSecurityToken, this.storageRoot, (byte)this.pushInterruptSetting, this.permissions, this.trusted);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readSettings() {
        byte[] maximums = Permissions.getEmptySet();
        byte[] currentLevels = Permissions.getEmptySet();
        RandomAccessStream storage = new RandomAccessStream(classSecurityToken);
        this.permissions = new byte[2][];
        this.permissions[0] = maximums;
        this.permissions[1] = currentLevels;
        try {
            storage.connect(this.getStorageRoot() + "settings.bin", 1);
            try {
                DataInputStream storageStream = storage.openDataInputStream();
                byte version = storageStream.readByte();
                if (version != 1) {
                    System.out.println("Corrupt application settings file.");
                    return;
                }
                this.trusted = storageStream.readBoolean();
                this.pushInterruptSetting = storageStream.readByte();
                byte count = storageStream.readByte();
                storageStream.readFully(currentLevels, 0, count);
                count = storageStream.readByte();
                storageStream.readFully(maximums, 0, count);
            }
            finally {
                storage.disconnect();
            }
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    public boolean permissionToInterrupt(String connection) {
        return this.permissionToInterrupt(connection, false);
    }

    public boolean permissionToInterrupt(String connection, boolean isBluetooth) {
        String currentName;
        String question;
        String automaticInterrupt = System.getProperty("AUTOINTERRUPT");
        if (automaticInterrupt != null && automaticInterrupt.equalsIgnoreCase("true")) {
            return true;
        }
        switch (this.pushInterruptSetting) {
            case 1: 
            case 2: {
                return true;
            }
            case -128: 
            case 0: {
                return false;
            }
        }
        String name = this.getSuiteNameForInterrupt();
        MIDletSuite current = Scheduler.getScheduler().getMIDletSuite();
        if (current instanceof MIDletSuiteImpl) {
            MIDletSuiteImpl temp = (MIDletSuiteImpl)current;
            question = isBluetooth ? temp.getPushInterruptQuestionForBluetooth() : temp.getPushInterruptQuestion();
            currentName = temp.getSuiteNameForInterrupt();
        } else {
            question = isBluetooth ? this.getPushInterruptQuestionForBluetooth() : this.getPushInterruptQuestion();
            currentName = Resource.getString("The current application");
        }
        try {
            boolean interruptOk = SecurityToken.askUserForPermission(classSecurityToken, "Can %1 Interrupt?", question, name, currentName, null, null);
            switch (this.pushInterruptSetting) {
                case 4: {
                    if (interruptOk) {
                        this.pushInterruptSetting = 2;
                        return true;
                    }
                    this.pushInterruptSetting = -128;
                    return false;
                }
                case 8: 
                case 32: {
                    if (interruptOk) {
                        this.pushInterruptSetting = 8;
                        return true;
                    }
                    this.pushInterruptSetting = 32;
                    return false;
                }
                case 16: 
                case 64: {
                    if (interruptOk) {
                        this.pushInterruptSetting = 16;
                        return true;
                    }
                    this.pushInterruptSetting = 64;
                    return false;
                }
            }
            return false;
        }
        catch (InterruptedException ie) {
            return false;
        }
    }

    public boolean isTrusted() {
        return this.trusted;
    }

    public boolean isRegistered(String midletName) {
        int i = 1;
        String midlet;
        while ((midlet = this.getProperty("MIDlet-" + i)) != null) {
            MIDletInfo midletInfo = new MIDletInfo(midlet);
            if (midletInfo.classname.equals(midletName)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected String getPushInterruptQuestion() {
        return PUSH_INTERRUPT_QUESTION;
    }

    protected String getPushInterruptQuestionForBluetooth() {
        String friendlyName;
        if (this.btPushAdaptor == null) {
            try {
                this.btPushAdaptor = (BTPushAdaptor)Class.forName("com.sun.midp.io.JSR082PushAdaptor").newInstance();
            }
            catch (Exception e) {
                return this.getPushInterruptQuestion();
            }
        }
        if ((friendlyName = this.btPushAdaptor.getCurrentFriendlyName()) != null && friendlyName.length() > 0) {
            return PUSH_INTERRUPT_QUESTION_FOR_BT_1 + friendlyName + PUSH_INTERRUPT_QUESTION_FOR_BT_2;
        }
        return this.getPushInterruptQuestion();
    }

    protected String getSuiteNameForInterrupt() {
        return this.getProperty("MIDlet-Name");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getJadUrl() {
        RandomAccessStream storage = new RandomAccessStream(classSecurityToken);
        try {
            storage.connect(this.getStorageRoot() + "jadUrl.utf", 1);
            DataInputStream storageStream = storage.openDataInputStream();
            String string = storageStream.readUTF();
            return string;
        }
        catch (Exception e) {
            String string = null;
            return string;
        }
        finally {
            try {
                storage.disconnect();
            }
            catch (IOException e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getJarUrl() {
        RandomAccessStream storage = new RandomAccessStream(classSecurityToken);
        try {
            storage.connect(this.getStorageRoot() + "jarUrl.utf", 1);
            DataInputStream storageStream = storage.openDataInputStream();
            String string = storageStream.readUTF();
            return string;
        }
        catch (Exception e) {
            String string = "unknown";
            return string;
        }
        finally {
            try {
                storage.disconnect();
            }
            catch (IOException e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PaymentInfo getPaymentInfo() {
        if (this.paymentInfo == null) {
            if (this.getProperty("Pay-Version") == null) {
                return null;
            }
            if (this.bufferedJadProps == null) {
                this.getPropertiesFromStorage();
                if (this.bufferedJadProps == null || this.bufferedJarProps == null) {
                    return null;
                }
            }
            RandomAccessStream storage = new RandomAccessStream(classSecurityToken);
            File file = new File(classSecurityToken);
            JadProperties jadProps = this.bufferedJadProps;
            if (System.getProperty("sun.payment.dbgpropsinjar") != null) {
                jadProps = this.bufferedJarProps;
            }
            if (file.exists(this.storageRoot + "suite.jpp")) {
                try {
                    storage.connect(this.storageRoot + "suite.jpp", 1);
                    try {
                        byte[] data = new byte[storage.getSizeOf()];
                        storage.readBytes(data, 0, data.length);
                        ByteArrayInputStream bis = new ByteArrayInputStream(data);
                        ManifestProperties payProps = new ManifestProperties();
                        payProps.load(bis);
                        ((InputStream)bis).close();
                        this.paymentInfo = PaymentInfo.createFromProperties(jadProps, payProps);
                    }
                    finally {
                        storage.disconnect();
                    }
                }
                catch (IOException e) {
                }
                catch (PaymentException e) {
                    System.out.println(e.getMessage());
                }
            } else {
                try {
                    this.paymentInfo = PaymentInfo.createFromProperties(jadProps, this.bufferedJarProps);
                }
                catch (PaymentException e) {
                    System.out.println(e.getMessage());
                }
            }
            if (this.paymentInfo != null) {
                KvemPaymentModule paymentModule = (KvemPaymentModule)PaymentModule.getInstance();
                paymentModule.initializeTransactionStore(this);
            }
        }
        return this.paymentInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void savePaymentInfo() throws IOException {
        PaymentInfo paymentInfo = this.getPaymentInfo();
        if (paymentInfo != null) {
            byte[] data;
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            OutputStreamWriter os = new OutputStreamWriter((OutputStream)bos, "UTF-8");
            try {
                paymentInfo.export(os);
                data = bos.toByteArray();
            }
            finally {
                os.close();
            }
            RandomAccessStream storage = new RandomAccessStream(classSecurityToken);
            storage.connect(this.storageRoot + "suite.jpp", -3);
            try {
                storage.writeBytes(data, 0, data.length);
            }
            finally {
                storage.disconnect();
            }
        }
    }

    public int getPaymentID() {
        if (this.paymentID == -1) {
            this.paymentID = MIDletSuiteImpl.getPaymentID(this.storageRoot);
        }
        return this.paymentID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getPaymentID(String storageRoot) {
        File file = new File(classSecurityToken);
        if (!file.exists(storageRoot + "suite.pay")) {
            return -1;
        }
        int paymentID = -1;
        RandomAccessStream storage = new RandomAccessStream(classSecurityToken);
        try {
            storage.connect(storageRoot + "suite.pay", 1);
            try {
                DataInputStream is = storage.openDataInputStream();
                try {
                    paymentID = is.readInt();
                }
                finally {
                    is.close();
                }
            }
            finally {
                storage.disconnect();
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        return paymentID;
    }
}

