/*
 * Decompiled with CFR 0.152.
 */
package com.sun.midp.publickeystore;

import com.sun.midp.io.j2me.storage.File;
import com.sun.midp.io.j2me.storage.RandomAccessStream;
import com.sun.midp.publickeystore.PublicKeyInfo;
import com.sun.midp.publickeystore.PublicKeyStore;
import com.sun.midp.security.SecurityToken;
import com.sun.midp.ssl.CertStore;
import com.sun.midp.ssl.SSLStreamConnection;
import com.sun.midp.ssl.X509Certificate;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;

public class WebPublicKeyStore
extends PublicKeyStore
implements CertStore {
    private static SecurityToken classSecurityToken;
    private static WebPublicKeyStore trustedKeyStore;

    public static void initSecurityToken(SecurityToken token) {
        if (classSecurityToken == null) {
            classSecurityToken = token;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadCertificateAuthorities() {
        WebPublicKeyStore ks;
        InputStream tks;
        RandomAccessStream storage;
        if (trustedKeyStore != null) {
            return;
        }
        try {
            storage = new RandomAccessStream(classSecurityToken);
            storage.connect(File.getStorageRootFor("_main.ks"), 1);
            tks = storage.openInputStream();
        }
        catch (Exception e) {
            System.out.println("Could not open the trusted key store, cannot authenticate HTTPS servers");
            return;
        }
        try {
            ks = new WebPublicKeyStore(tks);
        }
        catch (Exception e) {
            System.out.println("Corrupt key store file, cannot authenticate HTTPS servers");
            e.printStackTrace();
            return;
        }
        finally {
            try {
                storage.disconnect();
            }
            catch (Exception e) {}
        }
        WebPublicKeyStore.setTrustedKeyStore(ks);
    }

    public static void resetCertificateAuthorities() {
        trustedKeyStore = null;
    }

    private static void setTrustedKeyStore(WebPublicKeyStore keyStore) {
        if (trustedKeyStore != null) {
            return;
        }
        trustedKeyStore = keyStore;
        SSLStreamConnection.setTrustedCertStore(keyStore);
        SSLStreamConnection.lockTrustedCertStore();
    }

    public static WebPublicKeyStore getTrustedKeyStore() {
        if (trustedKeyStore == null) {
            WebPublicKeyStore.loadCertificateAuthorities();
        }
        return trustedKeyStore;
    }

    public WebPublicKeyStore(InputStream in) throws IOException {
        super(in);
    }

    public X509Certificate[] getCertificates(String subjectName) {
        Vector keys = this.findKeys(subjectName);
        if (keys == null) {
            return null;
        }
        X509Certificate[] certs = new X509Certificate[keys.size()];
        for (int i = 0; i < keys.size(); ++i) {
            certs[i] = WebPublicKeyStore.createCertificate((PublicKeyInfo)keys.elementAt(i));
        }
        return certs;
    }

    public static X509Certificate createCertificate(PublicKeyInfo keyInfo) {
        if (keyInfo == null) {
            return null;
        }
        try {
            X509Certificate cert = new X509Certificate(1, new byte[0], keyInfo.getOwner(), keyInfo.getOwner(), keyInfo.getNotBefore(), keyInfo.getNotAfter(), keyInfo.getModulus(), keyInfo.getExponent(), null, 0);
            return cert;
        }
        catch (Exception e) {
            return null;
        }
    }
}

