/*
 * Decompiled with CFR 0.152.
 */
package com.sun.midp.security;

import com.sun.midp.io.j2me.storage.File;
import com.sun.midp.io.j2me.storage.RandomAccessStream;
import com.sun.midp.lcdui.DisplayManager;
import com.sun.midp.lcdui.DisplayManagerFactory;
import com.sun.midp.lcdui.MIDletEventListener;
import com.sun.midp.lcdui.Resource;
import com.sun.midp.midlet.MIDletSuite;
import com.sun.midp.publickeystore.PublicKeyInfo;
import com.sun.midp.publickeystore.WebPublicKeyStore;
import com.sun.midp.security.SecurityToken;
import java.io.IOException;
import java.util.Vector;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.midlet.MIDlet;

class ConfirmPermission
implements CommandListener,
MIDletEventListener {
    private DisplayManager displayManager = DisplayManagerFactory.getDisplayManager();
    private Command yesCmd = new Command(Resource.getString("Yes"), 4, 1);
    private Command noCmd = new Command(Resource.getString("No"), 2, 1);
    private boolean answer;
    private final Alert alert;
    private final SecurityToken securityToken;

    ConfirmPermission(SecurityToken token, String title, String question, String app, String resource, String extraValue, MIDletSuite midletSuite) {
        byte[] rawPng;
        String[] substitutions = new String[]{app, resource, extraValue};
        this.alert = new Alert(Resource.getString(title, substitutions));
        this.securityToken = token;
        Image icon = null;
        Image iconAuth = null;
        Image mutableImage = null;
        String iconFilename = File.getConfigRoot() + "security_query.png";
        RandomAccessStream stream = new RandomAccessStream(token);
        try {
            stream.connect(iconFilename, 1);
            rawPng = new byte[stream.getSizeOf()];
            stream.readBytes(rawPng, 0, rawPng.length);
            stream.disconnect();
            icon = Image.createImage(rawPng, 0, rawPng.length);
        }
        catch (IOException noImage) {
            // empty catch block
        }
        if (midletSuite != null) {
            Vector keys;
            iconFilename = File.getConfigRoot() + (midletSuite.isTrusted() ? "trusted_prompt.png" : "untrusted_prompt.png");
            stream = new RandomAccessStream(token);
            try {
                stream.connect(iconFilename, 1);
                rawPng = new byte[stream.getSizeOf()];
                stream.readBytes(rawPng, 0, rawPng.length);
                stream.disconnect();
                iconAuth = Image.createImage(rawPng, 0, rawPng.length);
            }
            catch (IOException ioe) {
                // empty catch block
            }
            if (icon != null && iconAuth != null) {
                mutableImage = Image.createImage(icon.getWidth(), icon.getHeight() + 2 * iconAuth.getHeight());
                Graphics gr = mutableImage.getGraphics();
                gr.drawImage(icon, 0, 0, 20);
                gr.drawImage(iconAuth, icon.getWidth() / 2, icon.getHeight() + iconAuth.getHeight(), 17);
            }
            this.alert.setImage(mutableImage);
            StringBuffer alertText = new StringBuffer();
            alertText.append(Resource.getString(question, substitutions));
            String ca = midletSuite.getCA();
            if (ca != null && ca.length() > 0 && ((PublicKeyInfo)(keys = WebPublicKeyStore.getTrustedKeyStore().findKeys(ca)).elementAt(0)).getDomain().equals("identified_third_party")) {
                alertText.append("\n\n");
                alertText.append(Resource.getString("Certificate Authority:"));
                alertText.append("\n");
                int delimiter = 59;
                String[] shortcuts = new String[]{"O=", "OU=", "ST=", "C=", "L=", "CN="};
                String[] fields = new String[]{Resource.getString("Organization"), Resource.getString("Organization Unit"), Resource.getString("State (Province)"), Resource.getString("Country Code"), Resource.getString("Locality (City)"), Resource.getString("Computer Name")};
                StringBuffer label = new StringBuffer(40);
                int pos = 0;
                int nLabels = 0;
                for (int i = 0; i < fields.length; ++i) {
                    pos = ca.indexOf(shortcuts[i]);
                    if (pos == -1) continue;
                    int posEnd = ca.indexOf(59, pos += shortcuts[i].length());
                    if (posEnd == -1) {
                        posEnd = ca.length();
                    }
                    label.setLength(0);
                    label.append(fields[i]);
                    label.append(": ");
                    alertText.append(label.toString());
                    alertText.append(ca.substring(pos, posEnd));
                    alertText.append("\n");
                    ++nLabels;
                }
                if (nLabels == 0) {
                    alertText.append(Resource.getString("None"));
                }
            }
            this.alert.setString(alertText.toString());
        } else {
            if (icon != null) {
                this.alert.setImage(icon);
            }
            this.alert.setString(Resource.getString(question, substitutions));
        }
        this.alert.addCommand(this.noCmd);
        this.alert.addCommand(this.yesCmd);
        this.alert.setCommandListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean doModal() throws InterruptedException {
        ConfirmPermission confirmPermission = this;
        synchronized (confirmPermission) {
            this.answer = false;
            Object preemptToken = this.displayManager.preemptDisplay(this.securityToken, this, this.alert, true);
            if (preemptToken == null) {
                return false;
            }
            try {
                this.wait();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.displayManager.donePreempting(preemptToken);
            return this.answer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setAnswer(boolean theAnswer) {
        ConfirmPermission confirmPermission = this;
        synchronized (confirmPermission) {
            this.answer = theAnswer;
            this.notify();
        }
    }

    public void commandAction(Command c, Displayable s) {
        if (c == this.yesCmd) {
            this.setAnswer(true);
        } else {
            this.setAnswer(false);
        }
    }

    public void pauseMIDlet(MIDlet midlet) {
    }

    public void startMIDlet(MIDlet midlet) {
    }

    public void destroyMIDlet(MIDlet midlet) {
    }
}

