/*
 * Decompiled with CFR 0.152.
 */
package com.sun.midp.security;

import com.sun.midp.io.Util;
import com.sun.midp.io.j2me.storage.File;
import com.sun.midp.io.j2me.storage.RandomAccessStream;
import com.sun.midp.midletsuite.InvalidJadException;
import com.sun.midp.midletsuite.ManifestProperties;
import com.sun.midp.security.PermissionProperties;
import com.sun.midp.security.SecurityToken;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public final class Permissions {
    public static final String POLICY_FILENAME = "_policy.txt";
    private static final String PERMISSIONS_FILENAME = "_permissions.txt";
    private static final String FUNCTION_GROUPS_FILENAME = "_function_groups.txt";
    public static final String INTERNAL_DOMAIN_NAME = "internal";
    public static String UNTRUSTED_DOMAIN_NAME = "unidentified_third_party";
    public static final String IDENTIFIED_THIRD_PARTY_DOMAIN = "identified_third_party";
    private static final String[] names = new String[]{"com.sun.midp", "com.sun.midp.midletsuite.ams", "javax.microedition.io.Connector.http", "javax.microedition.io.Connector.socket", "javax.microedition.io.Connector.https", "javax.microedition.io.Connector.ssl", "javax.microedition.io.Connector.serversocket", "javax.microedition.io.Connector.datagram", "javax.microedition.io.Connector.datagramreceiver", "javax.microedition.io.Connector.comm", "javax.microedition.io.PushRegistry", "javax.microedition.io.Connector.sms", "javax.microedition.io.Connector.cbs", "javax.wireless.messaging.sms.send", "javax.wireless.messaging.sms.receive", "javax.wireless.messaging.cbs.receive", "javax.microedition.media.control.RecordControl", "javax.microedition.media.control.VideoControl.getSnapshot", "javax.microedition.io.Connector.mms", "javax.wireless.messaging.mms.send", "javax.wireless.messaging.mms.receive", "javax.microedition.io.Connector.obex.client", "javax.microedition.io.Connector.obex.server", "javax.microedition.io.Connector.obex.client.tcp", "javax.microedition.io.Connector.obex.server.tcp", "javax.microedition.pim.ContactList.read", "javax.microedition.pim.ContactList.write", "javax.microedition.pim.EventList.read", "javax.microedition.pim.EventList.write", "javax.microedition.pim.ToDoList.read", "javax.microedition.pim.ToDoList.write", "javax.microedition.io.Connector.file.read", "javax.microedition.io.Connector.file.write", "javax.microedition.io.Connector.bluetooth.client", "javax.microedition.io.Connector.bluetooth.server", "javax.bluetooth.RemoteDevice.authorize", "javax.microedition.location.Location", "javax.microedition.location.Orientation", "javax.microedition.location.ProximityListener", "javax.microedition.location.LandmarkStore.read", "javax.microedition.location.LandmarkStore.write", "javax.microedition.location.LandmarkStore.category", "javax.microedition.location.LandmarkStore.management", "javax.microedition.apdu.aid", "javax.microedition.jcrmi", "javax.microedition.securityservice.CMSMessageSignatureService", "javax.microedition.apdu.sat", "javax.microedition.content.ContentHandler", "javax.microedition.payment.process", "javax.microedition.io.Connector.sip", "javax.microedition.io.Connector.sips", "javax.bluetooth.enable", "javax.microedition.amms.control.camera.enableShutterFeedback", "javax.microedition.amms.control.tuner.setPreset", "javax.bluetooth.discoverable", "com.sun.midp.pim.change"};
    public static final int MIDP = 0;
    public static final int AMS = 1;
    public static final int HTTP = 2;
    public static final int TCP = 3;
    public static final int HTTPS = 4;
    public static final int SSL = 5;
    public static final int TCP_SERVER = 6;
    public static final int UDP = 7;
    public static final int UDP_SERVER = 8;
    public static final int COMM = 9;
    public static final int PUSH = 10;
    public static final int SMS_SERVER = 11;
    public static final int CBS_SERVER = 12;
    public static final int SMS_SEND = 13;
    public static final int SMS_RECEIVE = 14;
    public static final int CBS_RECEIVE = 15;
    public static final int MM_RECORD = 16;
    public static final int MM_IMAGE_CAPTURING = 17;
    public static final int MMS_SERVER = 18;
    public static final int MMS_SEND = 19;
    public static final int MMS_RECEIVE = 20;
    public static final int OBEX_CLIENT = 21;
    public static final int OBEX_SERVER = 22;
    public static final int TCP_OBEX_CLIENT = 23;
    public static final int TCP_OBEX_SERVER = 24;
    public static final int PIM_CONTACT_READ = 25;
    public static final int PIM_CONTACT_WRITE = 26;
    public static final int PIM_EVENT_READ = 27;
    public static final int PIM_EVENT_WRITE = 28;
    public static final int PIM_TODO_READ = 29;
    public static final int PIM_TODO_WRITE = 30;
    public static final int FILE_CONNECTION_READ = 31;
    public static final int FILE_CONNECTION_WRITE = 32;
    public static final int BLUETOOTH_CLIENT = 33;
    public static final int BLUETOOTH_SERVER = 34;
    public static final int BT_AUTHORIZE = 35;
    public static final int LOCATION = 36;
    public static final int ORIENTATION = 37;
    public static final int LOCATION_PROXIMITY = 38;
    public static final int LANDMARK_READ = 39;
    public static final int LANDMARK_WRITE = 40;
    public static final int LANDMARK_CATEGORY = 41;
    public static final int LANDMARK_MANAGE = 42;
    public static final int APDU_CONNECTION = 43;
    public static final int JCRMI_CONNECTION = 44;
    public static final int SIGN_SERVICE = 45;
    public static final int APDU_CHANNEL0 = 46;
    public static final int CHAPI_REGISTER = 47;
    public static final int PAYMENT = 48;
    public static final int SIP = 49;
    public static final int SIPS = 50;
    public static final int BT_ENABLE = 51;
    public static final int AMMS_CAMERA_SHUTTERFEEDBACK = 52;
    public static final int AMMS_TUNER_SETPRESET = 53;
    public static final int BT_DISCOVERABLE = 54;
    public static final int PIM_ENTRY_CHANGE = 55;
    public static final int NUMBER_OF_PERMISSIONS = 56;
    public static final int MAX_LEVELS = 0;
    public static final int CUR_LEVELS = 1;
    public static final byte NEVER = 0;
    public static final byte ALLOW = 1;
    public static final byte BLANKET_GRANTED = 2;
    public static final byte BLANKET = 4;
    public static final byte SESSION = 8;
    public static final byte ONE_SHOT = 16;
    public static final byte DENY_SESSION = 32;
    public static final byte DENY = 64;
    public static final byte USER_DENIED = -128;
    private static final String USER_DATA_PIM_CHANGE_QUESTION = "%1 wants to %2 %3";
    private static final String USER_DATA_PIM_CHANGE_TITLE = "PIM entry changing";
    private static final String BT_ENABLE_QUESTION = "Your Bluetooth device is disabled.\n\nSelect \"Yes\" in order to enable %1 to use Bluetooth.";
    private static final String BT_ENABLE_TITLE = "Enable Bluetooth? ";
    private static final String BT_DISCOVERABLE_QUESTION = "Your Bluetooth device is not globally discoverable.\n\nSelect \"Yes\" in order to set your device discoverable.";
    private static final String BT_DISCOVERABLE_TITLE = "Set Bluetooth Discoverable? ";
    private static final String LEVEL_ALLOW = "allow";
    private static final String LEVEL_ONESHOT = "oneshot";
    private static final String LEVEL_SESSION = "session";
    private static final String LEVEL_BLANKET = "blanket";
    private static final String TAG_ALIAS = "alias";
    private static final String TAG_DOMAIN = "domain";
    private static final String TAG_TYPE = "policy_type";
    private static final String TAG_EXCLUDE = "exclude";
    private static final String TYPE_MSA = "msa";
    private static final String TYPE_JTWI = "jtwi";
    private static Hashtable permissionsTable = null;
    private static Hashtable promptsMap = null;
    private static Hashtable groupsMap = null;
    private static Hashtable aliasTable = null;
    private static Vector exclusions = null;
    private static boolean msa = true;
    private static SecurityToken token = null;

    public static void initSecurityToken(SecurityToken secToken) {
        token = secToken;
    }

    public static boolean applyMSA() {
        return msa;
    }

    public static String getName(int permission) {
        if (permission < 0 || permission >= names.length) {
            throw new SecurityException("Application not authorized to access the restricted API");
        }
        return names[permission];
    }

    public static String getTitle(int permission) {
        if (!Permissions.initialized()) {
            return "";
        }
        Vector prompts = (Vector)promptsMap.get(names[permission]);
        return (String)prompts.elementAt(0);
    }

    public static String getQuestion(int permission) {
        if (!Permissions.initialized()) {
            return "";
        }
        Vector prompts = (Vector)promptsMap.get(names[permission]);
        return (String)prompts.elementAt(1);
    }

    public static boolean excluded(String domain, String alias, byte level) {
        return new ExcludedLevel(domain, alias, level).existsIn(exclusions);
    }

    public static byte[][] forDomain(SecurityToken token, String name) {
        byte[] maximums = new byte[56];
        byte[] defaults = new byte[56];
        byte[][] permissions = new byte[][]{maximums, defaults};
        if (INTERNAL_DOMAIN_NAME.equals(name)) {
            for (int i = 0; i < maximums.length; ++i) {
                maximums[i] = 1;
                defaults[i] = 1;
            }
            return permissions;
        }
        if (Permissions.getPermissions(token, name, maximums, defaults)) {
            return permissions;
        }
        if (Permissions.getPermissions(token, UNTRUSTED_DOMAIN_NAME, maximums, defaults)) {
            return permissions;
        }
        throw new SecurityException(UNTRUSTED_DOMAIN_NAME + " domain is not configured");
    }

    public static byte[] getEmptySet() {
        byte[] permissions = new byte[56];
        Permissions.clearPerms(permissions);
        return permissions;
    }

    private static Vector expandAlias(Vector apiList, Hashtable aliasTable) {
        boolean aliasMatch = false;
        if (aliasTable == null || apiList == null) {
            return apiList;
        }
        Vector returnList = new Vector(apiList.size());
        for (int apiIdx = 0; apiIdx < apiList.size(); ++apiIdx) {
            String apiName = (String)apiList.elementAt(apiIdx);
            if (apiName.indexOf(46) == -1) {
                Enumeration e = aliasTable.keys();
                while (e.hasMoreElements()) {
                    String aliasName = (String)e.nextElement();
                    if (!apiName.equals(aliasName)) continue;
                    Vector aliasVector = (Vector)aliasTable.get(aliasName);
                    for (int i = 0; i < aliasVector.size(); ++i) {
                        returnList.addElement(aliasVector.elementAt(i));
                    }
                    aliasMatch = true;
                    break;
                }
            }
            if (aliasMatch) {
                aliasMatch = false;
                continue;
            }
            returnList.addElement(apiName);
        }
        return returnList;
    }

    private static void clearPerms(byte[] perms) {
        for (int i = 0; i < perms.length; ++i) {
            perms[i] = 0;
        }
    }

    private static int getPermIndex(String apiName) {
        for (int nameIdx = 0; nameIdx < names.length; ++nameIdx) {
            if (!names[nameIdx].equals(apiName)) continue;
            return nameIdx;
        }
        throw new IllegalArgumentException("bad API name: " + apiName);
    }

    private static void setPerms(byte[] perms, Vector apiList, byte highestLevel, byte defaultLevel) {
        for (int apiIdx = 0; apiIdx < apiList.size(); ++apiIdx) {
            int permIdx = Permissions.getPermIndex((String)apiList.elementAt(apiIdx)) * 2;
            perms[permIdx] = highestLevel;
            perms[permIdx + 1] = defaultLevel;
        }
    }

    private static byte getPermFromString(String permString) {
        if (LEVEL_ALLOW.equals(permString)) {
            return 1;
        }
        if (LEVEL_BLANKET.equals(permString)) {
            return 4;
        }
        if (LEVEL_SESSION.equals(permString)) {
            return 8;
        }
        if (LEVEL_ONESHOT.equals(permString)) {
            return 16;
        }
        throw new IllegalArgumentException("bad perm level: " + permString);
    }

    private static Vector makeVector(Object o1, Object o2) {
        Vector<Object> vector = new Vector<Object>();
        vector.addElement(o1);
        vector.addElement(o2);
        return vector;
    }

    private static void initializePromptsMap() {
        promptsMap = new Hashtable();
        promptsMap.put(names[0], Permissions.makeVector(names[0], names[0]));
        promptsMap.put(names[1], Permissions.makeVector(names[1], names[1]));
        promptsMap.put(names[54], Permissions.makeVector(BT_DISCOVERABLE_TITLE, BT_DISCOVERABLE_QUESTION));
        promptsMap.put(names[51], Permissions.makeVector(BT_ENABLE_TITLE, BT_ENABLE_QUESTION));
        promptsMap.put(names[55], Permissions.makeVector(USER_DATA_PIM_CHANGE_TITLE, USER_DATA_PIM_CHANGE_QUESTION));
    }

    private static String replaceCRLF(String value) {
        int posCRLF;
        int pos = 0;
        String result = "";
        while ((posCRLF = value.indexOf("\\n", pos)) != -1) {
            result = result + value.substring(pos, posCRLF) + "\n";
            pos = posCRLF + 2;
        }
        return result + value.substring(pos);
    }

    private static void loadProperties(InputStream is, ManifestProperties props) throws InvalidJadException {
        try {
            props.load(is);
        }
        catch (IOException ioe) {
            throw new InvalidJadException(2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static InputStream openPropertiesFile(RandomAccessStream storage, String fileName) throws InvalidJadException {
        ByteArrayInputStream is;
        try {
            storage.connect(File.getStorageRootFor(fileName), 1);
            try {
                byte[] data = new byte[storage.getSizeOf()];
                storage.readBytes(data, 0, data.length);
                is = new ByteArrayInputStream(data);
            }
            finally {
                storage.disconnect();
            }
        }
        catch (IOException e) {
            throw new InvalidJadException(2);
        }
        return is;
    }

    private static void processExclude(String val) throws InvalidJadException {
        byte level;
        Vector value = Util.getCommaSeparatedValues(val);
        if (value == null || value.size() < 3) {
            throw new InvalidJadException(29);
        }
        try {
            level = Permissions.getPermFromString((String)value.elementAt(2));
        }
        catch (IllegalArgumentException iae) {
            throw new InvalidJadException(29);
        }
        ExcludedLevel ex = new ExcludedLevel((String)value.elementAt(0), (String)value.elementAt(1), level);
        if (exclusions == null) {
            exclusions = new Vector();
        }
        exclusions.addElement(ex);
    }

    private static void processPolicyType(String val) {
        if (val.equals(TYPE_MSA)) {
            msa = true;
        } else {
            UNTRUSTED_DOMAIN_NAME = "untrusted";
            msa = false;
        }
    }

    private static void readFunctionGroups(SecurityToken token) throws InvalidJadException {
        RandomAccessStream storage = new RandomAccessStream(Permissions.token);
        InputStream is = Permissions.openPropertiesFile(storage, FUNCTION_GROUPS_FILENAME);
        if (is == null) {
            return;
        }
        ManifestProperties props = new ManifestProperties();
        Permissions.loadProperties(is, props);
        if (groupsMap == null) {
            groupsMap = new Hashtable();
        }
        for (int i = 0; i < props.size(); ++i) {
            String key = props.getKeyAt(i);
            String val = props.getValueAt(i);
            if (TAG_TYPE.equals(key)) {
                Permissions.processPolicyType(val);
                continue;
            }
            if (key.startsWith(TAG_EXCLUDE)) {
                Permissions.processExclude(val);
                continue;
            }
            Vector value = Util.getCommaSeparatedValues(val = Permissions.replaceCRLF(val));
            if (value == null || value.size() < 3) {
                throw new InvalidJadException(28);
            }
            groupsMap.put(key, value);
        }
    }

    private static void readPermissionsFile(SecurityToken token) throws InvalidJadException {
        RandomAccessStream storage = new RandomAccessStream(Permissions.token);
        InputStream is = Permissions.openPropertiesFile(storage, PERMISSIONS_FILENAME);
        if (is == null) {
            return;
        }
        ManifestProperties props = new ManifestProperties();
        Permissions.loadProperties(is, props);
        if (promptsMap == null) {
            Permissions.initializePromptsMap();
        }
        for (int i = 0; i < props.size(); ++i) {
            Vector<Object> value;
            String key = props.getKeyAt(i);
            String val = props.getValueAt(i);
            key = key.replace('_', '.');
            if (val.indexOf(44) == -1) {
                value = promptsMap.get((val = val.replace('_', '.')).trim());
                if (value == null) {
                    throw new InvalidJadException(28);
                }
                promptsMap.put(key, value);
                continue;
            }
            val = Permissions.replaceCRLF(val);
            value = Util.getCommaSeparatedValues(val);
            promptsMap.put(key, value);
        }
    }

    private static RandomAccessStream getStorage() {
        if (token == null) {
            return new RandomAccessStream();
        }
        return new RandomAccessStream(token);
    }

    private static void readPermissionsTable(SecurityToken token) throws InvalidJadException {
        RandomAccessStream storage = Permissions.getStorage();
        InputStream permIS = Permissions.openPropertiesFile(storage, POLICY_FILENAME);
        if (permIS == null) {
            return;
        }
        if (permissionsTable == null) {
            permissionsTable = new Hashtable();
        }
        PermissionProperties pp = new PermissionProperties();
        byte[] newPerms = new byte[112];
        String currentDomain = null;
        try {
            pp.load(permIS);
        }
        catch (IOException e) {
            System.out.println("Corrupt policy file");
            throw new InvalidJadException(28);
        }
        Permissions.clearPerms(newPerms);
        try {
            for (int i = 0; i < pp.size(); ++i) {
                byte defaultPerm;
                byte perm;
                String propertyKey = pp.getKeyAt(i);
                String propertyValue = pp.getValueAt(i);
                if (TAG_ALIAS.equals(propertyKey)) {
                    int nameIdx = propertyValue.indexOf(32);
                    String aliasName = propertyValue.substring(0, nameIdx);
                    String aliasValue = propertyValue.substring(nameIdx + 1, propertyValue.length());
                    if (aliasTable == null) {
                        aliasTable = new Hashtable();
                    }
                    aliasTable.put(aliasName, Util.getCommaSeparatedValues(aliasValue));
                    continue;
                }
                if (TAG_DOMAIN.equals(propertyKey)) {
                    if (permissionsTable == null) {
                        permissionsTable = new Hashtable();
                    }
                    if (currentDomain != null) {
                        permissionsTable.put(currentDomain, newPerms);
                        newPerms = new byte[112];
                        Permissions.clearPerms(newPerms);
                    }
                    currentDomain = propertyValue;
                    continue;
                }
                if (LEVEL_ALLOW.equals(propertyKey)) {
                    Vector apiNames = Util.getCommaSeparatedValues(propertyValue);
                    apiNames = Permissions.expandAlias(apiNames, aliasTable);
                    Permissions.setPerms(newPerms, apiNames, (byte)1, (byte)1);
                    continue;
                }
                int defaultPermIdx = propertyKey.indexOf(40);
                if (defaultPermIdx != -1) {
                    String permString = propertyKey.substring(0, defaultPermIdx);
                    String defaultPermString = propertyKey.substring(defaultPermIdx + 1, propertyKey.indexOf(41));
                    perm = Permissions.getPermFromString(permString);
                    defaultPerm = Permissions.getPermFromString(defaultPermString);
                } else {
                    perm = Permissions.getPermFromString(propertyKey);
                    defaultPerm = 64;
                }
                Vector apiNames = Util.getCommaSeparatedValues(propertyValue);
                apiNames = Permissions.expandAlias(apiNames, aliasTable);
                Permissions.setPerms(newPerms, apiNames, perm, defaultPerm);
            }
            if (currentDomain != null) {
                permissionsTable.put(currentDomain, newPerms);
            }
        }
        catch (Exception e) {
            System.out.println("Corrupt policy file");
            permissionsTable = null;
            throw new InvalidJadException(28);
        }
        Permissions.readPermissionsFile(token);
        Permissions.readFunctionGroups(token);
    }

    public static boolean isValidDomainName(SecurityToken token, String domain) {
        if (!Permissions.initialized()) {
            return false;
        }
        if (INTERNAL_DOMAIN_NAME.equals(domain)) {
            return true;
        }
        byte[] permList = (byte[])permissionsTable.get(domain);
        return permList != null;
    }

    private static boolean getPermissions(SecurityToken token, String domain, byte[] permissions, byte[] defaults) {
        if (!Permissions.initialized()) {
            return false;
        }
        byte[] permList = (byte[])permissionsTable.get(domain);
        if (permList != null) {
            for (int idx = 0; idx < 56; ++idx) {
                int permIdx = idx * 2;
                permissions[idx] = permList[permIdx];
                defaults[idx] = permList[permIdx + 1];
            }
            return true;
        }
        return false;
    }

    public static String getAliasForPermission(int permission) {
        if (!Permissions.initialized()) {
            return "";
        }
        Enumeration aliases = aliasTable.keys();
        while (aliases.hasMoreElements()) {
            String alias = (String)aliases.nextElement();
            Enumeration apis = ((Vector)aliasTable.get(alias)).elements();
            while (apis.hasMoreElements()) {
                String api = (String)apis.nextElement();
                if (!api.equals(names[permission])) continue;
                return alias;
            }
        }
        return null;
    }

    private static Vector getApiNamesForPermission(int permission) {
        Vector vector = null;
        String alias = Permissions.getAliasForPermission(permission);
        if (alias != null) {
            vector = (Vector)aliasTable.get(alias);
        }
        return vector;
    }

    public static byte[] getApiIndexesForPermission(int permission) {
        return Permissions.getApiIndexesForAlias(Permissions.getAliasForPermission(permission));
    }

    public static byte[] getApiIndexesForAlias(String alias) {
        if (!Permissions.initialized() || alias == null) {
            return new byte[0];
        }
        Vector apiNames = (Vector)aliasTable.get(alias);
        if (apiNames == null) {
            return new byte[0];
        }
        int count = apiNames.size();
        byte[] indexes = new byte[count];
        for (int i = 0; i < count; ++i) {
            indexes[i] = Permissions.getPermissionIndex((String)apiNames.elementAt(i));
        }
        return indexes;
    }

    private static byte getPermissionIndex(String name) {
        for (byte i = 0; i < names.length; i = (byte)(i + 1)) {
            if (!names[i].equals(name)) continue;
            return i;
        }
        return -1;
    }

    public static Vector getAliases() {
        if (!Permissions.initialized()) {
            return null;
        }
        Vector<String> aliases = new Vector<String>(aliasTable.size());
        Enumeration keys = aliasTable.keys();
        while (keys.hasMoreElements()) {
            aliases.addElement((String)keys.nextElement());
        }
        return aliases;
    }

    public static int getAliasCount() {
        if (!Permissions.initialized()) {
            return -1;
        }
        return aliasTable.size();
    }

    public static boolean initialized() {
        if (aliasTable == null) {
            try {
                Permissions.readPermissionsTable(null);
            }
            catch (InvalidJadException e) {
                return false;
            }
            catch (Exception e) {
                return false;
            }
        }
        return true;
    }

    private static Vector getAliasStrings(String alias) {
        if (!Permissions.initialized()) {
            return null;
        }
        return (Vector)groupsMap.get(alias);
    }

    public static String getAliasName(String alias) {
        if (!Permissions.initialized()) {
            return "";
        }
        return (String)Permissions.getAliasStrings(alias).elementAt(0);
    }

    public static String getAliasQuestion(String alias) {
        if (!Permissions.initialized()) {
            return "";
        }
        return (String)Permissions.getAliasStrings(alias).elementAt(1);
    }

    public static String getAliasDefaultAnswer(String alias) {
        if (!Permissions.initialized()) {
            return "";
        }
        return (String)Permissions.getAliasStrings(alias).elementAt(2);
    }

    public static void setPermissionGroup(byte[] current, int permission, byte level) {
        Vector apiNames = Permissions.getApiNamesForPermission(permission);
        if (apiNames == null) {
            return;
        }
        Enumeration apis = apiNames.elements();
        while (apis.hasMoreElements()) {
            byte index = Permissions.getPermissionIndex((String)apis.nextElement());
            if (current[index] == 0) continue;
            current[index] = level;
        }
    }

    public static void setPermissionAsked(byte[] current, int permission, byte level) {
        Vector apiNames = Permissions.getApiNamesForPermission(permission);
        if (apiNames == null) {
            return;
        }
        Enumeration apis = apiNames.elements();
        while (apis.hasMoreElements()) {
            current[Permissions.getPermissionIndex((String)((String)apis.nextElement()))] = level;
        }
    }

    public static boolean isUpLeveled(int permission) {
        switch (permission) {
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 18: 
            case 20: {
                return true;
            }
        }
        return false;
    }

    private static class ExcludedLevel {
        private String domain;
        private String alias;
        private byte level;

        ExcludedLevel(String domain, String alias, byte level) {
            this.domain = domain;
            this.alias = alias;
            this.level = level;
        }

        public boolean existsIn(Vector vec) {
            Enumeration e = vec.elements();
            while (e.hasMoreElements()) {
                if (!((ExcludedLevel)e.nextElement()).equals(this)) continue;
                return true;
            }
            return false;
        }

        private boolean equals(ExcludedLevel el) {
            if (!el.domain.equals(this.domain)) {
                return false;
            }
            if (!el.alias.equals(this.alias)) {
                return false;
            }
            return el.level == this.level;
        }
    }
}

