/*
 * Decompiled with CFR 0.152.
 */
package com.sun.midp.security;

import com.sun.midp.security.SecurityToken;

public final class SecurityInitializer {
    private static SecurityToken internalSecurityToken;
    private static boolean dispensingEnabled;

    public static void init(SecurityToken token) {
        if (internalSecurityToken != null) {
            throw new SecurityException();
        }
        internalSecurityToken = token;
        try {
            SecurityInitializer.initSecurity("javax.microedition.content.Registry");
            SecurityInitializer.initSecurity("com.sun.midp.content.RegistryImpl");
            SecurityInitializer.initSecurity("com.sun.midp.content.InvocationImpl");
            SecurityInitializer.initSecurity("com.sun.j2me.global.NormalizationTableImpl");
            SecurityInitializer.initSecurity("com.sun.j2me.global.CollationElementTableImpl");
            SecurityInitializer.initSecurity("com.sun.j2me.global.DevResourceManagerFactory");
            SecurityInitializer.initSecurity("com.sun.j2me.global.DevResourceBundleReader");
            SecurityInitializer.initSecurity("com.sun.kvem.payment.KvemPaymentModule");
            SecurityInitializer.initSecurity("com.sun.perseus.platform.ResourceHandler");
            SecurityInitializer.initSecurity("com.sun.midp.io.j2me.file.Protocol");
            SecurityInitializer.initSecurity("com.sun.kvem.jsr082.impl.bluetooth.SDDBStorageImpl");
        }
        catch (Throwable t) {
            throw new RuntimeException(t.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initSecurity(String classname) {
        try {
            dispensingEnabled = true;
            Class.forName(classname);
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        finally {
            dispensingEnabled = false;
        }
    }

    public static SecurityToken getSecurityToken() {
        if (dispensingEnabled) {
            return internalSecurityToken;
        }
        throw new SecurityException();
    }

    private SecurityInitializer() {
    }

    static {
        dispensingEnabled = false;
    }
}

