/*
 * Decompiled with CFR 0.152.
 */
package com.sun.midp.ssl;

import com.sun.midp.ssl.CryptoException;
import com.sun.midp.ssl.Key;
import com.sun.midp.ssl.KeyBuilder;

public final class SecretKey
implements Key {
    byte kind;
    short bitsize;
    boolean initOk;
    byte[] secret = null;

    SecretKey(byte by, short s) {
        this.kind = by;
        this.bitsize = s;
        this.initOk = false;
    }

    public void clearKey() {
        this.initOk = false;
        this.bitsize = 0;
    }

    public short getSize() {
        return this.bitsize;
    }

    public byte getType() {
        return this.kind;
    }

    public boolean isInitialized() {
        return this.initOk;
    }

    public byte getKey(byte[] byArray, short s) {
        if (!this.initOk || s + this.secret.length > byArray.length) {
            return 0;
        }
        System.arraycopy(this.secret, 0, byArray, s, this.secret.length);
        return (byte)this.secret.length;
    }

    public void setKey(byte[] byArray, short s) throws CryptoException {
        int n = this.bitsize + 7 >>> 3;
        if (s + n > byArray.length) {
            throw new CryptoException(2);
        }
        this.secret = new byte[n];
        System.arraycopy(byArray, s, this.secret, 0, n);
        this.initOk = true;
    }

    public String toString() {
        return "[" + this.getSize() + "-bit secret key: 0x" + KeyBuilder.hexEncode(this.secret) + "]";
    }
}

