/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mmedia;

import com.sun.mmedia.AMRQTTempWAVFile;
import com.sun.mmedia.WavPlayer;
import com.sun.mmedia.protocol.CommonDS;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.media.Control;
import javax.microedition.media.MediaException;
import javax.microedition.media.protocol.DataSource;
import javax.microedition.media.protocol.SourceStream;

public class AMR3DConnectablePlayer2
extends WavPlayer {
    private int peer = 0;
    private DataSource amrSource;
    private SourceStream amrStream;
    private InputStream tempWavFile;
    static boolean haveQuickTime = AMR3DConnectablePlayer2.nVerifyQTexists();
    private static final String errMsg = "Error: Can not find QuickTime path in registry.";

    private static native boolean nVerifyQTexists();

    public AMR3DConnectablePlayer2() throws MediaException {
        if (!haveQuickTime) {
            System.err.println(errMsg);
            throw new MediaException(errMsg);
        }
    }

    public String getContentType() {
        this.chkClosed(true);
        return "audio/amr";
    }

    public synchronized void realize() throws MediaException {
        this.chkClosed(false);
        if (this.state >= 200) {
            return;
        }
        if (this.amrSource == null) {
            throw new MediaException("Invalid AMR stream");
        }
        this.amrStream = this.amrSource.getStreams()[0];
        this.parseData();
        this.tempWavFile = new AMRQTTempWAVFile(this.peer);
        try {
            CommonDS wavSource = new CommonDS();
            wavSource.setInputStream(this.tempWavFile);
            wavSource.setContentType("audio/x-wav");
            this.source = wavSource;
        }
        catch (Exception e) {
            throw new MediaException("Cannot realize" + e.getMessage());
        }
        this.stream = this.source.getStreams()[0];
        this.doRealize();
        this.state = 200;
    }

    public void close() {
        super.close();
        this.closeQTPeer();
    }

    public void setSource(DataSource source) throws IOException, MediaException {
        this.amrSource = source;
        this.source = null;
    }

    protected Control doGetControl(String type) {
        if (this.getState() != 100 && type.startsWith("javax.microedition.media.control.")) {
            if ((type = type.substring("javax.microedition.media.control.".length())).equals("RateControl")) {
                return null;
            }
            if (type.equals("MetaDataControl")) {
                return null;
            }
            if (type.equals("RecordControl")) {
                return null;
            }
            return super.doGetControl("javax.microedition.media.control." + type);
        }
        return null;
    }

    private native int nInitQTPeer() throws Exception;

    private native void nReadNextAMRData(int var1, byte[] var2, int var3, int var4) throws IOException;

    private native void nFinishRealization(int var1) throws MediaException;

    protected void parseData() throws MediaException {
        try {
            this.amrSource.start();
        }
        catch (IOException e) {
            throw new MediaException("Failed to start source: " + e.getMessage());
        }
        try {
            this.peer = this.nInitQTPeer();
            byte[] amr_data_buf = new byte[256];
            int n = 0;
            do {
                n = this.amrStream.read(amr_data_buf, 0, amr_data_buf.length);
                this.nReadNextAMRData(this.peer, amr_data_buf, 0, n);
            } while (n == amr_data_buf.length);
            this.nFinishRealization(this.peer);
        }
        catch (Exception e) {
            throw new MediaException("Cannot realize: " + e.getMessage());
        }
        try {
            this.amrSource.stop();
            this.amrSource.disconnect();
            this.amrSource = null;
            this.amrStream = null;
        }
        catch (IOException e) {
            throw new MediaException("I/O error: " + e.getMessage());
        }
    }

    private native void nDeallocate(int var1);

    protected void closeQTPeer() {
        this.nDeallocate(this.peer);
        this.peer = 0;
    }
}

