/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mmedia;

import com.sun.mmedia.MIDletPauseListener;
import com.sun.mmedia.PermissionAccessor;
import com.sun.mmedia.PlayerEventQueue;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.media.Control;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.PlayerListener;
import javax.microedition.media.TimeBase;
import javax.microedition.media.control.StopTimeControl;
import javax.microedition.media.protocol.DataSource;
import javax.microedition.media.protocol.SourceStream;

public abstract class BasicPlayer
implements Player,
TimeBase,
StopTimeControl {
    private static int pcount = -1;
    private static Object idLock = new Object();
    public int state = 100;
    int loopCountSet = 1;
    int loopCount;
    boolean EOM = false;
    boolean loopAfterEOM = false;
    Vector listeners = new Vector(2);
    boolean listenersModified = false;
    PlayerEventQueue eventQueue = null;
    Object evtLock = new Object();
    protected int pID = 0;
    private static Hashtable mplayers = new Hashtable(4);
    private static Hashtable pstates = new Hashtable();
    private static Hashtable mtimes = new Hashtable();
    protected static final String pkgName = "javax.microedition.media.control.";
    protected static final String fpcName = "FramePositioningControl";
    protected static final String guiName = "GUIControl";
    protected static final String mdcName = "MetaDataControl";
    protected static final String micName = "MIDIControl";
    protected static final String picName = "PitchControl";
    protected static final String racName = "RateControl";
    protected static final String recName = "RecordControl";
    protected static final String stcName = "StopTimeControl";
    protected static final String tecName = "TempoControl";
    protected static final String tocName = "ToneControl";
    protected static final String vicName = "VideoControl";
    protected static final String vocName = "VolumeControl";
    protected static final String rtspName = "RtspControl";
    private static final String[] allCtrls = new String[]{"FramePositioningControl", "GUIControl", "MetaDataControl", "MIDIControl", "PitchControl", "RateControl", "RecordControl", "StopTimeControl", "TempoControl", "ToneControl", "VideoControl", "VolumeControl", "RtspControl"};
    private static final int[] allPermissions = new int[0];
    private boolean isTrusted;
    private String[] control_names;
    private int[] permissions;
    protected DataSource source;
    protected SourceStream stream;
    private TimeBase timeBase = this;
    protected long stopTime = Long.MAX_VALUE;
    int eventQueueSize = 20;
    private boolean closedDelivered;
    private static MIDletPauseListener pauseListener = null;
    private static boolean vmPaused = false;
    public static final int AUDIO_NONE = 0;
    public static final int AUDIO_PCM = 1;
    public static final int AUDIO_MIDI = 2;
    protected boolean hasDataSource = true;
    private long origin = 0L;
    private long offset = 0L;
    private long time = 0L;
    private long sysOffset = 0L;
    private boolean useSystemTime = true;
    private Object timeLock = new Object();
    int NOT_SEEKABLE = 0;
    int SEEKABLE_TO_START = 1;
    int RANDOM_ACCESSIBLE = 2;
    private static final int MAX_SKIP = 2048;
    private static byte[] skipArray;

    public static void setMIDletPauseListener(MIDletPauseListener listener) {
        if (pauseListener == null) {
            pauseListener = listener;
        }
    }

    public static void pauseStateEntered(MIDletPauseListener listener, boolean paused) {
        if (listener != pauseListener) {
            return;
        }
        vmPaused = paused;
        if (vmPaused) {
            Enumeration e = mplayers.elements();
            while (e.hasMoreElements()) {
                BasicPlayer p = (BasicPlayer)e.nextElement();
                if (p.getState() != 400) continue;
                BasicPlayer.notifyPauseListener("Player");
            }
        }
    }

    public static void notifyPauseListener(String msg) {
        if (vmPaused && pauseListener != null) {
            pauseListener.reportActivity(msg);
        }
    }

    public BasicPlayer() {
        this.init();
        this.control_names = allCtrls;
        this.permissions = allPermissions;
    }

    protected BasicPlayer(String[] n, int[] p) {
        this.init();
        this.control_names = n == null ? allCtrls : n;
        this.permissions = p == null ? allPermissions : p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        this.sysOffset = System.currentTimeMillis() * 1000L;
        Object object = idLock;
        synchronized (object) {
            this.pID = pcount = (pcount + 1) % Short.MAX_VALUE;
        }
        mplayers.put(new Integer(this.pID), this);
    }

    public boolean initFromURL(String encodings) {
        return true;
    }

    protected final void checkPermissions() throws SecurityException {
        if (this.isTrusted) {
            return;
        }
        for (int i = 0; i < this.permissions.length; ++i) {
            PermissionAccessor.checkPermissions(this.permissions[i]);
        }
        this.isTrusted = true;
    }

    protected final void chkClosed(boolean unrealized) {
        int theState = this.state;
        if (theState == 0 || unrealized && theState == 100) {
            throw new IllegalStateException("Can't invoke the method at the " + (theState == 0 ? "closed" : "unrealized") + " state ");
        }
    }

    public synchronized void setLoopCount(int count) {
        this.chkClosed(false);
        if (this.state == 400) {
            throw new IllegalStateException("setLoopCount");
        }
        if (count == 0 || count < -1) {
            throw new IllegalArgumentException("setLoopCount");
        }
        this.loopCountSet = count;
        this.loopCount = count;
        this.doSetLoopCount(count);
    }

    protected void doSetLoopCount(int count) {
    }

    public int getAudioType() {
        return 0;
    }

    public void setOutput(Object output) {
    }

    public Object getOutput() {
        return null;
    }

    public synchronized void realize() throws MediaException {
        this.chkClosed(false);
        if (this.state >= 200) {
            return;
        }
        if (this.source != null) {
            this.checkPermissions();
        }
        if (this.source != null && this.stream == null) {
            this.stream = this.source.getStreams()[0];
        } else if (this.hasDataSource) {
            this.state = 100;
            throw new MediaException("Unable to realize");
        }
        this.doRealize();
        this.state = 200;
    }

    protected abstract void doRealize() throws MediaException;

    public synchronized void prefetch() throws MediaException {
        this.chkClosed(false);
        if (this.state >= 300) {
            return;
        }
        if (this.state < 200) {
            this.realize();
        } else {
            this.checkPermissions();
        }
        this.doPrefetch();
        this.state = 300;
    }

    protected abstract void doPrefetch() throws MediaException;

    public synchronized void start() throws MediaException {
        this.chkClosed(false);
        if (this.state >= 400) {
            return;
        }
        if (this.state < 300) {
            this.prefetch();
        } else if (!this.EOM && !this.loopAfterEOM) {
            this.checkPermissions();
        }
        this.updateTimeBase(true);
        if (this.stopTime != Long.MAX_VALUE && this.stopTime <= this.getMediaTime()) {
            this.satev();
            return;
        }
        if (this.EOM) {
            try {
                this.setMediaTime(0L);
            }
            catch (MediaException mediaException) {
                // empty catch block
            }
        }
        if (!this.doStart()) {
            throw new MediaException("start");
        }
        this.state = 400;
        this.sendEvent("started", new Long(this.getMediaTime()));
        this.doPostStart();
    }

    protected abstract boolean doStart();

    protected void doPostStart() {
    }

    public synchronized void stop() throws MediaException {
        this.chkClosed(false);
        this.loopAfterEOM = false;
        if (this.state < 400) {
            return;
        }
        this.doStop();
        this.updateTimeBase(false);
        this.state = 300;
        this.sendEvent("stopped", new Long(this.getMediaTime()));
    }

    protected abstract void doStop() throws MediaException;

    public synchronized void deallocate() {
        this.chkClosed(false);
        this.loopAfterEOM = false;
        if (this.state < 300) {
            return;
        }
        if (this.state == 400) {
            try {
                this.stop();
            }
            catch (MediaException mediaException) {
                // empty catch block
            }
        }
        this.doDeallocate();
        this.EOM = true;
        this.state = 200;
    }

    protected abstract void doDeallocate();

    public synchronized void close() {
        if (this.state == 0) {
            return;
        }
        this.deallocate();
        this.doClose();
        this.state = 0;
        if (this.source != null) {
            this.source.disconnect();
        }
        this.sendEvent("closed", null);
        mplayers.remove(new Integer(this.pID));
    }

    protected abstract void doClose();

    public synchronized long setMediaTime(long now) throws MediaException {
        long theDur;
        this.chkClosed(true);
        if (now < 0L) {
            now = 0L;
        }
        if (this.state == 400) {
            this.origin = this.getTime();
        }
        if ((theDur = this.doGetDuration()) != -1L && now > theDur) {
            now = theDur;
        }
        long rtn = this.doSetMediaTime(now);
        this.EOM = false;
        if (this.state == 400) {
            this.offset = rtn;
        }
        return rtn;
    }

    protected abstract long doSetMediaTime(long var1) throws MediaException;

    public long getMediaTime() {
        this.chkClosed(false);
        return this.doGetMediaTime();
    }

    protected abstract long doGetMediaTime();

    public int getState() {
        return this.state;
    }

    public long getDuration() {
        this.chkClosed(false);
        return this.doGetDuration();
    }

    protected abstract long doGetDuration();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPlayerListener(PlayerListener playerListener) {
        this.chkClosed(false);
        if (playerListener != null) {
            Vector vector = this.listeners;
            synchronized (vector) {
                this.listenersModified = true;
                this.listeners.addElement(playerListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePlayerListener(PlayerListener playerListener) {
        this.chkClosed(false);
        if (playerListener != null) {
            Vector vector = this.listeners;
            synchronized (vector) {
                this.listenersModified = true;
                this.listeners.removeElement(playerListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void notifyListeners(String message, Object obj) {
        Object[] copy;
        Vector vector = this.listeners;
        synchronized (vector) {
            copy = new Object[this.listeners.size()];
            this.listeners.copyInto(copy);
            this.listenersModified = false;
        }
        for (int i = 0; i < copy.length; ++i) {
            PlayerListener listener = (PlayerListener)copy[i];
            listener.playerUpdate(this, message, obj);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendEvent(String evtName, Object evtData) {
        if (this.listeners.size() == 0 && evtName != "endOfMedia" && evtName != "closed" && evtName != "error") {
            return;
        }
        if (this.closedDelivered) {
            return;
        }
        Object object = this.evtLock;
        synchronized (object) {
            if (this.eventQueue == null) {
                this.eventQueue = new PlayerEventQueue(this);
            }
            this.eventQueue.sendEvent(evtName, evtData);
        }
        if (evtName == "closed" || evtName == "error") {
            this.closedDelivered = true;
        }
    }

    synchronized void doFinishLoopIteration() {
        this.EOM = true;
        this.loopAfterEOM = false;
        if (this.state > 300) {
            this.updateTimeBase(false);
            this.state = 300;
            if (this.loopCount > 1 || this.loopCount == -1) {
                this.loopAfterEOM = true;
            }
        }
    }

    synchronized void doNextLoopIteration() {
        if (this.loopAfterEOM) {
            block8: {
                if (this.loopCount > 1 || this.loopCount == -1) {
                    try {
                        if (this.setMediaTime(0L) == 0L) {
                            if (this.loopCount > 1) {
                                --this.loopCount;
                            }
                            this.start();
                            break block8;
                        }
                        this.loopCount = 1;
                    }
                    catch (MediaException ex) {
                        this.loopCount = 1;
                    }
                } else if (this.loopCountSet > 1) {
                    this.loopCount = this.loopCountSet;
                }
            }
            this.loopAfterEOM = false;
        }
    }

    public final Control[] getControls() {
        this.chkClosed(true);
        Vector<Control> v = new Vector<Control>(3);
        for (int i = 0; i < this.control_names.length; ++i) {
            Control c = this.getControl(this.control_names[i]);
            if (c == null || v.contains(c)) continue;
            v.addElement(c);
        }
        Object[] ret = new Control[v.size()];
        v.copyInto(ret);
        return ret;
    }

    public final Control getControl(String type) {
        this.chkClosed(true);
        if (type == null) {
            throw new IllegalArgumentException();
        }
        if (type.indexOf(46) < 0) {
            for (int i = 0; i < allCtrls.length; ++i) {
                if (allCtrls[i].equals(type)) {
                    return this.doGetControl(pkgName + type);
                }
                if (!allCtrls[i].endsWith(type)) continue;
                return this.doGetControl(allCtrls[i]);
            }
        }
        return this.doGetControl(type);
    }

    protected abstract Control doGetControl(String var1);

    public static BasicPlayer get(int pid) {
        return (BasicPlayer)mplayers.get(new Integer(pid));
    }

    public static void pauseAll() {
        if (mplayers == null) {
            return;
        }
        Enumeration e = mplayers.elements();
        while (e.hasMoreElements()) {
            BasicPlayer p = (BasicPlayer)e.nextElement();
            int state = p.getState();
            long time = p.getMediaTime();
            pstates.put(p, new Integer(state));
            mtimes.put(p, new Long(time));
            p.deallocate();
        }
    }

    public static void resumeAll() {
        if (mplayers == null || pstates.size() == 0) {
            return;
        }
        Enumeration e = mplayers.elements();
        while (e.hasMoreElements()) {
            BasicPlayer p = (BasicPlayer)e.nextElement();
            int state = (Integer)pstates.get(p);
            long time = (Long)mtimes.get(p);
            switch (state) {
                case 300: {
                    try {
                        p.prefetch();
                        p.setMediaTime(time);
                    }
                    catch (MediaException ex) {}
                    break;
                }
                case 400: {
                    try {
                        p.realize();
                        p.prefetch();
                        p.setMediaTime(time);
                        p.start();
                        break;
                    }
                    catch (MediaException ex) {
                        // empty catch block
                    }
                }
            }
        }
        pstates.clear();
        mtimes.clear();
    }

    public int doSetLevel(int ll) {
        return ll;
    }

    public void setSource(DataSource source) throws IOException, MediaException {
        this.source = source;
    }

    public void setTimeBase(TimeBase master) throws MediaException {
        this.chkClosed(true);
        if (this.state == 400) {
            throw new IllegalStateException("Cannot call setTimeBase on a player in the STARTED state");
        }
        if (master == null) {
            return;
        }
        if (master != this) {
            throw new MediaException("Incompatible TimeBase");
        }
    }

    public TimeBase getTimeBase() {
        this.chkClosed(true);
        return this.timeBase;
    }

    public String getContentType() {
        this.chkClosed(true);
        return this.source != null ? this.source.getContentType() : "";
    }

    public final long getStopTime() {
        return this.stopTime;
    }

    public final synchronized void setStopTime(long time) {
        if (this.state == 400) {
            if (this.stopTime != Long.MAX_VALUE && time != Long.MAX_VALUE) {
                throw new IllegalStateException("StopTime already set");
            }
            if (time < this.getMediaTime()) {
                try {
                    this.doStop();
                }
                catch (MediaException mediaException) {
                    // empty catch block
                }
                this.satev();
                return;
            }
        }
        this.stopTime = time;
        this.doSetStopTime(this.stopTime);
    }

    protected void doSetStopTime(long time) {
    }

    protected void satev() {
        this.updateTimeBase(false);
        this.state = 300;
        this.stopTime = Long.MAX_VALUE;
        this.sendEvent("stoppedAtTime", new Long(this.getMediaTime()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getTime() {
        Object object = this.timeLock;
        synchronized (object) {
            this.time = this.useSystemTime ? this.origin + (System.currentTimeMillis() * 1000L - this.sysOffset) - this.offset : this.origin + this.getMediaTime() - this.offset;
            return this.time;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTimeBase(boolean started) {
        Object object = this.timeLock;
        synchronized (object) {
            this.origin = this.getTime();
            this.useSystemTime = !started;
            this.offset = started ? this.getMediaTime() : System.currentTimeMillis() * 1000L - this.sysOffset;
        }
    }

    protected int readFully(byte[] b, int off, int len) throws IOException {
        int count;
        for (int n = 0; n < len; n += count) {
            count = this.stream.read(b, off + n, len - n);
            if (count >= 0) continue;
            throw new IOException("premature end of stream");
        }
        return len;
    }

    protected long skipFully(int numBytes) throws IOException {
        long target = this.stream.tell() + (long)numBytes;
        if (this.stream.getSeekType() == 2) {
            if (this.stream.seek(target) != target) {
                throw new IOException("skipped past end");
            }
            return numBytes;
        }
        if (numBytes < 0) {
            throw new IOException("bad param");
        }
        int toSkip = numBytes;
        int min = numBytes;
        if (min > 2048) {
            min = 2048;
        }
        if (skipArray == null || skipArray.length < min) {
            skipArray = new byte[min];
        }
        while (toSkip > 0) {
            min = toSkip;
            if (min > 2048) {
                min = 2048;
            }
            if (this.stream.read(skipArray, 0, min) < min) {
                throw new IOException("skipped past end");
            }
            toSkip -= min;
        }
        return numBytes;
    }

    protected long seekStrm(long where) throws IOException {
        return this.stream.seek(where);
    }

    protected int getSeekType() {
        return this.stream.getSeekType();
    }
}

