/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mmedia;

import com.sun.mmedia.BasicAudioOut;
import com.sun.mmedia.BasicPlayer;
import com.sun.mmedia.DefaultConfiguration;
import com.sun.mmedia.ImageAccess;
import com.sun.mmedia.TonePlayer;
import com.sun.mmedia.VideoRenderer;
import java.util.Hashtable;

public abstract class Configuration {
    protected Hashtable handlers = new Hashtable();
    protected Hashtable processors = new Hashtable();
    protected Hashtable mimeTypes = new Hashtable();
    private static Configuration config;
    protected static boolean nativeLooping;
    public static final String TONE_DEVICE_LOCATOR = "device://tone";
    public static final String MIDI_DEVICE_LOCATOR = "device://midi";
    public static final String RADIO_CAPTURE_LOCATOR = "capture://radio";
    public static final String AUDIO_CAPTURE_LOCATOR = "capture://audio";
    public static final String VIDEO_CAPTURE_LOCATOR = "capture://video";
    protected Hashtable properties = new Hashtable();
    private static Object singletonLock;

    public abstract String[] getSupportedContentTypes(String var1);

    public abstract String[] getSupportedProtocols(String var1);

    public abstract String[] getSupportedMediaProcessorInputTypes();

    public abstract String[] getSupportedSoundSource3DPlayerTypes();

    public abstract String getProperty(String var1);

    public abstract void setProperty(String var1, String var2);

    public abstract BasicAudioOut getAudioRenderer();

    public abstract VideoRenderer getVideoRenderer(BasicPlayer var1, int var2, int var3);

    public abstract TonePlayer getTonePlayer();

    public String ext2Mime(String name) {
        int idx = name.lastIndexOf(46);
        String ext = idx != -1 ? name.substring(idx + 1).toLowerCase() : name.toLowerCase();
        return (String)this.mimeTypes.get(ext);
    }

    public String getHandler(String type) {
        return (String)this.handlers.get(type);
    }

    public String getMediaProcessor(String type) {
        return (String)this.processors.get(type);
    }

    public abstract ImageAccess getImageAccessor();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Configuration getConfiguration() {
        Object object = singletonLock;
        synchronized (object) {
            if (config != null) {
                return config;
            }
            String className = System.getProperty("mmapi-configuration");
            if (className != null) {
                try {
                    Class<?> handlerClass = Class.forName(className);
                    config = (Configuration)handlerClass.newInstance();
                }
                catch (Exception exception) {}
            } else {
                config = new DefaultConfiguration();
            }
            return config;
        }
    }

    public static boolean nativeLoopMode() {
        return nativeLooping;
    }

    static {
        nativeLooping = false;
        singletonLock = new Object();
    }
}

