/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mmedia;

import com.sun.mmedia.BasicPlayer;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.PlayerListener;
import javax.microedition.media.control.VolumeControl;

class ContainerVolumeCtrl
implements VolumeControl,
PlayerListener {
    private int level;
    private boolean muted;
    private BasicPlayer owner;
    private Player player;
    private VolumeControl playerVolumeControl;

    public ContainerVolumeCtrl(BasicPlayer o) {
        this.owner = o;
        this.level = -1;
        this.muted = false;
    }

    public synchronized void detachPlayer() {
        this.playerVolumeControl = null;
        this.owner.removePlayerListener(this);
        this.player = null;
    }

    public synchronized void attachPlayer(Player p) {
        this.player = p;
        try {
            p.realize();
        }
        catch (MediaException e) {
            this.player = null;
            return;
        }
        p.addPlayerListener(this);
        this.playerVolumeControl = (VolumeControl)p.getControl("VolumeControl");
        if (this.playerVolumeControl != null) {
            this.playerVolumeControl.setMute(this.muted);
            this.playerVolumeControl.setLevel(this.level);
        }
    }

    public void playerUpdate(Player p, String event, Object eventData) {
        if (event.equals("volumeChanged")) {
            this.owner.sendEvent(event, this);
        }
    }

    public synchronized void setMute(boolean m) {
        if (this.playerVolumeControl != null) {
            this.playerVolumeControl.setMute(m);
            this.muted = this.playerVolumeControl.isMuted();
        } else if (this.muted != m) {
            this.muted = m;
            this.owner.sendEvent("volumeChanged", this);
        }
    }

    public synchronized boolean isMuted() {
        if (this.playerVolumeControl != null) {
            this.muted = this.playerVolumeControl.isMuted();
        }
        return this.muted;
    }

    public synchronized int setLevel(int ll) {
        if (this.playerVolumeControl != null) {
            this.level = this.playerVolumeControl.setLevel(ll);
        } else {
            if (ll < 0) {
                ll = 0;
            } else if (ll > 100) {
                ll = 100;
            }
            if (this.level != ll) {
                this.level = ll;
                this.owner.sendEvent("volumeChanged", this);
            }
        }
        return this.level;
    }

    public synchronized int getLevel() {
        if (this.level == -1) {
            // empty if block
        }
        if (this.playerVolumeControl != null) {
            this.level = this.playerVolumeControl.getLevel();
        }
        return this.level;
    }

    synchronized void setLevelImpl(int ll) {
        this.level = ll;
    }
}

