/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mmedia;

import com.sun.mmedia.BasicAudioOut;
import com.sun.mmedia.BasicPlayer;
import com.sun.mmedia.Configuration;
import com.sun.mmedia.ImageAccess;
import com.sun.mmedia.MIDPImageAccessor;
import com.sun.mmedia.MIDPVideoRenderer;
import com.sun.mmedia.TonePlayer;
import com.sun.mmedia.VideoRenderer;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class DefaultConfiguration
extends Configuration {
    public static final String MIME_AUDIO_TONE = "audio/x-tone-seq";
    public static final String MIME_AUDIO_AMR = "audio/amr";
    public static final String MIME_IMAGE_GIF = "image/gif";
    public static final String MIME_IMAGE_PNG = "image/png";
    public static final String MIME_IMAGE_JPEG = "image/jpeg";
    public static final String MIME_IMAGE_RAW = "image/raw";
    public static final String MIME_AUDIO_AMR_WB = "audio/amr-wb";
    public static final String MIME_AUDIO_WAV = "audio/x-wav";
    public static final String MIME_AUDIO_MIDI = "audio/midi";
    public static final String MIME_AUDIO_SP_MIDI = "audio/sp-midi";
    public static final String MIME_VIDEO_MPEG = "video/mpeg";
    public static final String MIME_VIDEO_MPEG4 = "video/mpeg4";
    public static final String MIME_AUDIO_PCMU = "audio/x-pcmu";
    public static final String RGB565 = "video/vnd.sun.rgb565";
    private static ImageAccess imageAccessor;
    private static TonePlayer myTonePlayer;
    private boolean needAMMS;
    private boolean needQSound;
    protected Hashtable supportedProtocols = new Hashtable();
    private Hashtable supportedContentTypes;
    private Vector nullContentTypes;
    private Vector captureContentTypes;
    private Vector deviceContentTypes;
    private Vector fileContentTypes;
    private Vector httpContentTypes;
    protected static final String[] hfdcProtocols;
    protected static final String[] hfcProtocols;
    protected static final String[] hfdProtocols;
    protected static final String[] hfProtocols;
    protected static final String[] cProtocols;
    protected static final String[] dProtocols;
    protected static final String[] supportedMPInputTypes;
    protected static final String[] supportedSS3DPlayerTypes;

    public DefaultConfiguration() {
        this.init();
        this.nullContentTypes = new Vector(9);
        this.captureContentTypes = new Vector(2);
        this.deviceContentTypes = new Vector(2);
        this.fileContentTypes = new Vector(8);
        this.httpContentTypes = new Vector(8);
        this.supportedContentTypes = new Hashtable();
        this.supportedContentTypes.put("capture", this.captureContentTypes);
        this.supportedContentTypes.put("device", this.deviceContentTypes);
        this.supportedContentTypes.put("file", this.fileContentTypes);
        this.supportedContentTypes.put("http", this.httpContentTypes);
        Enumeration keys = this.supportedProtocols.keys();
        while (keys.hasMoreElements()) {
            String mime = (String)keys.nextElement();
            String[] values = (String[])this.supportedProtocols.get(mime);
            for (int i = 0; i < values.length; ++i) {
                Vector vectorContentTypes = (Vector)this.supportedContentTypes.get(values[i]);
                vectorContentTypes.addElement(mime);
            }
            this.nullContentTypes.addElement(mime);
        }
    }

    protected void init() {
        String value;
        System.err.println("Failed to find configuration object - DefaultConfiguration is used!");
        try {
            value = System.getProperty("microedition.amms.version");
            this.needAMMS = value != null;
        }
        catch (Exception e) {
            this.needAMMS = false;
        }
        try {
            value = System.getProperty("supports.mediacapabilities");
            this.needQSound = value.indexOf("audio3d") != -1;
        }
        catch (Exception e) {
            this.needQSound = false;
        }
        this.handlers.put("http", "com.sun.mmedia.protocol.CommonDS");
        this.handlers.put("file", "com.sun.mmedia.protocol.CommonDS");
        this.handlers.put("capture", "com.sun.mmedia.protocol.WavCapture");
        if (this.needQSound) {
            this.handlers.put("device://tone", "com.sun.mmedia.QSoundToneSequencePlayer");
            this.handlers.put("device://midi", "com.sun.mmedia.QSoundMIDIPlayer");
        } else {
            this.handlers.put("device://tone", "com.sun.mmedia.ToneSequencePlayer");
            this.handlers.put("device://midi", "com.sun.mmedia.MIDIPlayer");
        }
        if (this.needAMMS) {
            this.handlers.put("capture://radio", "com.sun.amms.AmmsTuner");
            this.handlers.put("capture://video", "com.sun.amms.AmmsCameraPlayer");
        } else {
            this.handlers.put("capture://radio", "com.sun.mmedia.MmapiTuner");
            this.handlers.put("capture://video", "com.sun.mmedia.MmapiCameraPlayer");
        }
        this.supportedProtocols.put(RGB565, cProtocols);
        if (this.needQSound) {
            this.handlers.put(MIME_AUDIO_TONE, "com.sun.mmedia.QSoundToneSequencePlayer");
            this.handlers.put(MIME_AUDIO_MIDI, "com.sun.mmedia.QSoundMIDIPlayer");
            this.handlers.put(MIME_AUDIO_SP_MIDI, "com.sun.mmedia.QSoundMIDIPlayer");
        } else {
            this.handlers.put(MIME_AUDIO_TONE, "com.sun.mmedia.ToneSequencePlayer");
            this.handlers.put(MIME_AUDIO_MIDI, "com.sun.mmedia.MIDIPlayer");
            this.handlers.put(MIME_AUDIO_SP_MIDI, "com.sun.mmedia.MIDIPlayer");
        }
        this.supportedProtocols.put(MIME_AUDIO_TONE, hfdProtocols);
        this.supportedProtocols.put(MIME_AUDIO_MIDI, hfdProtocols);
        this.handlers.put(MIME_IMAGE_GIF, "com.sun.mmedia.GIFPlayer");
        this.handlers.put(MIME_AUDIO_WAV, "com.sun.mmedia.WavPlayer");
        this.handlers.put(MIME_VIDEO_MPEG, "com.sun.mmedia.JavaMPEG1Player2");
        this.supportedProtocols.put(MIME_IMAGE_GIF, hfProtocols);
        this.supportedProtocols.put(MIME_AUDIO_WAV, hfcProtocols);
        this.supportedProtocols.put(MIME_VIDEO_MPEG, hfProtocols);
        if (this.needAMMS) {
            this.processors.put(MIME_IMAGE_RAW, "com.sun.amms.RAWImageProcessor");
            this.processors.put(MIME_IMAGE_JPEG, "com.sun.amms.JPEGImageProcessor");
            this.processors.put(MIME_IMAGE_PNG, "com.sun.amms.PNGImageProcessor");
        }
        if (this.needQSound) {
            this.setProperty("com.sun.mmedia.TonePlayer", "com.sun.mmedia.QSoundTonePlayer");
        } else {
            this.setProperty("com.sun.mmedia.TonePlayer", "com.sun.mmedia.MIDIOut");
        }
        if (this.needQSound) {
            this.setProperty("com.sun.mmedia.BasicAudioOut", "com.sun.mmedia.QSoundPCMOut");
        } else {
            this.setProperty("com.sun.mmedia.BasicAudioOut", "com.sun.mmedia.MapPCMOut");
        }
        if (this.needAMMS) {
            if (this.needQSound) {
                this.setProperty("javax.microedition.amms.GlobalManager", "com.sun.mmedia.QSoundGlobalManager");
            } else {
                this.setProperty("javax.microedition.amms.GlobalManager", "com.sun.mmedia.MapGlobalManager");
            }
        }
        this.mimeTypes.put("jts", MIME_AUDIO_TONE);
        this.mimeTypes.put("amr", MIME_AUDIO_AMR);
        this.mimeTypes.put("awb", MIME_AUDIO_AMR_WB);
        this.mimeTypes.put("gif", MIME_IMAGE_GIF);
        this.mimeTypes.put("wav", MIME_AUDIO_WAV);
        this.mimeTypes.put("mpg", MIME_VIDEO_MPEG);
        this.mimeTypes.put("mpeg", MIME_VIDEO_MPEG);
        this.mimeTypes.put("mid", MIME_AUDIO_MIDI);
        this.mimeTypes.put("midi", MIME_AUDIO_MIDI);
        this.mimeTypes.put("audio/tone", MIME_AUDIO_TONE);
        this.mimeTypes.put("audio/wav", MIME_AUDIO_WAV);
        this.mimeTypes.put(MIME_AUDIO_WAV, MIME_AUDIO_WAV);
        this.mimeTypes.put("audio/x-midi", MIME_AUDIO_MIDI);
        this.mimeTypes.put(MIME_AUDIO_AMR, MIME_AUDIO_AMR);
        this.mimeTypes.put(MIME_AUDIO_AMR_WB, MIME_AUDIO_AMR_WB);
        this.mimeTypes.put(MIME_AUDIO_SP_MIDI, MIME_AUDIO_SP_MIDI);
        this.mimeTypes.put(MIME_AUDIO_PCMU, MIME_AUDIO_PCMU);
        this.mimeTypes.put("video/x-jpeg", MIME_IMAGE_JPEG);
        this.initTunerProperties();
        imageAccessor = new MIDPImageAccessor();
        myTonePlayer = (TonePlayer)this.createInstanceOf("com.sun.mmedia.TonePlayer");
    }

    protected void initTunerProperties() {
        this.setProperty("com.sun.tuner.presets", "5");
        this.setProperty("com.sun.tuner.play", "2");
        this.setProperty("com.sun.tuner.fm.stations", "3");
        this.setProperty("com.sun.tuner.fm.station_1", "885000");
        this.setProperty("com.sun.tuner.fm.name_1", "KCQW");
        this.setProperty("com.sun.tuner.fm.text_1", "Hour of Opera");
        this.setProperty("com.sun.tuner.fm.url_1", "tuner1.wav");
        this.setProperty("com.sun.tuner.fm.station_2", "932000");
        this.setProperty("com.sun.tuner.fm.name_2", "Rock 932");
        this.setProperty("com.sun.tuner.fm.text_2", "Drive Rock");
        this.setProperty("com.sun.tuner.fm.url_2", "tuner2.wav");
        this.setProperty("com.sun.tuner.fm.preset_2", "3");
        this.setProperty("com.sun.tuner.fm.station_3", "1015000");
        this.setProperty("com.sun.tuner.fm.name_3", "NNNERD");
        this.setProperty("com.sun.tuner.fm.text_3", "Module Prime");
        this.setProperty("com.sun.tuner.fm.url_3", "tuner4.wav");
        this.setProperty("com.sun.tuner.fm.preset_3", "2");
        this.setProperty("com.sun.tuner.am.stations", "2");
        this.setProperty("com.sun.tuner.am.station_1", "5800");
        this.setProperty("com.sun.tuner.am.name_1", "FUNR");
        this.setProperty("com.sun.tuner.am.text_1", "Funny News");
        this.setProperty("com.sun.tuner.am.url_1", "tuner3.wav");
        this.setProperty("com.sun.tuner.am.preset_1", "4");
        this.setProperty("com.sun.tuner.am.station_2", "12110");
        this.setProperty("com.sun.tuner.am.name_2", "TLKB");
        this.setProperty("com.sun.tuner.am.text_2", "Talk Back");
        this.setProperty("com.sun.tuner.am.url_2", "tuner5.wav");
        this.setProperty("com.sun.tuner.am.preset_2", "1");
    }

    public String[] getSupportedContentTypes(String protocol) {
        Vector vectorContentTypes;
        Vector vector = vectorContentTypes = protocol == null ? this.nullContentTypes : (Vector)this.supportedContentTypes.get(protocol);
        if (vectorContentTypes == null) {
            return new String[0];
        }
        Object[] array = new String[vectorContentTypes.size()];
        vectorContentTypes.copyInto(array);
        return array;
    }

    public String[] getSupportedProtocols(String content_type) {
        String[] array = content_type == null ? hfdcProtocols : (String[])this.supportedProtocols.get(content_type);
        return array == null ? new String[]{} : array;
    }

    public BasicAudioOut getAudioRenderer() {
        return (BasicAudioOut)this.createInstanceOf("com.sun.mmedia.BasicAudioOut");
    }

    public VideoRenderer getVideoRenderer(BasicPlayer player, int sourceWidth, int sourceHeight) {
        return new MIDPVideoRenderer(player, sourceWidth, sourceHeight);
    }

    public ImageAccess getImageAccessor() {
        return imageAccessor;
    }

    public TonePlayer getTonePlayer() {
        return myTonePlayer;
    }

    public String[] getSupportedMediaProcessorInputTypes() {
        return this.needAMMS ? supportedMPInputTypes : new String[]{};
    }

    public String[] getSupportedSoundSource3DPlayerTypes() {
        return this.needAMMS && this.needQSound ? supportedSS3DPlayerTypes : new String[]{};
    }

    public String getProperty(String key) {
        return (String)this.properties.get(key);
    }

    public void setProperty(String key, String value) {
        this.properties.put(key, value);
    }

    private Object createInstanceOf(String propertyName) {
        try {
            String propertyValue = this.getProperty(propertyName);
            Class<?> propertyClass = Class.forName(propertyValue);
            Object propertyInstance = propertyClass.newInstance();
            return propertyInstance;
        }
        catch (Exception e) {
            return null;
        }
    }

    static {
        hfdcProtocols = new String[]{"http", "file", "device", "capture"};
        hfcProtocols = new String[]{"http", "file", "capture"};
        hfdProtocols = new String[]{"http", "file", "device"};
        hfProtocols = new String[]{"http", "file"};
        cProtocols = new String[]{"capture"};
        dProtocols = new String[]{"device"};
        supportedMPInputTypes = new String[]{MIME_IMAGE_PNG, MIME_IMAGE_JPEG, MIME_IMAGE_RAW};
        supportedSS3DPlayerTypes = new String[]{MIME_AUDIO_WAV, MIME_AUDIO_MIDI, MIME_AUDIO_SP_MIDI, MIME_AUDIO_TONE};
    }
}

