/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mmedia;

import com.sun.mmedia.BasicPlayer;
import com.sun.mmedia.Configuration;
import com.sun.mmedia.ImageAccess;
import com.sun.mmedia.VideoRenderer;
import java.io.IOException;
import java.util.Vector;
import javax.microedition.media.Control;
import javax.microedition.media.MediaException;
import javax.microedition.media.control.FramePositioningControl;
import javax.microedition.media.control.RateControl;

public final class GIFPlayer
extends BasicPlayer
implements Runnable {
    private static ImageAccess imageAccessor = Configuration.getConfiguration().getImageAccessor();
    private int videoWidth;
    private int videoHeight;
    private int leftPos;
    private int topPos;
    private int[] referenceFrame = null;
    private int[] rgbData = null;
    private int backgroundColor;
    private boolean transparencyFlag;
    private int transparencyColorIndex;
    private int transparencyColor;
    private Thread playThread;
    private boolean done;
    private long startTime;
    private long EARLY_THRESHOLD = 250L;
    private final long MIN_WAIT;
    private Vector frameTimes;
    private byte[] gifFrame;
    private int frameCount;
    private long mediaTimeOffset;
    private long displayTime;
    private VideoRenderer videoControl;
    private FramePosCtrl framePosControl;
    private RateCtrl rateControl;
    private long duration;
    private int seekType;
    private long firstFramePos;
    private boolean stopped;
    private Object playLock = new Object();
    private byte[] globalColorTable;
    private byte[] header;
    private byte[] logicalScreenDescriptor;
    private byte[] imageDescriptor;
    private byte[] graphicControl;
    private byte[] localColorTable;
    private byte[] imageData;
    private int imageDataLength;
    private boolean scanMode = false;
    private byte[] oneByte = new byte[1];

    public GIFPlayer() {
        this.MIN_WAIT = 50L;
    }

    protected Control doGetControl(String type) {
        if (type.startsWith("javax.microedition.media.control.")) {
            if ((type = type.substring("javax.microedition.media.control.".length())).equals("VideoControl") || type.equals("GUIControl")) {
                return this.videoControl;
            }
            if (type.equals("FramePositioningControl")) {
                return this.framePosControl;
            }
            if (type.equals("RateControl")) {
                return this.rateControl;
            }
            if (type.equals("StopTimeControl")) {
                return this;
            }
        }
        return null;
    }

    protected long doGetDuration() {
        return this.duration;
    }

    protected long doGetMediaTime() {
        long mediaTime;
        if (this.getState() < 400) {
            mediaTime = this.mediaTimeOffset;
        } else {
            mediaTime = (System.currentTimeMillis() - this.startTime) * 1000L + this.mediaTimeOffset;
            mediaTime = (long)((double)mediaTime * ((double)this.rateControl.getRate() / 100000.0));
        }
        if (mediaTime >= this.duration) {
            return this.duration;
        }
        return mediaTime;
    }

    protected long doSetMediaTime(long now) throws MediaException {
        this.mediaTimeOffset = now;
        if (now > this.duration) {
            now = this.duration;
        }
        if (this.seekType == this.NOT_SEEKABLE) {
            throw new MediaException("stream not seekable");
        }
        if (this.state == 400) {
            this.doStop();
        }
        try {
            int count = this.framePosControl.mapTimeToFrame(now);
            if (count + 1 < this.frameCount) {
                this.frameCount = 0;
                this.seekFirstFrame();
            }
            while (this.frameCount <= count && this.getFrame()) {
            }
            this.displayTime = this.getDuration(this.frameCount) / 1000L;
            if (this.state == 400) {
                this.doStart();
            }
        }
        catch (IOException e) {
            throw new MediaException(e.getMessage());
        }
        return now;
    }

    protected void doRealize() throws MediaException {
        this.duration = -1L;
        this.frameCount = 0;
        this.mediaTimeOffset = 0L;
        this.seekType = this.stream.getSeekType();
        if (!this.parseHeader()) {
            throw new MediaException("invalid GIF header");
        }
        this.scanFrames();
        this.videoControl = Configuration.getConfiguration().getVideoRenderer(this, this.videoWidth, this.videoHeight);
        this.videoControl.initRendering(260, this.videoWidth, this.videoHeight);
        this.framePosControl = new FramePosCtrl();
        this.rateControl = new RateCtrl();
        this.referenceFrame = null;
        this.rgbData = null;
        this.gifFrame = null;
    }

    protected void doPrefetch() throws MediaException {
        if (this.referenceFrame == null) {
            int size = this.videoWidth * this.videoHeight;
            this.referenceFrame = new int[size];
            if (!this.transparencyFlag || this.backgroundColor != this.transparencyColor) {
                int val = this.backgroundColor | 0xFF000000;
                for (int i = 0; i < size; ++i) {
                    this.referenceFrame[i] = val;
                }
            }
        }
        try {
            this.frameCount = 0;
            this.seekFirstFrame();
            if (!this.getFrame()) {
                throw new MediaException("can't get first frame");
            }
        }
        catch (IOException e) {
            throw new MediaException("can't seek first frame");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean doStart() {
        boolean started = true;
        this.startTime = System.currentTimeMillis();
        if (this.stopped) {
            this.stopped = false;
            Object object = this.playLock;
            synchronized (object) {
                this.playLock.notifyAll();
            }
        }
        this.displayTime = this.getFrameInterval(this.frameCount) / 1000L;
        this.playThreadFinished();
        Object object = this.playLock;
        synchronized (object) {
            if (this.playThread == null) {
                this.playThread = new Thread(this);
                this.playThread.start();
            }
        }
        return started;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStop() throws MediaException {
        if (this.stopped) {
            return;
        }
        Object object = this.playLock;
        synchronized (object) {
            try {
                if (this.playThread != null) {
                    this.stopped = true;
                    this.playLock.notifyAll();
                    this.mediaTimeOffset = this.doGetMediaTime();
                    this.startTime = 0L;
                    this.playLock.wait();
                }
            }
            catch (Exception e) {
                throw new MediaException(e.getMessage());
            }
        }
    }

    protected void doDeallocate() {
        this.playThreadFinished();
        this.stopped = false;
        this.gifFrame = null;
        this.rgbData = null;
        this.referenceFrame = null;
    }

    protected void doClose() {
        this.done = true;
        if (this.videoControl != null) {
            this.videoControl.close();
            this.videoControl = null;
        }
        this.frameTimes = null;
        this.header = null;
        this.logicalScreenDescriptor = null;
        this.imageDescriptor = null;
        this.graphicControl = null;
        this.globalColorTable = null;
        this.localColorTable = null;
        this.imageData = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Object object;
        this.done = false;
        while (!this.done) {
            if (!this.stopped) {
                this.processFrame();
            }
            if (!this.stopped) continue;
            object = this.playLock;
            synchronized (object) {
                this.playLock.notifyAll();
                try {
                    this.playLock.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        if (!this.stopped && !this.framePosControl.isActive()) {
            if (this.frameCount < this.frameTimes.size()) {
                this.duration = this.getDuration(this.frameCount);
                this.sendEvent("durationUpdated", new Long(this.duration));
            }
            this.mediaTimeOffset = this.doGetMediaTime();
            this.startTime = 0L;
            this.sendEvent("endOfMedia", new Long(this.mediaTimeOffset));
        }
        object = this.playLock;
        synchronized (object) {
            this.playThread = null;
            this.playLock.notifyAll();
        }
    }

    private void stopTimeReached() {
        this.mediaTimeOffset = this.doGetMediaTime();
        this.stopped = true;
        this.startTime = 0L;
        this.satev();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void playThreadFinished() {
        Object object = this.playLock;
        synchronized (object) {
            if (this.playThread != null) {
                this.done = true;
                this.playLock.notifyAll();
                try {
                    this.playLock.wait(5000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    private long getDuration(int frameCount) {
        long duration = 0L;
        for (int i = 0; i < frameCount; ++i) {
            duration += ((Long)this.frameTimes.elementAt(i)).longValue();
        }
        return duration;
    }

    private long getFrameInterval(int frameCount) {
        long interval = 0L;
        if (frameCount > 0 && frameCount <= this.frameTimes.size()) {
            interval = (Long)this.frameTimes.elementAt(frameCount - 1);
        }
        return interval;
    }

    private int timeToFrame(long mediaTime) {
        long interval;
        int frame = 0;
        long elapsedTime = 0L;
        for (int i = 0; i < this.frameTimes.size() && (elapsedTime += (interval = ((Long)this.frameTimes.elementAt(i)).longValue())) <= mediaTime; ++i) {
            ++frame;
        }
        return frame;
    }

    private long frameToTime(int frameNumber) {
        long elapsedTime = 0L;
        for (int i = 0; i < this.frameTimes.size(); ++i) {
            long interval = (Long)this.frameTimes.elementAt(i);
            if (i >= frameNumber) break;
            elapsedTime += interval;
        }
        return elapsedTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processFrame() {
        long mediaTime = this.doGetMediaTime() / 1000L;
        long frameInterval = this.getFrameInterval(this.frameCount) / 1000L;
        if (mediaTime + this.EARLY_THRESHOLD > this.displayTime) {
            if (!this.getFrame()) {
                Object object = this.playLock;
                synchronized (object) {
                    try {
                        long waitTime = this.displayTime - mediaTime;
                        if (waitTime > 0L) {
                            this.playLock.wait(waitTime);
                        }
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
                this.done = true;
                return;
            }
            this.displayTime += frameInterval;
            frameInterval = this.getFrameInterval(this.frameCount) / 1000L;
        }
        this.createFrame();
        this.renderFrame();
        if (this.stopTime != Long.MAX_VALUE && this.doGetMediaTime() >= this.stopTime) {
            this.stopTimeReached();
        }
        if (!this.stopped) {
            this.EARLY_THRESHOLD = 250L;
            if (frameInterval > 0L && frameInterval < this.EARLY_THRESHOLD) {
                this.EARLY_THRESHOLD = frameInterval / 2L;
            }
            if ((mediaTime = this.doGetMediaTime() / 1000L) < this.displayTime - this.EARLY_THRESHOLD) {
                Object object = this.playLock;
                synchronized (object) {
                    try {
                        if (!this.done) {
                            mediaTime = this.doGetMediaTime() / 1000L;
                            long waitTime = this.displayTime - this.EARLY_THRESHOLD - mediaTime;
                            while (!this.stopped && waitTime > 0L) {
                                if (waitTime > 50L) {
                                    this.playLock.wait(50L);
                                    waitTime -= 50L;
                                } else {
                                    this.playLock.wait(waitTime);
                                    waitTime = 0L;
                                }
                                if (this.stopTime == Long.MAX_VALUE || this.doGetMediaTime() < this.stopTime) continue;
                                this.stopTimeReached();
                            }
                        }
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
            }
        }
    }

    private void seekFirstFrame() throws IOException {
        if (this.seekType == this.RANDOM_ACCESSIBLE) {
            this.stream.seek(this.firstFramePos);
        } else {
            this.stream.seek(0L);
            this.parseHeader();
        }
    }

    private void createFrame() {
        Object im = imageAccessor.imageCreateFromByteArray(this.gifFrame, 0, this.gifFrame.length);
        int width = imageAccessor.getImageWidth(im);
        int height = imageAccessor.getImageHeight(im);
        this.rgbData = imageAccessor.getRGBIntImageData(im);
        if (width == this.videoWidth && height == this.videoHeight) {
            System.arraycopy(this.rgbData, 0, this.referenceFrame, 0, width * height);
        } else {
            for (int i = 0; i < height; ++i) {
                for (int k = 0; k < width; ++k) {
                    int val = this.rgbData[i * width + k];
                    int a = val >> 24 & 0xFF;
                    if (a != 255) continue;
                    this.referenceFrame[(i + this.topPos) * this.videoWidth + k + this.leftPos] = val;
                }
            }
        }
    }

    private void renderFrame() {
        if (this.referenceFrame != null) {
            this.videoControl.render(this.referenceFrame);
        }
    }

    private void scanFrames() throws MediaException {
        this.scanMode = true;
        this.frameCount = 0;
        this.duration = 0L;
        this.frameTimes = new Vector();
        boolean eos = false;
        do {
            int id;
            try {
                id = this.readUnsignedByte();
            }
            catch (IOException e) {
                id = 59;
            }
            if (id == 33) {
                this.parseControlExtension();
                continue;
            }
            if (id == 44) {
                this.parseImageDescriptor();
                continue;
            }
            eos = id == 59 ? true : true;
        } while (!eos);
        this.frameCount = 0;
        try {
            this.seekFirstFrame();
        }
        catch (IOException e) {
            throw new MediaException(e.getMessage());
        }
    }

    private boolean getFrame() {
        this.scanMode = false;
        if (this.stream.tell() == 0L) {
            this.parseHeader();
        }
        boolean eos = false;
        this.imageData = null;
        do {
            int id;
            try {
                id = this.readUnsignedByte();
            }
            catch (IOException e) {
                id = 59;
            }
            if (id == 33) {
                this.parseControlExtension();
                continue;
            }
            if (id == 44) {
                this.parseImageDescriptor();
                continue;
            }
            eos = id == 59 ? true : true;
        } while (!eos && this.imageData == null);
        if (this.imageData != null) {
            int length = this.header.length + this.logicalScreenDescriptor.length + 1 + this.imageDataLength + this.imageDescriptor.length;
            if (this.globalColorTable != null) {
                length += this.globalColorTable.length;
            }
            if (this.graphicControl != null) {
                length += this.graphicControl.length;
            }
            if (this.localColorTable != null) {
                length += this.localColorTable.length;
            }
            if (this.gifFrame == null || length > this.gifFrame.length) {
                this.gifFrame = new byte[length];
            }
            int idx = 0;
            System.arraycopy(this.header, 0, this.gifFrame, idx, this.header.length);
            System.arraycopy(this.logicalScreenDescriptor, 0, this.gifFrame, idx += this.header.length, this.logicalScreenDescriptor.length);
            idx += this.logicalScreenDescriptor.length;
            if (this.globalColorTable != null) {
                System.arraycopy(this.globalColorTable, 0, this.gifFrame, idx, this.globalColorTable.length);
                idx += this.globalColorTable.length;
            }
            if (this.graphicControl != null) {
                System.arraycopy(this.graphicControl, 0, this.gifFrame, idx, this.graphicControl.length);
                idx += this.graphicControl.length;
            }
            this.gifFrame[idx++] = 44;
            System.arraycopy(this.imageDescriptor, 0, this.gifFrame, idx, this.imageDescriptor.length);
            idx += this.imageDescriptor.length;
            if (this.localColorTable != null) {
                System.arraycopy(this.localColorTable, 0, this.gifFrame, idx, this.localColorTable.length);
                idx += this.localColorTable.length;
            }
            System.arraycopy(this.imageData, 0, this.gifFrame, idx, this.imageDataLength);
            ++this.frameCount;
            return true;
        }
        return false;
    }

    private boolean parseHeader() {
        boolean ok = true;
        try {
            if (this.header == null) {
                this.header = new byte[6];
            }
            this.stream.read(this.header, 0, 6);
            if (this.header[0] != 71 || this.header[1] != 73 || this.header[2] != 70) {
                ok = false;
            }
            if (ok) {
                ok = this.header[3] == 56 && (this.header[4] == 57 || this.header[4] == 55) && this.header[5] == 97 ? this.parseLogicalScreenDescriptor() : false;
            }
        }
        catch (IOException e) {
            ok = false;
        }
        this.firstFramePos = this.stream.tell();
        return ok;
    }

    private boolean parseLogicalScreenDescriptor() {
        try {
            if (this.logicalScreenDescriptor == null) {
                this.logicalScreenDescriptor = new byte[7];
            }
            this.stream.read(this.logicalScreenDescriptor, 0, 7);
            this.videoWidth = this.readShort(this.logicalScreenDescriptor, 0);
            this.videoHeight = this.readShort(this.logicalScreenDescriptor, 2);
            byte lo = this.logicalScreenDescriptor[4];
            boolean globalFlag = (lo >> 7 & 1) == 1;
            int resolution = (lo >> 4 & 7) + 1;
            int sortFlag = lo >> 3 & 1;
            int tableSize = 3 * (1 << (lo & 7) + 1);
            int index = this.logicalScreenDescriptor[5] & 0xFF;
            byte pixelAspectRatio = this.logicalScreenDescriptor[6];
            if (globalFlag) {
                this.parseGlobalColorTable(tableSize);
                int r = this.globalColorTable[index *= 3] & 0xFF;
                int g = this.globalColorTable[index + 1] & 0xFF;
                int b = this.globalColorTable[index + 2] & 0xFF;
                this.backgroundColor = (r << 16) + (g << 8) + b;
            } else {
                this.globalColorTable = null;
            }
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    private void parseGlobalColorTable(int size) {
        this.globalColorTable = new byte[size];
        try {
            this.stream.read(this.globalColorTable, 0, size);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private int readShort(byte[] data, int offset) {
        int lo = data[offset] & 0xFF;
        int hi = data[offset + 1] & 0xFF;
        return lo + (hi << 8);
    }

    private int readShort() {
        int val = 0;
        try {
            int lo = this.readUnsignedByte();
            int hi = this.readUnsignedByte();
            val = lo + (hi << 8);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return val;
    }

    private void parseImageDescriptor() {
        try {
            if (this.imageDescriptor == null) {
                this.imageDescriptor = new byte[9];
            }
            this.stream.read(this.imageDescriptor, 0, 9);
            this.leftPos = this.readShort(this.imageDescriptor, 0);
            this.imageDescriptor[0] = 0;
            this.imageDescriptor[1] = 0;
            this.topPos = this.readShort(this.imageDescriptor, 2);
            this.imageDescriptor[2] = 0;
            this.imageDescriptor[3] = 0;
            int width = this.readShort(this.imageDescriptor, 4);
            int height = this.readShort(this.imageDescriptor, 6);
            byte lo = this.imageDescriptor[8];
            int localFlag = lo >> 7;
            boolean interlaceFlag = (lo >> 6 & 1) == 1;
            int sortFlag = lo >> 5 & 1;
            if (localFlag == 1) {
                int tableSize = 3 * (1 << (lo & 7) + 1);
                this.parseLocalColorTable(tableSize);
            } else {
                this.localColorTable = null;
            }
            this.parseImageData();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void parseLocalColorTable(int size) {
        this.localColorTable = new byte[size];
        try {
            this.stream.read(this.localColorTable, 0, size);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void parseImageData() {
        try {
            int size;
            int lzw = this.readUnsignedByte();
            if (this.imageData == null) {
                this.imageData = new byte[1024];
            }
            this.imageData[0] = (byte)lzw;
            int idx = 1;
            do {
                if (this.imageData.length < idx + 1 + (size = this.readUnsignedByte())) {
                    byte[] data = new byte[idx + 1 + size];
                    System.arraycopy(this.imageData, 0, data, 0, idx);
                    this.imageData = data;
                    data = null;
                }
                this.imageData[idx++] = (byte)size;
                if (size > 0) {
                    this.stream.read(this.imageData, idx, size);
                }
                idx += size;
            } while (size != 0);
            this.imageDataLength = idx;
        }
        catch (IOException e) {
            this.imageDataLength = 0;
        }
    }

    private void parsePlainTextExtension() {
        try {
            int size = this.readUnsignedByte();
            if (size != 12) {
                // empty if block
            }
            int leftPos = this.readShort();
            int topPos = this.readShort();
            int width = this.readShort();
            int height = this.readShort();
            int cellWidth = this.readUnsignedByte();
            int cellHeight = this.readUnsignedByte();
            int fgIndex = this.readUnsignedByte();
            int bgIndex = this.readUnsignedByte();
            do {
                if ((size = this.readUnsignedByte()) <= 0) continue;
                byte[] data = new byte[size];
                this.stream.read(data, 0, size);
            } while (size != 0);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void parseControlExtension() {
        try {
            int label = this.readUnsignedByte();
            if (label == 255) {
                this.parseApplicationExtension();
            } else if (label == 254) {
                this.parseCommentExtension();
            } else if (label == 249) {
                this.parseGraphicControlExtension();
            } else if (label == 1) {
                this.parsePlainTextExtension();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void parseApplicationExtension() {
        try {
            int size = this.readUnsignedByte();
            if (size != 11) {
                // empty if block
            }
            byte[] data = new byte[8];
            this.stream.read(data, 0, 8);
            data = new byte[3];
            this.stream.read(data, 0, 3);
            do {
                if ((size = this.readUnsignedByte()) <= 0) continue;
                data = new byte[size];
                this.stream.read(data, 0, size);
            } while (size != 0);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void parseCommentExtension() {
        try {
            int size;
            do {
                if ((size = this.readUnsignedByte()) <= 0) continue;
                byte[] data = new byte[size];
                this.stream.read(data, 0, size);
            } while (size != 0);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void parseGraphicControlExtension() {
        try {
            int pf;
            if (this.graphicControl == null) {
                this.graphicControl = new byte[8];
            }
            this.graphicControl[0] = 33;
            this.graphicControl[1] = -7;
            this.stream.read(this.graphicControl, 2, 6);
            int size = this.graphicControl[2] & 0xFF;
            if (size != 4) {
                // empty if block
            }
            this.transparencyFlag = ((pf = this.graphicControl[3] & 0xFF) & 1) == 1;
            int frameInterval = this.readShort(this.graphicControl, 4) * 10000;
            this.transparencyColorIndex = (this.graphicControl[6] & 0xFF) * 3;
            if (this.transparencyFlag && this.globalColorTable != null) {
                int r = this.globalColorTable[this.transparencyColorIndex] & 0xFF;
                int g = this.globalColorTable[this.transparencyColorIndex + 1] & 0xFF;
                int b = this.globalColorTable[this.transparencyColorIndex + 2] & 0xFF;
                this.transparencyColor = (r << 16) + (g << 8) + b;
            }
            int terminator = this.graphicControl[7] & 0xFF;
            if (this.scanMode) {
                ++this.frameCount;
                this.frameTimes.addElement(new Long(frameInterval));
                this.duration += (long)frameInterval;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private int readUnsignedByte() throws IOException {
        if (this.stream.read(this.oneByte, 0, 1) == -1) {
            throw new IOException();
        }
        return this.oneByte[0] & 0xFF;
    }

    class RateCtrl
    implements RateControl {
        private int rate = 100000;
        private final int MIN_PLAYBACK_RATE;
        private final int MAX_PLAYBACK_RATE;

        RateCtrl() {
            this.MIN_PLAYBACK_RATE = 10000;
            this.MAX_PLAYBACK_RATE = 200000;
        }

        public int setRate(int millirate) {
            this.rate = millirate < 10000 ? 10000 : (millirate > 200000 ? 200000 : millirate);
            return this.rate;
        }

        public int getRate() {
            return this.rate;
        }

        public int getMaxRate() {
            return 200000;
        }

        public int getMinRate() {
            return 10000;
        }
    }

    class FramePosCtrl
    implements FramePositioningControl {
        private boolean active = false;

        FramePosCtrl() {
        }

        public int seek(int frameNumber) {
            this.active = true;
            GIFPlayer.this.EOM = false;
            if (frameNumber < 0) {
                frameNumber = 0;
            } else if (frameNumber >= GIFPlayer.this.frameTimes.size()) {
                frameNumber = GIFPlayer.this.frameTimes.size() - 1;
            }
            long time = this.mapFrameToTime(frameNumber);
            try {
                GIFPlayer.this.doSetMediaTime(time);
            }
            catch (MediaException e) {
                // empty catch block
            }
            this.active = false;
            return frameNumber;
        }

        public int skip(int framesToSkip) {
            this.active = true;
            GIFPlayer.this.EOM = false;
            int frames_skipped = 0;
            int oldFrame = GIFPlayer.this.frameCount - 1;
            if (oldFrame < 0) {
                oldFrame = 0;
            } else if (oldFrame >= GIFPlayer.this.frameTimes.size()) {
                oldFrame = GIFPlayer.this.frameTimes.size() - 1;
            }
            long newFrame = (long)oldFrame + (long)framesToSkip;
            if (newFrame < 0L) {
                newFrame = 0L;
            } else if (newFrame >= (long)GIFPlayer.this.frameTimes.size()) {
                newFrame = GIFPlayer.this.frameTimes.size() - 1;
            }
            long time = this.mapFrameToTime((int)newFrame);
            try {
                GIFPlayer.this.doSetMediaTime(time);
                frames_skipped = (int)(newFrame - (long)oldFrame);
            }
            catch (MediaException e) {
                // empty catch block
            }
            this.active = false;
            return frames_skipped;
        }

        public long mapFrameToTime(int frameNumber) {
            if (frameNumber < 0 || frameNumber >= GIFPlayer.this.frameTimes.size()) {
                return -1L;
            }
            return GIFPlayer.this.frameToTime(frameNumber) * (long)GIFPlayer.this.rateControl.getRate() / 100000L;
        }

        public int mapTimeToFrame(long mediaTime) {
            if (mediaTime < 0L || mediaTime > GIFPlayer.this.duration) {
                return -1;
            }
            long time = mediaTime * (long)GIFPlayer.this.rateControl.getRate() / 100000L;
            return GIFPlayer.this.timeToFrame(time);
        }

        public boolean isActive() {
            return this.active;
        }
    }
}

