/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mmedia;

import com.sun.mmedia.BasicPlayer;
import com.sun.mmedia.ImageEncoder;
import com.sun.mmedia.MIDPRendererCanvasBuddy;
import com.sun.mmedia.MIDPVideoPainter;
import com.sun.mmedia.MMCustomItem;
import com.sun.mmedia.MMHelper;
import com.sun.mmedia.PermissionAccessor;
import com.sun.mmedia.VideoRenderer;
import com.sun.mmedia.protocol.LocatorParser;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.media.MediaException;

public final class MIDPVideoRenderer
extends VideoRenderer
implements MIDPVideoPainter {
    private MMItem mmItem;
    private Canvas canvas;
    private boolean fsmode;
    private boolean closed;
    private int mode = -1;
    private boolean cvis;
    private boolean pvis;
    private BasicPlayer player;
    private int dx;
    private int tmpdx;
    private int dy;
    private int tmpdy;
    private int dw;
    private int tmpdw;
    private int dh;
    private int tmpdh;
    private int videoWidth;
    private int videoHeight;
    private byte[] tempSnapData;
    private static final boolean TRACE_FRAMERATE = false;
    private int frameCount;
    private long frameStartTime = 0L;
    private static final String UNSUP_PARAMS = "Unsupported parameters";
    private Object dispBoundsLock = new Object();
    public static final int RGB565 = 1;
    public static final int RGB888 = 2;
    public static final int XRGB888 = 3;
    public static final int XBGR888 = 4;
    public static final int RGBX888 = 5;
    public static final int YUV420_PLANAR = 6;
    public static final int YUV422_PLANAR = 7;
    public static final int YUYV = 8;
    public static final int UYVY = 9;
    public static final int YVYU = 10;
    public static final int NATIVE_RENDER = 128;
    public static final int USE_ALPHA = 256;
    int rgbMode;
    int pWidth;
    int pHeight;
    int[] rgbData;
    int[] scaledRGB;
    byte[] pngData;
    int pngDataLength;
    boolean nativeRender;
    boolean useAlpha;
    private Image image;
    private MMHelper mmh = null;

    MIDPVideoRenderer(BasicPlayer player, int sourceWidth, int sourceHeight) {
        this.setSourceSize(sourceWidth, sourceHeight);
        this.player = player;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setSourceSize(int sourceWidth, int sourceHeight) {
        this.videoWidth = sourceWidth;
        this.videoHeight = sourceHeight;
        Object object = this.dispBoundsLock;
        synchronized (object) {
            this.dw = this.videoWidth;
            this.dh = this.videoHeight;
        }
    }

    private void checkState() {
        if (this.mode == -1) {
            throw new IllegalStateException("initDisplayMode not called yet");
        }
    }

    public Object initDisplayMode(int mode, Object container) {
        if (this.mode != -1) {
            throw new IllegalStateException("mode is already set");
        }
        if (mode == 1) {
            if (!(container instanceof Canvas)) {
                throw new IllegalArgumentException("container needs to be a Canvas for USE_DIRECT_VIDEO mode");
            }
            if (this.mmh == null) {
                this.mmh = MIDPRendererCanvasBuddy.getMMHelper();
                if (this.mmh == null) {
                    throw new IllegalArgumentException("unable to set USE_DIRECT_VIDEO mode");
                }
            }
            this.mode = mode;
            this.fsmode = false;
            this.cvis = true;
            this.canvas = (Canvas)container;
            this.mmh.registerPlayer(this.canvas, this);
            this.setVisible(false);
            return null;
        }
        if (mode == 0) {
            if (!(container == null || container instanceof String && container.equals("javax.microedition.lcdui.Item"))) {
                throw new IllegalArgumentException("container needs to be a javax.microedition.lcdui.Item for USE_GUI_PRIMITIVE mode");
            }
            this.mode = mode;
            this.fsmode = false;
            this.cvis = true;
            this.mmItem = new MMItem();
            this.setVisible(true);
            return this.mmItem;
        }
        throw new IllegalArgumentException("unsupported mode");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDisplayLocation(int x, int y) {
        this.checkState();
        if (this.mode == 1) {
            if (this.fsmode) {
                Object object = this.dispBoundsLock;
                synchronized (object) {
                    this.tmpdx = x;
                    this.tmpdy = y;
                }
            }
            Object object = this.dispBoundsLock;
            synchronized (object) {
                this.dx = x;
                this.dy = y;
            }
            if (this.pvis && this.cvis) {
                this.canvas.repaint();
            }
        }
    }

    public int getDisplayX() {
        return this.dx;
    }

    public int getDisplayY() {
        return this.dy;
    }

    private static void checkPermission() throws SecurityException {
        PermissionAccessor.checkPermissions(12);
    }

    public void setVisible(boolean visible) {
        this.checkState();
        this.pvis = visible;
        if (this.canvas != null) {
            this.canvas.repaint();
        } else if (this.mmItem != null) {
            this.mmItem.forcePaint(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDisplaySize(int width, int height) throws MediaException {
        boolean sizeChanged;
        this.checkState();
        if (width < 1 || height < 1) {
            throw new IllegalArgumentException("Invalid size");
        }
        boolean bl = sizeChanged = this.dw != width || this.dh != height;
        if (this.fsmode) {
            Object object = this.dispBoundsLock;
            synchronized (object) {
                this.tmpdw = width;
                this.tmpdh = height;
            }
        }
        Object object = this.dispBoundsLock;
        synchronized (object) {
            this.dw = width;
            this.dh = height;
        }
        if (this.pvis) {
            if (this.mmItem != null) {
                this.mmItem.forcePaint(null);
            } else if (this.cvis) {
                this.canvas.repaint();
            }
        }
        if (sizeChanged && !this.fsmode) {
            this.player.sendEvent("sizeChanged", this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDisplayFullScreen(boolean fullScreenMode) throws MediaException {
        this.checkState();
        if (this.fsmode != fullScreenMode) {
            boolean bl = this.fsmode = !this.fsmode;
            if (this.fsmode) {
                Object object = this.dispBoundsLock;
                synchronized (object) {
                    this.tmpdx = this.dx;
                    this.tmpdy = this.dy;
                    this.tmpdw = this.dw;
                    this.tmpdh = this.dh;
                }
                if (this.mode == 1) {
                    this.canvas.setFullScreenMode(true);
                } else {
                    this.canvas = this.mmItem.toFullScreen(this, this);
                    if (this.canvas == null) {
                        return;
                    }
                }
                object = this.dispBoundsLock;
                synchronized (object) {
                    this.dx = 0;
                    this.dy = 0;
                    int scrw = this.canvas.getWidth();
                    int scrh = this.canvas.getHeight();
                    this.dw = scrh * this.videoWidth / this.videoHeight;
                    if (this.dw > scrw) {
                        this.dw = scrw;
                        this.dh = scrw * this.videoHeight / this.videoWidth;
                        this.dy = (scrh - this.dh) / 2;
                    } else {
                        this.dh = scrh;
                        this.dx = (scrw - this.dw) / 2;
                    }
                }
                if (this.cvis) {
                    this.canvas.repaint();
                }
            } else {
                Object object = this.dispBoundsLock;
                synchronized (object) {
                    this.dx = this.tmpdx;
                    this.dy = this.tmpdy;
                    this.dw = this.tmpdw;
                    this.dh = this.tmpdh;
                }
                if (this.mode == 1) {
                    this.canvas.setFullScreenMode(false);
                    if (this.pvis && this.cvis) {
                        this.canvas.repaint();
                    }
                } else {
                    this.mmItem.toNormal();
                    this.canvas = null;
                    if (this.pvis) {
                        this.mmItem.forcePaint(null);
                    }
                }
            }
            this.player.sendEvent("sizeChanged", this);
        }
    }

    public int getDisplayWidth() {
        this.checkState();
        return this.dw;
    }

    public int getDisplayHeight() {
        this.checkState();
        return this.dh;
    }

    public int getSourceWidth() {
        return this.videoWidth;
    }

    public int getSourceHeight() {
        return this.videoHeight;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getSnapshot(String imageType) throws MediaException, SecurityException {
        this.checkState();
        MIDPVideoRenderer.checkPermission();
        MIDPVideoRenderer mIDPVideoRenderer = this;
        synchronized (mIDPVideoRenderer) {
            int quality;
            int encType;
            String enc;
            block34: {
                String value;
                String key;
                LocatorParser lp;
                boolean interlaced;
                boolean progressive;
                String colors;
                int height;
                int width;
                block35: {
                    block36: {
                        enc = "jpeg";
                        encType = 1;
                        width = this.videoWidth;
                        height = this.videoHeight;
                        quality = 100;
                        String video_type = null;
                        colors = "rgb888";
                        progressive = false;
                        interlaced = false;
                        if (imageType == null) break block34;
                        String imgTypeLC = imageType.toLowerCase();
                        lp = new LocatorParser(imgTypeLC);
                        key = lp.getParameter();
                        if (key != null) {
                            if (!key.equals("encoding")) {
                                throw new MediaException(UNSUP_PARAMS);
                            }
                            enc = lp.getValue();
                        }
                        if (!enc.equals("jpeg")) break block35;
                        video_type = "jfif";
                        quality = 80;
                        while ((key = lp.getParameter()) != null) {
                            value = lp.getValue();
                            try {
                                if (key.equals("width")) {
                                    width = Integer.parseInt(value);
                                    continue;
                                }
                                if (key.equals("height")) {
                                    height = Integer.parseInt(value);
                                    continue;
                                }
                                if (key.equals("type")) {
                                    video_type = value;
                                    continue;
                                }
                                if (key.equals("progressive")) {
                                    progressive = value.equals("true");
                                    continue;
                                }
                                if (key.equals("interlaced")) {
                                    interlaced = value.equals("true");
                                    continue;
                                }
                                if (key.equals("quality")) {
                                    quality = Integer.parseInt(value);
                                    continue;
                                }
                                if (key.equals("fps")) continue;
                                if (key.equals("colors")) continue;
                                throw new MediaException("Illegal option");
                            }
                            catch (NumberFormatException nfe) {
                                throw new MediaException("Number format error");
                            }
                        }
                        if (lp.hasMore()) break block36;
                        if (video_type.equals("jfif") && width == this.videoWidth && height == this.videoHeight && !progressive && !interlaced) break block34;
                    }
                    throw new MediaException(UNSUP_PARAMS);
                }
                if (enc.equals("png")) {
                    encType = 2;
                    while ((key = lp.getParameter()) != null) {
                        value = lp.getValue();
                        try {
                            if (key.equals("width")) {
                                width = Integer.parseInt(value);
                                continue;
                            }
                            if (key.equals("height")) {
                                height = Integer.parseInt(value);
                                continue;
                            }
                            if (key.equals("colors")) {
                                colors = value;
                                continue;
                            }
                            if (key.equals("fps")) continue;
                            if (key.equals("quality")) continue;
                            throw new MediaException("Illegal option");
                        }
                        catch (NumberFormatException nfe) {
                            throw new MediaException("Number format error");
                        }
                    }
                    if (lp.hasMore() || !colors.equals("rgb888") || width != this.videoWidth || height != this.videoHeight || progressive || interlaced) {
                        throw new MediaException(UNSUP_PARAMS);
                    }
                } else {
                    throw new MediaException(UNSUP_PARAMS);
                }
            }
            int snapLength = 0;
            if (this.tempSnapData == null) {
                this.tempSnapData = new byte[this.videoWidth * this.videoHeight * 4];
            }
            if (this.pngData != null) {
                Image pngImage = Image.createImage(this.pngData, 0, this.pngDataLength);
                int[] tempRGBData = new int[this.videoWidth * this.videoHeight];
                pngImage.getRGB(tempRGBData, 0, this.videoWidth, 0, 0, this.videoWidth, this.videoHeight);
                snapLength = ImageEncoder.RGBIntCompress(tempRGBData, this.videoWidth, this.videoHeight, quality, this.tempSnapData, encType);
            } else if (this.rgbData != null) {
                snapLength = ImageEncoder.RGBIntCompress(this.rgbData, this.videoWidth, this.videoHeight, quality, this.tempSnapData, encType);
                if (snapLength <= 0) {
                    throw new MediaException("Error encoding to " + enc);
                }
            } else {
                byte[] blank = new byte[this.videoWidth * this.videoHeight * 4];
                for (int i = 0; i < this.videoWidth * this.videoHeight * 4; ++i) {
                    blank[i] = 0;
                }
                snapLength = ImageEncoder.RGBByteCompress(blank, this.videoWidth, this.videoHeight, quality, this.tempSnapData, encType);
            }
            if (snapLength <= 0) {
                throw new MediaException("Error encoding to " + enc);
            }
            byte[] snap = new byte[snapLength];
            System.arraycopy(this.tempSnapData, 0, snap, 0, snapLength);
            return snap;
        }
    }

    private int tryParam(String tok, String prop, int def) {
        if (tok.startsWith(prop)) {
            tok = tok.substring(prop.length(), tok.length());
            try {
                return Integer.parseInt(tok);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return def;
    }

    public synchronized void close() {
        if (!this.closed && this.canvas != null) {
            this.mmh.unregisterPlayer(this.canvas, this);
        }
        this.rgbData = null;
        this.scaledRGB = null;
        this.pngData = null;
        this.closed = true;
    }

    public void initRendering(int mode, int width, int height) {
        this.rgbMode = mode & 0x7F;
        this.nativeRender = (mode & 0x80) > 0;
        this.useAlpha = (mode & 0x100) > 0;
        this.pWidth = width;
        this.pHeight = height;
    }

    void setMode(int mode) {
        this.rgbMode = mode & 0x7F;
        this.nativeRender = mode >= 128;
    }

    int getPreferredRGBMode() {
        return 2;
    }

    public void render(int[] data) {
        this.render((Object)data);
    }

    synchronized boolean render(Object data) {
        if (data == null) {
            return false;
        }
        if (!(data instanceof int[])) {
            return false;
        }
        this.update((int[])data);
        return true;
    }

    synchronized boolean renderImage(byte[] imageData, int imageLength) {
        this.pngData = imageData;
        this.pngDataLength = imageLength;
        if (!this.pvis) {
            return false;
        }
        if (this.canvas != null) {
            if (this.cvis) {
                this.canvas.repaint(this.dx, this.dy, this.dw, this.dh);
            }
        } else if (this.mmItem != null) {
            this.mmItem.renderImage(imageData, imageLength);
        }
        return true;
    }

    private void update(int[] frame) {
        if (this.rgbMode != 4) {
            return;
        }
        this.rgbData = frame;
        if (!this.pvis) {
            return;
        }
        if (this.canvas != null) {
            if (this.cvis) {
                this.canvas.repaint(this.dx, this.dy, this.dw, this.dh);
            }
        } else if (this.mmItem != null) {
            this.mmItem.forcePaint(frame);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int[] scaleToDest(int[] source) {
        int ldw = 0;
        int ldh = 0;
        Object object = this.dispBoundsLock;
        synchronized (object) {
            ldw = this.dw;
            ldh = this.dh;
        }
        object = this;
        synchronized (object) {
            if (this.scaledRGB == null || this.scaledRGB.length < ldw * ldh) {
                this.scaledRGB = new int[ldw * ldh];
            }
            int dp = 0;
            for (int y = 0; y < ldh; ++y) {
                for (int x = 0; x < ldw; ++x) {
                    this.scaledRGB[dp++] = source[y * this.videoHeight / ldh * this.videoWidth + x * this.videoWidth / ldw];
                }
            }
            return this.scaledRGB;
        }
    }

    private int[] scaleToDest(Image img) {
        if (this.rgbData == null) {
            this.rgbData = new int[this.videoWidth * this.videoHeight];
        }
        int width = img.getWidth();
        int height = img.getHeight();
        img.getRGB(this.rgbData, 0, this.videoWidth, 0, 0, width, height);
        return this.scaleToDest(this.rgbData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintVideo(Graphics g) {
        block18: {
            if (!this.pvis || !this.cvis) {
                return;
            }
            int cx = g.getClipX();
            int cy = g.getClipY();
            int cw = g.getClipWidth();
            int ch = g.getClipHeight();
            g.clipRect(this.dx, this.dy, this.dw, this.dh);
            if (g.getClipWidth() > 0 && g.getClipHeight() > 0 && this.pvis) {
                int w = this.dw;
                int h = this.dh;
                if (w > this.videoWidth) {
                    w = this.videoWidth;
                }
                if (h > this.videoHeight) {
                    h = this.videoHeight;
                }
                try {
                    MIDPVideoRenderer mIDPVideoRenderer = this;
                    synchronized (mIDPVideoRenderer) {
                        if (this.pngData != null) {
                            if (this.image != null) {
                                // empty if block
                            }
                            this.image = Image.createImage(this.pngData, 0, this.pngDataLength);
                            if (this.dw != this.videoWidth || this.dh != this.videoHeight) {
                                int[] scaledRGB = this.scaleToDest(this.image);
                                g.drawRGB(scaledRGB, 0, this.dw, this.dx, this.dy, this.dw, this.dh, this.useAlpha);
                            } else {
                                g.drawImage(this.image, this.dx, this.dy, 20);
                            }
                        } else if (this.rgbData != null) {
                            if (this.dw != this.videoWidth || this.dh != this.videoHeight) {
                                int[] scaledRGB = this.scaleToDest(this.rgbData);
                                g.drawRGB(scaledRGB, 0, this.dw, this.dx, this.dy, this.dw, this.dh, this.useAlpha);
                            } else {
                                g.drawRGB(this.rgbData, 0, this.videoWidth, this.dx, this.dy, w, h, this.useAlpha);
                            }
                        }
                        break block18;
                    }
                }
                finally {
                    g.setClip(cx, cy, cw, ch);
                }
            }
            g.setClip(cx, cy, cw, ch);
        }
    }

    public void showVideo() {
        if (this.canvas == null) {
            return;
        }
        if (!this.cvis) {
            this.cvis = true;
            this.canvas.repaint();
        }
    }

    public void hideVideo() {
        if (this.canvas == null) {
            return;
        }
        if (this.cvis) {
            this.cvis = false;
            this.canvas.repaint();
        }
    }

    final class MMItem
    extends MMCustomItem {
        int ody;
        int odh;
        int odw;
        int[] frame;
        Image image;
        Object imageLock = new Object();

        public MMItem() {
            super("");
        }

        void forcePaint(int[] frame) {
            if (frame != null) {
                this.frame = frame;
            } else {
                this.invalidate();
            }
            this.repaint();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void renderImage(byte[] imageData, int imageLength) {
            Object object = this.imageLock;
            synchronized (object) {
                this.image = Image.createImage(imageData, 0, imageLength);
            }
            this.repaint();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void paint(Graphics g, int w, int h) {
            if (!MIDPVideoRenderer.this.pvis) {
                return;
            }
            if (this.frame != null) {
                if (MIDPVideoRenderer.this.dw != MIDPVideoRenderer.this.videoWidth || MIDPVideoRenderer.this.dh != MIDPVideoRenderer.this.videoHeight) {
                    int[] scaledRGB = MIDPVideoRenderer.this.scaleToDest(this.frame);
                    g.drawRGB(scaledRGB, 0, MIDPVideoRenderer.this.dw, 0, 0, MIDPVideoRenderer.this.dw, MIDPVideoRenderer.this.dh, MIDPVideoRenderer.this.useAlpha);
                } else {
                    g.drawRGB(this.frame, 0, MIDPVideoRenderer.this.videoWidth, 0, 0, MIDPVideoRenderer.this.videoWidth, MIDPVideoRenderer.this.videoHeight, MIDPVideoRenderer.this.useAlpha);
                }
            } else {
                Object object = this.imageLock;
                synchronized (object) {
                    if (this.image != null) {
                        if (MIDPVideoRenderer.this.dw != MIDPVideoRenderer.this.videoWidth || MIDPVideoRenderer.this.dh != MIDPVideoRenderer.this.videoHeight) {
                            int[] scaledRGB = MIDPVideoRenderer.this.scaleToDest(this.image);
                            g.drawRGB(scaledRGB, 0, MIDPVideoRenderer.this.dw, 0, 0, MIDPVideoRenderer.this.dw, MIDPVideoRenderer.this.dh, MIDPVideoRenderer.this.useAlpha);
                        } else {
                            g.drawImage(this.image, 0, 0, 20);
                        }
                    }
                }
            }
        }

        protected int getMinContentWidth() {
            return 1;
        }

        protected int getMinContentHeight() {
            return 1;
        }

        protected int getPrefContentWidth(int h) {
            return MIDPVideoRenderer.this.dw;
        }

        protected int getPrefContentHeight(int w) {
            return MIDPVideoRenderer.this.dh;
        }

        protected void hideNotify() {
            super.hideNotify();
        }
    }
}

