/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mmedia;

import com.sun.midp.io.j2me.socket.Protocol;
import com.sun.midp.security.ImplicitlyTrustedClass;
import com.sun.midp.security.SecurityToken;
import com.sun.mmedia.BasicPlayer;
import com.sun.mmedia.Configuration;
import com.sun.mmedia.ContainerVolumeCtrl;
import com.sun.mmedia.TunerPreset;
import com.sun.mmedia.protocol.LocatorParser;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import javax.microedition.media.Control;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;

public class MmapiTuner
extends BasicPlayer
implements ImplicitlyTrustedClass {
    private static final String[] allCtrls;
    private static final int MODE_MONO = 1;
    private static final int MODE_STEREO = 2;
    private static final int MODE_AUTO = 3;
    protected static final String MODULATION_FM = "fm";
    protected static final String MODULATION_AM = "am";
    protected static final int AM_MIN = 5300;
    protected static final int AM_MAX = 17100;
    protected static final int FM_MIN = 875000;
    protected static final int FM_MAX = 1080000;
    private static final int NUM_PRESETS = 4;
    protected static int[] fm_stations;
    protected static int[] am_stations;
    protected static String[] fm_names;
    protected static String[] am_names;
    protected static String[] fm_text;
    protected static String[] am_text;
    protected static String[] fm_urls;
    protected static String[] am_urls;
    protected static int[] fm_presets;
    protected static int[] am_presets;
    private static Configuration config;
    private static final String playerContentType = "audio/x-wav";
    private static final int BUF_SIZE = 16384;
    private static SecurityToken classSecurityToken;
    private Player player;
    private ContainerVolumeCtrl volumeControl;
    private boolean need_startup_play;
    protected Vector presets;
    protected String p_modulation;
    protected int p_frequency;
    protected int p_stereo_mode;
    private String p_program_id;
    private int p_preset;
    private int instance;
    private Protocol sc;
    private InputStream radioInStream;

    public final void initSecurityToken(SecurityToken token) {
        if (classSecurityToken != null) {
            return;
        }
        classSecurityToken = token;
    }

    public MmapiTuner() {
        super(allCtrls, null);
        this.init();
    }

    protected MmapiTuner(String[] n, int[] p) {
        super(n == null ? allCtrls : n, p);
        this.init();
    }

    private void init() {
        TunerPreset p;
        int preset;
        int i;
        this.instance = this.hashCode();
        this.hasDataSource = false;
        this.need_startup_play = false;
        int size = MmapiTuner.getIntegerProperty("com.sun.tuner.presets");
        if (size <= 0) {
            size = 4;
        }
        this.presets = new Vector(size);
        for (i = 0; i < size; ++i) {
            this.presets.addElement(new TunerPreset("", 3, MODULATION_FM, 875000));
        }
        for (i = 0; i < fm_presets.length; ++i) {
            preset = fm_presets[i];
            if (preset < 1 || preset > this.presets.size() || fm_stations[i] < 875000 || fm_stations[i] > 1080000) continue;
            p = (TunerPreset)this.presets.elementAt(preset - 1);
            p.setName(fm_names[i]);
            p.set(MODULATION_FM, fm_stations[i], 3);
        }
        for (i = 0; i < am_presets.length; ++i) {
            preset = am_presets[i];
            if (preset < 1 || preset > this.presets.size() || am_stations[i] < 5300 || am_stations[i] > 17100) continue;
            p = (TunerPreset)this.presets.elementAt(preset - 1);
            p.setName(fm_names[i]);
            p.set(MODULATION_AM, am_stations[i], 3);
        }
        preset = MmapiTuner.getIntegerProperty("com.sun.tuner.play");
        if (preset >= 1 && preset <= this.presets.size()) {
            p = (TunerPreset)this.presets.elementAt(preset - 1);
            this.p_modulation = p.getModulation();
            this.p_frequency = p.getFrequency();
            this.p_stereo_mode = p.getStereoMode();
            this.p_program_id = p.getName();
            this.p_preset = preset;
            this.need_startup_play = true;
        } else {
            this.p_modulation = null;
            this.p_frequency = 0;
            this.p_stereo_mode = 0;
            this.p_program_id = null;
            this.p_preset = 0;
        }
        this.volumeControl = new ContainerVolumeCtrl(this);
    }

    public boolean initFromURL(String encodings) {
        if (encodings != null) {
            this.p_modulation = null;
            this.p_frequency = 0;
            this.p_stereo_mode = 0;
            this.p_program_id = null;
            this.p_preset = 0;
            String f_modulation = null;
            LocatorParser lp = new LocatorParser(encodings);
            while (lp.hasMore()) {
                String name = lp.getParameter();
                String val = lp.getValue();
                try {
                    if (name.equals("st") && this.p_stereo_mode == 0) {
                        if (val.equals("auto")) {
                            this.p_stereo_mode = 3;
                            continue;
                        }
                        if (val.equals("mono")) {
                            this.p_stereo_mode = 1;
                            continue;
                        }
                        if (val.equals("stereo")) {
                            this.p_stereo_mode = 2;
                            continue;
                        }
                        return false;
                    }
                    if (name.equals("mod") && this.p_program_id == null && this.p_modulation == null && this.p_preset == 0) {
                        if (!val.equals(MODULATION_AM)) {
                            if (!val.equals(MODULATION_FM)) {
                                return false;
                            }
                        }
                        this.p_modulation = val;
                        continue;
                    }
                    if (name.equals("f") && this.p_program_id == null && this.p_preset == 0 && this.p_frequency == 0) {
                        double to_div;
                        double to_mul;
                        if (val.endsWith("M")) {
                            to_mul = 10000.0;
                            to_div = 1.0;
                            val = val.substring(0, val.length() - 1);
                        } else if (val.endsWith("k")) {
                            to_mul = 10.0;
                            to_div = 1.0;
                            val = val.substring(0, val.length() - 1);
                        } else {
                            to_mul = 10.0;
                            to_div = 1000.0;
                        }
                        this.p_frequency = (int)(Double.parseDouble(val) * to_mul / to_div);
                        if (this.p_frequency >= 875000 && this.p_frequency <= 1080000) {
                            f_modulation = MODULATION_FM;
                            continue;
                        }
                        if (this.p_frequency >= 5300 && this.p_frequency <= 17100) {
                            f_modulation = MODULATION_AM;
                            continue;
                        }
                        return false;
                    }
                    if (name.equals("id") && this.p_program_id == null && this.p_modulation == null && this.p_preset == 0 && this.p_frequency == 0) {
                        this.p_frequency = fm_stations[this.nameToIndex(val, fm_names)];
                        this.p_modulation = MODULATION_FM;
                        this.p_program_id = val;
                        continue;
                    }
                    if (name.equals("preset") && this.p_program_id == null && this.p_modulation == null && this.p_preset == 0 && this.p_frequency == 0) {
                        this.p_preset = Integer.parseInt(val);
                        TunerPreset p = (TunerPreset)this.presets.elementAt(this.p_preset - 1);
                        this.p_frequency = p.getFrequency();
                        this.p_modulation = p.getModulation();
                        this.p_stereo_mode = p.getStereoMode();
                        this.p_program_id = p.getName();
                        continue;
                    }
                    return false;
                }
                catch (Exception e) {
                    return false;
                }
            }
            if (f_modulation != null) {
                if (this.p_modulation == null) {
                    this.p_modulation = f_modulation;
                } else if (!this.p_modulation.equals(f_modulation)) {
                    return false;
                }
            }
            if (this.p_stereo_mode == 0) {
                this.p_stereo_mode = 3;
            }
        }
        this.need_startup_play = this.p_frequency != 0;
        return true;
    }

    public String getContentType() {
        this.chkClosed(true);
        return playerContentType;
    }

    private static int getIntegerProperty(String prop) {
        try {
            return Integer.parseInt(config.getProperty(prop));
        }
        catch (Exception e) {
            return -1;
        }
    }

    private static String getStringProperty(String prop) {
        String val = config.getProperty(prop);
        return val == null ? "" : val;
    }

    protected final int freqToIndex(int freq, int[] stations) {
        for (int i = 0; i < stations.length; ++i) {
            if (stations[i] != freq) continue;
            return i;
        }
        return -1;
    }

    private int nameToIndex(String name, String[] names) {
        for (int i = 0; i < names.length; ++i) {
            if (!name.equals(names[i])) continue;
            return i;
        }
        return -1;
    }

    private native int nGetPort();

    private native int nOpenSocket(int var1, String var2, int var3);

    private InputStream openSocket(String url) throws MediaException {
        int port = this.nGetPort();
        if (port > 0) {
            try {
                this.sc = new Protocol();
                this.sc.openPrim(classSecurityToken, "//127.0.0.1:" + port, 1, false);
                this.sc.setSocketOption((byte)0, 1);
                this.radioInStream = this.sc.openInputStream();
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new MediaException("Unable to open socket connection");
            }
        } else {
            throw new MediaException("Unable to get port for socket connection");
        }
        this.nOpenSocket(this.instance, url, 16384);
        return this.radioInStream;
    }

    private native int nCloseSocket(int var1);

    private void closeSocket() {
        try {
            if (this.radioInStream != null) {
                this.radioInStream.close();
                this.radioInStream = null;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (this.sc != null) {
                this.sc.close();
                this.sc = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.nCloseSocket(this.instance);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void switchStation(int freq, int[] stations, String[] urls, boolean needStart) throws MediaException {
        block11: {
            MmapiTuner mmapiTuner = this;
            synchronized (mmapiTuner) {
                this.chkClosed(false);
                if (this.player != null) {
                    this.volumeControl.detachPlayer();
                    this.player.close();
                    this.player = null;
                    this.closeSocket();
                }
            }
            System.gc();
            int idx = this.freqToIndex(freq, stations);
            if (idx != -1) {
                Object buf = null;
                try {
                    MmapiTuner mmapiTuner2 = this;
                    synchronized (mmapiTuner2) {
                        this.player = Manager.createPlayer(this.openSocket(urls[idx]), playerContentType);
                        this.player.setLoopCount(-1);
                        this.volumeControl.attachPlayer(this.player);
                        if (needStart) {
                            this.player.start();
                        }
                        break block11;
                    }
                }
                catch (IOException e) {
                    throw new MediaException("cannot create tuner player");
                }
            }
            throw new MediaException("cannot switch to frequency " + freq);
        }
        System.gc();
    }

    private void initialStation() {
        if (this.need_startup_play) {
            try {
                if (this.p_modulation.equals(MODULATION_FM)) {
                    this.switchStation(this.p_frequency, fm_stations, fm_urls, true);
                } else {
                    this.switchStation(this.p_frequency, am_stations, am_urls, true);
                }
            }
            catch (MediaException mediaException) {
                // empty catch block
            }
            this.need_startup_play = false;
        }
    }

    protected void doRealize() throws MediaException {
        this.initialStation();
        if (this.player != null) {
            this.player.realize();
        }
    }

    protected void doPrefetch() throws MediaException {
        if (this.player != null) {
            this.player.prefetch();
            this.volumeControl.getLevel();
        } else {
            this.volumeControl.setLevelImpl(100);
        }
    }

    protected boolean doStart() {
        try {
            if (this.player != null) {
                this.player.start();
            }
        }
        catch (MediaException e) {
            return false;
        }
        return true;
    }

    protected void doStop() throws MediaException {
        if (this.player != null) {
            this.player.stop();
        }
    }

    protected void doDeallocate() {
        if (this.player != null) {
            this.player.deallocate();
        }
    }

    protected void doClose() {
        if (this.player != null) {
            this.volumeControl.detachPlayer();
            this.player.close();
            this.player = null;
        }
    }

    public long doGetDuration() {
        return -1L;
    }

    protected long doSetMediaTime(long now) throws MediaException {
        throw new MediaException("not supported");
    }

    public long doGetMediaTime() {
        if (this.player != null) {
            return this.player.getMediaTime();
        }
        return 0L;
    }

    protected Control doGetControl(String type) {
        if (type.equals("javax.microedition.media.control.VolumeControl")) {
            return this.volumeControl;
        }
        return null;
    }

    protected final int seekBandUpwards(int[] stations, int startFreq) {
        int frequency = 0;
        for (int i = 0; i < stations.length; ++i) {
            if (stations[i] < startFreq) continue;
            frequency = stations[i];
            break;
        }
        if (frequency == 0 && stations.length > 0 && stations[0] < startFreq) {
            frequency = stations[0];
        }
        return frequency;
    }

    protected final int seekBandDownwards(int[] stations, int startFreq) {
        int frequency = 0;
        for (int i = stations.length - 1; i >= 0; --i) {
            if (stations[i] > startFreq) continue;
            frequency = stations[i];
            break;
        }
        if (frequency == 0 && stations.length > 0 && stations[stations.length - 1] > startFreq) {
            frequency = stations[stations.length - 1];
        }
        return frequency;
    }

    protected final int setFrequency(int freq, int[] stations) {
        int frequency = 0;
        int below = -1;
        int above = -1;
        for (int i = 0; i < stations.length; ++i) {
            if (stations[i] >= freq) {
                if (stations[i] == freq) {
                    frequency = stations[i];
                    break;
                }
                above = stations[i];
                break;
            }
            below = stations[i];
        }
        if (frequency == 0) {
            int d2;
            int d1;
            frequency = below == -1 && above != -1 ? above : (below != -1 && above == -1 ? below : ((d1 = freq - below) < (d2 = above - freq) ? below : above));
        }
        return frequency;
    }

    static {
        int i;
        allCtrls = new String[]{"RecordControl", "VolumeControl"};
        config = Configuration.getConfiguration();
        int size = MmapiTuner.getIntegerProperty("com.sun.tuner.fm.stations");
        fm_stations = new int[size];
        fm_names = new String[size];
        fm_text = new String[size];
        fm_urls = new String[size];
        fm_presets = new int[size];
        for (i = 0; i < size; ++i) {
            MmapiTuner.fm_stations[i] = MmapiTuner.getIntegerProperty("com.sun.tuner.fm.station_" + (i + 1));
            MmapiTuner.fm_names[i] = MmapiTuner.getStringProperty("com.sun.tuner.fm.name_" + (i + 1));
            MmapiTuner.fm_text[i] = MmapiTuner.getStringProperty("com.sun.tuner.fm.text_" + (i + 1));
            MmapiTuner.fm_urls[i] = MmapiTuner.getStringProperty("com.sun.tuner.fm.url_" + (i + 1));
            MmapiTuner.fm_presets[i] = MmapiTuner.getIntegerProperty("com.sun.tuner.fm.preset_" + (i + 1));
        }
        size = MmapiTuner.getIntegerProperty("com.sun.tuner.am.stations");
        am_stations = new int[size];
        am_names = new String[size];
        am_text = new String[size];
        am_urls = new String[size];
        am_presets = new int[size];
        for (i = 0; i < size; ++i) {
            MmapiTuner.am_stations[i] = MmapiTuner.getIntegerProperty("com.sun.tuner.am.station_" + (i + 1));
            MmapiTuner.am_names[i] = MmapiTuner.getStringProperty("com.sun.tuner.am.name_" + (i + 1));
            MmapiTuner.am_text[i] = MmapiTuner.getStringProperty("com.sun.tuner.am.text_" + (i + 1));
            MmapiTuner.am_urls[i] = MmapiTuner.getStringProperty("com.sun.tuner.am.url_" + (i + 1));
            MmapiTuner.am_presets[i] = MmapiTuner.getIntegerProperty("com.sun.tuner.am.preset_" + (i + 1));
        }
    }
}

