/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mmedia;

import com.sun.midp.midlet.MIDletSuite;
import com.sun.midp.midlet.Scheduler;

public final class PermissionAccessor {
    public static final int PERMISSION_SYSTEM = 0;
    public static final int PERMISSION_HTTP_READ = 1;
    public static final int PERMISSION_HTTP_WRITE = 2;
    public static final int PERMISSION_FILE_READ = 3;
    public static final int PERMISSION_FILE_WRITE = 4;
    public static final int PERMISSION_SOCKET_READ = 5;
    public static final int PERMISSION_SOCKET_WRITE = 6;
    public static final int PERMISSION_IMAGE_CAPTURE = 7;
    public static final int PERMISSION_VIDEO_CAPTURE = 8;
    public static final int PERMISSION_AUDIO_CAPTURE = 9;
    public static final int PERMISSION_VIDEO_RECORDING = 10;
    public static final int PERMISSION_AUDIO_RECORDING = 11;
    public static final int PERMISSION_VIDEO_SNAPSHOT = 12;
    public static final int PERMISSION_VIDEO_CAMERA_SHUTTER_FEEDBACK = 13;
    public static final int PERMISSION_RADIO_TUNER_SET_PRESET = 14;
    private static final int[] mapPermissions = new int[]{0, 2, 2, 31, 32, 3, 3, 17, 16, 16, 16, 16, 17, 52, 53};
    private static final String[] locatorTypes = new String[]{"capture://audio", "capture://video", "capture://radio", "capture://", "device://", "file://", "http://"};
    private static final int NEED_NO_PERMISSIONS = 0;
    private static final int FAILED_PERMISSIONS = -1;
    private static final int[] mapLocatorPermissions = new int[]{0, 0, 0, 0, 0, 31, 2};

    public static void checkPermissions(int thePermission) throws SecurityException {
        try {
            int permission = mapPermissions[thePermission];
            MIDletSuite midletSuite = Scheduler.getScheduler().getMIDletSuite();
            midletSuite.checkForPermission(permission, null);
        }
        catch (SecurityException se) {
            throw se;
        }
        catch (InterruptedException e) {
            throw new SecurityException("Interrupted while trying to ask the user permission");
        }
        catch (Exception e) {
            throw new SecurityException("Failed to check user permission");
        }
    }

    public static void checkLocatorPermissions(String locator) throws SecurityException {
        int permission = -1;
        try {
            String locStr = locator.toLowerCase();
            for (int i = 0; i < locatorTypes.length; ++i) {
                if (!locStr.startsWith(locatorTypes[i])) continue;
                permission = mapLocatorPermissions[i];
                if (permission != 0) break;
                return;
            }
            MIDletSuite midletSuite = Scheduler.getScheduler().getMIDletSuite();
            midletSuite.checkForPermission(permission, locStr);
        }
        catch (SecurityException se) {
            throw se;
        }
        catch (InterruptedException ie) {
            throw new SecurityException("Interrupted while trying to ask the user permission");
        }
        catch (Exception e) {
            throw new SecurityException("Failed to check locator permission");
        }
    }

    public static void checkContentTypePermissions(String locator, String contentType) throws SecurityException {
    }
}

