/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mmedia;

import com.sun.mmedia.BasicPlayer;
import com.sun.mmedia.QSoundAudioVirtualizerCtrl;
import com.sun.mmedia.QSoundChorusCtrl;
import com.sun.mmedia.QSoundConnectable;
import com.sun.mmedia.QSoundEffectOrderCtrl;
import com.sun.mmedia.QSoundEqualizerCtrl;
import com.sun.mmedia.QSoundMIDIConnectable;
import com.sun.mmedia.QSoundMIDIOut;
import com.sun.mmedia.QSoundMIDITuple;
import com.sun.mmedia.QSoundPCMOut;
import com.sun.mmedia.QSoundPanCtrl;
import com.sun.mmedia.QSoundReverbSourceCtrl;
import com.sun.mmedia.QSoundVolumeCtrl;
import java.util.Enumeration;
import java.util.Vector;
import javax.microedition.amms.EffectModule;
import javax.microedition.media.Control;
import javax.microedition.media.Controllable;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;

public class QSoundEffectModule
implements EffectModule,
QSoundConnectable,
QSoundMIDIConnectable {
    private int peer;
    private Vector players = new Vector();
    private Control[] controls;
    private static final String[] control_names = new String[]{"javax.microedition.amms.control.audioeffect.ReverbSourceControl", "javax.microedition.amms.control.audioeffect.AudioVirtualizerControl", "javax.microedition.amms.control.audioeffect.ChorusControl", "javax.microedition.amms.control.audioeffect.EqualizerControl", "javax.microedition.media.control.VolumeControl", "javax.microedition.amms.control.PanControl", "javax.microedition.amms.control.EffectOrderControl"};

    private native int nInitEffectModule(int var1);

    private static native int nInitReverbSourceCtrl(int var0);

    private static native int nInitAudioVirtualizerCtrl(int var0);

    private static native int nInitChorusCtrl(int var0);

    private static native int nInitEqualizerCtrl(int var0);

    private static native int nInitVolumeCtrl(int var0);

    private static native int nInitPanCtrl(int var0);

    private static native int nInitEffectOrderCtrl(int var0);

    public QSoundEffectModule(int qp) {
        this.peer = this.nInitEffectModule(qp);
        this.controls = new Control[]{new QSoundReverbSourceCtrl(QSoundEffectModule.nInitReverbSourceCtrl(this.peer)), new QSoundAudioVirtualizerCtrl(QSoundEffectModule.nInitAudioVirtualizerCtrl(this.peer)), new QSoundChorusCtrl(QSoundEffectModule.nInitChorusCtrl(this.peer)), new QSoundEqualizerCtrl(QSoundEffectModule.nInitEqualizerCtrl(this.peer)), new QSoundVolumeCtrl(QSoundEffectModule.nInitVolumeCtrl(this.peer)), new QSoundPanCtrl(QSoundEffectModule.nInitPanCtrl(this.peer)), new QSoundEffectOrderCtrl(QSoundEffectModule.nInitEffectOrderCtrl(this.peer), (Controllable)((Object)this))};
    }

    private native void nAddMIDIPlayer(int var1, int var2, int var3);

    private native void nRemoveMIDIPlayer(int var1, int var2, int var3);

    public void addMIDIChannel(Player player, int channel) throws MediaException {
        if (channel > 15 || channel < 0) {
            throw new IllegalArgumentException("Illegal channel number");
        }
        if (player == null) {
            throw new IllegalArgumentException("null player");
        }
        int s = player.getState();
        if (s == 300 || s == 400) {
            throw new IllegalStateException();
        }
        Enumeration e = this.players.elements();
        while (e.hasMoreElements()) {
            Object o = e.nextElement();
            Player r = (Player)(o instanceof QSoundMIDITuple ? ((QSoundMIDITuple)o).getKey() : o);
            s = r.getState();
            if (s != 300 && s != 400) continue;
            throw new IllegalStateException();
        }
        if (!(player instanceof BasicPlayer)) {
            throw new IllegalArgumentException("Player not recognised");
        }
        BasicPlayer bp = (BasicPlayer)player;
        if (bp.getAudioType() != 2) {
            throw new IllegalArgumentException("Not MIDI Player");
        }
        QSoundMIDITuple tp = new QSoundMIDITuple(bp, channel);
        if (this.players.contains(tp)) {
            throw new IllegalArgumentException("Channel already added");
        }
        Object out = bp.getOutput();
        if (!(out instanceof QSoundMIDIOut)) {
            throw new MediaException();
        }
        QSoundMIDIOut midiStream = (QSoundMIDIOut)out;
        midiStream.impose(this, channel);
        this.players.addElement(tp);
    }

    public void removeMIDIChannel(Player player, int channel) {
        if (player == null) {
            throw new IllegalArgumentException("Invalid player");
        }
        if (channel > 15 || channel < 0) {
            throw new IllegalArgumentException("Illegal channel number");
        }
        int s = player.getState();
        if (s == 300 || s == 400) {
            throw new IllegalStateException();
        }
        Enumeration e = this.players.elements();
        while (e.hasMoreElements()) {
            Object o = e.nextElement();
            Player r = (Player)(o instanceof QSoundMIDITuple ? ((QSoundMIDITuple)o).getKey() : o);
            s = r.getState();
            if (s != 300 && s != 400) continue;
            throw new IllegalStateException();
        }
        BasicPlayer bp = (BasicPlayer)player;
        QSoundMIDITuple tp = new QSoundMIDITuple(bp, channel);
        if (!this.players.contains(tp)) {
            throw new IllegalArgumentException("Channel doesn't exist");
        }
        QSoundMIDIOut midiStream = (QSoundMIDIOut)bp.getOutput();
        midiStream.dispose(this, channel);
        this.players.removeElement(tp);
    }

    private native void nAddPlayer(int var1, int var2);

    private native void nRemovePlayer(int var1, int var2);

    public void addPlayer(Player player) throws MediaException {
        if (player == null) {
            throw new IllegalArgumentException();
        }
        int s = player.getState();
        if (s == 300 || s == 400) {
            throw new IllegalStateException();
        }
        Enumeration e = this.players.elements();
        while (e.hasMoreElements()) {
            Object o = e.nextElement();
            Player r = (Player)(o instanceof QSoundMIDITuple ? ((QSoundMIDITuple)o).getKey() : o);
            if (r == player) {
                throw new IllegalArgumentException();
            }
            s = r.getState();
            if (s != 300 && s != 400) continue;
            throw new IllegalStateException();
        }
        if (!(player instanceof BasicPlayer)) {
            throw new MediaException();
        }
        BasicPlayer bp = (BasicPlayer)player;
        Object out = bp.getOutput();
        int audioType = bp.getAudioType();
        if (audioType == 1) {
            QSoundPCMOut waveStream;
            if (out instanceof QSoundPCMOut) {
                waveStream = (QSoundPCMOut)out;
                waveStream.impose(this);
            } else {
                waveStream = new QSoundPCMOut(this);
            }
            bp.setOutput(waveStream);
        } else if (audioType == 2) {
            if (out instanceof QSoundMIDIOut) {
                QSoundMIDIOut midiStream = (QSoundMIDIOut)out;
                midiStream.impose(this, -1);
            }
        } else {
            throw new MediaException("Unknown type");
        }
        this.players.addElement(bp);
    }

    public void removePlayer(Player player) {
        if (player == null) {
            throw new IllegalArgumentException();
        }
        int s = player.getState();
        if (s == 300 || s == 400) {
            throw new IllegalStateException();
        }
        Vector toBeRemoved = new Vector(this.players.size());
        Enumeration e = this.players.elements();
        while (e.hasMoreElements()) {
            Object o = e.nextElement();
            Player r = (Player)(o instanceof QSoundMIDITuple ? ((QSoundMIDITuple)o).getKey() : o);
            if (r == player) {
                toBeRemoved.addElement(o);
            }
            if ((s = r.getState()) != 300 && s != 400) continue;
            throw new IllegalStateException();
        }
        if (toBeRemoved.isEmpty()) {
            throw new IllegalArgumentException();
        }
        BasicPlayer bp = (BasicPlayer)player;
        int audioType = bp.getAudioType();
        if (audioType == 1) {
            QSoundPCMOut waveStream = (QSoundPCMOut)bp.getOutput();
            waveStream.dispose();
        } else if (audioType == 2) {
            QSoundMIDIOut midiStream = (QSoundMIDIOut)bp.getOutput();
            midiStream.dispose(this);
        }
        e = toBeRemoved.elements();
        while (e.hasMoreElements()) {
            this.players.removeElement(e.nextElement());
        }
    }

    public void connectMIDI(int inStreamPeer, int channel) {
        this.nAddMIDIPlayer(this.peer, inStreamPeer, channel);
    }

    public void disconnectMIDI(int inStreamPeer, int channel) {
        this.nRemoveMIDIPlayer(this.peer, inStreamPeer, channel);
    }

    public void connect(int inStreamPeer) {
        this.nAddPlayer(this.peer, inStreamPeer);
    }

    public void disconnect(int inStreamPeer) {
        this.nRemovePlayer(this.peer, inStreamPeer);
    }

    public Control getControl(String controlType) {
        if (controlType == null) {
            throw new IllegalArgumentException();
        }
        if (this.players.size() == 0) {
            return null;
        }
        String type = controlType.indexOf(46) < 0 ? "javax.microedition.media.control." + controlType : controlType;
        Control control = null;
        for (int i = 0; i < control_names.length; ++i) {
            if (!type.equals(control_names[i])) continue;
            control = this.controls[i];
            break;
        }
        return control;
    }

    public Control[] getControls() {
        return this.players.size() == 0 ? new Control[]{} : this.controls;
    }
}

