/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mmedia;

import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.control.MIDIControl;

public class QSoundMIDICtrl
implements MIDIControl {
    private int peer;
    private Player player;

    public QSoundMIDICtrl(int mc) {
        this.peer = mc;
    }

    public QSoundMIDICtrl(int mc, Player p) {
        this.peer = mc;
        this.player = p;
    }

    private native int nGetBankList(int var1, boolean var2, int[] var3);

    public int[] getBankList(boolean custom) {
        if (this.player != null && this.player.getState() < 300) {
            throw new IllegalStateException();
        }
        int[] bl = new int[200];
        int len = this.nGetBankList(this.peer, custom, bl);
        if (len == -1) {
            throw new IllegalArgumentException();
        }
        int[] rbl = new int[len];
        for (int i = 0; i < len; ++i) {
            rbl[i] = bl[i];
        }
        return rbl;
    }

    private native int nGetChannelVolume(int var1, int var2);

    public int getChannelVolume(int channel) {
        if (this.player != null && this.player.getState() < 300) {
            throw new IllegalStateException();
        }
        int v = this.nGetChannelVolume(this.peer, channel);
        if (v == -2) {
            throw new IllegalArgumentException();
        }
        return v;
    }

    private native int nGetKeyName(int var1, int var2, int var3, int var4, byte[] var5);

    public String getKeyName(int bank, int prog, int key) throws MediaException {
        if (this.player != null && this.player.getState() < 300) {
            throw new IllegalStateException();
        }
        byte[] st = new byte[50];
        int len = this.nGetKeyName(this.peer, bank, prog, key, st);
        if (len == -2) {
            throw new MediaException();
        }
        if (len == -1) {
            throw new IllegalArgumentException();
        }
        return new String(st, 0, len);
    }

    private native boolean nGetProgram(int var1, int var2, int[] var3);

    public int[] getProgram(int channel) {
        if (this.player != null && this.player.getState() < 300) {
            throw new IllegalStateException();
        }
        int[] program = new int[2];
        if (!this.nGetProgram(this.peer, channel, program)) {
            throw new IllegalArgumentException();
        }
        return program;
    }

    private native int nGetProgramList(int var1, int var2, int[] var3);

    public int[] getProgramList(int bank) {
        if (this.player != null && this.player.getState() < 300) {
            throw new IllegalStateException();
        }
        int[] pl = new int[200];
        int len = this.nGetProgramList(this.peer, bank, pl);
        if (len == -1) {
            throw new IllegalArgumentException();
        }
        int[] rpl = new int[len];
        for (int i = 0; i < len; ++i) {
            rpl[i] = pl[i];
        }
        return rpl;
    }

    private native int nGetProgramName(int var1, int var2, int var3, byte[] var4);

    public String getProgramName(int bank, int prog) throws MediaException {
        if (this.player != null && this.player.getState() < 300) {
            throw new IllegalStateException();
        }
        byte[] st = new byte[50];
        int len = this.nGetProgramName(this.peer, bank, prog, st);
        if (len == -2) {
            throw new MediaException();
        }
        if (len == -1) {
            throw new IllegalArgumentException();
        }
        return new String(st, 0, len);
    }

    private native boolean nIsBankQuerySupported(int var1);

    public boolean isBankQuerySupported() {
        return this.nIsBankQuerySupported(this.peer);
    }

    private native int nLongMidiEvent(int var1, byte[] var2, int var3, int var4);

    public int longMidiEvent(byte[] data, int offset, int length) {
        if (this.player != null && this.player.getState() < 300) {
            throw new IllegalStateException();
        }
        int l = this.nLongMidiEvent(this.peer, data, offset, length);
        if (l == -2) {
            throw new IllegalArgumentException();
        }
        return l;
    }

    private native boolean nSetChannelVolume(int var1, int var2, int var3);

    public void setChannelVolume(int channel, int volume) {
        if (this.player != null && this.player.getState() < 300) {
            throw new IllegalStateException();
        }
        int tries = 5;
        boolean noError = true;
        while (tries-- > 0 && (noError = this.nSetChannelVolume(this.peer, channel, volume)) && this.getChannelVolume(channel) != volume) {
            try {
                Thread.sleep(20L);
            }
            catch (Exception e) {}
        }
        if (!noError) {
            throw new IllegalArgumentException();
        }
    }

    private native boolean nSetProgram(int var1, int var2, int var3, int var4);

    public void setProgram(int channel, int bank, int program) {
        if (this.player != null && this.player.getState() < 300) {
            throw new IllegalStateException();
        }
        if (!this.nSetProgram(this.peer, channel, bank, program)) {
            throw new IllegalArgumentException();
        }
        try {
            Thread.sleep(15L);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    private native boolean nShortMidiEvent(int var1, int var2, int var3, int var4);

    public void shortMidiEvent(int type, int data1, int data2) {
        if (this.player != null && this.player.getState() < 300) {
            throw new IllegalStateException();
        }
        if (!this.nShortMidiEvent(this.peer, type, data1, data2)) {
            throw new IllegalArgumentException();
        }
        try {
            Thread.sleep(15L);
        }
        catch (Exception e) {
            // empty catch block
        }
    }
}

