/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mmedia;

import com.sun.mmedia.QSoundHiddenManager;
import com.sun.mmedia.QSoundMIDICtrl;
import com.sun.mmedia.QSoundMetaDataCtrl;
import com.sun.mmedia.QSoundPitchCtrl;
import com.sun.mmedia.QSoundRateCtrl;
import com.sun.mmedia.QSoundTempoCtrl;
import com.sun.mmedia.QSoundVolumeCtrl;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.control.MIDIControl;
import javax.microedition.media.control.MetaDataControl;
import javax.microedition.media.control.PitchControl;
import javax.microedition.media.control.RateControl;
import javax.microedition.media.control.StopTimeControl;
import javax.microedition.media.control.TempoControl;
import javax.microedition.media.control.VolumeControl;

class QSoundMIDIPlayControl {
    private int qsMIDI;
    private int globMan = QSoundHiddenManager.getMIDIGlobalPeer();
    private Player player;
    private int loopCount;
    private int currentLoopCount;
    private int lastLoopCount;
    private QSoundVolumeCtrl vc;
    private QSoundMIDICtrl mc;
    private QSoundPitchCtrl pc;
    private QSoundRateCtrl rc;
    private QSoundTempoCtrl tc;
    private QSoundMetaDataCtrl dc;
    private boolean opened;

    private native int nOpen(int var1);

    private native void nClose(int var1, int var2);

    private native boolean nFillBuffer(int var1, int var2, byte[] var3);

    private native void nDeallocateBuffer(int var1);

    private native void nStart(int var1);

    private native void nStop(int var1);

    private native boolean nIsDone(int var1);

    private native int nLoopsDone(int var1);

    private native int nSetPosition(int var1, int var2);

    private native int nGetPosition(int var1);

    private native int nGetDuration(int var1);

    private native void nSetLoopCount(int var1, int var2);

    private static native int nInitVolumeCtrl(int var0);

    private static native int nInitMIDICtrl(int var0);

    private static native int nInitPitchCtrl(int var0);

    private static native int nInitRateCtrl(int var0);

    private static native int nInitTempoCtrl(int var0);

    private static native int nInitMetaDataCtrl(int var0);

    QSoundMIDIPlayControl() {
        this.opened = false;
    }

    QSoundMIDIPlayControl(Player p) {
        this.player = p;
        this.opened = false;
    }

    boolean open() {
        return this.open(false);
    }

    boolean open(boolean forceOpen) {
        if (this.opened && !forceOpen) {
            return this.opened;
        }
        this.qsMIDI = this.nOpen(this.globMan);
        this.vc = new QSoundVolumeCtrl(QSoundMIDIPlayControl.nInitVolumeCtrl(this.qsMIDI), this.player);
        this.mc = new QSoundMIDICtrl(QSoundMIDIPlayControl.nInitMIDICtrl(this.qsMIDI), this.player);
        this.pc = new QSoundPitchCtrl(QSoundMIDIPlayControl.nInitPitchCtrl(this.qsMIDI));
        this.rc = new QSoundRateCtrl(QSoundMIDIPlayControl.nInitRateCtrl(this.qsMIDI));
        this.tc = new QSoundTempoCtrl(QSoundMIDIPlayControl.nInitTempoCtrl(this.qsMIDI));
        this.dc = new QSoundMetaDataCtrl(QSoundMIDIPlayControl.nInitMetaDataCtrl(this.qsMIDI));
        this.opened = true;
        return this.opened;
    }

    void close() {
        this.nDeallocateBuffer(this.qsMIDI);
        this.nClose(this.globMan, this.qsMIDI);
        this.qsMIDI = 0;
    }

    boolean fillBuffer(byte[] b) {
        boolean r = this.nFillBuffer(this.globMan, this.qsMIDI, b);
        if (r && this.loopCount != 0) {
            this.nSetLoopCount(this.qsMIDI, this.loopCount);
        }
        return r;
    }

    void start() {
        this.lastLoopCount = this.loopCount == -1 ? 0 : this.loopCount;
        this.nStart(this.qsMIDI);
    }

    void stop() {
        this.nStop(this.qsMIDI);
    }

    boolean isDone() {
        boolean r = this.nIsDone(this.qsMIDI);
        if (!r && this.loopCount != 0) {
            this.currentLoopCount = this.nLoopsDone(this.qsMIDI);
        }
        return r;
    }

    long setMediaTime(long now) throws MediaException {
        if (this.qsMIDI == 0) {
            return 0L;
        }
        int pos = this.nSetPosition(this.qsMIDI, (int)now / 100);
        return (long)pos * 100L;
    }

    long getMediaTime() {
        if (this.qsMIDI == 0) {
            return -1L;
        }
        return (long)this.nGetPosition(this.qsMIDI) * 100L;
    }

    long getDuration() {
        if (this.qsMIDI == 0) {
            return -1L;
        }
        return (long)this.nGetDuration(this.qsMIDI) * 100L;
    }

    void setLoopCount(int count) {
        this.loopCount = count;
        this.nSetLoopCount(this.qsMIDI, this.loopCount);
    }

    int numLoopComplete() {
        int numLoops = this.currentLoopCount - this.lastLoopCount;
        this.lastLoopCount = this.currentLoopCount;
        return numLoops;
    }

    StopTimeControl getStopTimeControl(StopTimeControl tc) {
        return tc;
    }

    VolumeControl getVolumeControl() {
        return this.vc;
    }

    MIDIControl getMIDIControl() {
        return this.mc;
    }

    PitchControl getPitchControl() {
        return this.pc;
    }

    RateControl getRateControl() {
        return this.rc;
    }

    TempoControl getTempoControl() {
        return this.tc;
    }

    MetaDataControl getMetaDataControl() {
        return this.dc;
    }

    int peer() {
        return this.qsMIDI;
    }
}

