/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mmedia;

import com.sun.mmedia.BasicAudioOut;
import com.sun.mmedia.QSoundConnectable;
import com.sun.mmedia.QSoundHiddenManager;
import com.sun.mmedia.QSoundVolumeCtrl;

public class QSoundPCMOut
implements BasicAudioOut,
QSoundConnectable {
    private int peer = 0;
    private int em_peer = QSoundPCMOut.nInitEffectModule(QSoundHiddenManager.getGlobalPeer());
    private QSoundConnectable qc;
    private long bytesPerMilliSecond = 0L;
    private long byteCount = 0L;
    private QSoundVolumeCtrl vc = new QSoundVolumeCtrl(QSoundPCMOut.nInitVolumeCtrl(this.em_peer));

    private static native int nInitEffectModule(int var0);

    private static native int nInitVolumeCtrl(int var0);

    private native int nOpen(int var1, int var2, int var3);

    private native int nClose(int var1);

    private native int nWrite(int var1, int var2, int var3, byte[] var4);

    private native int nCommon(int var1, int var2, int var3);

    public QSoundPCMOut() {
        this.qc = this;
    }

    QSoundPCMOut(QSoundConnectable con) {
        this.qc = con;
    }

    public boolean open(int sampleRate, int bits, int channels) {
        return this.open(sampleRate, bits, channels, false, false);
    }

    public boolean open(int sampleRate, int bits, int channels, boolean signed, boolean bigEndian) {
        this.peer = this.nOpen(sampleRate, bits, channels);
        this.bytesPerMilliSecond = sampleRate * (bits >> 3) * channels / 1000;
        if (this.peer != 0) {
            this.qc.connect(this.peer);
        }
        return this.peer != 0;
    }

    public int write(byte[] data, int offset, int len) {
        this.byteCount += (long)data.length;
        return this.nWrite(this.peer, offset, len, data);
    }

    public void pause() {
    }

    public void resume() {
    }

    public void flush() {
        this.byteCount = 0L;
    }

    public int drain() {
        return -1;
    }

    public void drainLoop() {
    }

    public synchronized void close() {
        this.qc.disconnect(this.peer);
        this.qc = null;
        this.nClose(this.peer);
        this.peer = 0;
    }

    void impose(QSoundConnectable qcon) {
        if (this.peer != 0) {
            this.qc.disconnect(this.peer);
        }
        this.qc = qcon;
        if (this.peer != 0) {
            this.qc.connect(this.peer);
        }
    }

    void dispose() {
        if (this.peer != 0) {
            this.qc.disconnect(this.peer);
        }
        this.qc = this;
        if (this.peer != 0) {
            this.qc.connect(this.peer);
        }
    }

    public synchronized long getSamplesPlayed() {
        return 0L;
    }

    public void setVolume(int level) {
        this.vc.setLevel(level);
    }

    public int getVolume() {
        return this.vc.getLevel();
    }

    public synchronized long getMediaTime() {
        long millSecs = this.byteCount / this.bytesPerMilliSecond;
        return millSecs;
    }

    public synchronized void setMediaTime(long mediaTime) {
    }

    public void setRate(int rate) {
        if (this.peer == 0) {
            return;
        }
        this.nCommon(this.peer, 17, rate);
    }

    private native void nAddPlayer(int var1, int var2);

    private native void nRemovePlayer(int var1, int var2);

    public void connect(int inStreamPeer) {
        this.nAddPlayer(this.em_peer, inStreamPeer);
    }

    public void disconnect(int inStreamPeer) {
        this.nRemovePlayer(this.em_peer, inStreamPeer);
    }
}

