/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mmedia;

import com.sun.mmedia.BasicPlayer;
import com.sun.mmedia.QSoundMIDIConnectable;
import com.sun.mmedia.QSoundMIDIOut;
import com.sun.mmedia.QSoundMIDIPlayControl;
import com.sun.mmedia.QSoundMIDITuple;
import com.sun.mmedia.QSoundToneCtrl;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import javax.microedition.media.Control;
import javax.microedition.media.MediaException;
import javax.microedition.media.control.StopTimeControl;

public class QSoundToneSequencePlayer
extends BasicPlayer
implements Runnable,
QSoundMIDIOut,
StopTimeControl {
    private QSoundMIDIPlayControl qsmc;
    private Object playLock = new Object();
    private Thread playThread;
    private boolean stopped;
    private QSoundMIDIConnectable qmc;
    private Vector channels;
    private QSoundToneCtrl tctrl;
    private final int bufferSize;

    public QSoundToneSequencePlayer() {
        this.bufferSize = 2048;
        this.qsmc = new QSoundMIDIPlayControl(this);
        this.channels = new Vector(10);
        this.hasDataSource = false;
        this.tctrl = new QSoundToneCtrl(this);
    }

    protected void doRealize() throws MediaException {
        this.qsmc.open();
        this.stopped = true;
        Enumeration e = this.channels.elements();
        int p = this.qsmc.peer();
        while (e.hasMoreElements()) {
            QSoundMIDITuple mt = (QSoundMIDITuple)e.nextElement();
            ((QSoundMIDIConnectable)mt.getKey()).connectMIDI(p, mt.getChannel());
        }
        if (this.source != null) {
            byte[] b = new byte[2048];
            ByteArrayOutputStream baos = new ByteArrayOutputStream(2048);
            try {
                int count;
                if (this.stream.tell() > 0L) {
                    this.stream.seek(0L);
                }
                while ((count = this.stream.read(b, 0, 2048)) > 0) {
                    baos.write(b, 0, count);
                }
                boolean r = this.qsmc.fillBuffer(baos.toByteArray());
                baos.close();
                if (!r) {
                    throw new MediaException("Bad Tone Format");
                }
            }
            catch (IOException ioe) {
                throw new MediaException("Failure occured with read stream");
            }
            baos = null;
        }
    }

    protected void doPrefetch() throws MediaException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean doStart() {
        if (!this.stopped) {
            try {
                this.doStop();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.stopped = false;
        Object object = this.playLock;
        synchronized (object) {
            this.playThread = new Thread(this);
            this.playThread.start();
            try {
                this.playLock.wait();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStop() throws MediaException {
        this.qsmc.stop();
        this.stopped = true;
        Object object = this.playLock;
        synchronized (object) {
            try {
                this.playThread.join();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected void doDeallocate() {
    }

    protected void doClose() {
        if (this.state != 100) {
            if (!this.stopped) {
                try {
                    this.doStop();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            Enumeration e = this.channels.elements();
            int p = this.qsmc.peer();
            while (e.hasMoreElements()) {
                QSoundMIDITuple mt = (QSoundMIDITuple)e.nextElement();
                ((QSoundMIDIConnectable)mt.getKey()).disconnectMIDI(p, mt.getChannel());
            }
            this.qsmc.close();
            this.channels.removeAllElements();
            this.channels = null;
            this.qsmc = null;
        }
    }

    protected long doSetMediaTime(long now) throws MediaException {
        return this.qsmc.setMediaTime(now);
    }

    protected long doGetMediaTime() {
        return this.qsmc.getMediaTime();
    }

    protected long doGetDuration() {
        return this.qsmc.getDuration();
    }

    protected Control doGetControl(String controlType) {
        if (this.getState() != 100 && controlType.startsWith("javax.microedition.media.control.")) {
            if ((controlType = controlType.substring("javax.microedition.media.control.".length())).equals("VolumeControl")) {
                return this.qsmc.getVolumeControl();
            }
            if (controlType.equals("StopTimeControl")) {
                return this.qsmc.getStopTimeControl(this);
            }
            if (controlType.equals("ToneControl")) {
                return this.tctrl;
            }
            if (controlType.equals("MIDIControl")) {
                return this.qsmc.getMIDIControl();
            }
            if (controlType.equals("PitchControl")) {
                return this.qsmc.getPitchControl();
            }
            if (controlType.equals("RateControl")) {
                return this.qsmc.getRateControl();
            }
            if (controlType.equals("TempoControl")) {
                return this.qsmc.getTempoControl();
            }
        }
        return null;
    }

    void doNextLoopIteration() {
    }

    protected void doSetLoopCount(int count) {
        this.qsmc.setLoopCount(count);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.qsmc.start();
        Object object = this.playLock;
        synchronized (object) {
            this.playLock.notify();
        }
        boolean done = false;
        boolean stoppedAtTime = false;
        int numLoopComplete = 0;
        while (!this.stopped) {
            try {
                Thread.sleep(500L);
            }
            catch (Exception e) {
                // empty catch block
            }
            done = this.qsmc.isDone();
            if (!done && (numLoopComplete = this.qsmc.numLoopComplete()) > 0) {
                Long medt = new Long(this.qsmc.getMediaTime());
                while (numLoopComplete-- > 0) {
                    this.sendEvent("endOfMedia", medt);
                }
            }
            boolean bl = stoppedAtTime = this.stopTime != Long.MAX_VALUE && this.stopTime < this.doGetMediaTime();
            if (!done && !stoppedAtTime) continue;
            this.stopped = true;
        }
        if (done) {
            this.sendEvent("endOfMedia", new Long(this.qsmc.getMediaTime()));
        } else if (stoppedAtTime) {
            this.qsmc.stop();
            this.satev();
        }
    }

    public boolean impose(QSoundMIDIConnectable qcon, int ch) {
        QSoundMIDITuple mt = new QSoundMIDITuple(qcon, ch);
        if (this.channels.contains(mt)) {
            return false;
        }
        this.channels.addElement(mt);
        if (this.state != 100) {
            qcon.connectMIDI(this.qsmc.peer(), ch);
        }
        return true;
    }

    public boolean dispose(QSoundMIDIConnectable qcon) {
        int l;
        if (this.qsmc == null) {
            return true;
        }
        int p = this.qsmc.peer();
        if (p == 0) {
            return true;
        }
        QSoundMIDITuple tmptuple = new QSoundMIDITuple(qcon, -1);
        while ((l = this.channels.lastIndexOf(tmptuple)) >= 0) {
            QSoundMIDITuple mt = (QSoundMIDITuple)this.channels.elementAt(l);
            ((QSoundMIDIConnectable)mt.getKey()).disconnectMIDI(p, mt.getChannel());
            this.channels.removeElement(mt);
        }
        return true;
    }

    public boolean dispose(QSoundMIDIConnectable qcon, int ch) {
        int l;
        if (this.qsmc == null) {
            return true;
        }
        int p = this.qsmc.peer();
        if (p == 0) {
            return true;
        }
        QSoundMIDITuple tmptuple = new QSoundMIDITuple(qcon, ch);
        while ((l = this.channels.lastIndexOf(tmptuple)) >= 0) {
            QSoundMIDITuple mt = (QSoundMIDITuple)this.channels.elementAt(l);
            ((QSoundMIDIConnectable)mt.getKey()).disconnectMIDI(p, mt.getChannel());
            this.channels.removeElement(mt);
        }
        return true;
    }

    public int getAudioType() {
        return 2;
    }

    public Object getOutput() {
        return this;
    }

    boolean setSequence(byte[] seq) throws IllegalArgumentException {
        this.source = null;
        if (this.state == 100) {
            this.qsmc.open();
        }
        return this.qsmc.fillBuffer(seq);
    }

    public String getContentType() {
        this.chkClosed(true);
        return this.source != null ? this.source.getContentType() : "audio/x-tone-seq";
    }

    public boolean equals(Object o) {
        if (o instanceof QSoundMIDITuple) {
            QSoundMIDITuple t = (QSoundMIDITuple)o;
            return this.channels.contains(t);
        }
        return super.equals(o);
    }
}

