/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mmedia;

import com.sun.mmedia.RecordCtrl;
import com.sun.mmedia.WavPlayer;
import java.io.IOException;

public final class WavRecordCtrl
extends RecordCtrl {
    private byte[] header;

    public WavRecordCtrl() {
    }

    public WavRecordCtrl(WavPlayer p) {
        this.player = p;
        this.headerSize = 44;
    }

    public final String getContentType() {
        return "audio/x-wav";
    }

    protected final byte[] getHeader(int dataSize) throws IOException {
        WavPlayer wPlayer = (WavPlayer)this.player;
        int channels = wPlayer.channels;
        int sampleRate = wPlayer.sampleRate;
        int sampleSizeInBits = wPlayer.sampleSizeInBits;
        if (this.header == null || this.header.length < 44) {
            this.header = new byte[44];
        }
        int avBytesPerSec = channels * sampleRate * (sampleSizeInBits / 8);
        int blockAlign = sampleSizeInBits / 8 * channels;
        int offset = 0;
        WavRecordCtrl.writeInt(this.header, 1179011410, offset, false);
        WavRecordCtrl.writeInt(this.header, dataSize + 36, offset += 4, false);
        WavRecordCtrl.writeInt(this.header, 1163280727, offset += 4, false);
        WavRecordCtrl.writeInt(this.header, 544501094, offset += 4, false);
        WavRecordCtrl.writeInt(this.header, 16, offset += 4, false);
        WavRecordCtrl.writeShort(this.header, 1, offset += 4, false);
        WavRecordCtrl.writeShort(this.header, (short)channels, offset += 2, false);
        WavRecordCtrl.writeInt(this.header, sampleRate, offset += 2, false);
        WavRecordCtrl.writeInt(this.header, avBytesPerSec, offset += 4, false);
        WavRecordCtrl.writeShort(this.header, blockAlign, offset += 4, false);
        WavRecordCtrl.writeShort(this.header, sampleSizeInBits, offset += 2, false);
        WavRecordCtrl.writeInt(this.header, 1635017060, offset += 2, false);
        WavRecordCtrl.writeInt(this.header, dataSize, offset += 4, false);
        return this.header;
    }
}

