/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mmedia.protocol;

import com.sun.midp.io.j2me.http.Protocol;
import com.sun.midp.security.ImplicitlyTrustedClass;
import com.sun.midp.security.SecurityToken;
import com.sun.mmedia.Configuration;
import com.sun.mmedia.protocol.BasicDS;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.media.MediaException;
import javax.microedition.media.protocol.ContentDescriptor;
import javax.microedition.media.protocol.SourceStream;

public class CommonDS
extends BasicDS
implements SourceStream,
ImplicitlyTrustedClass {
    private static SecurityToken classSecurityToken;
    private long contentLength = -1L;
    private InputStream inputStream;
    private long location;
    private static final int BUFLEN = 512;
    private static byte[] buf;

    public final void initSecurityToken(SecurityToken token) {
        if (classSecurityToken != null) {
            return;
        }
        classSecurityToken = token;
    }

    public void setLocator(String ml) throws MediaException {
        super.setLocator(CommonDS.urlCvrt(ml));
    }

    public void setInputStream(InputStream is) {
        this.connected = true;
        try {
            super.setLocator(null);
        }
        catch (MediaException e) {
            // empty catch block
        }
        this.inputStream = is;
        try {
            is.mark(is.available());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.contentLength = -1L;
    }

    public void connect() throws IOException {
        if (this.connected) {
            return;
        }
        this.getConnection();
        this.connected = true;
    }

    void getConnection() throws IOException {
        boolean goodurl = false;
        if (this.locator == null) {
            throw new IOException(this + ": connect() failed");
        }
        this.contentType = null;
        String fileName = CommonDS.getRemainder(this.locator);
        if (fileName == null) {
            throw new IOException("bad url");
        }
        int i = fileName.lastIndexOf(46);
        if (i != -1) {
            String ext = fileName.substring(i + 1).toLowerCase();
            this.contentType = Configuration.getConfiguration().ext2Mime(ext);
        }
        try {
            if (this.locator.toLowerCase().startsWith("http:")) {
                Protocol httpCon = new Protocol();
                httpCon.openPrim(classSecurityToken, this.locator.substring("http:".length()));
                int rescode = httpCon.getResponseCode();
                if (rescode >= 400) {
                    httpCon.close();
                    goodurl = false;
                } else {
                    this.inputStream = httpCon.openInputStream();
                    this.contentLength = httpCon.getLength();
                    String ct = httpCon.getType().toLowerCase();
                    if (this.contentType == null) {
                        this.contentType = Configuration.getConfiguration().ext2Mime(ct);
                    }
                    httpCon.close();
                    goodurl = true;
                }
            } else if (this.locator.startsWith("file:")) {
                com.sun.midp.io.j2me.file.Protocol fileCon = new com.sun.midp.io.j2me.file.Protocol();
                fileCon.openPrim(classSecurityToken, this.locator.substring("file:".length()));
                if (fileCon.exists(classSecurityToken) && !fileCon.isDirectory(classSecurityToken) && fileCon.canRead(classSecurityToken)) {
                    this.inputStream = fileCon.openInputStream(classSecurityToken);
                    this.contentLength = fileCon.fileSize(classSecurityToken);
                    fileCon.close();
                    goodurl = true;
                } else {
                    fileCon.close();
                    goodurl = false;
                }
            } else if (this.locator.equals("device://tone") || this.locator.equals("device://midi") || this.locator.equals("capture://video")) {
                this.inputStream = null;
                this.contentLength = -1L;
                goodurl = true;
            }
        }
        catch (Exception ex) {
            throw new IOException("failed to connect" + ex.getMessage());
        }
        if (!goodurl) {
            throw new IOException("bad url");
        }
    }

    public synchronized void disconnect() {
        if (!this.connected) {
            return;
        }
        this.close();
        this.connected = false;
    }

    public void start() throws IOException {
    }

    public void stop() {
    }

    public SourceStream[] getStreams() {
        return new SourceStream[]{this};
    }

    public long getDuration() {
        return -1L;
    }

    public ContentDescriptor getContentDescriptor() {
        return null;
    }

    public int getTransferSize() {
        return -1;
    }

    public int read(byte[] buffer, int offset, int length) throws IOException {
        int len = length;
        int off = offset;
        do {
            int bytesRead;
            if ((bytesRead = this.inputStream.read(buffer, off, len)) == -1) {
                int totalBytesRead = length - len;
                return totalBytesRead > 0 ? totalBytesRead : -1;
            }
            this.location += (long)bytesRead;
            off += bytesRead;
            if ((len -= bytesRead) == 0) continue;
            Thread.yield();
        } while (len != 0);
        return length;
    }

    public long seek(long where) throws IOException {
        int seekable = this.getSeekType();
        if (seekable == 0) {
            throw new IOException("can't seek");
        }
        if (where < 0L) {
            where = 0L;
        }
        if (seekable == 1 && where != 0L) {
            throw new IOException("can't seek");
        }
        if (this.contentLength > 0L && where > this.contentLength) {
            where = this.contentLength;
        }
        long oldLocation = this.location;
        long skipped = 0L;
        if (where < oldLocation) {
            this.reopenStream();
            this.location = this.skip(this.inputStream, where);
        } else {
            skipped = this.skip(this.inputStream, where - oldLocation);
            this.location = oldLocation + skipped;
        }
        return this.location;
    }

    private void reopenStream() throws IOException {
        try {
            this.inputStream.reset();
            return;
        }
        catch (IOException ex) {
            if (this.getLocator() == null) {
                throw ex;
            }
            if (this.inputStream != null) {
                this.inputStream.close();
                this.inputStream = null;
            }
            this.getConnection();
            return;
        }
    }

    public long tell() {
        return this.location;
    }

    public synchronized void close() {
        if (this.inputStream == null) {
            return;
        }
        try {
            this.inputStream.close();
            this.inputStream = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public long getContentLength() {
        return this.contentLength;
    }

    private long skip(InputStream istream, long amount) throws IOException {
        long remaining = amount;
        if (buf == null) {
            buf = new byte[512];
        }
        while (remaining > 0L) {
            int actual = (int)(remaining > 512L ? 512L : remaining);
            if ((actual = istream.read(buf, 0, actual)) == 0) break;
            remaining -= (long)actual;
        }
        return amount - remaining;
    }

    public int getSeekType() {
        return 2;
    }

    private static String getRemainder(String loc) {
        String proto = "";
        int idx = loc.indexOf(58);
        if (idx != -1) {
            proto = loc.substring(idx + 1);
        }
        return proto;
    }

    public static String urlCvrt(String theml) {
        String proto = CommonDS.getProtocol(theml);
        String ret = theml;
        if (proto != null && proto.equals("file")) {
            String file = CommonDS.getRemainder(theml);
            boolean changed = false;
            if (file == null) {
                return theml;
            }
            try {
                int idx = 0;
                while ((idx = file.indexOf("%", idx)) >= 0) {
                    if (file.length() > idx + 2) {
                        byte[] bytes = new byte[1];
                        try {
                            bytes[0] = (byte)Integer.valueOf(file.substring(idx + 1, idx + 3), 16).intValue();
                            file = file.substring(0, idx) + new String(bytes) + file.substring(idx + 3);
                            changed = true;
                        }
                        catch (NumberFormatException ne) {
                            // empty catch block
                        }
                    }
                    ++idx;
                }
                if (changed) {
                    ret = proto + ":" + file;
                }
            }
            catch (Exception e) {
                ret = theml;
            }
        }
        return ret;
    }

    static {
        buf = null;
    }
}

