/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mmedia.protocol;

import com.sun.mmedia.protocol.BasicDS;
import com.sun.mmedia.protocol.LocatorParser;
import java.io.IOException;
import javax.microedition.media.MediaException;
import javax.microedition.media.protocol.ContentDescriptor;
import javax.microedition.media.protocol.SourceStream;

public class WavCapture
extends BasicDS
implements SourceStream {
    private int sampleRate = 8000;
    private int sampleSize = 16;
    private int channels = 1;
    private int endian;
    private int signedvalue;
    private int peer;
    private long bytesRead;
    private byte[] hdr = new byte[44];
    private int hdrSize;
    private int hdrOfs;

    public WavCapture() {
        this.contentType = "audio/x-wav";
    }

    public void setLocator(String locator) throws MediaException {
        String key = null;
        String value = null;
        try {
            LocatorParser lp;
            block21: {
                block20: {
                    lp = new LocatorParser(locator.toLowerCase());
                    if (!lp.getProtocol().equals("capture")) break block20;
                    if (lp.getDevice().equals("audio")) break block21;
                }
                throw new MediaException("Illegal locator " + locator);
            }
            while ((key = lp.getParameter()) != null) {
                value = lp.getValue();
                if (key.equals("encoding")) {
                    if (value.equals("pcm")) continue;
                    throw new MediaException("Only pcm encoding is supported");
                }
                if (key.equals("rate")) {
                    this.sampleRate = Integer.parseInt(value);
                    continue;
                }
                if (key.equals("bits")) {
                    this.sampleSize = Integer.parseInt(value);
                    continue;
                }
                if (key.equals("channels")) {
                    this.channels = Integer.parseInt(value);
                    continue;
                }
                if (key.equals("endian")) {
                    if (value.equals("little")) {
                        this.endian = 1;
                        continue;
                    }
                    if (value.equals("big")) {
                        this.endian = 2;
                        continue;
                    }
                    throw new MediaException("Illegal value for endian " + value);
                }
                if (key.equals("signed")) {
                    if (value.equals("signed")) {
                        this.signedvalue = 1;
                        continue;
                    }
                    if (value.equals("unsigned")) {
                        this.signedvalue = 2;
                        continue;
                    }
                    throw new MediaException("Illegal value for signed " + value);
                }
                throw new MediaException("Illegal key/value pair " + key + " : " + value);
            }
            if (lp.hasMore()) {
                throw new MediaException("Malformed locator. Parameters should be specified in <key>=<value> format");
            }
        }
        catch (MediaException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MediaException("Illegal value for parameter " + key + " : " + value);
        }
        if (this.channels > 2 || this.channels < 1 || this.sampleSize != 8 && this.sampleSize != 16 || this.sampleSize == 8 && this.signedvalue == 1 || this.sampleSize == 16 && (this.signedvalue == 2 || this.endian == 2)) {
            throw new MediaException("Requested format is not supported " + locator);
        }
        this.locator = locator;
    }

    void getConnection() throws IOException {
        this.peer = this.nOpen(this.sampleRate, this.sampleSize, this.channels, 6);
        if (this.peer == 0) {
            throw new IOException("Couldn't open audio input");
        }
        this.createHeader(this.sampleRate, this.sampleSize, this.channels);
    }

    public void close() {
        this.stop();
        if (this.peer != 0) {
            this.nCommand(this.peer, 3, 0);
            this.peer = 0;
        }
    }

    public void start() throws IOException {
        if (this.nCommand(this.peer, 1, 0) == 0) {
            throw new IOException("Couldn't start audio input");
        }
    }

    public void stop() {
        this.nCommand(this.peer, 2, 0);
    }

    public void connect() throws IOException {
        this.getConnection();
    }

    public synchronized void disconnect() {
        this.close();
    }

    public SourceStream[] getStreams() {
        return new SourceStream[]{this};
    }

    public ContentDescriptor getContentDescriptor() {
        return new ContentDescriptor(this.getContentType());
    }

    public long getContentLength() {
        return -1L;
    }

    public int read(byte[] buffer, int offset, int length) throws IOException {
        if (this.hdrSize > 0) {
            int toCopy = this.hdrSize;
            if (length < toCopy) {
                toCopy = length;
            }
            System.arraycopy(this.hdr, this.hdrOfs, buffer, offset, toCopy);
            this.hdrSize -= toCopy;
            this.hdrOfs += toCopy;
            return toCopy;
        }
        int got = this.nRead(this.peer, buffer, offset, length);
        this.bytesRead += (long)got;
        while (got == 0) {
            try {
                Thread.sleep(16L);
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
            got = this.nRead(this.peer, buffer, offset, length);
            this.bytesRead += (long)got;
        }
        return got;
    }

    public long seek(long where) throws IOException {
        throw new IOException("Cannot seek");
    }

    public long tell() {
        return this.bytesRead;
    }

    public int getSeekType() {
        return 0;
    }

    public int getTransferSize() {
        return 8 * (this.sampleSize * this.sampleRate * this.channels / 8 / 64);
    }

    private native int nOpen(int var1, int var2, int var3, int var4);

    private native int nCommand(int var1, int var2, int var3);

    private native int nRead(int var1, byte[] var2, int var3, int var4);

    private void writeInt(int value) {
        this.hdr[this.hdrSize++] = (byte)(value & 0xFF);
        this.hdr[this.hdrSize++] = (byte)(value >>> 8 & 0xFF);
        this.hdr[this.hdrSize++] = (byte)(value >>> 16 & 0xFF);
        this.hdr[this.hdrSize++] = (byte)(value >>> 24 & 0xFF);
    }

    private void writeShort(int value) {
        this.hdr[this.hdrSize++] = (byte)(value >> 0 & 0xFF);
        this.hdr[this.hdrSize++] = (byte)(value >> 8 & 0xFF);
    }

    private void createHeader(int samplesPerSec, int sampleSizeInBits, int channels) {
        this.hdrSize = 0;
        int avBytesPerSec = channels * samplesPerSec * (sampleSizeInBits / 8);
        this.writeInt(1179011410);
        this.writeInt(-1);
        this.writeInt(1163280727);
        this.writeInt(544501094);
        this.writeInt(16);
        this.writeShort(1);
        this.writeShort((short)channels);
        this.writeInt(samplesPerSec);
        this.writeInt(avBytesPerSec);
        this.writeShort(channels * sampleSizeInBits / 8);
        this.writeShort(sampleSizeInBits);
        this.writeInt(1635017060);
        this.writeInt(-1);
    }
}

