/*
 * Decompiled with CFR 0.152.
 */
package com.sun.perseus.builder;

import com.sun.perseus.builder.Messages;
import com.sun.perseus.builder.ModelBuilder;
import com.sun.perseus.model.DocumentNode;
import com.sun.perseus.model.FontFace;
import com.sun.perseus.model.ModelNode;
import com.sun.perseus.model.UpdateAdapter;
import com.sun.perseus.platform.ResourceHandler;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.helpers.DefaultHandler;

public final class DefaultFontFace {
    private static Object secureToken = null;
    public static final String DEFAULT_FONT_FACE_FILE = "/com/sun/perseus/render/resources/defaultFont.svg";
    public static final String INITIAL_FONT_FACE_FILE = "/com/sun/perseus/render/resources/initialFont.svg";
    protected static FontFace defaultFontFace;
    protected static FontFace[] initialFontFaces;

    public static FontFace getDefaultFontFace() {
        if (defaultFontFace == null) {
            DefaultFontFace.loadDefaultFontFace();
        }
        return defaultFontFace;
    }

    public static FontFace[] getInitialFontFaces() {
        if (initialFontFaces == null) {
            DefaultFontFace.loadInitialFontFaces();
        }
        return initialFontFaces;
    }

    static void loadInitialFontFaces() throws Error {
        try {
            ModelNode svg = DefaultFontFace.loadSVGResource(INITIAL_FONT_FACE_FILE);
            int n = 0;
            for (ModelNode c = svg.getFirstChildNode(); c != null; c = c.getNextSiblingNode()) {
                ++n;
            }
            initialFontFaces = new FontFace[n];
            ModelNode font = svg.getFirstChildNode();
            for (int i = 0; i < initialFontFaces.length; ++i) {
                DefaultFontFace.initialFontFaces[i] = (FontFace)font.getFirstChildNode();
                font = font.getNextSiblingNode();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Error();
        }
    }

    static void loadDefaultFontFace() throws Error {
        try {
            ModelNode svg = DefaultFontFace.loadSVGResource(DEFAULT_FONT_FACE_FILE);
            defaultFontFace = (FontFace)svg.getFirstChildNode().getFirstChildNode();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Error();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static ModelNode loadSVGResource(String svgResource) throws Exception {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setValidating(true);
        SAXParser parser = factory.newSAXParser();
        DocumentNode root = new DocumentNode();
        UpdateAdapter ul = new UpdateAdapter();
        root.setUpdateListener(ul);
        ModelBuilder modelBuilder = new ModelBuilder(null, root);
        InputStream is = ResourceHandler.getSystemResource(svgResource, secureToken);
        if (is == null) {
            throw new Exception(Messages.formatMessage(Messages.ERROR_CANNOT_LOAD_RESOURCE, new Object[]{svgResource}));
        }
        ul.loadStarting(root, is);
        try {
            parser.parse(is, (DefaultHandler)modelBuilder);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException ioe) {}
            int n = modelBuilder.entityStreams.size();
            for (int i = 0; i < n; ++i) {
                Reader r = (Reader)modelBuilder.entityStreams.elementAt(i);
                try {
                    r.close();
                    continue;
                }
                catch (IOException ioe) {}
            }
        }
        if (!ul.loadSuccess()) {
            throw new Exception(Messages.formatMessage(Messages.ERROR_CANNOT_LOAD_RESOURCE, new Object[]{svgResource}));
        }
        return modelBuilder.getModelRoot().getFirstChildNode();
    }

    private DefaultFontFace() {
    }

    static {
        try {
            secureToken = ResourceHandler.getSecurityToken();
        }
        catch (SecurityException se) {
            se.printStackTrace();
        }
    }
}

