/*
 * Decompiled with CFR 0.152.
 */
package com.sun.perseus.j2d;

import com.sun.perseus.j2d.RasterImage;
import com.sun.perseus.util.Base64DecodeStream;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.io.Connector;
import javax.microedition.io.StreamConnection;
import javax.microedition.lcdui.Image;

public class ImageLoaderUtil {
    protected RasterImage brokenImage;
    protected RasterImage loadingImage;
    static final String BASE64_PREFIX = "data:";
    static final int BROKEN_IMAGE_COLOR = 0;
    static final int LOADING_IMAGE_COLOR = 0;
    static final String BASE64_JPG_HREF_PREFIX = "data:image/jpg;base64,";
    static final String BASE64_JPG_HREF_PREFIX2 = "data:image/jpeg;base64,";
    static final String BASE64_PNG_HREF_PREFIX = "data:image/png;base64,";
    static final String BASE64_HREF_PREFIX = "data:;base64,";
    static final int BASE64_JPG_HREF_PREFIX_LENGTH = "data:image/jpg;base64,".getBytes().length;
    static final int BASE64_JPG_HREF_PREFIX2_LENGTH = "data:image/jpeg;base64,".getBytes().length;
    static final int BASE64_PNG_HREF_PREFIX_LENGTH = "data:image/png;base64,".getBytes().length;
    static final int BASE64_HREF_PREFIX_LENGTH = "data:;base64,".getBytes().length;

    public ImageLoaderUtil() {
        this.createPlaceholderImages();
    }

    public RasterImage getLoadingImage() {
        return this.loadingImage;
    }

    public RasterImage getBrokenImage() {
        return this.brokenImage;
    }

    public boolean isDataURI(String uri) {
        return uri.startsWith(BASE64_PREFIX);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RasterImage getExternalImage(String href) {
        System.out.println("getExternalImage(), Image href = " + href);
        Image img = null;
        StreamConnection c = null;
        InputStream s = null;
        try {
            c = (StreamConnection)Connector.open((String)href);
            s = c.openInputStream();
            img = Image.createImage(s);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            System.out.println("returning broken image");
            RasterImage rasterImage = this.brokenImage;
            return rasterImage;
        }
        catch (IllegalArgumentException iae) {
            iae.printStackTrace();
            System.out.println("returning broken image");
            RasterImage rasterImage = this.brokenImage;
            return rasterImage;
        }
        finally {
            try {
                if (s != null) {
                    s.close();
                }
                if (c != null) {
                    c.close();
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
        return new RasterImage(img);
    }

    public RasterImage createImage(byte[] imageData) {
        Image img = Image.createImage(imageData, 0, imageData.length);
        return new RasterImage(img);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RasterImage getEmbededImage(String uri) {
        int startAt = 0;
        if (uri.startsWith(BASE64_PNG_HREF_PREFIX)) {
            startAt = BASE64_PNG_HREF_PREFIX_LENGTH;
        } else if (uri.startsWith(BASE64_JPG_HREF_PREFIX)) {
            startAt = BASE64_JPG_HREF_PREFIX_LENGTH;
        } else if (uri.startsWith(BASE64_JPG_HREF_PREFIX2)) {
            startAt = BASE64_JPG_HREF_PREFIX2_LENGTH;
        } else if (uri.startsWith(BASE64_HREF_PREFIX)) {
            startAt = BASE64_HREF_PREFIX_LENGTH;
        } else {
            return this.brokenImage;
        }
        InputStream is = new Base64StringStream(uri, startAt);
        is = new Base64DecodeStream(is);
        byte[] data = new byte[(uri.length() - startAt) * 3 / 4];
        try {
            Image img = Image.createImage(is);
            RasterImage rasterImage = new RasterImage(img);
            return rasterImage;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            RasterImage rasterImage = this.brokenImage;
            return rasterImage;
        }
        catch (IllegalArgumentException iae) {
            iae.printStackTrace();
            RasterImage rasterImage = this.brokenImage;
            return rasterImage;
        }
        finally {
            try {
                is.close();
            }
            catch (IOException ioe) {}
        }
    }

    protected void createPlaceholderImages() {
        int[] argb = new int[]{0};
        Image image = Image.createRGBImage(argb, 1, 1, true);
        this.brokenImage = new RasterImage(image);
        argb = new int[]{0};
        image = Image.createRGBImage(argb, 1, 1, true);
        this.loadingImage = new RasterImage(image);
    }

    static class Base64StringStream
    extends InputStream {
        private String str;
        private int len = 0;
        private int offset = 0;

        public int read() {
            return this.offset < this.len ? (int)this.str.charAt(this.offset++) : -1;
        }

        public Base64StringStream(String str, int offset) {
            this.str = str;
            this.offset = offset;
            this.len = str.length();
        }
    }
}

