/*
 * Decompiled with CFR 0.152.
 */
package com.sun.perseus.j2d;

import com.sun.perseus.j2d.PaintDef;
import com.sun.perseus.j2d.PiscesRenderGraphics;
import com.sun.perseus.j2d.Transform;
import com.sun.pisces.PiscesRenderer;
import com.sun.pisces.Transform6;
import org.w3c.dom.svg.SVGRect;

public class LinearGradientPaintDef
implements PaintDef {
    public static final int CYCLE_NONE = 0;
    public static final int CYCLE_REPEAT = 1;
    public static final int CYCLE_REFLECT = 2;
    private Transform6 IDENTITY = new Transform6();
    float x0;
    float y0;
    float x1;
    float y1;
    float[] fractions;
    int[] frac;
    int[] rgba;
    int[] lrgba;
    int lastPaintOpacity = 255;
    int cycleMethod;
    protected boolean isObjectBBox = false;
    protected Transform gradientTransform;

    public LinearGradientPaintDef(float x0, float y0, float x1, float y1, float[] fractions, int[] rgba, int cycleMethod, boolean isObjectBBox, Transform gradientTransform) {
        this.x0 = x0;
        this.y0 = y0;
        this.x1 = x1;
        this.y1 = y1;
        this.fractions = fractions;
        this.rgba = rgba;
        this.cycleMethod = cycleMethod;
        this.isObjectBBox = isObjectBBox;
        this.gradientTransform = gradientTransform;
    }

    public void setPaint(PiscesRenderGraphics rg, PiscesRenderer pr, int paintOpacity) {
        if (this.frac == null) {
            this.frac = new int[this.fractions.length];
            for (int i = 0; i < this.fractions.length; ++i) {
                this.frac[i] = (int)(this.fractions[i] * 65536.0f);
            }
        }
        int[] c = this.rgba;
        if (paintOpacity != 255) {
            c = this.lrgba;
            if (paintOpacity != this.lastPaintOpacity) {
                if (this.lrgba == null) {
                    this.lrgba = new int[this.rgba.length];
                }
                int a = 0;
                int i = 0;
                while (i < this.rgba.length) {
                    this.lrgba[i] = this.rgba[i] & 0xFFFFFF;
                    a = paintOpacity * (0xFF & this.rgba[i] >> 24) / 255;
                    int n = i++;
                    this.lrgba[n] = this.lrgba[n] | a << 24;
                }
                this.lastPaintOpacity = paintOpacity;
            }
        }
        Transform txf = null;
        txf = rg.paintTransform != null ? new Transform(rg.paintTransform) : new Transform((float)rg.transform.m00 / 65536.0f, (float)rg.transform.m10 / 65536.0f, (float)rg.transform.m01 / 65536.0f, (float)rg.transform.m11 / 65536.0f, (float)rg.transform.m02 / 65536.0f, (float)rg.transform.m12 / 65536.0f);
        if (this.isObjectBBox) {
            SVGRect bbox = rg.paintTarget.getBBox();
            txf.mTranslate(bbox.getX(), bbox.getY());
            txf.mScale(bbox.getWidth(), bbox.getHeight());
        }
        if (this.gradientTransform != null) {
            txf.mMultiply(this.gradientTransform);
        }
        Transform6 t = new Transform6();
        t.m00 = (int)(txf.m0 * 65536.0f);
        t.m10 = (int)(txf.m1 * 65536.0f);
        t.m01 = (int)(txf.m2 * 65536.0f);
        t.m11 = (int)(txf.m3 * 65536.0f);
        t.m02 = (int)(txf.m4 * 65536.0f);
        t.m12 = (int)(txf.m5 * 65536.0f);
        pr.setLinearGradient((int)(this.x0 * 65536.0f), (int)(this.y0 * 65536.0f), (int)(this.x1 * 65536.0f), (int)(this.y1 * 65536.0f), this.frac, c, this.cycleMethod, t);
    }
}

