/*
 * Decompiled with CFR 0.152.
 */
package com.sun.perseus.j2d;

import com.sun.perseus.j2d.GraphicsProperties;
import com.sun.perseus.j2d.HitTester;
import com.sun.perseus.j2d.Path;
import com.sun.perseus.j2d.RenderGraphics;
import com.sun.perseus.j2d.Tile;
import com.sun.perseus.j2d.TileSink;
import com.sun.perseus.j2d.Transform;
import com.sun.pisces.Dasher;
import com.sun.pisces.Flattener;
import com.sun.pisces.PathSink;
import com.sun.pisces.PathStore;
import com.sun.pisces.Stroker;
import com.sun.pisces.Transform4;
import com.sun.pisces.Transform6;
import com.sun.pisces.Transformer;

public class PathSupport {
    private static final Transform4 identity = new Transform4();
    private static final Transform6 identity6 = new Transform6();
    private static final Transform6 txf = new Transform6();
    private static TileSink tileSink = new TileSink();
    private static Transformer transformerSink = new Transformer(tileSink, identity6);
    private static long acv = 14670L;
    private static final double CtrlVal = 0.5522847498307933;
    private static long pcv_ = 50865L;
    private static long ncv_ = 14670L;

    private static int toFixed(float f) {
        return (int)(f * 65536.0f);
    }

    private static void emitPath(Path path, PathSink output) {
        int numSegments = path.getNumberOfSegments();
        byte[] pathCommands = path.getCommands();
        float[] pathData = path.getData();
        int x1 = -1;
        int y1 = -1;
        Object pt = null;
        int offset = 0;
        block7: for (int seg = 0; seg < numSegments; ++seg) {
            if (pathCommands[seg] != 4) {
                x1 = PathSupport.toFixed(pathData[offset]);
                y1 = PathSupport.toFixed(pathData[offset + 1]);
            }
            switch (pathCommands[seg]) {
                case 0: {
                    output.moveTo(x1, y1);
                    offset += 2;
                    continue block7;
                }
                case 1: {
                    output.lineTo(x1, y1);
                    offset += 2;
                    continue block7;
                }
                case 2: {
                    int x2 = PathSupport.toFixed(pathData[offset + 2]);
                    int y2 = PathSupport.toFixed(pathData[offset + 3]);
                    output.quadTo(x1, y1, x2, y2);
                    offset += 4;
                    continue block7;
                }
                case 3: {
                    int x2 = PathSupport.toFixed(pathData[offset + 2]);
                    int y2 = PathSupport.toFixed(pathData[offset + 3]);
                    int x3 = PathSupport.toFixed(pathData[offset + 4]);
                    int y3 = PathSupport.toFixed(pathData[offset + 5]);
                    output.cubicTo(x1, y1, x2, y2, x3, y3);
                    offset += 6;
                    continue block7;
                }
                case 4: {
                    output.close();
                }
            }
        }
        output.end();
    }

    public static boolean isHit(Path path, int windingRule, float hx, float hy) {
        HitTester hitTester = new HitTester(windingRule, PathSupport.toFixed(hx), PathSupport.toFixed(hy));
        PathSupport.emitPath(path, hitTester);
        boolean hit = hitTester.containsPoint();
        return hit;
    }

    public static boolean isStrokedPathHit(Object strokedPath, int windingRule, float hx, float hy) {
        HitTester hitTester = new HitTester(1, PathSupport.toFixed(hx), PathSupport.toFixed(hy));
        PathStore path = (PathStore)strokedPath;
        path.produce(hitTester);
        boolean hit = hitTester.containsPoint();
        return hit;
    }

    public static void computeStrokedPathTile(Tile tile, Object strokedPath, Transform t) {
        PathStore sp = (PathStore)strokedPath;
        tileSink.reset();
        RenderGraphics.setTransform(t, txf);
        transformerSink.setTransform(txf);
        sp.produce(transformerSink);
        tileSink.setTile(tile);
    }

    private static PathSink createStroker(PathSink output, GraphicsProperties gp) {
        Stroker stroker = new Stroker();
        stroker.setParameters((int)(gp.getStrokeWidth() * 65536.0f), gp.getStrokeLineCap(), gp.getStrokeLineJoin(), (int)(gp.getStrokeMiterLimit() * 65536.0f), identity);
        stroker.setOutput(output);
        Flattener flattener = new Flattener();
        flattener.setFlatness(65536);
        float[] strokeDashArray = gp.getStrokeDashArray();
        if (strokeDashArray != null) {
            int[] intStrokeDashArray = new int[strokeDashArray.length];
            for (int i = 0; i < strokeDashArray.length; ++i) {
                intStrokeDashArray[i] = (int)(strokeDashArray[i] * 65536.0f);
            }
            Dasher dasher = new Dasher();
            dasher.setParameters(intStrokeDashArray, PathSupport.computeStrokeDashOffset(gp.getStrokeDashOffset(), gp.getStrokeDashArray()), identity);
            dasher.setOutput(stroker);
            flattener.setOutput(dasher);
        } else {
            flattener.setOutput(stroker);
        }
        return flattener;
    }

    static int computeStrokeDashOffset(float strokeDashOffset, float[] strokeDashArray) {
        float sdo;
        if (strokeDashArray == null) {
            return 0;
        }
        if (strokeDashOffset >= 0.0f) {
            return (int)(strokeDashOffset * 65536.0f);
        }
        int length = 0;
        for (int i = 0; i < strokeDashArray.length; ++i) {
            length = (int)((float)length + strokeDashArray[i]);
        }
        if (length <= 0) {
            return 0;
        }
        for (sdo = strokeDashOffset; sdo < 0.0f; sdo += (float)length) {
        }
        return (int)(sdo * 65536.0f);
    }

    public static Object getStrokedPath(Path path, GraphicsProperties gp) {
        PathStore strokedPath = new PathStore();
        PathSink stroker = PathSupport.createStroker(strokedPath, gp);
        PathSupport.emitPath(path, stroker);
        return strokedPath;
    }

    public static Object getStrokedRect(float x, float y, float w, float h, GraphicsProperties gp) {
        PathStore strokedPath = new PathStore();
        PathSink stroker = PathSupport.createStroker(strokedPath, gp);
        stroker.moveTo(PathSupport.toFixed(x), PathSupport.toFixed(y));
        stroker.lineTo(PathSupport.toFixed(x + w), PathSupport.toFixed(y));
        stroker.lineTo(PathSupport.toFixed(x + w), PathSupport.toFixed(y + h));
        stroker.lineTo(PathSupport.toFixed(x), PathSupport.toFixed(y + h));
        stroker.close();
        stroker.end();
        return strokedPath;
    }

    public static Object getStrokedRect(float fx, float fy, float fw, float fh, float rx, float ry, GraphicsProperties gp) {
        int x = PathSupport.toFixed(fx);
        int y = PathSupport.toFixed(fy);
        int w = PathSupport.toFixed(fw);
        int h = PathSupport.toFixed(fh);
        int aw = PathSupport.toFixed(rx);
        int ah = PathSupport.toFixed(ry);
        int xw = x + w;
        int yh = y + h;
        int aw2 = aw >> 1;
        int ah2 = ah >> 1;
        int acvaw = (int)(acv * (long)aw >> 16);
        int acvah = (int)(acv * (long)ah >> 16);
        int xacvaw = x + acvaw;
        int xw_acvaw = xw - acvaw;
        int yacvah = y + acvah;
        int yh_acvah = yh - acvah;
        int xaw2 = x + aw2;
        int xw_aw2 = xw - aw2;
        int yah2 = y + ah2;
        int yh_ah2 = yh - ah2;
        PathStore strokedPath = new PathStore();
        PathSink stroker = PathSupport.createStroker(strokedPath, gp);
        stroker.moveTo(x, yah2);
        stroker.lineTo(x, yh_ah2);
        stroker.cubicTo(x, yh_acvah, xacvaw, yh, xaw2, yh);
        stroker.lineTo(xw_aw2, yh);
        stroker.cubicTo(xw_acvaw, yh, xw, yh_acvah, xw, yh_ah2);
        stroker.lineTo(xw, yah2);
        stroker.cubicTo(xw, yacvah, xw_acvaw, y, xw_aw2, y);
        stroker.lineTo(xaw2, y);
        stroker.cubicTo(xacvaw, y, x, yacvah, x, yah2);
        stroker.close();
        stroker.end();
        return strokedPath;
    }

    public static Object getStrokedLine(float x1, float y1, float x2, float y2, GraphicsProperties gp) {
        PathStore strokedPath = new PathStore();
        PathSink stroker = PathSupport.createStroker(strokedPath, gp);
        stroker.moveTo(PathSupport.toFixed(x1), PathSupport.toFixed(y1));
        stroker.lineTo(PathSupport.toFixed(x2), PathSupport.toFixed(y2));
        stroker.end();
        return strokedPath;
    }

    public static Object getStrokedEllipse(float x, float y, float width, float height, GraphicsProperties gp) {
        PathStore strokedPath = new PathStore();
        PathSink stroker = PathSupport.createStroker(strokedPath, gp);
        int x_ = PathSupport.toFixed(x);
        int y_ = PathSupport.toFixed(y);
        int width_ = PathSupport.toFixed(width);
        int height_ = PathSupport.toFixed(height);
        int xw_ = x_ + width_;
        int xw2_ = x_ + (width_ >> 1);
        int yh_ = y_ + height_;
        int yh2_ = y_ + (height_ >> 1);
        int xpcvw_ = x_ + (int)(pcv_ * (long)width_ >> 16);
        int ypcvh_ = y_ + (int)(pcv_ * (long)height_ >> 16);
        int xncvw_ = x_ + (int)(ncv_ * (long)width_ >> 16);
        int yncvh_ = y_ + (int)(ncv_ * (long)height_ >> 16);
        stroker.moveTo(xw_, yh2_);
        stroker.cubicTo(xw_, ypcvh_, xpcvw_, yh_, xw2_, yh_);
        stroker.cubicTo(xncvw_, yh_, x_, ypcvh_, x_, yh2_);
        stroker.cubicTo(x_, yncvh_, xncvw_, y_, xw2_, y_);
        stroker.cubicTo(xpcvw_, y_, xw_, yncvh_, xw_, yh2_);
        stroker.close();
        stroker.end();
        return strokedPath;
    }
}

