/*
 * Decompiled with CFR 0.152.
 */
package com.sun.perseus.j2d;

import com.sun.perseus.j2d.PaintServer;
import com.sun.perseus.j2d.PaintTarget;
import com.sun.perseus.j2d.Path;
import com.sun.perseus.j2d.RGB;
import com.sun.perseus.j2d.RasterImage;
import com.sun.perseus.j2d.RenderContext;
import com.sun.perseus.j2d.Tile;
import com.sun.perseus.j2d.Transform;
import com.sun.pisces.PiscesRenderer;
import com.sun.pisces.Transform6;

public abstract class PiscesRenderGraphics
extends RenderContext {
    protected static final Transform IDENTITY = new Transform(null);
    protected PaintTarget paintTarget;
    protected Transform paintTransform = null;
    protected PiscesRenderer pr;
    protected Transform6 transform = new Transform6();
    protected boolean needSetTransform = true;
    protected Transform6 imageTransform = new Transform6();
    protected int width;
    protected int height;
    protected Tile renderingTile = new Tile();
    protected Tile primitiveTile = new Tile();

    public PiscesRenderGraphics(PiscesRenderer pr, int width, int height) {
        if (pr == null) {
            throw new NullPointerException();
        }
        if (width <= 0 || height <= 0) {
            throw new IllegalArgumentException();
        }
        this.width = width;
        this.height = height;
        this.pr = pr;
        this.setRenderingTile(null);
        this.setPrimitiveTile(null);
    }

    public abstract void clearRect(int var1, int var2, int var3, int var4, RGB var5);

    public void setRenderingTile(Tile renderingTile) {
        if (renderingTile != null) {
            this.renderingTile.x = renderingTile.x;
            this.renderingTile.y = renderingTile.y;
            this.renderingTile.maxX = renderingTile.maxX;
            this.renderingTile.maxY = renderingTile.maxY;
        } else {
            this.renderingTile.x = 0;
            this.renderingTile.y = 0;
            this.renderingTile.maxX = this.width - 1;
            this.renderingTile.maxY = this.height - 1;
        }
        this.setPrimitiveTile(renderingTile);
    }

    public void setPrimitiveTile(Tile primitiveTile) {
        if (primitiveTile != null) {
            this.primitiveTile.x = primitiveTile.x;
            this.primitiveTile.y = primitiveTile.y;
            this.primitiveTile.maxX = primitiveTile.maxX;
            this.primitiveTile.maxY = primitiveTile.maxY;
        } else {
            this.primitiveTile.x = this.renderingTile.x;
            this.primitiveTile.y = this.renderingTile.y;
            this.primitiveTile.maxX = this.renderingTile.maxX;
            this.primitiveTile.maxY = this.renderingTile.maxY;
        }
        this.applyClip();
    }

    void applyClip() {
        int x = this.primitiveTile.x;
        int y = this.primitiveTile.y;
        int mx = this.primitiveTile.maxX;
        int my = this.primitiveTile.maxY;
        if (x < this.renderingTile.x) {
            x = this.renderingTile.x;
        }
        if (y < this.renderingTile.y) {
            y = this.renderingTile.y;
        }
        if (mx > this.renderingTile.maxX) {
            mx = this.renderingTile.maxX;
        }
        if (my > this.renderingTile.maxY) {
            my = this.renderingTile.maxY;
        }
        int w = mx - x + 1;
        int h = my - y + 1;
        if (w <= 0 || h <= 0) {
            throw new IllegalArgumentException();
        }
        this.pr.setClip(x, y, w, h);
    }

    public Tile getRenderingTile() {
        return this.renderingTile;
    }

    public Tile getPrimitiveTile() {
        return this.primitiveTile;
    }

    public void setPaintTarget(PaintTarget paintTarget) {
        this.paintTarget = paintTarget;
    }

    public void setPaintTransform(Transform paintTransform) {
        this.paintTransform = paintTransform;
    }

    public void setRenderingQuality(boolean isHigh) {
        if (isHigh) {
            this.pr.setAntialiasing(true);
        } else {
            this.pr.setAntialiasing(false);
        }
    }

    public void setTransform(Transform newTransform) {
        this.needSetTransform = PiscesRenderGraphics.setTransform(newTransform, this.transform) || this.needSetTransform;
        this.needSetTransform = true;
    }

    static boolean setTransform(Transform newTransform, Transform6 transform) {
        if (newTransform == null) {
            return PiscesRenderGraphics.setTransform(IDENTITY, transform);
        }
        int m00 = (int)(newTransform.m0 * 65536.0f);
        int m10 = (int)(newTransform.m1 * 65536.0f);
        int m01 = (int)(newTransform.m2 * 65536.0f);
        int m11 = (int)(newTransform.m3 * 65536.0f);
        int m02 = (int)(newTransform.m4 * 65536.0f);
        int m12 = (int)(newTransform.m5 * 65536.0f);
        if (m00 != transform.m00 || m10 != transform.m10 || m01 != transform.m01 || m11 != transform.m11 || m02 != transform.m02 || m12 != transform.m12) {
            transform.m00 = m00;
            transform.m10 = m10;
            transform.m01 = m01;
            transform.m11 = m11;
            transform.m02 = m02;
            transform.m12 = m12;
            return true;
        }
        return false;
    }

    public void fill(Path path) {
        this.fillOrDraw(path, this.fill, this.getFillOpacityImpl(), true);
    }

    void fillOrDraw(Path path, PaintServer paint, int opOpacity, boolean isFill) {
        if (this.needSetTransform) {
            this.pr.setTransform(this.transform);
            this.needSetTransform = false;
        }
        paint.getPaintDef().setPaint(this, this.pr, opOpacity);
        if (isFill) {
            this.pr.setFill();
            this.pr.beginRendering(this.getFillRule());
        } else {
            this.pr.setStroke(this.strokeWidth, this.getStrokeLineCap(), this.getStrokeLineJoin(), this.strokeMiterLimit, this.strokeDashArray, this.computeStrokeDashOffset());
            this.pr.beginRendering(1);
        }
        this.pr.setPathData(path.data, path.commands, path.nSegments);
        this.pr.endRendering();
    }

    public void draw(Path path) {
        this.fillOrDraw(path, this.stroke, this.getStrokeOpacityImpl(), false);
    }

    public void fillRect(float x, float y, float w, float h, float aw, float ah) {
        if (this.needSetTransform) {
            this.pr.setTransform(this.transform);
            this.needSetTransform = false;
        }
        this.fill.getPaintDef().setPaint(this, this.pr, this.getFillOpacityImpl());
        if (aw > 0.0f || ah > 0.0f) {
            this.pr.fillRoundRect((int)(x * 65536.0f), (int)(y * 65536.0f), (int)(w * 65536.0f), (int)(h * 65536.0f), (int)(aw * 65536.0f), (int)(ah * 65536.0f));
        } else {
            this.pr.fillRect((int)(x * 65536.0f), (int)(y * 65536.0f), (int)(w * 65536.0f), (int)(h * 65536.0f));
        }
    }

    public void drawRect(float x, float y, float w, float h, float aw, float ah) {
        if (this.needSetTransform) {
            this.pr.setTransform(this.transform);
            this.needSetTransform = false;
        }
        this.stroke.getPaintDef().setPaint(this, this.pr, this.getStrokeOpacityImpl());
        this.pr.setStroke(this.strokeWidth, this.getStrokeLineCap(), this.getStrokeLineJoin(), this.strokeMiterLimit, this.strokeDashArray, this.computeStrokeDashOffset());
        if (aw > 0.0f || ah > 0.0f) {
            this.pr.drawRoundRect((int)(x * 65536.0f), (int)(y * 65536.0f), (int)(w * 65536.0f), (int)(h * 65536.0f), (int)(aw * 65536.0f), (int)(ah * 65536.0f));
        } else {
            this.pr.drawRect((int)(x * 65536.0f), (int)(y * 65536.0f), (int)(w * 65536.0f), (int)(h * 65536.0f));
        }
    }

    public void drawOval(float x, float y, float w, float h) {
        if (this.needSetTransform) {
            this.pr.setTransform(this.transform);
            this.needSetTransform = false;
        }
        this.stroke.getPaintDef().setPaint(this, this.pr, this.getStrokeOpacityImpl());
        this.pr.setStroke(this.strokeWidth, this.getStrokeLineCap(), this.getStrokeLineJoin(), this.strokeMiterLimit, this.strokeDashArray, this.computeStrokeDashOffset());
        this.pr.drawOval((int)(x * 65536.0f), (int)(y * 65536.0f), (int)(w * 65536.0f), (int)(h * 65536.0f));
    }

    public void fillOval(float x, float y, float w, float h) {
        if (this.needSetTransform) {
            this.pr.setTransform(this.transform);
            this.needSetTransform = false;
        }
        this.fill.getPaintDef().setPaint(this, this.pr, this.getFillOpacityImpl());
        this.pr.fillOval((int)(x * 65536.0f), (int)(y * 65536.0f), (int)(w * 65536.0f), (int)(h * 65536.0f));
    }

    public void drawLine(float x1, float y1, float x2, float y2) {
        if (this.needSetTransform) {
            this.pr.setTransform(this.transform);
            this.needSetTransform = false;
        }
        this.stroke.getPaintDef().setPaint(this, this.pr, this.getStrokeOpacityImpl());
        this.pr.setStroke(this.strokeWidth, this.getStrokeLineCap(), this.getStrokeLineJoin(), this.strokeMiterLimit, this.strokeDashArray, this.computeStrokeDashOffset());
        this.pr.drawLine((int)(x1 * 65536.0f), (int)(y1 * 65536.0f), (int)(x2 * 65536.0f), (int)(y2 * 65536.0f));
    }

    public void drawImage(RasterImage image, float dx, float dy, float dw, float dh) {
        if (image == null || image.getWidth() <= 0 || image.getHeight() <= 0 || dw <= 0.0f || dh <= 0.0f) {
            return;
        }
        int sw = image.getWidth();
        int sh = image.getHeight();
        if (this.needSetTransform) {
            this.pr.setTransform(this.transform);
            this.needSetTransform = false;
        }
        float scaleX = dw / (float)sw;
        float scaleY = dh / (float)sh;
        Transform6 imageTransform = new Transform6();
        imageTransform.m00 = (int)(scaleX * 65536.0f);
        imageTransform.m11 = (int)(scaleY * 65536.0f);
        imageTransform.m02 = (int)(dx * 65536.0f);
        imageTransform.m12 = (int)(dy * 65536.0f);
        this.pr.setTexture(1, image.getRGB(), sw, sh, 0, sw, imageTransform, false);
        this.pr.fillRect((int)(dx * 65536.0f), (int)(dy * 65536.0f), (int)(dw * 65536.0f), (int)(dh * 65536.0f));
    }
}

