/*
 * Decompiled with CFR 0.152.
 */
package com.sun.perseus.j2d;

import com.sun.perseus.j2d.PaintDef;
import com.sun.perseus.j2d.PaintServer;
import com.sun.perseus.j2d.PaintTarget;
import com.sun.perseus.j2d.PiscesRenderGraphics;
import com.sun.pisces.PiscesRenderer;
import org.w3c.dom.svg.SVGRGBColor;

public class RGB
implements SVGRGBColor,
PaintDef,
PaintServer {
    int rgb = -16777216;
    public static final RGB black = new RGB(0, 0, 0);
    public static final RGB white = new RGB(255, 255, 255);
    public static final RGB blue = new RGB(0, 0, 255);
    public static final RGB orange = new RGB(255, 200, 0);
    public static final RGB red = new RGB(255, 0, 0);
    public static final RGB green = new RGB(0, 255, 0);
    public static final RGB yellow = new RGB(255, 255, 0);
    public static final RGB gray = new RGB(192, 192, 192);

    public RGB(int r, int g, int b) {
        this(255, r, g, b);
    }

    public RGB(int a, int r, int g, int b) {
        this.rgb = a << 24 | r << 16 | g << 8 | b;
    }

    public int getRed() {
        return 0xFF & this.rgb >> 16;
    }

    public int getGreen() {
        return 0xFF & this.rgb >> 8;
    }

    public int getBlue() {
        return 0xFF & this.rgb;
    }

    public int getAlpha() {
        return 0xFF & this.rgb >> 24;
    }

    public void setPaint(PiscesRenderGraphics rg, PiscesRenderer pr, int paintOpacity) {
        pr.setColor(0xFF & this.rgb >> 16, 0xFF & this.rgb >> 8, 0xFF & this.rgb, paintOpacity * (0xFF & this.rgb >> 24) / 255);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("rgb(");
        sb.append(this.getRed());
        sb.append(",");
        sb.append(this.getGreen());
        sb.append(",");
        sb.append(this.getBlue());
        sb.append(")");
        return sb.toString();
    }

    public PaintDef getPaintDef() {
        return this;
    }

    public void setPaintTarget(String paintType, PaintTarget paintTarget) {
    }

    public void dispose() {
    }
}

