/*
 * Decompiled with CFR 0.152.
 */
package com.sun.perseus.j2d;

import com.sun.perseus.j2d.PaintServer;
import com.sun.perseus.j2d.RGB;
import com.sun.perseus.j2d.TextRenderingProperties;

public class RenderContext
implements TextRenderingProperties {
    protected static int INITIAL_STROKE_WIDTH_IMPL = 65536;
    protected static int INITIAL_STROKE_MITER_LIMIT_IMPL = 262144;
    protected static int[] INITIAL_STROKE_DASH_ARRAY_IMPL = null;
    protected static int INITIAL_STROKE_DASH_OFFSET_IMPL = 0;
    protected static final int FONT_STYLE_MASK = 0x60000000;
    protected static final int FONT_WEIGHT_MASK = 0x1E000000;
    protected static final int TEXT_ANCHOR_MASK = 0x1800000;
    protected static final int STROKE_OPACITY_MASK = 8355840;
    protected static final int FILL_OPACITY_MASK = 32640;
    protected static final int FILL_RULE_MASK = 64;
    protected static final int STROKE_LINE_CAP_MASK = 48;
    protected static final int STROKE_LINE_JOIN_MASK = 12;
    protected static final int VISIBILITY_MASK = 2;
    protected static final int DISPLAY_MASK = 1;
    protected static final int FONT_STYLE_NORMAL_IMPL = 0;
    protected static final int FONT_STYLE_ITALIC_IMPL = 0x40000000;
    protected static final int FONT_STYLE_OBLIQUE_IMPL = 0x60000000;
    protected static final int FONT_WEIGHT_100_IMPL = 0;
    protected static final int FONT_WEIGHT_200_IMPL = 0x2000000;
    protected static final int FONT_WEIGHT_300_IMPL = 0x4000000;
    protected static final int FONT_WEIGHT_400_IMPL = 0x6000000;
    protected static final int FONT_WEIGHT_500_IMPL = 0x8000000;
    protected static final int FONT_WEIGHT_600_IMPL = 0xA000000;
    protected static final int FONT_WEIGHT_700_IMPL = 0xC000000;
    protected static final int FONT_WEIGHT_800_IMPL = 0xE000000;
    protected static final int FONT_WEIGHT_900_IMPL = 0x10000000;
    protected static final int TEXT_ANCHOR_MIDDLE_IMPL = 0;
    protected static final int TEXT_ANCHOR_START_IMPL = 0x800000;
    protected static final int TEXT_ANCHOR_END_IMPL = 0x1000000;
    protected static final int CAP_BUTT_IMPL = 0;
    protected static final int CAP_ROUND_IMPL = 16;
    protected static final int CAP_SQUARE_IMPL = 32;
    protected static final int JOIN_MITER_IMPL = 0;
    protected static final int JOIN_ROUND_IMPL = 4;
    protected static final int JOIN_BEVEL_IMPL = 8;
    protected PaintServer fill = INITIAL_FILL;
    protected PaintServer stroke = INITIAL_STROKE;
    protected RGB color = INITIAL_COLOR;
    protected int[] strokeDashArray = INITIAL_STROKE_DASH_ARRAY_IMPL;
    protected int strokeWidth = INITIAL_STROKE_WIDTH_IMPL;
    protected int strokeMiterLimit = INITIAL_STROKE_MITER_LIMIT_IMPL;
    protected int strokeDashOffset = INITIAL_STROKE_DASH_OFFSET_IMPL;
    protected String[] fontFamily = INITIAL_FONT_FAMILY;
    protected float fontSize = 10.0f;
    protected int pack = 115631107;
    protected static final int INITIAL_FONT_STYLE_IMPL = 0;
    protected static final int INITIAL_FONT_WEIGHT_IMPL = 0x6000000;
    protected static final int INITIAL_TEXT_ANCHOR_IMPL = 0x800000;
    protected static final int INITIAL_STROKE_OPACITY_IMPL = 0x640000;
    protected static final int INITIAL_FILL_OPACITY_IMPL = 25600;
    protected static final int INITIAL_FILL_RULE_IMPL = 0;
    protected static final int INITIAL_STROKE_LINE_CAP_IMPL = 0;
    protected static final int INITIAL_STROKE_LINE_JOIN_IMPL = 0;
    protected static final int INITIAL_VISIBILITY_IMPL = 2;
    protected static final int INITIAL_DISPLAY_IMPL = 1;
    protected static final int INITIAL_PACK = 115631107;

    public RenderContext() {
    }

    public RenderContext(RenderContext rcs) {
        this.restore(rcs);
    }

    public void restore(RenderContext rcs) {
        this.fill = rcs.fill;
        this.stroke = rcs.stroke;
        this.color = rcs.color;
        this.strokeDashArray = rcs.strokeDashArray;
        this.strokeWidth = rcs.strokeWidth;
        this.strokeMiterLimit = rcs.strokeMiterLimit;
        this.strokeDashOffset = rcs.strokeDashOffset;
        this.fontFamily = rcs.fontFamily;
        this.fontSize = rcs.fontSize;
        this.pack = rcs.pack;
    }

    public void reset() {
        this.fill = INITIAL_FILL;
        this.stroke = INITIAL_STROKE;
        this.color = INITIAL_COLOR;
        this.strokeDashArray = INITIAL_STROKE_DASH_ARRAY_IMPL;
        this.strokeWidth = INITIAL_STROKE_WIDTH_IMPL;
        this.strokeMiterLimit = INITIAL_STROKE_MITER_LIMIT_IMPL;
        this.strokeDashOffset = INITIAL_STROKE_DASH_OFFSET_IMPL;
        this.fontFamily = INITIAL_FONT_FAMILY;
        this.fontSize = 10.0f;
        this.pack = 115631107;
    }

    public void setFill(PaintServer newFill) {
        this.fill = newFill;
    }

    public PaintServer getFill() {
        return this.fill;
    }

    public void setFillOpacity(float newFillOpacity) {
        if (newFillOpacity < 0.0f) {
            newFillOpacity = 0.0f;
        } else if (newFillOpacity > 1.0f) {
            newFillOpacity = 1.0f;
        }
        this.pack &= 0xFFFF807F;
        this.pack |= (int)(newFillOpacity * 200.0f) << 7 & 0x7F80;
    }

    public float getFillOpacity() {
        return (float)((this.pack & 0x7F80) >> 7) / 200.0f;
    }

    int getFillOpacityImpl() {
        return (int)((float)((this.pack & 0x7F80) >> 7) * 255.0f / 200.0f);
    }

    public void setStroke(PaintServer newStroke) {
        this.stroke = newStroke;
    }

    public PaintServer getStroke() {
        return this.stroke;
    }

    public void setStrokeOpacity(float newStrokeOpacity) {
        if (newStrokeOpacity < 0.0f) {
            newStrokeOpacity = 0.0f;
        } else if (newStrokeOpacity > 1.0f) {
            newStrokeOpacity = 1.0f;
        }
        this.pack &= 0xFF807FFF;
        this.pack |= (int)(newStrokeOpacity * 200.0f) << 15 & 0x7F8000;
    }

    public float getStrokeOpacity() {
        return (float)((this.pack & 0x7F8000) >> 15) / 200.0f;
    }

    public int getStrokeOpacityImpl() {
        return (int)((float)((this.pack & 0x7F8000) >> 15) * 255.0f / 200.0f);
    }

    public void setColor(RGB newColor) {
        this.color = newColor;
    }

    public RGB getColor() {
        return this.color;
    }

    public void setFillRule(int newFillRule) {
        this.pack = newFillRule == 0 ? (this.pack |= 0x40) : (this.pack &= 0xFFFFFFBF);
    }

    public int getFillRule() {
        if ((this.pack & 0x40) == 64) {
            return 0;
        }
        return 1;
    }

    public float[] getStrokeDashArray() {
        if (this.strokeDashArray == null) {
            return null;
        }
        float[] sda = new float[this.strokeDashArray.length];
        for (int i = 0; i < sda.length; ++i) {
            sda[i] = (float)this.strokeDashArray[i] / 65536.0f;
        }
        return sda;
    }

    public void setStrokeDashArray(float[] newStrokeDashArray) {
        if (newStrokeDashArray == null) {
            this.strokeDashArray = null;
        } else {
            this.strokeDashArray = new int[newStrokeDashArray.length];
            for (int i = 0; i < this.strokeDashArray.length; ++i) {
                this.strokeDashArray[i] = (int)(newStrokeDashArray[i] * 65536.0f);
            }
        }
    }

    public int getStrokeLineCap() {
        switch (this.pack & 0x30) {
            case 0: {
                return 0;
            }
            case 16: {
                return 1;
            }
        }
        return 2;
    }

    public void setStrokeLineCap(int newStrokeLineCap) {
        this.pack &= 0xFFFFFFCF;
        switch (newStrokeLineCap) {
            case 0: {
                this.pack |= 0;
                break;
            }
            case 1: {
                this.pack |= 0x10;
                break;
            }
            default: {
                this.pack |= 0x20;
            }
        }
    }

    public int getStrokeLineJoin() {
        switch (this.pack & 0xC) {
            case 0: {
                return 0;
            }
            case 4: {
                return 1;
            }
        }
        return 2;
    }

    public void setStrokeLineJoin(int newStrokeLineJoin) {
        this.pack &= 0xFFFFFFF3;
        switch (newStrokeLineJoin) {
            case 0: {
                this.pack |= 0;
                break;
            }
            case 1: {
                this.pack |= 4;
                break;
            }
            default: {
                this.pack |= 8;
            }
        }
    }

    public float getStrokeWidth() {
        return (float)this.strokeWidth / 65536.0f;
    }

    public void setStrokeWidth(float newStrokeWidth) {
        this.strokeWidth = (int)(newStrokeWidth * 65536.0f);
    }

    public float getStrokeMiterLimit() {
        return (float)this.strokeMiterLimit / 65536.0f;
    }

    public void setStrokeMiterLimit(float newStrokeMiterLimit) {
        this.strokeMiterLimit = (int)(newStrokeMiterLimit * 65536.0f);
    }

    public float getStrokeDashOffset() {
        return (float)this.strokeDashOffset / 65536.0f;
    }

    public void setStrokeDashOffset(float newStrokeDashOffset) {
        this.strokeDashOffset = (int)(newStrokeDashOffset * 65536.0f);
    }

    public void setVisibility(boolean newVisibility) {
        this.pack = newVisibility ? (this.pack |= 2) : (this.pack &= 0xFFFFFFFD);
    }

    public boolean getVisibility() {
        return (this.pack & 2) == 2;
    }

    public void setDisplay(boolean newDisplay) {
        this.pack = newDisplay ? (this.pack |= 1) : (this.pack &= 0xFFFFFFFE);
    }

    public boolean getDisplay() {
        return (this.pack & 1) == 1;
    }

    public String[] getFontFamily() {
        return this.fontFamily;
    }

    public void setFontFamily(String[] newFontFamily) {
        this.fontFamily = newFontFamily;
    }

    public float getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(float newFontSize) {
        this.fontSize = newFontSize;
    }

    public int getFontStyle() {
        switch (this.pack & 0x60000000) {
            case 0: {
                return 1;
            }
            case 0x40000000: {
                return 4;
            }
        }
        return 2;
    }

    public void setFontStyle(int newFontStyle) {
        this.pack &= 0x9FFFFFFF;
        switch (newFontStyle) {
            case 1: {
                this.pack |= 0;
                break;
            }
            case 4: {
                this.pack |= 0x40000000;
                break;
            }
            default: {
                this.pack |= 0x60000000;
            }
        }
    }

    public int getFontWeight() {
        switch (this.pack & 0x1E000000) {
            case 0: {
                return 1;
            }
            case 0x2000000: {
                return 2;
            }
            case 0x4000000: {
                return 4;
            }
            case 0x6000000: {
                return 8;
            }
            case 0x8000000: {
                return 16;
            }
            case 0xA000000: {
                return 32;
            }
            case 0xC000000: {
                return 64;
            }
            case 0xE000000: {
                return 128;
            }
        }
        return 256;
    }

    public void setFontWeight(int newFontWeight) {
        this.pack &= 0xE1FFFFFF;
        switch (newFontWeight) {
            case 1: {
                this.pack |= 0;
                break;
            }
            case 2: {
                this.pack |= 0x2000000;
                break;
            }
            case 4: {
                this.pack |= 0x4000000;
                break;
            }
            case 8: {
                this.pack |= 0x6000000;
                break;
            }
            case 16: {
                this.pack |= 0x8000000;
                break;
            }
            case 32: {
                this.pack |= 0xA000000;
                break;
            }
            case 64: {
                this.pack |= 0xC000000;
                break;
            }
            case 128: {
                this.pack |= 0xE000000;
                break;
            }
            default: {
                this.pack |= 0x10000000;
            }
        }
    }

    public int getTextAnchor() {
        switch (this.pack & 0x1800000) {
            case 0x800000: {
                return 0;
            }
            case 0: {
                return 1;
            }
        }
        return 2;
    }

    public void setTextAnchor(int newTextAnchor) {
        this.pack &= 0xFE7FFFFF;
        switch (newTextAnchor) {
            case 0: {
                this.pack |= 0x800000;
                break;
            }
            case 1: {
                this.pack |= 0;
                break;
            }
            default: {
                this.pack |= 0x1000000;
            }
        }
    }

    public RenderContext save() {
        return new RenderContext(this);
    }

    int computeStrokeDashOffset() {
        int sdo;
        if (this.strokeDashArray == null) {
            return 0;
        }
        if (this.strokeDashOffset >= 0) {
            return this.strokeDashOffset;
        }
        int length = 0;
        for (int i = 0; i < this.strokeDashArray.length; ++i) {
            length += this.strokeDashArray[i];
        }
        if (length <= 0) {
            return 0;
        }
        for (sdo = this.strokeDashOffset; sdo < 0; sdo += length) {
        }
        return sdo;
    }
}

