/*
 * Decompiled with CFR 0.152.
 */
package com.sun.perseus.j2d;

import com.sun.perseus.j2d.Tile;
import com.sun.pisces.PathSink;

class TileSink
extends PathSink {
    protected int minX;
    protected int minY;
    protected int maxX;
    protected int maxY;

    TileSink() {
    }

    public void reset() {
        this.minX = Integer.MAX_VALUE;
        this.minY = Integer.MAX_VALUE;
        this.maxX = Integer.MIN_VALUE;
        this.maxY = Integer.MIN_VALUE;
    }

    public void moveTo(int x0, int y0) {
        this.checkPoint(x0, y0);
    }

    void checkPoint(int x0, int y0) {
        if (x0 < this.minX) {
            this.minX = x0;
        } else if (x0 > this.maxX) {
            this.maxX = x0;
        }
        if (y0 < this.minY) {
            this.minY = y0;
        } else if (y0 > this.maxY) {
            this.maxY = y0;
        }
    }

    public void lineJoin() {
    }

    public void lineTo(int x1, int y1) {
        this.checkPoint(x1, y1);
    }

    public void close() {
    }

    public void end() {
    }

    public void quadTo(int x1, int y1, int x2, int y2) {
        this.checkPoint(x1, y1);
        this.checkPoint(x2, y2);
    }

    public void cubicTo(int x1, int y1, int x2, int y2, int x3, int y3) {
        this.checkPoint(x1, y1);
        this.checkPoint(x2, y2);
        this.checkPoint(x3, y3);
    }

    public void setTile(Tile tile) {
        tile.x = this.minX >> 16;
        tile.y = this.minY >> 16;
        tile.maxX = (this.maxX >> 16) - 1;
        tile.maxY = (this.maxY >> 16) - 1;
        if (this.minX < 0 && (this.minX & 0xFFFF) != 0) {
            --tile.x;
        }
        if (this.minY < 0 && (this.minX & 0xFFFF) != 0) {
            --tile.y;
        }
        if (this.maxX > 0 && (this.maxX & 0xFFFF) != 0) {
            ++tile.maxX;
        }
        if (this.maxY > 0 && (this.maxY & 0xFFFF) != 0) {
            ++tile.maxY;
        }
    }
}

