/*
 * Decompiled with CFR 0.152.
 */
package com.sun.perseus.midp;

import com.sun.perseus.j2d.RenderGraphics;
import com.sun.perseus.midp.Messages;
import com.sun.perseus.model.CanvasUpdateListener;
import com.sun.perseus.model.DocumentNode;
import com.sun.perseus.model.ModelEvent;
import com.sun.perseus.model.ModelNode;
import com.sun.perseus.model.SMILSample;
import com.sun.perseus.model.SimpleCanvasManager;
import com.sun.perseus.model.Time;
import com.sun.perseus.util.RunnableQueue;
import com.sun.pisces.GraphicsSurfaceDestination;
import com.sun.pisces.NativeSurface;
import com.sun.pisces.PiscesRenderer;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Graphics;
import javax.microedition.m2g.SVGEventListener;

class SVGCanvas
extends Canvas
implements CanvasUpdateListener {
    public static final int CLEAR_COLOR = -1;
    public static final int STATE_STOPPED = 1;
    public static final int STATE_PLAYING = 2;
    public static final int STATE_PAUSED = 3;
    public static final int SMIL_ANIMATION_FRAME_LENGTH = 1000;
    protected int lastX;
    protected int lastY;
    protected boolean lastWasPressed;
    protected int state = 1;
    protected SimpleCanvasManager canvasManager;
    protected DocumentNode documentNode;
    protected NativeSurface offscreen;
    protected GraphicsSurfaceDestination gsd;
    protected int offscreenWidth;
    protected int offscreenHeight;
    protected PiscesRenderer pr;
    protected RenderGraphics rg;
    protected SVGEventListener svgEventListener;
    protected RunnableQueue updateQueue = null;
    protected SMILSample smilSample = null;
    protected SMILSample.DocumentWallClock clock = null;
    protected float timeIncrement = 0.1f;
    protected ModelNode lastMouseTarget = null;
    private boolean ignoreCanvasUpdate = false;

    public SVGCanvas(DocumentNode documentNode) {
        if (documentNode == null) {
            throw new NullPointerException();
        }
        if (!documentNode.isLoaded()) {
            throw new IllegalStateException();
        }
        this.documentNode = documentNode;
        this.updateQueue = RunnableQueue.getDefault();
        documentNode.setUpdateQueue(this.updateQueue);
        this.buildOffscreen(1, 1);
        this.canvasManager = new SimpleCanvasManager(this.rg, documentNode, this);
        this.canvasManager.turnOff();
        documentNode.setRunnableHandler(this.canvasManager);
        this.clock = new SMILSample.DocumentWallClock(documentNode);
        this.smilSample = new SMILSample(documentNode, this.clock);
        documentNode.initializeTimingEngine();
        documentNode.sample(new Time(0L));
        documentNode.applyAnimations();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paint(Graphics g) {
        this.checkOffscreen();
        int x = g.getClipX();
        int y = g.getClipY();
        int w = g.getClipWidth();
        int h = g.getClipHeight();
        Object object = this.canvasManager.lock;
        synchronized (object) {
            if (x != 0 || y != 0 || w != this.documentNode.getWidth() || h != this.documentNode.getHeight()) {
                g.setColor(-1);
                g.fillRect(x, y, w, h);
            }
            if (this.gsd == null) {
                this.gsd = new GraphicsSurfaceDestination(g);
            }
            this.gsd.drawSurface(this.offscreen, 0, 0, 0, 0, this.offscreenWidth, this.offscreenHeight, 1.0f);
            this.canvasManager.consume();
        }
    }

    protected void checkOffscreen() {
        if (this.offscreen == null) {
            this.buildOffscreen(this.getWidth(), this.getHeight());
        } else {
            int width = this.getWidth();
            int height = this.getHeight();
            if (width > this.documentNode.getWidth()) {
                width = this.documentNode.getWidth();
            }
            if (height > this.documentNode.getHeight()) {
                height = this.documentNode.getHeight();
            }
            if (width != this.offscreenWidth || height != this.offscreenHeight) {
                this.buildOffscreen(width, height);
            }
        }
    }

    protected void buildOffscreen(final int width, final int height) {
        if (width > 0 && height > 0) {
            this.offscreen = new NativeSurface(width, height);
            this.offscreenWidth = width;
            this.offscreenHeight = height;
        } else {
            if (this.offscreenWidth == 1 && this.offscreenHeight == 1) {
                return;
            }
            this.offscreen = new NativeSurface(1, 1);
            this.offscreenWidth = 1;
            this.offscreenHeight = 1;
        }
        this.pr = new PiscesRenderer(this.offscreen, this.offscreenWidth, this.offscreenHeight, 0, this.offscreenWidth, 1, 2);
        this.rg = new RenderGraphics(this.pr, this.offscreenWidth, this.offscreenHeight);
        if (this.canvasManager != null) {
            try {
                this.updateQueue.invokeAndWait(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        Object object = SVGCanvas.this.canvasManager.lock;
                        synchronized (object) {
                            SVGCanvas.this.documentNode.setSize(width, height);
                            SVGCanvas.this.canvasManager.setRenderGraphics(SVGCanvas.this.rg);
                            SVGCanvas.this.canvasManager.consume();
                        }
                        SVGCanvas.this.ignoreCanvasUpdate = true;
                        SVGCanvas.this.canvasManager.updateCanvas();
                        SVGCanvas.this.ignoreCanvasUpdate = false;
                    }
                }, null);
            }
            catch (InterruptedException ie) {
                ie.printStackTrace();
            }
        } else {
            this.pr.setColor(255, 255, 255);
            this.pr.clearRect(0, 0, this.offscreenWidth, this.offscreenHeight);
        }
    }

    public void updateComplete(Object canvasManager) {
        if (!this.ignoreCanvasUpdate) {
            this.repaint(0, 0, this.documentNode.getWidth(), this.documentNode.getHeight());
        }
    }

    public void initialLoadComplete(Exception e) {
        if (e != null) {
            e.printStackTrace();
        }
    }

    protected void pointerPressed(int x, int y) {
        if (this.svgEventListener != null) {
            this.svgEventListener.pointerPressed(x, y);
        }
        this.lastX = x;
        this.lastY = y;
        this.lastWasPressed = true;
        float[] pt = new float[]{x, y};
        this.dispatchPointerEvent("mousedown", pt);
    }

    protected void pointerReleased(int x, int y) {
        if (this.svgEventListener != null) {
            this.svgEventListener.pointerReleased(x, y);
        }
        float[] pt = new float[]{x, y};
        this.dispatchPointerEvent("mouseup", pt);
        if (this.lastWasPressed && this.lastX == x && this.lastY == y) {
            this.dispatchPointerEvent("click", pt);
        }
        this.lastWasPressed = false;
    }

    protected void dispatchPointerEvent(final String eventType, final float[] pt) {
        if (this.state == 1) {
            return;
        }
        this.invokeLater(new Runnable(){

            public void run() {
                ModelNode target = SVGCanvas.this.documentNode.nodeHitAt(pt);
                if (target == null) {
                    target = SVGCanvas.this.documentNode;
                }
                if (SVGCanvas.this.lastMouseTarget != target) {
                    ModelEvent e;
                    if (SVGCanvas.this.lastMouseTarget != null && SVGCanvas.this.lastMouseTarget != SVGCanvas.this.documentNode) {
                        e = new ModelEvent("mouseout", SVGCanvas.this.lastMouseTarget);
                        SVGCanvas.this.documentNode.dispatchEvent(e);
                    }
                    e = new ModelEvent("mouseover", target);
                    SVGCanvas.this.documentNode.dispatchEvent(e);
                    SVGCanvas.this.lastMouseTarget = target;
                }
                ModelEvent evt = new ModelEvent(eventType, target);
                SVGCanvas.this.documentNode.dispatchEvent(evt);
            }
        });
    }

    protected void keyPressed(int keyCode) {
        if (this.svgEventListener != null) {
            this.svgEventListener.keyPressed(keyCode);
        }
        this.dispatchKeyEvent("keydown", keyCode);
    }

    protected void dispatchKeyEvent(final String eventType, final int keyCode) {
        Runnable r = new Runnable(){

            public void run() {
                SVGCanvas.this.documentNode.dispatchEvent(new ModelEvent(eventType, SVGCanvas.this.documentNode, (char)keyCode));
            }
        };
        if (this.state != 1) {
            this.invokeLater(r);
        }
    }

    protected void keyReleased(int keyCode) {
        if (this.svgEventListener != null) {
            this.svgEventListener.keyReleased(keyCode);
        }
        this.dispatchKeyEvent("keyup", keyCode);
    }

    protected void sizeChanged(int w, int h) {
        if (this.svgEventListener != null) {
            this.svgEventListener.sizeChanged(w, h);
        }
    }

    protected void hideNotify() {
        if (this.svgEventListener != null) {
            this.svgEventListener.hideNotify();
        }
    }

    protected void showNotify() {
        if (this.svgEventListener != null) {
            this.svgEventListener.showNotify();
        }
    }

    public void setSVGEventListener(SVGEventListener svgEventListener) {
        this.svgEventListener = svgEventListener;
    }

    public void setTimeIncrement(float timeIncrement) {
        if (timeIncrement <= 0.0f) {
            throw new IllegalArgumentException();
        }
        this.timeIncrement = timeIncrement;
        if (this.state == 2) {
            this.updateQueue.unschedule(this.smilSample);
            this.updateQueue.scheduleAtFixedRate(this.smilSample, this.canvasManager, (long)(1000.0f * timeIncrement));
        }
    }

    public float getTimeIncrement() {
        return this.timeIncrement;
    }

    public void play() {
        if (this.state == 2) {
            throw new IllegalStateException(Messages.formatMessage(Messages.ERROR_INVALID_STATE, new Object[]{this.getClass().getName(), this.stateToString(), "play()", "stopped, paused"}));
        }
        this.updateQueue.preemptLater(new Runnable(){

            public void run() {
                SVGCanvas.this.documentNode.setPlaying(true);
            }
        }, this.canvasManager);
        this.clock.start();
        this.updateQueue.scheduleAtFixedRate(this.smilSample, this.canvasManager, (long)(1000.0f * this.timeIncrement));
        this.state = 2;
        this.canvasManager.turnOn();
    }

    public void pause() {
        if (this.state != 2) {
            throw new IllegalStateException(Messages.formatMessage(Messages.ERROR_INVALID_STATE, new Object[]{this.getClass().getName(), this.stateToString(), "pause()", "playing"}));
        }
        this.state = 3;
        this.updateQueue.preemptLater(new Runnable(){

            public void run() {
                SVGCanvas.this.documentNode.setPlaying(false);
            }
        }, this.canvasManager);
        this.updateQueue.unschedule(this.smilSample);
        this.canvasManager.turnOn();
    }

    public void stop() {
        if (this.state == 1) {
            throw new IllegalStateException(Messages.formatMessage(Messages.ERROR_INVALID_STATE, new Object[]{this.getClass().getName(), this.stateToString(), "stop()", "paused, playing"}));
        }
        this.state = 1;
        this.updateQueue.unschedule(this.smilSample);
        this.documentNode.setPlaying(false);
        this.canvasManager.consume();
        this.canvasManager.turnOff();
    }

    void invokeAndWait(Runnable runnable) throws InterruptedException {
        if (runnable == null) {
            throw new NullPointerException();
        }
        if (this.state == 1) {
            throw new IllegalStateException(Messages.formatMessage(Messages.ERROR_INVALID_STATE, new Object[]{this.getClass().getName(), this.stateToString(), "invokeAndWait()", "paused, playing"}));
        }
        this.updateQueue.invokeAndWait(runnable, this.canvasManager);
    }

    void invokeLater(Runnable runnable) {
        if (runnable == null) {
            throw new NullPointerException();
        }
        if (this.state == 1) {
            throw new IllegalStateException(Messages.formatMessage(Messages.ERROR_INVALID_STATE, new Object[]{this.getClass().getName(), this.stateToString(), "invokeLater()", "paused, playing"}));
        }
        this.updateQueue.invokeLater(runnable, this.canvasManager);
    }

    String stateToString() {
        switch (this.state) {
            case 2: {
                return "playing";
            }
            case 3: {
                return "paused";
            }
        }
        return "stopped";
    }
}

