/*
 * Decompiled with CFR 0.152.
 */
package com.sun.perseus.model;

import com.sun.perseus.j2d.Box;
import com.sun.perseus.j2d.RenderGraphics;
import com.sun.perseus.j2d.Tile;
import com.sun.perseus.j2d.Transform;
import com.sun.perseus.model.AbstractRenderingNode;
import com.sun.perseus.model.CompositeGraphicsNodeProxy;
import com.sun.perseus.model.DirtyAreaManager;
import com.sun.perseus.model.ElementNode;
import com.sun.perseus.model.RenderingManager;
import org.w3c.dom.svg.SVGRect;

public class AbstractRenderingNodeProxy
extends CompositeGraphicsNodeProxy {
    protected RenderingManager renderingManager;

    protected AbstractRenderingNodeProxy(AbstractRenderingNode proxiedNode) {
        super(proxiedNode);
        if (DirtyAreaManager.ON) {
            this.renderingManager = new RenderingManager(this);
        }
    }

    protected void clearLayouts() {
    }

    public SVGRect getBBox() {
        return this.addNodeBBox(null, null);
    }

    Box addBBox(Box bbox, Transform t) {
        return this.addNodeBBox(bbox, t);
    }

    Box addNodeBBox(Box bbox, Transform t) {
        return this.proxied.addNodeBBox(bbox, t);
    }

    protected final void computeRenderingTile(Tile tile) {
        ((AbstractRenderingNode)this.proxied).computeRenderingTile(tile, this.txf, this);
    }

    final void renderingDirty() {
        if (DirtyAreaManager.ON) {
            this.renderingManager.dirty();
        }
    }

    protected void recomputeTransformState(Transform parentTransform) {
        super.recomputeTransformState(parentTransform);
        this.renderingDirty();
    }

    protected void setProxied(ElementNode newProxied) {
        if (this.proxied == newProxied) {
            return;
        }
        super.setProxied(newProxied);
        this.renderingDirty();
    }

    public boolean hasNodeRendering() {
        return true;
    }

    public void paint(RenderGraphics rg) {
        if (this.canRenderState != 0) {
            return;
        }
        if (DirtyAreaManager.ON) {
            Tile primitiveTile = this.getRenderingTile();
            if (primitiveTile == null || rg.getRenderingTile().isHit(primitiveTile)) {
                ((AbstractRenderingNode)this.proxied).paintRendered(rg, this, this, this.txf);
                this.nodeRendered();
            }
        } else {
            ((AbstractRenderingNode)this.proxied).paintRendered(rg, this, this, this.txf);
        }
    }

    protected void nodeRendered() {
        if (DirtyAreaManager.ON) {
            this.renderingManager.rendered();
        }
    }

    public void modifyingProxied() {
        super.modifyingProxied();
        this.renderingDirty();
    }

    protected final Tile getRenderingTile() {
        return this.renderingManager.getRenderingTile();
    }

    protected Tile getLastRenderedTile() {
        return this.renderingManager.getLastRenderedTile();
    }

    protected void clearLastRenderedTile() {
        this.renderingManager.clearLastRenderedTile();
    }

    void nodeHookedInDocumentTree() {
        this.renderingDirty();
    }

    void nodeUnhookedFromDocumentTree() {
        this.renderingDirty();
    }

    public void setDisplay(boolean newDisplay) {
        super.setDisplay(newDisplay);
        this.renderingDirty();
    }

    public void setVisibility(boolean newVisibility) {
        super.setVisibility(newVisibility);
        this.renderingDirty();
    }
}

