/*
 * Decompiled with CFR 0.152.
 */
package com.sun.perseus.model;

import com.sun.perseus.j2d.RenderGraphics;
import com.sun.perseus.model.CanvasUpdateListener;
import com.sun.perseus.model.DocumentNode;
import com.sun.perseus.model.ModelNode;
import com.sun.perseus.model.SMILSample;
import com.sun.perseus.model.SimpleCanvasManager;
import java.io.InputStream;

public class CanvasManager
extends SimpleCanvasManager {
    protected boolean loading;
    protected ModelNode progressiveNode = null;
    protected ModelNode needLoadNode = null;
    protected SMILSample sampler = null;
    protected long smilRate = 40L;

    public CanvasManager(RenderGraphics rg, DocumentNode documentNode, CanvasUpdateListener canvasUpdateListener) {
        super(rg, documentNode, canvasUpdateListener);
    }

    public void nodeInserted(ModelNode node) {
        if (this.loading) {
            if (this.needLoadNode == null) {
                if (node.parent.loaded) {
                    this.fullPaint();
                } else if (!node.getPaintNeedsLoad()) {
                    if (this.progressiveNode != null) {
                        this.needRepaint = true;
                    } else {
                        this.progressiveNode = node;
                    }
                } else {
                    this.needLoadNode = node;
                }
            } else {
                ModelNode parent = node;
                while (parent != null && parent != this.needLoadNode) {
                    parent = parent.parent;
                }
                if (parent == null) {
                    this.needRepaint = true;
                }
            }
        } else {
            this.needRepaint = true;
        }
    }

    boolean isNeedLoadNodeOrChild(ModelNode node) {
        ModelNode parent = node;
        while (parent != null && parent != this.needLoadNode) {
            parent = parent.parent;
        }
        return parent != null;
    }

    public void modifyingNode(ModelNode node) {
        if (!this.isNeedLoadNodeOrChild(node) && (node.hasNodeRendering() || node.hasDescendants()) && node.canRenderState == 0) {
            this.needRepaint = true;
        }
    }

    public void modifiedNode(ModelNode node) {
        if (!this.loading) {
            if (!this.needRepaint && (node.hasNodeRendering() || node.hasDescendants())) {
                this.needRepaint = true;
            }
        } else {
            if (!node.hasNodeRendering() && !node.hasDescendants()) {
                return;
            }
            if (this.needLoadNode != null) {
                if (node == this.needLoadNode) {
                    return;
                }
                ModelNode parent = node.parent;
                while (parent != null) {
                    if (parent == this.needLoadNode) {
                        return;
                    }
                    parent = parent.parent;
                }
                this.needRepaint = true;
            } else if (!this.needRepaint) {
                if (this.progressiveNode != null && this.progressiveNode != node) {
                    this.needRepaint = true;
                }
                this.progressiveNode = node;
            }
        }
    }

    public void loadComplete(ModelNode node) {
        if (node instanceof DocumentNode) {
            this.loading = false;
            this.canvasUpdateListener.initialLoadComplete(null);
            if (this.documentNode.updateQueue != null && this.documentNode.timeContainerRootSupport.timedElementChildren.size() > 0) {
                SMILSample.DocumentWallClock clock = new SMILSample.DocumentWallClock(this.documentNode);
                this.sampler = new SMILSample(this.documentNode, clock);
                this.documentNode.updateQueue.scheduleAtFixedRate(this.sampler, this, this.smilRate);
                this.documentNode.timeContainerRootSupport.initialize();
                clock.start();
            }
        } else if (node == this.needLoadNode) {
            if (this.progressiveNode != null) {
                throw new Error();
            }
            this.progressiveNode = node;
            this.needLoadNode = null;
        }
        this.updateCanvas();
    }

    public void loadingFailed(DocumentNode documentNode, Exception error) {
        this.loading = false;
        this.canvasUpdateListener.initialLoadComplete(error);
    }

    public void loadStarting(DocumentNode documentNode, InputStream is) {
        this.loading = true;
    }

    public void loadBegun(ModelNode node) {
        this.updateCanvas();
    }

    public void textInserted(ModelNode node) {
    }

    public SMILSample getSampler() {
        return this.sampler;
    }

    public void updateCanvas() {
        if (!this.loading) {
            if (this.needRepaint) {
                if (this.canvasConsumed) {
                    this.fullPaint();
                    this.needRepaint = false;
                } else if (this.documentNode.getUpdateQueue().getSize() == 0) {
                    this.documentNode.getUpdateQueue().preemptLater(new Runnable(){

                        public void run() {
                        }
                    }, this);
                }
            }
        } else {
            if (this.needRepaint) {
                if (this.needLoadNode == null) {
                    this.fullPaint();
                } else {
                    this.partialPaint(this.documentNode);
                    this.canvasUpdateListener.updateComplete(this);
                }
            } else if (this.progressiveNode != null) {
                this.progressivePaint(this.progressiveNode);
            }
            this.needRepaint = false;
            this.progressiveNode = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void progressivePaint(ModelNode node) {
        if (node.hasDescendants()) {
            this.fullNodePaint(node);
        } else if (node.hasNodeRendering() && node.canRenderState == 0) {
            Object object = this.lock;
            synchronized (object) {
                if (!this.canvasConsumed) {
                    try {
                        this.lock.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                node.paint(this.rg);
                this.canvasConsumed = false;
                this.canvasUpdateListener.updateComplete(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fullNodePaint(ModelNode node) {
        if (node.canRenderState == 0) {
            Object object = this.lock;
            synchronized (object) {
                if (!this.canvasConsumed) {
                    try {
                        this.lock.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                node.paint(this.rg);
                this.canvasConsumed = false;
                this.canvasUpdateListener.updateComplete(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void partialPaint(ModelNode node) {
        if (node == this.needLoadNode || node.canRenderState != 0) {
            return;
        }
        if (node.hasNodeRendering()) {
            Object object = this.lock;
            synchronized (object) {
                node.paint(this.rg);
            }
        } else {
            ModelNode child = node.getFirstExpandedChild();
            while (child != null) {
                this.partialPaint(child);
                child = child.nextSibling;
            }
            child = node.getFirstChildNode();
            while (child != null) {
                this.partialPaint(child);
                child = child.nextSibling;
            }
        }
    }
}

