/*
 * Decompiled with CFR 0.152.
 */
package com.sun.perseus.model;

import com.sun.perseus.j2d.GraphicsProperties;
import com.sun.perseus.j2d.PaintServer;
import com.sun.perseus.j2d.PaintTarget;
import com.sun.perseus.j2d.RGB;
import com.sun.perseus.j2d.Transform;
import com.sun.perseus.model.CompositeGraphicsNode;
import com.sun.perseus.model.ElementNodeProxy;
import com.sun.perseus.model.ModelNode;
import org.w3c.dom.svg.SVGRect;

public class CompositeGraphicsNodeProxy
extends ElementNodeProxy
implements GraphicsProperties,
PaintTarget {
    protected Transform txf = null;
    protected Transform inverseTxf = null;
    protected RGB color = CompositeGraphicsNode.INITIAL_COLOR;
    protected PaintServer fill = CompositeGraphicsNode.INITIAL_FILL;
    protected PaintServer stroke = CompositeGraphicsNode.INITIAL_STROKE;
    protected int fillRule = 1;
    protected float strokeWidth = 1.0f;
    protected float strokeMiterLimit = 4.0f;
    protected float[] strokeDashArray = CompositeGraphicsNode.INITIAL_STROKE_DASH_ARRAY;
    protected float strokeDashOffset = 0.0f;
    protected int pack = 115631171;

    protected CompositeGraphicsNodeProxy(CompositeGraphicsNode proxiedNode) {
        super(proxiedNode);
        this.canRenderState &= 0xFFFFFFFE;
        this.canRenderState |= proxiedNode.canRenderState & 0x7EE;
        this.fill = proxiedNode.fill;
        this.stroke = proxiedNode.stroke;
        this.color = proxiedNode.color;
        this.pack = proxiedNode.pack;
        this.strokeWidth = proxiedNode.strokeWidth;
        this.strokeMiterLimit = proxiedNode.strokeMiterLimit;
        this.strokeDashArray = proxiedNode.strokeDashArray;
        this.strokeDashOffset = proxiedNode.strokeDashOffset;
    }

    protected boolean contributeBBox() {
        return (this.pack & 1) != 0;
    }

    void recomputeInheritedProperties() {
        ModelNode p = this.ownerDocument;
        if (this.parent != null) {
            p = this.parent;
        }
        this.recomputePropertyState(1, p.getPropertyState(1));
        this.recomputePropertyState(2, p.getPropertyState(2));
        this.recomputePropertyState(4, p.getPropertyState(4));
        this.recomputePackedPropertyState(8, p.getPackedPropertyState(8));
        this.recomputeFloatPropertyState(16, p.getFloatPropertyState(16));
        this.recomputePackedPropertyState(32, p.getPackedPropertyState(32));
        this.recomputePackedPropertyState(64, p.getPackedPropertyState(64));
        this.recomputeFloatPropertyState(128, p.getFloatPropertyState(128));
        this.recomputePropertyState(256, p.getPropertyState(256));
        this.recomputeFloatPropertyState(512, p.getFloatPropertyState(512));
        this.recomputePackedPropertyState(1024, p.getPackedPropertyState(1024));
        this.recomputePackedPropertyState(2048, p.getPackedPropertyState(2048));
        this.recomputePackedPropertyState(4096, p.getPackedPropertyState(4096));
        this.recomputePackedPropertyState(8192, p.getPackedPropertyState(8192));
    }

    public SVGRect getBBox() {
        return null;
    }

    protected Object getPropertyState(int propertyIndex) {
        switch (propertyIndex) {
            case 1: {
                return this.fill;
            }
            case 2: {
                return this.stroke;
            }
            case 4: {
                return this.color;
            }
            case 256: {
                return this.getStrokeDashArray();
            }
        }
        return super.getPropertyState(propertyIndex);
    }

    protected float getFloatPropertyState(int propertyIndex) {
        switch (propertyIndex) {
            case 16: {
                return this.strokeWidth;
            }
            case 128: {
                return this.strokeMiterLimit;
            }
            case 512: {
                return this.strokeDashOffset;
            }
        }
        return super.getFloatPropertyState(propertyIndex);
    }

    protected int getPackedPropertyState(int propertyIndex) {
        switch (propertyIndex) {
            case 8: {
                return this.pack & 0x40;
            }
            case 32: {
                return this.pack & 0xC;
            }
            case 64: {
                return this.pack & 0x30;
            }
            case 1024: {
                return this.pack & 1;
            }
            case 2048: {
                return this.pack & 2;
            }
            case 4096: {
                return this.pack & 0x7F80;
            }
            case 8192: {
                return this.pack & 0x7F8000;
            }
        }
        return super.getPackedPropertyState(propertyIndex);
    }

    protected boolean isPropertyState(int propertyIndex, Object propertyValue) {
        switch (propertyIndex) {
            case 1: {
                return this.fill == propertyValue;
            }
            case 2: {
                return this.stroke == propertyValue;
            }
            case 4: {
                return this.color == propertyValue;
            }
            case 256: {
                return this.strokeDashArray == propertyValue;
            }
        }
        return super.isPropertyState(propertyIndex, propertyValue);
    }

    protected boolean isFloatPropertyState(int propertyIndex, float propertyValue) {
        switch (propertyIndex) {
            case 16: {
                return this.strokeWidth == propertyValue;
            }
            case 128: {
                return this.strokeMiterLimit == propertyValue;
            }
            case 512: {
                return this.strokeDashOffset == propertyValue;
            }
        }
        return super.isFloatPropertyState(propertyIndex, propertyValue);
    }

    protected boolean isPackedPropertyState(int propertyIndex, int propertyValue) {
        switch (propertyIndex) {
            case 8: {
                return propertyValue == (this.pack & 0x40);
            }
            case 32: {
                return propertyValue == (this.pack & 0xC);
            }
            case 64: {
                return propertyValue == (this.pack & 0x30);
            }
            case 1024: {
                return propertyValue == (this.pack & 1);
            }
            case 2048: {
                return propertyValue == (this.pack & 1);
            }
            case 4096: {
                return propertyValue == (this.pack & 0x7F80);
            }
            case 8192: {
                return propertyValue == (this.pack & 0x7F8000);
            }
        }
        return super.isPackedPropertyState(propertyIndex, propertyValue);
    }

    protected void setPropertyState(int propertyIndex, Object propertyValue) {
        switch (propertyIndex) {
            case 1: {
                this.setFill((PaintServer)propertyValue);
                break;
            }
            case 2: {
                this.setStroke((PaintServer)propertyValue);
                break;
            }
            case 4: {
                this.setColor((RGB)propertyValue);
                break;
            }
            case 256: {
                this.setStrokeDashArray((float[])propertyValue);
                break;
            }
            default: {
                super.setPropertyState(propertyIndex, propertyValue);
            }
        }
    }

    protected void setFloatPropertyState(int propertyIndex, float propertyValue) {
        switch (propertyIndex) {
            case 16: {
                this.setStrokeWidth(propertyValue);
                break;
            }
            case 128: {
                this.setStrokeMiterLimit(propertyValue);
                break;
            }
            case 512: {
                this.setStrokeDashOffset(propertyValue);
                break;
            }
            default: {
                super.setFloatPropertyState(propertyIndex, propertyValue);
            }
        }
    }

    protected void setPackedPropertyState(int propertyIndex, int propertyValue) {
        block0 : switch (propertyIndex) {
            case 8: {
                if (propertyValue == 0) {
                    this.setFillRule(0);
                    break;
                }
                this.setFillRule(1);
                break;
            }
            case 32: {
                switch (propertyValue) {
                    case 0: {
                        this.setStrokeLineJoin(0);
                        break block0;
                    }
                    case 4: {
                        this.setStrokeLineJoin(1);
                        break block0;
                    }
                }
                this.setStrokeLineJoin(2);
                break;
            }
            case 64: {
                switch (propertyValue) {
                    case 0: {
                        this.setStrokeLineCap(0);
                        break block0;
                    }
                    case 16: {
                        this.setStrokeLineCap(1);
                        break block0;
                    }
                }
                this.setStrokeLineCap(2);
                break;
            }
            case 1024: {
                if (propertyValue != 0) {
                    this.setDisplay(true);
                    break;
                }
                this.setDisplay(false);
                break;
            }
            case 2048: {
                if (propertyValue != 0) {
                    this.setVisibility(true);
                    break;
                }
                this.setVisibility(false);
                break;
            }
            case 4096: {
                this.setFillOpacity((float)(propertyValue >> 7) / 200.0f);
                break;
            }
            case 8192: {
                this.setStrokeOpacity((float)(propertyValue >> 15) / 200.0f);
                break;
            }
            default: {
                super.setPackedPropertyState(propertyIndex, propertyValue);
            }
        }
    }

    protected void recomputePropertyState(int propertyIndex, Object parentPropertyValue) {
        if (!((CompositeGraphicsNode)this.proxied).isInherited(propertyIndex) || this.isPropertyState(propertyIndex, parentPropertyValue)) {
            return;
        }
        this.setPropertyState(propertyIndex, parentPropertyValue);
        this.propagatePropertyState(propertyIndex, parentPropertyValue);
    }

    protected void recomputeFloatPropertyState(int propertyIndex, float parentPropertyValue) {
        if (!((CompositeGraphicsNode)this.proxied).isInherited(propertyIndex) || this.isFloatPropertyState(propertyIndex, parentPropertyValue)) {
            return;
        }
        this.setFloatPropertyState(propertyIndex, parentPropertyValue);
        this.propagateFloatPropertyState(propertyIndex, parentPropertyValue);
    }

    protected void recomputePackedPropertyState(int propertyIndex, int parentPropertyValue) {
        if (!((CompositeGraphicsNode)this.proxied).isInherited(propertyIndex) || this.isPackedPropertyState(propertyIndex, parentPropertyValue)) {
            return;
        }
        this.setPackedPropertyState(propertyIndex, parentPropertyValue);
        this.propagatePackedPropertyState(propertyIndex, parentPropertyValue);
    }

    protected void propagatePropertyState(int propertyIndex, Object parentPropertyValue) {
        ModelNode node = this.firstExpandedChild;
        while (node != null) {
            node.recomputePropertyState(propertyIndex, parentPropertyValue);
            node = node.nextSibling;
        }
    }

    protected void propagateFloatPropertyState(int propertyIndex, float parentPropertyValue) {
        ModelNode node = this.firstExpandedChild;
        while (node != null) {
            node.recomputeFloatPropertyState(propertyIndex, parentPropertyValue);
            node = node.nextSibling;
        }
    }

    protected void propagatePackedPropertyState(int propertyIndex, int parentPropertyValue) {
        ModelNode node = this.firstExpandedChild;
        while (node != null) {
            node.recomputePackedPropertyState(propertyIndex, parentPropertyValue);
            node = node.nextSibling;
        }
    }

    protected void proxiedPropertyStateChange(int propertyIndex, Object proxiedComputedValue) {
        if (!((CompositeGraphicsNode)this.proxied).isInherited(propertyIndex)) {
            this.setPropertyState(propertyIndex, proxiedComputedValue);
        } else {
            this.setPropertyState(propertyIndex, this.getInheritedPropertyState(propertyIndex));
        }
    }

    protected final void proxiedFloatPropertyStateChange(int propertyIndex, float proxiedComputedValue) {
        if (!((CompositeGraphicsNode)this.proxied).isInherited(propertyIndex)) {
            this.setFloatPropertyState(propertyIndex, proxiedComputedValue);
        } else {
            this.setFloatPropertyState(propertyIndex, this.getInheritedFloatPropertyState(propertyIndex));
        }
    }

    protected final void proxiedPackedPropertyStateChange(int propertyIndex, int proxiedComputedValue) {
        if (!((CompositeGraphicsNode)this.proxied).isInherited(propertyIndex)) {
            this.setPackedPropertyState(propertyIndex, proxiedComputedValue);
        } else {
            this.setPackedPropertyState(propertyIndex, this.getInheritedPackedPropertyState(propertyIndex));
        }
    }

    protected void recomputeTransformState(Transform parentTransform) {
        this.txf = this.proxied.appendTransform(parentTransform, this.txf);
        this.computeCanRenderTransformBit(this.txf);
        this.inverseTxf = null;
        this.recomputeTransformState(this.txf, this.firstExpandedChild);
    }

    public Transform getTransformState() {
        return this.txf;
    }

    public Transform getInverseTransformState() {
        if ((this.canRenderState & 0x10) == 0) {
            if (this.inverseTxf == null) {
                if (this.parent != null && this.txf == this.parent.getTransformState()) {
                    this.inverseTxf = this.parent.getInverseTransformState();
                } else {
                    this.inverseTxf = new Transform(null);
                    try {
                        this.inverseTxf = (Transform)this.txf.inverse(this.inverseTxf);
                    }
                    catch (Exception e) {
                        throw new Error();
                    }
                }
            }
        } else {
            this.inverseTxf = null;
        }
        return this.inverseTxf;
    }

    public PaintServer getFill() {
        return this.fill;
    }

    public void setFill(PaintServer newFill) {
        this.fill = newFill;
    }

    public PaintServer getStroke() {
        return this.stroke;
    }

    public void setStroke(PaintServer newStroke) {
        this.stroke = newStroke;
    }

    public RGB getColor() {
        return this.color;
    }

    public void setColor(RGB newColor) {
        this.color = newColor;
    }

    public int getFillRule() {
        if ((this.pack & 0x40) == 64) {
            return 1;
        }
        return 0;
    }

    public final void setFillRule(int newFillRule) {
        this.pack = newFillRule == 1 ? (this.pack |= 0x40) : (this.pack &= 0xFFFFFFBF);
    }

    public float getStrokeWidth() {
        return this.strokeWidth;
    }

    public void setStrokeWidth(float newStrokeWidth) {
        this.strokeWidth = newStrokeWidth;
    }

    public int getStrokeLineCap() {
        switch (this.pack & 0x30) {
            case 0: {
                return 0;
            }
            case 16: {
                return 1;
            }
        }
        return 2;
    }

    public void setStrokeLineCap(int newStrokeLineCap) {
        this.pack &= 0xFFFFFFCF;
        switch (newStrokeLineCap) {
            case 0: {
                this.pack |= 0;
                break;
            }
            case 1: {
                this.pack |= 0x10;
                break;
            }
            default: {
                this.pack |= 0x20;
            }
        }
    }

    public int getStrokeLineJoin() {
        switch (this.pack & 0xC) {
            case 0: {
                return 0;
            }
            case 4: {
                return 1;
            }
        }
        return 2;
    }

    public void setStrokeLineJoin(int newStrokeLineJoin) {
        this.pack &= 0xFFFFFFF3;
        switch (newStrokeLineJoin) {
            case 0: {
                this.pack |= 0;
                break;
            }
            case 1: {
                this.pack |= 4;
                break;
            }
            default: {
                this.pack |= 8;
            }
        }
    }

    public float getStrokeMiterLimit() {
        return this.strokeMiterLimit;
    }

    public void setStrokeMiterLimit(float newStrokeMiterLimit) {
        this.strokeMiterLimit = newStrokeMiterLimit;
    }

    public float getStrokeDashOffset() {
        return this.strokeDashOffset;
    }

    public void setStrokeDashOffset(float newStrokeDashOffset) {
        this.strokeDashOffset = newStrokeDashOffset;
    }

    public float[] getStrokeDashArray() {
        return this.strokeDashArray;
    }

    public void setStrokeDashArray(float[] newStrokeDashArray) {
        this.strokeDashArray = newStrokeDashArray;
    }

    public boolean getDisplay() {
        return (this.pack & 1) == 1;
    }

    public void setDisplay(boolean newDisplay) {
        this.pack = newDisplay ? (this.pack |= 1) : (this.pack &= 0xFFFFFFFE);
        this.computeCanRenderDisplayBit(newDisplay);
    }

    public boolean getVisibility() {
        return (this.pack & 2) == 2;
    }

    public void setVisibility(boolean newVisibility) {
        this.pack = newVisibility ? (this.pack |= 2) : (this.pack &= 0xFFFFFFFD);
    }

    public float getFillOpacity() {
        return (float)((this.pack & 0x7F80) >> 7) / 200.0f;
    }

    public void setFillOpacity(float newFillOpacity) {
        this.pack &= 0xFFFF807F;
        this.pack |= (int)(newFillOpacity * 200.0f) << 7 & 0x7F80;
    }

    public float getStrokeOpacity() {
        return (float)((this.pack & 0x7F8000) >> 15) / 200.0f;
    }

    public void setStrokeOpacity(float newStrokeOpacity) {
        this.pack &= 0xFF807FFF;
        this.pack |= (int)(newStrokeOpacity * 200.0f) << 15 & 0x7F8000;
    }

    public void onPaintServerUpdate(String paintType, PaintServer paintServer) {
    }
}

