/*
 * Decompiled with CFR 0.152.
 */
package com.sun.perseus.model;

import com.sun.perseus.model.Animation;
import com.sun.perseus.model.MotionSegment;
import com.sun.perseus.model.Segment;

class CompositeMotionSegment
implements MotionSegment {
    MotionSegment[] segments;
    float length;
    float[] nSegLength;

    CompositeMotionSegment() {
    }

    public Object[] getStart() {
        return this.segments[0].getStart();
    }

    public Object[] getEnd() {
        return this.segments[this.segments.length - 1].getEnd();
    }

    public void compute(float p, float[][] w) {
        int si = this.segments.length - 1;
        float prevSegLength = 0.0f;
        if (p < 1.0f) {
            for (si = 0; si < this.segments.length && !(p < this.nSegLength[si]); ++si) {
                prevSegLength = this.nSegLength[si];
            }
        } else if (si > 0) {
            prevSegLength = this.nSegLength[si - 1];
        }
        p = this.nSegLength[si] > prevSegLength ? (p - prevSegLength) / (this.nSegLength[si] - prevSegLength) : 1.0f;
        this.segments[si].compute(p, w);
    }

    public float getLength() {
        return this.length;
    }

    public void collapse(Segment seg, Animation anim) {
        CompositeMotionSegment cseg = (CompositeMotionSegment)seg;
        MotionSegment[] newSegments = new MotionSegment[this.segments.length + cseg.segments.length];
        System.arraycopy(this.segments, 0, newSegments, 0, this.segments.length);
        System.arraycopy(cseg.segments, 0, newSegments, this.segments.length, cseg.segments.length);
        this.segments = newSegments;
    }

    public void addToEnd(Object[] by) {
        this.segments[this.segments.length - 1].addToEnd(by);
    }

    public boolean isAdditive() {
        return this.segments[0].isAdditive();
    }

    public void setZeroStart() {
        this.segments[0].setZeroStart();
    }

    public void setStart(Object[] newStart) {
        this.segments[0].setStart(newStart);
    }

    public void initialize() {
        int si;
        int ns = this.segments.length;
        for (si = 0; si < ns; ++si) {
            this.segments[si].initialize();
        }
        this.length = 0.0f;
        this.nSegLength = new float[ns];
        for (si = 0; si < this.segments.length; ++si) {
            this.nSegLength[si] = this.segments[si].getLength();
            this.length += this.nSegLength[si];
        }
        if (this.length > 0.0f) {
            float curLength = 0.0f;
            for (int si2 = 0; si2 < ns - 1; ++si2) {
                this.nSegLength[si2] = (curLength += this.nSegLength[si2]) / this.length;
            }
        } else {
            for (si = 0; si < ns - 1; ++si) {
                this.nSegLength[si] = 0.0f;
            }
        }
        this.nSegLength[ns - 1] = 1.0f;
    }
}

