/*
 * Decompiled with CFR 0.152.
 */
package com.sun.perseus.model;

import com.sun.perseus.j2d.RGB;
import com.sun.perseus.j2d.RenderGraphics;
import com.sun.perseus.j2d.Tile;
import com.sun.perseus.model.ModelNode;
import com.sun.perseus.model.UpdateAdapter;
import com.sun.perseus.model.Viewport;
import java.util.Vector;

public class DirtyAreaManager
extends UpdateAdapter {
    public static boolean ON = false;
    public static final int DEFAULT_TILE_MIN_SIZE = 40;
    Vector dirtyNodes = new Vector();
    TileElement rootTile;
    Viewport vp;
    int tileMinSize = 40;
    int lastWidth = -1;
    int lastHeight = -1;
    RenderGraphics lastRG;

    public DirtyAreaManager(Viewport vp) {
        this.setViewport(vp);
    }

    public void setViewport(Viewport vp) {
        if (vp == this.vp) {
            return;
        }
        this.vp = vp;
        this.lastWidth = -1;
        this.lastHeight = -1;
    }

    public void setTileMinSize(int tileMinSize) {
        if (tileMinSize < 1) {
            throw new IllegalArgumentException();
        }
        this.tileMinSize = tileMinSize;
        this.lastWidth = -1;
        this.lastHeight = -1;
    }

    public void nodeInserted(ModelNode node) {
        if (!this.dirtyNodes.contains(node) && node.hasNodeRendering()) {
            this.dirtyNodes.addElement(node);
        }
    }

    public void modifyingNodeRendering(ModelNode node) {
        if (!this.dirtyNodes.contains(node)) {
            this.dirtyNodes.addElement(node);
        }
    }

    public TileElement getDirtyAreas(RenderGraphics rg) {
        int vw = this.vp.width;
        int vh = this.vp.height;
        if (this.lastWidth != vw || this.lastHeight != vh) {
            this.lastWidth = vw;
            this.lastHeight = vh;
            this.rootTile = vw >= 2 * this.tileMinSize && vh >= 2 * this.tileMinSize ? new TileQuadrant(null, this.tileMinSize, 0, 0, vw, vh) : new TileElement(null, 0, 0, vw, vh);
            this.dirtyNodes.removeAllElements();
            this.lastRG = rg;
            return this.rootTile;
        }
        if (this.lastRG != rg) {
            System.err.println(">>>> RenderGraphics changed");
            this.lastRG = rg;
            this.dirtyNodes.removeAllElements();
            return this.rootTile;
        }
        this.rootTile.clear();
        int nn = this.dirtyNodes.size();
        Object nb = null;
        ModelNode n = null;
        for (int i = 0; i < nn && !this.rootTile.hit; ++i) {
            n = (ModelNode)this.dirtyNodes.elementAt(i);
            this.rootTile.checkHit(n.getLastRenderedTile());
            n.clearLastRenderedTile();
            if (n.parent == null || n.canRenderState != 0) continue;
            this.rootTile.checkHit(n.getRenderingTile());
        }
        this.dirtyNodes.removeAllElements();
        return this.rootTile.getHitTiles(null);
    }

    public void refresh(ModelNode mn, RenderGraphics rg, RGB clearPaint) {
        TileElement dirtyAreaList;
        TileElement curTile = dirtyAreaList = this.getDirtyAreas(rg);
        boolean nTiles = false;
        while (curTile != null) {
            rg.setRenderingTile(curTile);
            rg.clearRect(curTile.x, curTile.y, curTile.maxX - curTile.x + 1, curTile.maxY - curTile.y + 1, clearPaint);
            mn.paint(rg);
            curTile = curTile.next;
        }
    }

    public static class TileQuadrant
    extends TileElement {
        TileElement[] children;

        public TileQuadrant(TileQuadrant parent, int tileMinSize, int x, int y, int width, int height) {
            super(parent, x, y, width, height);
            if (width < 2 * tileMinSize || height < 2 * tileMinSize) {
                throw new IllegalArgumentException();
            }
            int cw = width / 2;
            int ch = height / 2;
            if (width / 4 < tileMinSize || height / 4 < tileMinSize) {
                this.children = new TileElement[4];
                this.children[0] = new TileElement(this, x, y, cw, ch);
                this.children[1] = new TileElement(this, x + cw, y, width - cw, ch);
                this.children[2] = new TileElement(this, x, y + ch, cw, height - ch);
                this.children[3] = new TileElement(this, x + cw, y + ch, width - cw, height - ch);
            } else {
                this.children = new TileQuadrant[4];
                this.children[0] = new TileQuadrant(this, tileMinSize, x, y, cw, ch);
                this.children[1] = new TileQuadrant(this, tileMinSize, x + cw, y, width - cw, ch);
                this.children[2] = new TileQuadrant(this, tileMinSize, x, y + ch, cw, height - ch);
                this.children[3] = new TileQuadrant(this, tileMinSize, x + cw, y + ch, width - cw, height - ch);
            }
        }

        void checkHit(Tile t) {
            if (t == null) {
                return;
            }
            if (this.hit) {
                return;
            }
            if (this.isHit(t)) {
                for (int i = 0; i < 4; ++i) {
                    this.children[i].checkHit(t);
                }
            }
        }

        void notifyTileHit(Tile child) {
            if (this.children[0].hit && this.children[1].hit && this.children[2].hit && this.children[3].hit) {
                this.hit = true;
                if (this.parent != null) {
                    this.parent.notifyTileHit(this);
                }
            }
        }

        public void clear() {
            super.clear();
            this.children[0].clear();
            this.children[1].clear();
            this.children[2].clear();
            this.children[3].clear();
        }

        TileElement getHitTiles(TileElement rt) {
            if (this.hit) {
                this.next = rt;
                return this;
            }
            for (int i = 0; i < 4; ++i) {
                rt = this.children[i].getHitTiles(rt);
            }
            return rt;
        }
    }

    public static class TileElement
    extends Tile {
        TileQuadrant parent;
        boolean hit;
        public TileElement next;

        TileElement(TileQuadrant parent, int x, int y, int width, int height) {
            this.parent = parent;
            if (x < 0 || y < 0) {
                throw new IllegalArgumentException();
            }
            this.setTile(x, y, width, height);
        }

        void checkHit(Tile t) {
            if (t == null) {
                return;
            }
            if (this.isHit(t)) {
                this.hit = true;
                if (this.parent != null) {
                    this.parent.notifyTileHit(this);
                }
            }
        }

        public void clear() {
            this.hit = false;
            this.next = null;
        }

        TileElement getHitTiles(TileElement rt) {
            if (this.hit) {
                this.next = rt;
                return this;
            }
            return rt;
        }
    }
}

