/*
 * Decompiled with CFR 0.152.
 */
package com.sun.perseus.model;

import com.sun.perseus.j2d.Box;
import com.sun.perseus.j2d.PaintServer;
import com.sun.perseus.j2d.PaintTarget;
import com.sun.perseus.j2d.Path;
import com.sun.perseus.j2d.RGB;
import com.sun.perseus.j2d.Transform;
import com.sun.perseus.model.CompositeNode;
import com.sun.perseus.model.DocumentNode;
import com.sun.perseus.model.ElementNodeProxy;
import com.sun.perseus.model.Messages;
import com.sun.perseus.model.ModelNode;
import com.sun.perseus.model.PaintServerReference;
import com.sun.perseus.model.StringTraitAnim;
import com.sun.perseus.model.Time;
import com.sun.perseus.model.TraitAnim;
import com.sun.perseus.model.UpdateListener;
import com.sun.perseus.parser.Length;
import com.sun.perseus.util.SimpleTokenizer;
import java.util.Hashtable;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.svg.SVGElement;
import org.w3c.dom.svg.SVGMatrix;
import org.w3c.dom.svg.SVGPath;
import org.w3c.dom.svg.SVGRGBColor;
import org.w3c.dom.svg.SVGRect;

public abstract class ElementNode
extends CompositeNode
implements SVGElement {
    static final String TRAIT_TYPE_STRING = "string";
    static final String TRAIT_TYPE_FLOAT = "float";
    static final String TRAIT_TYPE_SVG_MATRIX = "SVGMatrix";
    static final String TRAIT_TYPE_SVG_PATH = "SVGPath";
    static final String TRAIT_TYPE_SVG_RECT = "SVGRect";
    static final String TRAIT_TYPE_SVG_RGB_COLOR = "SVGRGBColor";
    public static final int XML_SPACE_PRESERVE = 0;
    public static final int XML_SPACE_DEFAULT = 1;
    public static final int XML_SPACE_INHERIT = 2;
    static final String NULL_NS = "#!null/ns@!";
    protected String id = null;
    protected String uriBase = null;
    protected String[][] conditionalAttributes;
    public static final int REQUIRED_FEATURES_INDEX = 0;
    public static final int REQUIRED_EXTENSIONS_INDEX = 1;
    public static final int SYSTEM_LANGUAGE_INDEX = 2;
    public static final int CONDITIONAl_ATTRIBUTES_LENGTH = 3;
    protected int xmlSpace = 2;
    protected boolean paintNeedsLoad = false;
    protected ElementNodeProxy firstProxy;
    protected ElementNodeProxy lastProxy;
    protected boolean buildingProxy = false;
    protected Hashtable traitAnimsNS = null;

    public ElementNode(DocumentNode ownerDocument) {
        if (ownerDocument == null) {
            throw new IllegalArgumentException();
        }
        this.ownerDocument = ownerDocument;
    }

    ModelNode proxyNodeHitAt(float[] pt, ElementNodeProxy proxy) {
        return null;
    }

    protected void recomputeProxyTransformState() {
        ElementNodeProxy proxy = this.firstProxy;
        while (proxy != null) {
            proxy.recomputeTransformState();
            proxy = proxy.nextProxy;
        }
    }

    protected void preValidate() {
    }

    ModelNode getFirstExpandedChild() {
        return null;
    }

    public ModelNode getFirstComputedExpandedChild() {
        return null;
    }

    ModelNode getLastExpandedChild() {
        return null;
    }

    protected void unhookExpandedQuiet() {
    }

    protected void unhookChildrenQuiet() {
        super.unhookChildrenQuiet();
        ElementNodeProxy proxy = this.firstProxy;
        while (proxy != null) {
            proxy.unhookExpandedQuiet();
            proxy = proxy.nextProxy;
        }
    }

    public void appendTextChild(String text) {
    }

    protected void addProxy(ElementNodeProxy proxy) {
        if (proxy == null) {
            throw new NullPointerException();
        }
        if (this.firstProxy == null) {
            this.firstProxy = proxy;
            this.lastProxy = proxy;
        } else {
            this.lastProxy.nextProxy = proxy;
            proxy.prevProxy = this.lastProxy;
            this.lastProxy = proxy;
        }
    }

    void removeProxy(ElementNodeProxy proxy) {
        if (proxy == null || this.firstProxy == null) {
            return;
        }
        if (proxy == this.firstProxy) {
            this.firstProxy = proxy.nextProxy;
        }
        if (proxy == this.lastProxy) {
            this.lastProxy = proxy.prevProxy;
        }
        if (proxy.prevProxy != null) {
            proxy.prevProxy.nextProxy = proxy.nextProxy;
        }
        if (proxy.nextProxy != null) {
            proxy.nextProxy.prevProxy = proxy.prevProxy;
        }
    }

    protected void modifyingNode() {
        UpdateListener updateListener = this.getUpdateListener();
        if (updateListener != null) {
            updateListener.modifyingNode(this);
        }
        ElementNodeProxy proxy = this.firstProxy;
        while (proxy != null) {
            proxy.modifyingProxied();
            proxy = proxy.nextProxy;
        }
    }

    protected void modifiedNode() {
        UpdateListener updateListener = this.getUpdateListener();
        if (updateListener != null) {
            updateListener.modifiedNode(this);
        }
        ElementNodeProxy proxy = this.firstProxy;
        while (proxy != null) {
            proxy.modifiedProxied();
            proxy = proxy.nextProxy;
        }
    }

    public void add(ElementNode element) {
        super.add(element);
        ElementNodeProxy proxy = this.firstProxy;
        while (proxy != null) {
            proxy.proxiedChildAdded(element);
            proxy = proxy.nextProxy;
        }
    }

    ElementNodeProxy buildProxy() {
        return new ElementNodeProxy(this);
    }

    protected ElementNodeProxy buildExpandedProxy() {
        if (this.buildingProxy) {
            throw new IllegalStateException();
        }
        this.buildingProxy = true;
        ElementNodeProxy proxy = this.buildProxy();
        proxy.expand();
        this.buildingProxy = false;
        return proxy;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String newId) {
        if (newId == null) {
            throw new NullPointerException();
        }
        if (this.id != null) {
            throw new DOMException(7, Messages.formatMessage(Messages.ERROR_CANNOT_MODIFY_ID, new String[]{newId, this.id, this.getLocalName(), this.getNamespaceURI()}));
        }
        if (this.ownerDocument.getElementByIdAll(newId) != null) {
            ElementNode duplicateElement = (ElementNode)((Object)this.ownerDocument.getElementByIdAll(newId));
            throw new DOMException(15, Messages.formatMessage(Messages.ERROR_DUPLICATE_ID_VALUE, new String[]{newId, this.getLocalName(), this.getNamespaceURI(), duplicateElement.getLocalName(), duplicateElement.getNamespaceURI()}));
        }
        this.modifyingNode();
        this.id = newId;
        if (this.loaded && this.isInDocumentTree()) {
            this.ownerDocument.addIdentifiedNode(this);
        } else {
            this.ownerDocument.reserveId(this);
        }
        this.modifiedNode();
    }

    void nodeHookedInDocumentTree() {
        super.nodeHookedInDocumentTree();
        if (this.id != null) {
            this.ownerDocument.addIdentifiedNode(this);
        }
    }

    public String getURIBase() {
        if (this.uriBase == null) {
            if (this.parent != null) {
                return this.parent.getURIBase();
            }
            return null;
        }
        if (this.uriBase.indexOf(":") != -1 || this.parent == null) {
            return this.uriBase;
        }
        String parentURIBase = this.parent.getURIBase();
        if (parentURIBase != null) {
            int lastSlashIndex = parentURIBase.lastIndexOf(47);
            if (lastSlashIndex != -1) {
                parentURIBase = parentURIBase.substring(0, lastSlashIndex);
            }
            return parentURIBase + '/' + this.uriBase;
        }
        return this.uriBase;
    }

    public void setURIBase(String newUriBase) {
        if (ElementNode.equal(newUriBase, this.uriBase)) {
            return;
        }
        this.modifyingNode();
        this.uriBase = newUriBase;
        this.modifiedNode();
    }

    public void setXMLSpace(int newXmlSpace) {
        if (newXmlSpace == this.xmlSpace) {
            return;
        }
        switch (newXmlSpace) {
            case 0: 
            case 1: 
            case 2: {
                this.modifyingNode();
                this.xmlSpace = newXmlSpace;
                this.modifiedNode();
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public int getXMLSpace() {
        if (this.xmlSpace != 2) {
            return this.xmlSpace;
        }
        ModelNode ancestor = this.parent;
        while (ancestor != null) {
            if (ancestor instanceof ElementNode) {
                return ((ElementNode)this.parent).getXMLSpace();
            }
            ancestor = ancestor.parent;
        }
        return 1;
    }

    final boolean conditionEquals(int index, String[] conditionValue) {
        if (conditionValue == null) {
            return this.conditionalAttributes == null || this.conditionalAttributes[index] == null;
        }
        return this.conditionalAttributes != null && ElementNode.equal(this.conditionalAttributes[index], conditionValue);
    }

    public void setRequiredFeatures(String[] newRequiredFeatures) {
        this.setConditionalAttribute(0, newRequiredFeatures);
    }

    void setConditionalAttribute(int index, String[] newValue) {
        if (this.conditionEquals(index, newValue)) {
            return;
        }
        this.modifyingNode();
        if (newValue == null) {
            if (this.conditionalAttributes != null) {
                this.conditionalAttributes[index] = null;
            }
        } else {
            if (this.conditionalAttributes == null) {
                this.conditionalAttributes = new String[3][];
            }
            this.conditionalAttributes[index] = newValue;
        }
        switch (index) {
            case 0: {
                this.computeCanRenderRequiredFeaturesBit(newValue);
                ElementNodeProxy p = this.firstProxy;
                while (p != null) {
                    p.computeCanRenderRequiredFeaturesBit(newValue);
                    p = p.nextProxy;
                }
                break;
            }
            case 1: {
                this.computeCanRenderRequiredExtensionsBit(newValue);
                ElementNodeProxy p = this.firstProxy;
                while (p != null) {
                    p.computeCanRenderRequiredExtensionsBit(newValue);
                    p = p.nextProxy;
                }
                break;
            }
            default: {
                this.computeCanRenderSystemLanguageBit(newValue);
                ElementNodeProxy p = this.firstProxy;
                while (p != null) {
                    p.computeCanRenderSystemLanguageBit(newValue);
                    p = p.nextProxy;
                }
                break block0;
            }
        }
        this.modifiedNode();
    }

    public String[] getRequiredFeatures() {
        return this.getConditionalAttribute(0);
    }

    String[] getConditionalAttribute(int index) {
        if (this.conditionalAttributes != null) {
            return this.conditionalAttributes[index];
        }
        return null;
    }

    public void setRequiredExtensions(String[] newRequiredExtensions) {
        this.setConditionalAttribute(1, newRequiredExtensions);
    }

    public String[] getRequiredExtensions() {
        return this.getConditionalAttribute(1);
    }

    public void setSystemLanguage(String[] newSystemLanguage) {
        this.setConditionalAttribute(2, newSystemLanguage);
    }

    public String[] getSystemLanguage() {
        return this.getConditionalAttribute(2);
    }

    public boolean getPaintNeedsLoad() {
        return this.paintNeedsLoad;
    }

    public void setPreferedPaintNeedsLoad(boolean paintNeedsLoad) {
        this.paintNeedsLoad = paintNeedsLoad;
    }

    public String getNamespaceURI() {
        return "http://www.w3.org/2000/svg";
    }

    public Node getParentNode() {
        return (Node)((Object)this.parent);
    }

    public abstract ElementNode newInstance(DocumentNode var1);

    public Element getFirstElementChild() {
        return this.firstChild;
    }

    public Element getNextElementSibling() {
        return (Element)((Object)this.nextSibling);
    }

    public Element getPreviousElementSibling() {
        return (Element)((Object)this.prevSibling);
    }

    public Element getLastElementChild() {
        return this.lastChild;
    }

    boolean supportsTrait(String traitName) {
        return "id" == traitName || "requiredFeatures" == traitName || "requiredExtensions" == traitName || "systemLanguage" == traitName;
    }

    final void checkNCName(String name) throws DOMException {
        if (name == null || name.length() == 0) {
            throw this.unsupportedTrait(name);
        }
    }

    TraitAnim getSafeTraitAnimNS(String traitNamespace, String traitName) {
        TraitAnim traitAnim = this.getTraitAnimNS(traitNamespace, traitName);
        if (traitAnim == null) {
            traitAnim = this.createTraitAnimNS(traitNamespace, traitName);
        }
        return traitAnim;
    }

    TraitAnim getTraitAnimNS(String traitNamespace, String traitName) {
        Hashtable nsTraitAnims;
        if (traitName == null) {
            throw new NullPointerException();
        }
        if (this.traitAnimsNS == null) {
            return null;
        }
        if (traitNamespace == null || traitNamespace.length() == 0) {
            traitNamespace = NULL_NS;
        }
        if ((nsTraitAnims = (Hashtable)this.traitAnimsNS.get(traitNamespace)) != null) {
            return (TraitAnim)nsTraitAnims.get(traitName);
        }
        return null;
    }

    public String[] getRequiredTraits() {
        return null;
    }

    public String[][] getRequiredTraitsNS() {
        return null;
    }

    public String[][] getDefaultTraits() {
        return null;
    }

    public String[][] getTraitAliases() {
        return null;
    }

    String validateTraitNS(String namespaceURI, String traitName, String value, String reqNamespaceURI, String reqLocalName, String reqTraitNamespace, String reqTraitName) throws DOMException {
        return value;
    }

    float[][] validateFloatArrayTrait(String traitName, String value, String reqNamespaceURI, String reqLocalName, String reqTraitNamespace, String reqTraitName) throws DOMException {
        throw new Error();
    }

    boolean supportsTraitNS(String namespaceURI, String traitName) {
        if ("http://www.sun.com/svg/perseus" == namespaceURI && "externalResourcesRequired" == traitName) {
            return true;
        }
        if ("http://www.w3.org/XML/1998/namespace" == namespaceURI && ("base" == traitName || "space" == traitName)) {
            return true;
        }
        if (namespaceURI == null) {
            return this.supportsTrait(traitName);
        }
        return false;
    }

    public final String getTrait(String traitName) throws DOMException {
        if (!this.supportsTrait(traitName = ElementNode.intern(traitName))) {
            throw this.unsupportedTrait(traitName);
        }
        TraitAnim anim = this.getTraitAnimNS(NULL_NS, traitName);
        if (anim == null || !anim.active) {
            return this.getTraitImpl(traitName);
        }
        return anim.getTrait(TRAIT_TYPE_STRING);
    }

    String getSpecifiedTraitNSImpl(String traitNamespace, String traitName) throws DOMException {
        if (traitNamespace == null || traitNamespace == NULL_NS) {
            return this.getSpecifiedTraitImpl(traitName);
        }
        if ("http://www.w3.org/XML/1998/namespace" == traitNamespace && "base" == traitName) {
            return this.uriBase;
        }
        return this.getTraitNSImpl(traitNamespace, traitName);
    }

    String getSpecifiedTraitImpl(String traitName) throws DOMException {
        return this.getTraitImpl(traitName);
    }

    public String getTraitImpl(String name) throws DOMException {
        if ("id" == name) {
            return this.getId();
        }
        if ("requiredFeatures" == name) {
            return this.toStringTrait(this.getRequiredFeatures(), " ");
        }
        if ("requiredExtensions" == name) {
            return this.toStringTrait(this.getRequiredExtensions(), " ");
        }
        if ("systemLanguage" == name) {
            return this.toStringTrait(this.getSystemLanguage(), ",");
        }
        if (!this.supportsTrait(name)) {
            if (name == null) {
                throw this.unsupportedTrait(name);
            }
            String unknownTraitValue = this.ownerDocument.getUnknownTraitsNS(this, NULL_NS, name);
            if (unknownTraitValue != null) {
                return unknownTraitValue;
            }
            return "";
        }
        throw this.unsupportedTraitType(name, TRAIT_TYPE_STRING);
    }

    TraitAnim createTraitAnimNS(String traitNamespace, String traitName) {
        Hashtable<String, TraitAnim> nsTraitAnims;
        if (traitNamespace == null || traitNamespace.length() == 0) {
            traitNamespace = NULL_NS;
        }
        TraitAnim traitAnim = null;
        traitAnim = NULL_NS == traitNamespace ? this.createTraitAnimImpl(traitName) : this.createTraitAnimNSImpl(traitNamespace, traitName);
        if (this.traitAnimsNS == null) {
            this.traitAnimsNS = new Hashtable();
        }
        if ((nsTraitAnims = (Hashtable<String, TraitAnim>)this.traitAnimsNS.get(traitNamespace)) == null) {
            nsTraitAnims = new Hashtable<String, TraitAnim>();
            this.traitAnimsNS.put(traitNamespace, nsTraitAnims);
        }
        nsTraitAnims.put(traitName, traitAnim);
        return traitAnim;
    }

    TraitAnim createTraitAnimImpl(String traitName) {
        if (this.supportsTrait(traitName)) {
            throw this.notAnimatable(null, traitName);
        }
        return new StringTraitAnim(this, NULL_NS, traitName);
    }

    TraitAnim createTraitAnimNSImpl(String traitNamespace, String traitName) {
        if (this.supportsTraitNS(traitNamespace, traitName)) {
            throw this.notAnimatable(traitNamespace, traitName);
        }
        return new StringTraitAnim(this, traitNamespace, traitName);
    }

    public final String getTraitNS(String namespaceURI, String name) throws DOMException {
        if (namespaceURI == null) {
            return this.getTrait(name);
        }
        name = ElementNode.intern(name);
        if (!this.supportsTraitNS(namespaceURI = ElementNode.intern(namespaceURI), name)) {
            throw this.unsupportedTraitNS(name, namespaceURI);
        }
        StringTraitAnim anim = (StringTraitAnim)this.getTraitAnimNS(namespaceURI, name);
        if (anim == null || !anim.active) {
            return this.getTraitNSImpl(namespaceURI, name);
        }
        return anim.getTrait(TRAIT_TYPE_STRING);
    }

    String getTraitNSImpl(String namespaceURI, String name) {
        if ("http://www.sun.com/svg/perseus" == namespaceURI) {
            if ("externalResourcesRequired" == name) {
                if (this.paintNeedsLoad) {
                    return "true";
                }
                return "false";
            }
        } else if ("http://www.w3.org/XML/1998/namespace" == namespaceURI) {
            if ("base" == name) {
                return this.getURIBase();
            }
            if ("space" == name) {
                switch (this.getXMLSpace()) {
                    case 1: {
                        return "default";
                    }
                }
                return "preserve";
            }
        }
        if (!this.supportsTraitNS(namespaceURI, name)) {
            String unknownTraitValue = this.ownerDocument.getUnknownTraitsNS(this, namespaceURI, name);
            if (unknownTraitValue != null) {
                return unknownTraitValue;
            }
            return "";
        }
        throw this.unsupportedTraitTypeNS(name, namespaceURI, TRAIT_TYPE_STRING);
    }

    public final float getFloatTrait(String name) throws DOMException {
        if (!this.supportsTrait(name = ElementNode.intern(name))) {
            throw this.unsupportedTrait(name);
        }
        TraitAnim anim = this.getTraitAnimNS(NULL_NS, name);
        if (anim == null || !anim.active) {
            return this.getFloatTraitImpl(name);
        }
        return this.parseFloatTrait(name, anim.getTrait(TRAIT_TYPE_FLOAT));
    }

    float getFloatTraitImpl(String name) {
        throw this.unsupportedTraitType(name, TRAIT_TYPE_FLOAT);
    }

    public final SVGMatrix getMatrixTrait(String name) throws DOMException {
        if (!this.supportsTrait(name = ElementNode.intern(name))) {
            throw this.unsupportedTrait(name);
        }
        TraitAnim anim = this.getTraitAnimNS(NULL_NS, name);
        if (anim == null || !anim.active) {
            return this.getMatrixTraitImpl(name);
        }
        Transform m = this.parseTransformTrait(name, anim.getTrait(TRAIT_TYPE_SVG_MATRIX));
        if (m == null) {
            m = new Transform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f);
        }
        return m;
    }

    SVGMatrix getMatrixTraitImpl(String name) throws DOMException {
        throw this.unsupportedTraitType(name, TRAIT_TYPE_SVG_MATRIX);
    }

    public final SVGRect getRectTrait(String name) throws DOMException {
        if (!this.supportsTrait(name = ElementNode.intern(name))) {
            throw this.unsupportedTrait(name);
        }
        TraitAnim anim = this.getTraitAnimNS(NULL_NS, name);
        if (anim == null || !anim.active) {
            return this.getRectTraitImpl(name);
        }
        return this.toSVGRect(this.toViewBox(name, anim.getTrait(TRAIT_TYPE_SVG_RECT)));
    }

    SVGRect getRectTraitImpl(String name) throws DOMException {
        throw this.unsupportedTraitType(name, TRAIT_TYPE_SVG_RECT);
    }

    public final SVGPath getPathTrait(String name) throws DOMException {
        if (!this.supportsTrait(name = ElementNode.intern(name))) {
            throw this.unsupportedTrait(name);
        }
        TraitAnim anim = this.getTraitAnimNS(NULL_NS, name);
        if (anim == null || !anim.active) {
            return this.getPathTraitImpl(name);
        }
        return this.parsePathTrait(name, anim.getTrait(TRAIT_TYPE_SVG_PATH));
    }

    SVGPath getPathTraitImpl(String name) throws DOMException {
        throw this.unsupportedTraitType(name, TRAIT_TYPE_SVG_PATH);
    }

    public final SVGRGBColor getRGBColorTrait(String name) throws DOMException {
        if (!this.supportsTrait(name = ElementNode.intern(name))) {
            throw this.unsupportedTrait(name);
        }
        TraitAnim anim = this.getTraitAnimNS(NULL_NS, name);
        if (anim == null || !anim.active) {
            return this.getRGBColorTraitImpl(name);
        }
        return this.toSVGRGBColor(name, this.parseColorTrait(name, anim.getTrait(TRAIT_TYPE_SVG_RGB_COLOR)));
    }

    SVGRGBColor getRGBColorTraitImpl(String name) throws DOMException {
        throw this.unsupportedTraitType(name, TRAIT_TYPE_SVG_RGB_COLOR);
    }

    public final void setAttribute(String name, String value) throws DOMException {
        this.checkNCName(name);
        if (value == null) {
            throw this.illegalTraitValue(name, value);
        }
        name = name.intern();
        this.setTraitImpl(name, value);
    }

    public final String getAttribute(String name) throws DOMException {
        this.checkNCName(name);
        name = name.intern();
        return this.getTraitImpl(name);
    }

    public final void setTrait(String name, String value) throws DOMException {
        if (!this.supportsTrait(name = ElementNode.intern(name))) {
            throw this.unsupportedTrait(name);
        }
        if (value == null) {
            throw this.illegalTraitValue(name, value);
        }
        TraitAnim anim = this.getTraitAnimNS(NULL_NS, name);
        if (anim == null || !anim.active) {
            this.setTraitImpl(name, value);
        } else {
            anim.setTrait(value, TRAIT_TYPE_STRING);
        }
    }

    public void setTraitImpl(String name, String value) throws DOMException {
        if ("id" == name) {
            try {
                this.setId(value);
            }
            catch (IllegalArgumentException iae) {
                iae.printStackTrace();
                throw this.illegalTraitValue(name, value);
            }
        } else if ("requiredFeatures" == name) {
            if (value == null) {
                throw this.illegalTraitValue(name, value);
            }
            this.setRequiredFeatures(this.parseStringArrayTrait(name, value, " "));
        } else if ("requiredExtensions" == name) {
            if (value == null) {
                throw this.illegalTraitValue(name, value);
            }
            this.setRequiredExtensions(this.parseStringArrayTrait(name, value, " "));
        } else if ("systemLanguage" == name) {
            if (value == null) {
                throw this.illegalTraitValue(name, value);
            }
            this.setSystemLanguage(this.parseStringArrayTrait(name, value, ","));
        } else {
            if (this.supportsTrait(name)) {
                throw this.unsupportedTraitType(name, TRAIT_TYPE_STRING);
            }
            if (name == null) {
                throw this.unsupportedTrait(name);
            }
            if (value == null) {
                throw this.illegalTraitValue(name, value);
            }
            this.ownerDocument.setUnknownTraitsNS(this, NULL_NS, name, value);
        }
    }

    public final void setAttributeNS(String namespaceURI, String name, String value) throws DOMException {
        if (namespaceURI == null || namespaceURI.length() == 0) {
            this.setAttribute(name, value);
            return;
        }
        this.checkNCName(name);
        if (value == null) {
            throw this.illegalTraitValue(name, namespaceURI, value);
        }
        namespaceURI = namespaceURI.intern();
        name = name.intern();
        this.setTraitNSImpl(namespaceURI, name, value);
    }

    public final String getAttributeNS(String namespaceURI, String name) throws DOMException {
        if (namespaceURI == null || namespaceURI.length() == 0) {
            return this.getAttribute(name);
        }
        this.checkNCName(name);
        namespaceURI = namespaceURI.intern();
        name = name.intern();
        return this.getTraitNSImpl(namespaceURI, name);
    }

    public final void setTraitNS(String namespaceURI, String name, String value) throws DOMException {
        if (namespaceURI == null || namespaceURI.length() == 0) {
            this.setTrait(name, value);
            return;
        }
        if (!this.supportsTraitNS(namespaceURI = ElementNode.intern(namespaceURI), name = ElementNode.intern(name))) {
            throw this.unsupportedTraitNS(name, namespaceURI);
        }
        StringTraitAnim anim = (StringTraitAnim)this.getTraitAnimNS(namespaceURI, name);
        if (anim == null || !anim.active) {
            this.setTraitNSImpl(namespaceURI, name, value);
        } else {
            anim.setTrait(value, TRAIT_TYPE_STRING);
        }
    }

    public void setTraitNSImpl(String namespaceURI, String name, String value) throws DOMException {
        if ("http://www.sun.com/svg/perseus" == namespaceURI) {
            if ("externalResourcesRequired" == name) {
                if ("true".equals(value)) {
                    this.setPreferedPaintNeedsLoad(true);
                    return;
                }
                if ("false".equals(value)) {
                    this.setPreferedPaintNeedsLoad(false);
                    return;
                }
                throw this.illegalTraitValue(namespaceURI, name, value);
            }
        } else if ("http://www.w3.org/XML/1998/namespace" == namespaceURI) {
            if ("base" == name) {
                if (value == null) {
                    throw this.illegalTraitValue(name, value);
                }
                this.setURIBase(value);
            } else if ("space" == name) {
                if ("default".equals(value) || value != null && value.length() == 0) {
                    this.setXMLSpace(1);
                    return;
                }
                if ("preserve".equals(value)) {
                    this.setXMLSpace(0);
                    return;
                }
                throw this.illegalTraitValue(name, value);
            }
        }
        if (this.supportsTraitNS(name, value)) {
            throw new Error();
        }
        this.ownerDocument.setUnknownTraitsNS(this, namespaceURI, name, value);
    }

    public final void setFloatTrait(String name, float value) throws DOMException {
        if (!this.supportsTrait(name = ElementNode.intern(name))) {
            throw this.unsupportedTrait(name);
        }
        TraitAnim anim = this.getTraitAnimNS(NULL_NS, name);
        if (anim == null || !anim.active) {
            this.setFloatTraitImpl(name, value);
        } else {
            anim.setTrait(Float.toString(value), TRAIT_TYPE_FLOAT);
        }
    }

    String toStringTrait(String traitName, float[][] value) {
        throw new Error(traitName);
    }

    String toString(PaintServer paintServer) {
        if (paintServer == null) {
            return "none";
        }
        return paintServer.toString();
    }

    void setFloatArrayTrait(String name, float[][] value) throws DOMException {
        throw new Error(name);
    }

    void setFloatTraitImpl(String name, float value) {
        throw this.unsupportedTraitType(name, TRAIT_TYPE_FLOAT);
    }

    public final void setMatrixTrait(String name, SVGMatrix matrix) throws DOMException {
        if (!this.supportsTrait(name = ElementNode.intern(name))) {
            throw this.unsupportedTrait(name);
        }
        if (matrix == null) {
            throw this.illegalTraitValue(name, null);
        }
        TraitAnim anim = this.getTraitAnimNS(NULL_NS, name);
        if (anim == null || !anim.active) {
            this.setMatrixTraitImpl(name, new Transform(matrix));
        } else {
            anim.setTrait(ElementNode.toStringTrait((Transform)matrix), TRAIT_TYPE_SVG_MATRIX);
        }
    }

    void setMatrixTraitImpl(String name, Transform matrix) throws DOMException {
        throw this.unsupportedTraitType(name, TRAIT_TYPE_SVG_MATRIX);
    }

    public final void setRectTrait(String name, SVGRect rect) throws DOMException {
        if (!this.supportsTrait(name = ElementNode.intern(name))) {
            throw this.unsupportedTrait(name);
        }
        TraitAnim anim = this.getTraitAnimNS(NULL_NS, name);
        if (anim == null || !anim.active) {
            this.setRectTraitImpl(name, rect);
        } else {
            if (rect == null) {
                throw this.illegalTraitValue(name, null);
            }
            float[] vb = new float[]{rect.getX(), rect.getY(), rect.getWidth(), rect.getHeight()};
            anim.setTrait(this.toStringTrait(vb), TRAIT_TYPE_SVG_RECT);
        }
    }

    public void setRectTraitImpl(String name, SVGRect rect) throws DOMException {
        throw this.unsupportedTraitType(name, TRAIT_TYPE_SVG_RECT);
    }

    public final void setPathTrait(String name, SVGPath path) throws DOMException {
        if (!this.supportsTrait(name = ElementNode.intern(name))) {
            throw this.unsupportedTrait(name);
        }
        if (path == null) {
            throw this.illegalTraitValue(name, null);
        }
        TraitAnim anim = this.getTraitAnimNS(NULL_NS, name);
        if (anim == null || !anim.active) {
            this.setPathTraitImpl(name, path);
        } else {
            if (path == null) {
                throw this.illegalTraitValue(name, null);
            }
            anim.setTrait(((Path)path).toString(), TRAIT_TYPE_SVG_PATH);
        }
    }

    void setPathTraitImpl(String name, SVGPath path) throws DOMException {
        throw this.unsupportedTraitType(name, TRAIT_TYPE_SVG_PATH);
    }

    public final void setRGBColorTrait(String name, SVGRGBColor color) throws DOMException {
        if (!this.supportsTrait(name = ElementNode.intern(name))) {
            throw this.unsupportedTrait(name);
        }
        if (color == null) {
            throw this.illegalTraitValue(name, null);
        }
        TraitAnim anim = this.getTraitAnimNS(NULL_NS, name);
        if (anim == null || !anim.active) {
            this.setRGBColorTraitImpl(name, color);
        } else {
            anim.setTrait(color.toString(), TRAIT_TYPE_SVG_RGB_COLOR);
        }
    }

    void setRGBColorTraitImpl(String name, SVGRGBColor color) throws DOMException {
        throw this.unsupportedTraitType(name, TRAIT_TYPE_SVG_RGB_COLOR);
    }

    protected final String[] parseStringArrayTrait(String name, String value, String seperators) throws DOMException {
        if (value == null) {
            throw this.illegalTraitValue(name, value);
        }
        SimpleTokenizer st = new SimpleTokenizer(value, seperators);
        int n = st.countTokens();
        String[] result = new String[n];
        for (int i = 0; i < n; ++i) {
            result[i] = st.nextToken().trim().intern();
        }
        return result;
    }

    protected final float parseFloatTrait(String name, String value) throws DOMException {
        try {
            return this.ownerDocument.lengthParser.parseNumber(value);
        }
        catch (IllegalArgumentException iae) {
            throw this.illegalTraitValue(name, value);
        }
    }

    protected final float[] parsePositiveFloatArrayTrait(String name, String value) throws DOMException {
        try {
            SimpleTokenizer st = new SimpleTokenizer(value, ", ");
            float[] da = null;
            int n = st.countTokens();
            float totalLength = 0.0f;
            if (n % 2 == 0) {
                da = new float[n];
                for (int i = 0; i < da.length; ++i) {
                    da[i] = this.ownerDocument.lengthParser.parseNumber(st.nextToken());
                    if (Float.isNaN(da[i]) || da[i] < 0.0f) {
                        throw new IllegalArgumentException();
                    }
                    totalLength += da[i];
                }
            } else {
                da = new float[2 * n];
                for (int i = 0; i < n; ++i) {
                    da[i] = this.ownerDocument.lengthParser.parseNumber(st.nextToken());
                    da[n + i] = da[i];
                    if (Float.isNaN(da[i]) || da[i] < 0.0f) {
                        throw new IllegalArgumentException();
                    }
                    totalLength += da[i];
                }
            }
            if (totalLength > 0.0f) {
                return da;
            }
            return null;
        }
        catch (IllegalArgumentException iae) {
            throw this.illegalTraitValue(name, value);
        }
        catch (NullPointerException iae) {
            throw this.illegalTraitValue(name, value);
        }
    }

    protected final float parsePositiveFloatTrait(String name, String value) throws DOMException {
        try {
            float v = this.ownerDocument.lengthParser.parseNumber(value);
            if (v < 0.0f) {
                throw new IllegalArgumentException();
            }
            return v;
        }
        catch (IllegalArgumentException iae) {
            throw this.illegalTraitValue(name, value);
        }
    }

    protected final float parseLengthTrait(String name, String value, boolean isHorizontal) throws DOMException {
        try {
            Length l = this.ownerDocument.lengthParser.parseLength(value);
            switch (l.unit) {
                case 1: {
                    return l.value;
                }
                case 8: {
                    return l.value * 25.4f / this.ownerDocument.getPixelMMSize();
                }
                case 6: {
                    return l.value * 10.0f / this.ownerDocument.getPixelMMSize();
                }
                case 7: {
                    return l.value / this.ownerDocument.getPixelMMSize();
                }
                case 9: {
                    return l.value * 25.4f / (72.0f * this.ownerDocument.getPixelMMSize());
                }
                case 10: {
                    return l.value * 25.4f / (6.0f * this.ownerDocument.getPixelMMSize());
                }
                case 2: {
                    if (isHorizontal) {
                        return (float)this.ownerDocument.width * l.value / 100.0f;
                    }
                    return (float)this.ownerDocument.height * l.value / 100.0f;
                }
            }
            throw new Error();
        }
        catch (IllegalArgumentException iae) {
            throw this.illegalTraitValue(name, value);
        }
    }

    protected final float parsePositiveLengthTrait(String name, String value, boolean isHorizontal) throws DOMException {
        float v = this.parseLengthTrait(name, value, isHorizontal);
        if (v < 0.0f) {
            throw this.illegalTraitValue(name, value);
        }
        return v;
    }

    protected final Path parsePathTrait(String name, String value) throws DOMException {
        try {
            return this.ownerDocument.pathParser.parsePath(value);
        }
        catch (IllegalArgumentException iae) {
            DOMException de = this.illegalTraitValue(name, value);
            if (!this.loaded) {
                this.ownerDocument.setDelayedException(de);
                return this.ownerDocument.pathParser.getPath();
            }
            throw de;
        }
    }

    protected final Path parsePointsTrait(String name, String value) throws DOMException {
        try {
            return this.ownerDocument.pathParser.parsePoints(value);
        }
        catch (IllegalArgumentException iae) {
            DOMException de = this.illegalTraitValue(name, value);
            if (!this.loaded) {
                this.ownerDocument.setDelayedException(de);
                return this.ownerDocument.pathParser.getPath();
            }
            throw de;
        }
    }

    protected final Transform parseTransformTrait(String name, String value) throws DOMException {
        try {
            return this.ownerDocument.transformListParser.parseTransformList(value);
        }
        catch (IllegalArgumentException iae) {
            throw this.illegalTraitValue(name, value);
        }
    }

    protected final RGB parseColorTrait(String traitName, String value) throws DOMException {
        try {
            return this.ownerDocument.colorParser.parseColor(value);
        }
        catch (IllegalArgumentException e) {
            throw this.illegalTraitValue(traitName, value);
        }
    }

    protected final PaintServer parsePaintTrait(String traitName, PaintTarget paintTarget, String value) throws DOMException {
        if (value == null) {
            throw this.illegalTraitValue(traitName, value);
        }
        if (value.startsWith("url(#")) {
            if (value.length() < 7 || value.charAt(value.length() - 1) != ')') {
                throw this.illegalTraitValue(traitName, value);
            }
            String idRef = value.substring(5, value.length() - 1);
            return PaintServerReference.resolve(this.ownerDocument, paintTarget, traitName, idRef);
        }
        try {
            return this.ownerDocument.colorParser.parseColor(value);
        }
        catch (IllegalArgumentException e) {
            throw this.illegalTraitValue(traitName, value);
        }
    }

    protected final Time parseClockTrait(String traitName, String value) throws DOMException {
        if ("indefinite".equals(value)) {
            return Time.INDEFINITE;
        }
        try {
            return new Time(this.ownerDocument.clockParser.parseClock(value));
        }
        catch (IllegalArgumentException iae) {
            throw this.illegalTraitValue(traitName, value);
        }
    }

    protected final Time parseMinMaxClock(String traitName, String value, boolean isMin) throws DOMException {
        if ("indefinite".equals(value)) {
            return Time.INDEFINITE;
        }
        if (value == null) {
            throw this.illegalTraitValue(traitName, value);
        }
        try {
            long v = this.ownerDocument.clockParser.parseClock(value);
            if (v < 0L) {
                throw new IllegalArgumentException();
            }
            if (v == 0L && !isMin) {
                throw new IllegalArgumentException();
            }
            return new Time(v);
        }
        catch (IllegalArgumentException iae) {
            if (isMin) {
                return new Time(0L);
            }
            return Time.INDEFINITE;
        }
    }

    public final float[] parseFloatArrayTrait(String traitName, String value) throws DOMException {
        return this.parseFloatArrayTrait(traitName, value, ',');
    }

    public final float[] parseFloatArrayTrait(String traitName, String value, char sep) throws DOMException {
        try {
            return this.ownerDocument.numberListParser.parseNumberList(value, sep);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            throw this.illegalTraitValue(traitName, value);
        }
    }

    public final int parseFontStylesTrait(String name, String value) {
        if (value == null) {
            throw this.illegalTraitValue(name, value);
        }
        if ("all".equals(value)) {
            return 7;
        }
        SimpleTokenizer st = new SimpleTokenizer(value, ",");
        if (st.countTokens() < 1) {
            throw this.illegalTraitValue(name, value);
        }
        int styles = 0;
        while (st.hasMoreTokens()) {
            String t = st.nextToken().trim();
            if ("normal".equals(t)) {
                styles |= 1;
                continue;
            }
            if ("italic".equals(t)) {
                styles |= 4;
                continue;
            }
            if ("oblique".equals(t)) {
                styles |= 2;
                continue;
            }
            throw this.illegalTraitValue(name, value);
        }
        return styles;
    }

    protected final int parseFontWeightsTrait(String name, String value) {
        if (value == null) {
            throw this.illegalTraitValue(name, value);
        }
        if ("all".equals(value)) {
            return 511;
        }
        SimpleTokenizer st = new SimpleTokenizer(value, ",");
        if (st.countTokens() < 1) {
            throw this.illegalTraitValue(name, value);
        }
        int weights = 0;
        while (st.hasMoreTokens()) {
            String t = st.nextToken().trim();
            if ("normal".equals(t)) {
                weights |= 8;
                continue;
            }
            if ("bold".equals(t)) {
                weights |= 0x40;
                continue;
            }
            if ("100".equals(t)) {
                weights |= 1;
                continue;
            }
            if ("200".equals(t)) {
                weights |= 2;
                continue;
            }
            if ("300".equals(t)) {
                weights |= 4;
                continue;
            }
            if ("400".equals(t)) {
                weights |= 8;
                continue;
            }
            if ("500".equals(t)) {
                weights |= 0x10;
                continue;
            }
            if ("600".equals(t)) {
                weights |= 0x20;
                continue;
            }
            if ("700".equals(t)) {
                weights |= 0x40;
                continue;
            }
            if ("800".equals(t)) {
                weights |= 0x80;
                continue;
            }
            if ("900".equals(t)) {
                weights |= 0x100;
                continue;
            }
            throw this.illegalTraitValue(name, value);
        }
        return weights;
    }

    public String[] parseFontFamilyTrait(String name, String value) {
        if (value == null) {
            throw this.illegalTraitValue(name, value);
        }
        SimpleTokenizer st = new SimpleTokenizer(value, ",");
        String[] fontFamily = new String[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            fontFamily[i] = st.nextToken();
            fontFamily[i] = fontFamily[i].trim();
            if (fontFamily[i].length() > 0 && fontFamily[i].charAt(0) == '\'' && fontFamily[i].charAt(fontFamily[i].length() - 1) == '\'') {
                fontFamily[i] = fontFamily[i].substring(1, fontFamily[i].length() - 1);
            }
            ++i;
        }
        return fontFamily;
    }

    protected final int[][] parseUnicodeRangeTrait(String name, String value) throws DOMException {
        try {
            return this.ownerDocument.unicodeParser.parseUnicode(value);
        }
        catch (IllegalArgumentException iae) {
            throw this.illegalTraitValue(name, value);
        }
    }

    protected void checkWriteLoading(String name) throws DOMException {
        if (this.loaded && this.isInDocumentTree()) {
            throw this.readOnlyTraitError(name);
        }
    }

    protected void checkPositive(String name, float value) {
        if (value < 0.0f) {
            throw this.illegalTraitValue(name, Float.toString(value));
        }
    }

    protected DOMException unsupportedTraitType(String name, String type) {
        if (name == null) {
            return this.unsupportedTrait(name);
        }
        return new DOMException(17, Messages.formatMessage("error.trait.type.mismatch", new String[]{name, type, this.getLocalName(), this.getNamespaceURI()}));
    }

    protected DOMException unsupportedTraitTypeNS(String name, String namespaceURI, String type) {
        return new DOMException(17, Messages.formatMessage("error.trait.type.ns.mismatch", new String[]{name, namespaceURI, type, this.getLocalName(), this.getNamespaceURI()}));
    }

    protected DOMException unsupportedTrait(String name) {
        return new DOMException(9, Messages.formatMessage("error.unsupported.trait", new String[]{name, null, this.getLocalName(), this.getNamespaceURI()}));
    }

    protected DOMException unsupportedTraitNS(String name, String namespaceURI) {
        return new DOMException(9, Messages.formatMessage("error.unsupported.trait", new String[]{name, namespaceURI, this.getLocalName(), this.getNamespaceURI()}));
    }

    DOMException illegalTraitValue(String name, String value) {
        return new DOMException(15, Messages.formatMessage("error.invalid.trait.value", new String[]{name, value, this.getLocalName() + "(" + this.getId() + ")", this.getNamespaceURI()}));
    }

    DOMException notAnimatable(String traitNamespace, String traitName) {
        return new DOMException(9, Messages.formatMessage(Messages.ERROR_TRAIT_NOT_ANIMATABLE, new String[]{traitNamespace, traitName, this.getLocalName(), this.getNamespaceURI()}));
    }

    protected DOMException animationError(String targetId, String traitNamespace, String traitName, String targetNamespace, String targetName, String animationId, String animationNamespace, String animationLocalName, String errorDescription) {
        return new DOMException(11, Messages.formatMessage("error.invalid.animation.configuration", new String[]{targetId, traitNamespace, traitName, targetNamespace, targetName, animationId, animationNamespace, animationLocalName, animationLocalName, errorDescription}));
    }

    protected DOMException illegalTraitValue(String name, String namespaceURI, String value) {
        return this.illegalTraitValue(name + "(" + namespaceURI + ")", value);
    }

    protected DOMException readOnlyTraitError(String name) {
        return new DOMException(7, Messages.formatMessage("error.read.only.trait", new String[]{name, this.getLocalName(), this.getNamespaceURI()}));
    }

    protected RGB toRGB(String name, float[][] v) throws DOMException {
        if (v != null) {
            return new RGB((int)v[0][0], (int)v[0][1], (int)v[0][2]);
        }
        return null;
    }

    protected String toRGBString(String name, float[][] v) throws DOMException {
        if (v != null) {
            return "rgb(" + (int)v[0][0] + "," + (int)v[0][1] + "," + (int)v[0][2] + ")";
        }
        return "none";
    }

    protected SVGRGBColor toSVGRGBColor(String traitName, PaintServer paint) {
        if (paint == null) {
            return null;
        }
        if (!(paint instanceof SVGRGBColor)) {
            throw this.unsupportedTraitType(traitName, TRAIT_TYPE_SVG_RGB_COLOR);
        }
        return (SVGRGBColor)paint;
    }

    protected SVGRect toSVGRect(float[][] viewBox) {
        if (viewBox == null) {
            return null;
        }
        Box r = new Box(viewBox[0][0], viewBox[0][1], viewBox[1][0], viewBox[2][0]);
        return r;
    }

    protected float[][] toViewBox(String name, String value) throws DOMException {
        if (value == null) {
            throw this.illegalTraitValue(name, value);
        }
        try {
            return this.ownerDocument.viewBoxParser.parseViewBox(value);
        }
        catch (IllegalArgumentException iae) {
            throw this.illegalTraitValue(name, value);
        }
    }

    protected String toStringTrait(String[] array) {
        return this.toStringTrait(array, ",");
    }

    protected String toStringTrait(String[] array, String sep) {
        if (array == null || array.length < 1) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < array.length - 1; ++i) {
            sb.append(array[i]);
            sb.append(sep);
        }
        sb.append(array[array.length - 1]);
        return sb.toString();
    }

    protected String toStringTraitQuote(String[] array) {
        if (array == null || array.length < 1) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < array.length - 1; ++i) {
            if (array[i].indexOf(32) != -1) {
                sb.append('\'');
                sb.append(array[i]);
                sb.append('\'');
            } else {
                sb.append(array[i]);
            }
            sb.append(',');
        }
        if (array[array.length - 1].indexOf(32) != -1) {
            sb.append('\'');
            sb.append(array[array.length - 1]);
            sb.append('\'');
        } else {
            sb.append(array[array.length - 1]);
        }
        return sb.toString();
    }

    protected String toStringTrait(float[] array) {
        return this.toStringTrait(array, ',');
    }

    protected String toStringTrait(float[] array, char sep) {
        if (array == null) {
            return "none";
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < array.length - 1; ++i) {
            sb.append(array[i]);
            sb.append(sep);
        }
        sb.append(array[array.length - 1]);
        return sb.toString();
    }

    protected String toStringTrait(float[][] array) {
        if (array == null || array.length == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < array.length; ++i) {
            for (int j = 0; j < array[i].length - 1; ++j) {
                sb.append(array[i][j]);
                sb.append(',');
            }
            sb.append(array[i][array[i].length - 1]);
            sb.append(';');
        }
        String value = sb.toString();
        return value.substring(0, value.length() - 1);
    }

    protected SVGMatrix toSVGMatrixTrait(Transform transform) {
        if (transform == null) {
            return new Transform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f);
        }
        return new Transform(transform);
    }

    protected static String alignToStringTrait(int align) {
        switch (align) {
            case 1: {
                return "xMidYMid meet";
            }
        }
        return "none";
    }

    protected String fontStylesToStringTrait(int styles) {
        if (styles == 7) {
            return "all";
        }
        StringBuffer sb = new StringBuffer();
        if ((styles & 1) != 0) {
            sb.append("normal");
            sb.append(',');
        }
        if ((styles & 4) != 0) {
            sb.append("italic");
            sb.append(',');
        }
        if ((styles & 2) != 0) {
            sb.append("oblique");
            sb.append(',');
        }
        if (sb.length() > 0) {
            return sb.toString().substring(0, sb.length() - 1);
        }
        return sb.toString();
    }

    protected String fontWeightsToStringTrait(int weight) {
        if (weight == 511) {
            return "all";
        }
        StringBuffer sb = new StringBuffer();
        if ((weight & 1) != 0) {
            sb.append("100");
            sb.append(',');
        }
        if ((weight & 2) != 0) {
            sb.append("200");
            sb.append(',');
        }
        if ((weight & 4) != 0) {
            sb.append("300");
            sb.append(',');
        }
        if ((weight & 8) != 0) {
            sb.append("400");
            sb.append(',');
        }
        if ((weight & 0x10) != 0) {
            sb.append("500");
            sb.append(',');
        }
        if ((weight & 0x20) != 0) {
            sb.append("600");
            sb.append(',');
        }
        if ((weight & 0x40) != 0) {
            sb.append("700");
            sb.append(',');
        }
        if ((weight & 0x80) != 0) {
            sb.append("800");
            sb.append(',');
        }
        if ((weight & 0x100) != 0) {
            sb.append("900");
            sb.append(',');
        }
        if (sb.length() > 0) {
            return sb.toString().substring(0, sb.length() - 1);
        }
        return sb.toString();
    }

    protected static String toStringTrait(Transform transform) {
        if (transform == null) {
            return "matrix(1.0,0.0,0.0,1.0,0.0,0.0)";
        }
        StringBuffer sb = new StringBuffer();
        sb.append("matrix(");
        sb.append(transform.getComponent(0));
        sb.append(",");
        sb.append(transform.getComponent(1));
        sb.append(",");
        sb.append(transform.getComponent(2));
        sb.append(",");
        sb.append(transform.getComponent(3));
        sb.append(",");
        sb.append(transform.getComponent(4));
        sb.append(",");
        sb.append(transform.getComponent(5));
        sb.append(")");
        return sb.toString();
    }

    protected String unicodeRangeToStringTrait(int[][] u) {
        if (u == null) {
            return null;
        }
        if (u.length == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < u.length - 1; ++i) {
            if (u[i] == null || u[i].length != 2) {
                throw new IllegalArgumentException();
            }
            sb.append("U+");
            sb.append(Integer.toHexString(u[i][0]));
            sb.append('-');
            sb.append(Integer.toHexString(u[i][1]));
            sb.append(',');
        }
        if (u[u.length - 1] == null || u[u.length - 1].length != 2) {
            throw new IllegalArgumentException();
        }
        sb.append("U+");
        sb.append(Integer.toHexString(u[u.length - 1][0]));
        sb.append('-');
        sb.append(Integer.toHexString(u[u.length - 1][1]));
        return sb.toString();
    }

    float[][] toAnimatedFloatArray(float v) {
        return new float[][]{{v}};
    }

    float[][] toAnimatedFloatArray(float[] a) {
        float[][] v = new float[a.length][];
        for (int i = 0; i < a.length; ++i) {
            v[i] = new float[]{a[i]};
        }
        return v;
    }

    float[][] toAnimatedFloatArray(Path path) {
        return new float[][]{path.getData()};
    }

    float[] toTraitFloatArray(float[][] value) {
        float[] v = new float[value.length];
        for (int i = 0; i < v.length; ++i) {
            v[i] = value[i][0];
        }
        return v;
    }

    public String toString() {
        if (this.getId() != null && this.getId().length() > 0) {
            return "ElementNode[" + this.getId() + "] [" + super.toString() + "]";
        }
        return super.toString();
    }

    public static boolean equal(Object objA, Object objB) {
        if (objA == objB) {
            return true;
        }
        if (objA == null || objB == null) {
            return false;
        }
        return objA.equals(objB);
    }

    public static boolean equal(float[] faa, float[] fab) {
        if (faa == fab) {
            return true;
        }
        if (faa == null || fab == null || faa.length != fab.length) {
            return false;
        }
        int n = faa.length;
        for (int i = 0; i < n; ++i) {
            if (faa[i] == fab[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean equal(String[] saa, String[] sab) {
        if (saa == sab) {
            return true;
        }
        if (saa == null || sab == null || saa.length != sab.length) {
            return false;
        }
        int n = saa.length;
        for (int i = 0; i < n; ++i) {
            if (ElementNode.equal(saa[i], sab[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean equal(int[][] iaa, int[][] iab) {
        if (iaa == iab) {
            return true;
        }
        if (iaa == null || iab == null || iaa.length != iab.length) {
            return false;
        }
        int n = iaa.length;
        for (int i = 0; i < n; ++i) {
            if (iaa[i] == iab[i]) continue;
            if (iaa[i] == null || iab[i] == null || iaa[i].length != iab[i].length) {
                return false;
            }
            int m = iaa[i].length;
            for (int j = 0; j < m; ++j) {
                if (iaa[i][j] == iab[i][j]) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean equal(float[][] faa, float[][] fab) {
        if (faa == fab) {
            return true;
        }
        if (faa == null || fab == null || faa.length != fab.length) {
            return false;
        }
        int n = faa.length;
        for (int i = 0; i < n; ++i) {
            if (faa[i] == fab[i]) continue;
            if (faa[i] == null || fab[i] == null || faa[i].length != fab[i].length) {
                return false;
            }
            int m = faa[i].length;
            for (int j = 0; j < m; ++j) {
                if (faa[i][j] == fab[i][j]) continue;
                return false;
            }
        }
        return true;
    }

    public static String intern(String str) {
        if (str == null) {
            return null;
        }
        return str.intern();
    }
}

