/*
 * Decompiled with CFR 0.152.
 */
package com.sun.perseus.model;

import com.sun.perseus.j2d.Box;
import com.sun.perseus.j2d.GraphicsProperties;
import com.sun.perseus.j2d.PathSupport;
import com.sun.perseus.j2d.RenderGraphics;
import com.sun.perseus.j2d.Transform;
import com.sun.perseus.model.AbstractShapeNode;
import com.sun.perseus.model.DocumentNode;
import com.sun.perseus.model.ElementNode;
import com.sun.perseus.model.FloatTraitAnim;
import com.sun.perseus.model.TraitAnim;
import com.sun.perseus.platform.MathSupport;
import org.w3c.dom.DOMException;

public class Ellipse
extends AbstractShapeNode {
    static final String[] ELLIPSE_REQUIRED_TRAITS = new String[]{"rx", "ry"};
    static final String[] CIRCLE_REQUIRED_TRAITS = new String[]{"r"};
    protected boolean isCircle = false;
    protected float x;
    protected float y;
    protected float width;
    protected float height;

    public Ellipse(DocumentNode ownerDocument) {
        this(ownerDocument, false);
    }

    public Ellipse(DocumentNode ownerDocument, boolean isCircle) {
        super(ownerDocument);
        this.isCircle = isCircle;
        this.canRenderState |= 0x40;
        this.canRenderState |= 0x80;
    }

    public String getLocalName() {
        if (this.isCircle) {
            return "circle";
        }
        return "ellipse";
    }

    public ElementNode newInstance(DocumentNode doc) {
        return new Ellipse(doc, this.isCircle);
    }

    public float getCx() {
        return this.x + this.width / 2.0f;
    }

    public float getCy() {
        return this.y + this.height / 2.0f;
    }

    public float getRx() {
        return this.width / 2.0f;
    }

    public float getRy() {
        return this.height / 2.0f;
    }

    public void setCx(float cx) {
        float newCx = cx - this.width / 2.0f;
        if (newCx == this.x) {
            return;
        }
        this.modifyingNode();
        this.x = newCx;
        this.renderingDirty();
        this.modifiedNode();
    }

    public void setCy(float cy) {
        float newCy = cy - this.height / 2.0f;
        if (this.y == newCy) {
            return;
        }
        this.modifyingNode();
        this.y = newCy;
        this.renderingDirty();
        this.modifiedNode();
    }

    public void setRx(float rx) {
        if (rx < 0.0f) {
            throw new IllegalArgumentException();
        }
        if (this.width == rx * 2.0f) {
            return;
        }
        this.modifyingNode();
        this.renderingDirty();
        float cx = this.getCx();
        this.width = rx * 2.0f;
        this.x = cx - rx;
        this.computeCanRenderWidthBit(this.width);
        if (this.isCircle) {
            float cy = this.getCy();
            this.height = rx * 2.0f;
            this.y = cy - rx;
            this.computeCanRenderHeightBit(this.width);
        }
        this.modifiedNode();
    }

    public void setRy(float ry) {
        if (ry < 0.0f) {
            throw new IllegalArgumentException();
        }
        if (this.height == ry * 2.0f) {
            return;
        }
        this.modifyingNode();
        this.renderingDirty();
        float cy = this.getCy();
        this.height = ry * 2.0f;
        this.y = cy - ry;
        if (this.isCircle) {
            float cx = this.getCx();
            this.width = ry * 2.0f;
            this.x = cx - ry;
        }
        this.computeCanRenderHeightBit(this.height);
        this.modifiedNode();
    }

    public void fillShape(RenderGraphics rg) {
        rg.fillOval(this.x, this.y, this.width, this.height);
    }

    public void drawShape(RenderGraphics rg) {
        rg.drawOval(this.x, this.y, this.width, this.height);
    }

    public boolean contains(float x, float y, int fillRule) {
        float normx = (x - this.x) / this.width - 0.5f;
        float normy = (y - this.y) / this.height - 0.5f;
        return normx * normx + normy * normy < 0.25f;
    }

    Object getStrokedPath(GraphicsProperties gp) {
        return PathSupport.getStrokedEllipse(this.x, this.y, this.width, this.height, gp);
    }

    boolean supportsTrait(String traitName) {
        if ("cx" == traitName || "cy" == traitName) {
            return true;
        }
        if (this.isCircle && "r" == traitName) {
            return true;
        }
        if (!(this.isCircle || "rx" != traitName && "ry" != traitName)) {
            return true;
        }
        return super.supportsTrait(traitName);
    }

    public String[] getRequiredTraits() {
        if (this.isCircle) {
            return CIRCLE_REQUIRED_TRAITS;
        }
        return ELLIPSE_REQUIRED_TRAITS;
    }

    public String getTraitImpl(String name) throws DOMException {
        if ("cx" == name) {
            return Float.toString(this.getCx());
        }
        if ("cy" == name) {
            return Float.toString(this.getCy());
        }
        if (!this.isCircle && "rx" == name || this.isCircle && "r" == name) {
            return Float.toString(this.getRx());
        }
        if (!this.isCircle && "ry" == name) {
            return Float.toString(this.getRy());
        }
        return super.getTraitImpl(name);
    }

    float getFloatTraitImpl(String name) throws DOMException {
        if ("cx" == name) {
            return this.getCx();
        }
        if ("cy" == name) {
            return this.getCy();
        }
        if (!this.isCircle && "rx" == name || this.isCircle && "r" == name) {
            return this.getRx();
        }
        if ("ry" == name) {
            return this.getRy();
        }
        return super.getFloatTraitImpl(name);
    }

    TraitAnim createTraitAnimImpl(String traitName) {
        if ("cx" == traitName || "cy" == traitName || "rx" == traitName || "ry" == traitName || "r" == traitName) {
            return new FloatTraitAnim(this, traitName, "float");
        }
        return super.createTraitAnimImpl(traitName);
    }

    void setFloatArrayTrait(String name, float[][] value) throws DOMException {
        if ("cx" == name) {
            this.setCx(value[0][0]);
        } else if ("cy" == name) {
            this.setCy(value[0][0]);
        } else if ("rx" == name) {
            this.checkPositive(name, value[0][0]);
            this.setRx(value[0][0]);
        } else if ("ry" == name) {
            this.checkPositive(name, value[0][0]);
            this.setRy(value[0][0]);
        } else if ("r" == name) {
            this.checkPositive(name, value[0][0]);
            this.setRx(value[0][0]);
        } else {
            super.setFloatArrayTrait(name, value);
        }
    }

    public float[][] validateFloatArrayTrait(String traitName, String value, String reqNamespaceURI, String reqLocalName, String reqTraitNamespace, String reqTraitName) throws DOMException {
        if ("cx" == traitName || "cy" == traitName) {
            return this.toAnimatedFloatArray(this.parseFloatTrait(traitName, value));
        }
        if ("rx" == traitName || "r" == traitName || "ry" == traitName) {
            return this.toAnimatedFloatArray(this.parsePositiveFloatTrait(traitName, value));
        }
        return super.validateFloatArrayTrait(traitName, value, reqNamespaceURI, reqLocalName, reqTraitNamespace, reqTraitName);
    }

    public void setTraitImpl(String name, String value) throws DOMException {
        if ("cx" == name) {
            this.setCx(this.parseFloatTrait(name, value));
        } else if ("cy" == name) {
            this.setCy(this.parseFloatTrait(name, value));
        } else if (!this.isCircle && "rx" == name || this.isCircle && "r" == name) {
            this.setRx(this.parsePositiveFloatTrait(name, value));
        } else if ("ry" == name) {
            this.setRy(this.parsePositiveFloatTrait(name, value));
        } else {
            super.setTraitImpl(name, value);
        }
    }

    public void setFloatTraitImpl(String name, float value) throws DOMException {
        if ("cx" == name) {
            this.setCx(value);
        } else if ("cy" == name) {
            this.setCy(value);
        } else if (!this.isCircle && "rx" == name || this.isCircle && "r" == name) {
            this.checkPositive(name, value);
            this.setRx(value);
        } else if ("ry" == name) {
            this.checkPositive(name, value);
            this.setRy(value);
        } else {
            super.setFloatTraitImpl(name, value);
        }
    }

    String toStringTrait(String name, float[][] value) {
        if ("cx" == name || "cy" == name) {
            return Float.toString(value[0][0]);
        }
        if (!this.isCircle && "rx" == name || this.isCircle && "r" == name) {
            return Float.toString(value[0][0]);
        }
        if ("ry" == name) {
            return Float.toString(value[0][0]);
        }
        return super.toStringTrait(name, value);
    }

    Box addNodeBBox(Box bbox, Transform t) {
        float rx = this.getRx();
        float ry = this.getRy();
        if (t == null || t.getComponent(1) == 0.0f && t.getComponent(2) == 0.0f || this.width == 0.0f || this.height == 0.0f) {
            return Ellipse.addTransformedBBox(bbox, this.x, this.y, this.width, this.height, t);
        }
        float m0 = t.getComponent(0);
        float m1 = t.getComponent(1);
        float m2 = t.getComponent(2);
        float m3 = t.getComponent(3);
        float m4 = t.getComponent(4);
        float m5 = t.getComponent(5);
        float cx = this.getCx();
        float cy = this.getCy();
        float m0rx = m0 * rx;
        float m2ry = m2 * ry;
        float m1rx = m1 * rx;
        float m3ry = m3 * ry;
        float theta = MathSupport.atan2(m2ry, m0rx);
        float theta2 = theta + (float)Math.PI;
        float cost = MathSupport.cos(theta);
        float sint = MathSupport.sin(theta);
        float cost2 = MathSupport.cos(theta2);
        float sint2 = MathSupport.sin(theta2);
        float maxX = m0rx * cost + m2ry * sint;
        float minX = m0rx * cost2 + m2ry * sint2;
        float width = maxX - minX;
        if (minX > maxX) {
            minX = maxX;
            width = -width;
        }
        theta = MathSupport.atan2(m3ry, m1rx);
        theta2 = theta + (float)Math.PI;
        cost = MathSupport.cos(theta);
        sint = MathSupport.sin(theta);
        cost2 = MathSupport.cos(theta2);
        sint2 = MathSupport.sin(theta2);
        float maxY = m1rx * cost + m3ry * sint;
        float minY = m1rx * cost2 + m3ry * sint2;
        float height = maxY - minY;
        if (minY > maxY) {
            minY = maxY;
            height = -height;
        }
        float fx = m0 * cx + m2 * cy + m4;
        float fy = m1 * cx + m3 * cy + m5;
        return Ellipse.addBBox(bbox, fx + minX, fy + minY, width, height);
    }
}

