/*
 * Decompiled with CFR 0.152.
 */
package com.sun.perseus.model;

import com.sun.perseus.model.Animation;
import com.sun.perseus.model.Segment;
import com.sun.perseus.platform.MathSupport;

class FloatSegment
implements Segment {
    float[][] start;
    float[][] end;

    FloatSegment() {
    }

    public Object[] getStart() {
        return this.start;
    }

    public Object[] getEnd() {
        return this.end;
    }

    public void setZeroStart() {
        for (int ci = 0; ci < this.start.length; ++ci) {
            for (int di = 0; di < this.start[ci].length; ++di) {
                this.start[ci][di] = 0.0f;
            }
        }
    }

    public void setStart(Object[] newStart) {
        this.start = (float[][])newStart;
    }

    public void collapse(Segment seg, Animation anim) {
        FloatSegment mseg = (FloatSegment)seg;
        if (mseg.end.length != this.end.length) {
            throw new IllegalArgumentException();
        }
        this.end = mseg.end;
    }

    public void addToEnd(Object[] by) {
        if (by == null || !(by instanceof float[][])) {
            throw new IllegalArgumentException();
        }
        float[][] add = (float[][])by;
        if (add.length != this.end.length) {
            throw new IllegalArgumentException();
        }
        for (int ci = 0; ci < add.length; ++ci) {
            int avl;
            float[] v = this.end[ci];
            float[] av = add[ci];
            int vl = v != null ? v.length : 0;
            int n = avl = av != null ? av.length : 0;
            if (vl != avl) {
                throw new IllegalArgumentException();
            }
            for (int di = 0; di < vl; ++di) {
                int n2 = di;
                v[n2] = v[n2] + av[di];
            }
        }
    }

    public boolean isAdditive() {
        return true;
    }

    public float getLength() {
        float length = 0.0f;
        int nc = this.start.length;
        for (int ci = 0; ci < nc; ++ci) {
            float[] s = this.start[ci];
            float[] e = this.end[ci];
            int nd = s.length;
            float clength = 0.0f;
            for (int di = 0; di < nd; ++di) {
                clength += (e[di] - s[di]) * (e[di] - s[di]);
            }
            length += MathSupport.sqrt(clength);
        }
        return length;
    }

    public void compute(float p, float[][] w) {
        int nc = w.length;
        int nd = 0;
        for (int ci = 0; ci < nc; ++ci) {
            nd = w[ci].length;
            for (int di = 0; di < nd; ++di) {
                w[ci][di] = p * this.end[ci][di] + (1.0f - p) * this.start[ci][di];
            }
        }
    }

    public String toString() {
        int di;
        float[] fc;
        int ci;
        StringBuffer sb = new StringBuffer();
        sb.append("FloatSegment[");
        if (this.start == null) {
            sb.append("null");
        } else {
            sb.append("start[" + this.start.length + "] : {");
            for (ci = 0; ci < this.start.length; ++ci) {
                fc = this.start[ci];
                if (fc == null) {
                    sb.append("null");
                } else {
                    sb.append("float[" + fc.length + "{");
                    for (di = 0; di < fc.length; ++di) {
                        sb.append(fc[di]);
                        if (di >= fc.length - 1) continue;
                        sb.append(", ");
                    }
                    sb.append("}");
                }
                if (ci >= this.start.length - 1) continue;
                sb.append(", ");
            }
            sb.append("} ");
        }
        if (this.end == null) {
            sb.append("null");
        } else {
            sb.append("end[" + this.end.length + "] : {");
            for (ci = 0; ci < this.end.length; ++ci) {
                fc = this.end[ci];
                if (fc == null) {
                    sb.append("null");
                } else {
                    sb.append("float[" + fc.length + "{");
                    for (di = 0; di < fc.length; ++di) {
                        sb.append(fc[di]);
                        if (di >= fc.length - 1) continue;
                        sb.append(", ");
                    }
                    sb.append("}");
                }
                if (ci >= this.end.length - 1) continue;
                sb.append(", ");
            }
            sb.append("}");
        }
        return sb.toString();
    }

    public void initialize() {
    }
}

