/*
 * Decompiled with CFR 0.152.
 */
package com.sun.perseus.model;

import com.sun.perseus.j2d.Box;
import com.sun.perseus.j2d.RenderGraphics;
import com.sun.perseus.j2d.TextRenderingProperties;
import com.sun.perseus.j2d.Tile;
import com.sun.perseus.j2d.Transform;
import com.sun.perseus.model.DocumentNode;
import com.sun.perseus.model.GlyphProxy;

class GlyphLayout {
    protected float advance;
    protected float x;
    protected float y;
    protected GlyphProxy firstChild;
    protected GlyphProxy lastChild;
    protected GlyphLayout prevSibling;
    protected GlyphLayout nextSibling;
    protected DocumentNode ownerDocument;

    GlyphLayout(DocumentNode doc) {
        this.ownerDocument = doc;
    }

    Box addBBox(Box bbox, Transform t) {
        GlyphProxy gp = this.firstChild;
        while (gp != null) {
            this.ownerDocument.bboxGlyphTxf.setTransform(t);
            gp.applyTransform(this.ownerDocument.bboxGlyphTxf);
            bbox = gp.addNodeBBox(bbox, this.ownerDocument.bboxGlyphTxf);
            gp = gp.nextSibling;
        }
        return bbox;
    }

    protected final Tile addRenderingTile(Tile tile, TextRenderingProperties trp, Transform t) {
        if (trp.getStroke() != null) {
            GlyphProxy gp = this.firstChild;
            while (gp != null) {
                this.ownerDocument.bboxGlyphTxf.setTransform(t);
                gp.applyTransform(this.ownerDocument.bboxGlyphTxf);
                tile = gp.addRenderingTile(tile, trp, t);
                gp = gp.nextSibling;
            }
        } else {
            GlyphProxy gp = this.firstChild;
            float strokeWidth = trp.getStrokeWidth();
            while (gp != null) {
                this.ownerDocument.bboxGlyphTxf.setTransform(t);
                gp.applyTransform(this.ownerDocument.bboxGlyphTxf);
                trp.setStrokeWidth(strokeWidth / gp.proxied.emSquareScale);
                tile = gp.addRenderingTile(tile, trp, t);
                gp = gp.nextSibling;
            }
        }
        return tile;
    }

    public void add(GlyphProxy proxy) {
        if (proxy == null) {
            throw new NullPointerException();
        }
        if (this.firstChild == null) {
            this.firstChild = proxy;
            this.lastChild = proxy;
            proxy.nextSibling = null;
            proxy.prevSibling = null;
        } else {
            this.lastChild.nextSibling = proxy;
            proxy.nextSibling = null;
            proxy.prevSibling = this.lastChild;
            this.lastChild = proxy;
        }
    }

    protected void applyTransform(TextRenderingProperties trp, Transform tx) {
        tx.mTranslate(this.x, this.y);
        float fontSize = trp.getFontSize();
        if (fontSize > 0.0f) {
            tx.mScale(fontSize);
        }
        switch (trp.getTextAnchor()) {
            default: {
                break;
            }
            case 1: {
                tx.mTranslate(-this.advance / 2.0f, 0.0f);
                break;
            }
            case 2: {
                tx.mTranslate(-this.advance, 0.0f);
            }
        }
    }

    protected void applyInverseTransform(TextRenderingProperties trp, Transform tx) {
        switch (trp.getTextAnchor()) {
            default: {
                break;
            }
            case 1: {
                tx.mTranslate(this.advance / 2.0f, 0.0f);
                break;
            }
            case 2: {
                tx.mTranslate(this.advance, 0.0f);
            }
        }
        float fontSize = trp.getFontSize();
        if (fontSize > 0.0f) {
            tx.mScale(1.0f / fontSize);
        }
        tx.mTranslate(-this.x, -this.y);
    }

    void fillText(RenderGraphics rg, Transform tx) {
        GlyphProxy c = this.firstChild;
        while (c != null) {
            this.ownerDocument.paintGlyphTxf.setTransform(tx);
            c.applyTransform(this.ownerDocument.paintGlyphTxf);
            rg.setTransform(this.ownerDocument.paintGlyphTxf);
            if (c.proxied.d != null) {
                rg.fill(c.proxied.d);
            }
            c = c.nextSibling;
        }
    }

    void drawText(RenderGraphics rg, Transform tx) {
        GlyphProxy c = this.firstChild;
        float strokeWidth = rg.getStrokeWidth();
        while (c != null) {
            this.ownerDocument.paintGlyphTxf.setTransform(tx);
            c.applyTransform(this.ownerDocument.paintGlyphTxf);
            rg.setTransform(this.ownerDocument.paintGlyphTxf);
            rg.setStrokeWidth(strokeWidth / c.proxied.emSquareScale);
            if (c.proxied.d != null) {
                rg.draw(c.proxied.d);
            }
            c = c.nextSibling;
        }
        rg.setStrokeWidth(strokeWidth);
    }

    protected boolean isHitVP(float[] pt, TextRenderingProperties trp, Transform chunkTxf) {
        GlyphProxy c = this.lastChild;
        while (c != null) {
            this.ownerDocument.hitGlyphTxf.setTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f);
            c.applyInverseTransform(this.ownerDocument.hitGlyphTxf);
            this.ownerDocument.hitGlyphTxf.mMultiply(chunkTxf);
            this.ownerDocument.hitGlyphTxf.transformPoint(pt, this.ownerDocument.upt);
            if (c.isHit(this.ownerDocument.upt, trp)) {
                return true;
            }
            c = c.prevSibling;
        }
        return false;
    }

    public String toString() {
        return "GlyphLayout[x=" + this.x + ", y=" + this.y + " advance=" + this.advance + "]";
    }
}

