/*
 * Decompiled with CFR 0.152.
 */
package com.sun.perseus.model;

import com.sun.perseus.j2d.Transform;
import com.sun.perseus.model.DocumentNode;
import com.sun.perseus.model.ElementNode;
import com.sun.perseus.model.MotionTraitAnim;
import com.sun.perseus.model.StructureNode;
import com.sun.perseus.model.TraitAnim;
import com.sun.perseus.model.TransformTraitAnim;
import com.sun.perseus.model.Transformable;
import org.w3c.dom.DOMException;
import org.w3c.dom.svg.SVGMatrix;

public class Group
extends StructureNode
implements Transformable {
    protected Transform transform;
    protected Transform motion;
    protected Transform inverseTransform;

    public Group(DocumentNode ownerDocument) {
        super(ownerDocument);
    }

    public String getLocalName() {
        return "g";
    }

    public ElementNode newInstance(DocumentNode doc) {
        return new Group(doc);
    }

    public void setTransform(Transform newTransform) {
        if (Group.equal(newTransform, this.transform)) {
            return;
        }
        this.modifyingNode();
        this.transform = newTransform;
        this.recomputeTransformState();
        this.recomputeProxyTransformState();
        this.modifiedNode();
    }

    public void setMotion(Transform newMotion) {
        if (Group.equal(newMotion, this.motion)) {
            return;
        }
        this.modifyingNode();
        this.motion = newMotion;
        this.recomputeTransformState();
        this.recomputeProxyTransformState();
        this.modifiedNode();
    }

    public Transform getTransform() {
        return this.transform;
    }

    public Transform getMotion() {
        return this.motion;
    }

    protected Transform appendTransform(Transform tx, Transform workTx) {
        if (this.transform == null && this.motion == null) {
            return tx;
        }
        tx = this.recycleTransform(tx, workTx);
        if (this.motion != null) {
            tx.mMultiply(this.motion);
        }
        if (this.transform != null) {
            tx.mMultiply(this.transform);
        }
        return tx;
    }

    boolean supportsTrait(String traitName) {
        if ("transform" == traitName || "#motion" == traitName) {
            return true;
        }
        return super.supportsTrait(traitName);
    }

    public String getTraitImpl(String name) throws DOMException {
        if ("transform" == name) {
            return Group.toStringTrait(this.transform);
        }
        if ("#motion" == name) {
            return Group.toStringTrait(this.motion);
        }
        return super.getTraitImpl(name);
    }

    public void setTraitImpl(String name, String value) throws DOMException {
        if ("transform" == name) {
            this.setTransform(this.parseTransformTrait(name, value));
        } else if ("#motion" == name) {
            this.setMotion(this.parseTransformTrait(name, value));
        } else {
            super.setTraitImpl(name, value);
        }
    }

    SVGMatrix getMatrixTraitImpl(String name) throws DOMException {
        if ("transform".equals(name)) {
            return this.toSVGMatrixTrait(this.transform);
        }
        if ("#motion".equals(name)) {
            return this.toSVGMatrixTrait(this.motion);
        }
        return super.getMatrixTraitImpl(name);
    }

    void setMatrixTraitImpl(String name, Transform matrix) throws DOMException {
        if ("transform".equals(name)) {
            this.setTransform(matrix);
        } else if ("#motion".equals(name)) {
            this.setMotion(matrix);
        } else {
            super.setMatrixTraitImpl(name, matrix);
        }
    }

    TraitAnim createTraitAnimImpl(String traitName) {
        if ("transform" == traitName) {
            return new TransformTraitAnim(this, traitName);
        }
        if ("#motion" == traitName) {
            return new MotionTraitAnim(this, traitName);
        }
        return super.createTraitAnimImpl(traitName);
    }

    void setFloatArrayTrait(String name, float[][] value) throws DOMException {
        if ("transform".equals(name)) {
            if (this.transform == null) {
                this.modifyingNode();
                this.transform = new Transform(value[0][0], value[1][0], value[2][0], value[3][0], value[4][0], value[5][0]);
            } else if (!this.transform.equals(value)) {
                this.modifyingNode();
                this.transform.setTransform(value[0][0], value[1][0], value[2][0], value[3][0], value[4][0], value[5][0]);
            } else {
                return;
            }
            this.recomputeTransformState();
            this.recomputeProxyTransformState();
            this.modifiedNode();
        } else if ("#motion" == name) {
            if (this.motion == null) {
                this.modifyingNode();
                this.motion = new Transform(value[0][0], value[1][0], value[2][0], value[3][0], value[4][0], value[5][0]);
            } else if (!this.motion.equals(value)) {
                this.modifyingNode();
                this.motion.setTransform(value[0][0], value[1][0], value[2][0], value[3][0], value[4][0], value[5][0]);
            } else {
                return;
            }
            this.recomputeTransformState();
            this.recomputeProxyTransformState();
            this.modifiedNode();
        } else {
            super.setFloatArrayTrait(name, value);
        }
    }

    public float[][] validateFloatArrayTrait(String traitName, String value, String reqNamespaceURI, String reqLocalName, String reqTraitNamespace, String reqTraitName) throws DOMException {
        if ("transform" == traitName || "#motion" == traitName) {
            Transform txf = this.parseTransformTrait(traitName, value);
            return new float[][]{{txf.getComponent(0)}, {txf.getComponent(1)}, {txf.getComponent(2)}, {txf.getComponent(3)}, {txf.getComponent(4)}, {txf.getComponent(5)}};
        }
        return super.validateFloatArrayTrait(traitName, value, reqNamespaceURI, reqLocalName, reqTraitNamespace, reqTraitName);
    }

    String toStringTrait(String name, float[][] value) {
        if ("transform" == name) {
            Transform transform = new Transform(value[0][0], value[1][0], value[2][0], value[3][0], value[4][0], value[5][0]);
            return Group.toStringTrait(transform);
        }
        return super.toStringTrait(name, value);
    }
}

