/*
 * Decompiled with CFR 0.152.
 */
package com.sun.perseus.model;

import com.sun.perseus.j2d.Box;
import com.sun.perseus.j2d.GraphicsProperties;
import com.sun.perseus.j2d.PaintTarget;
import com.sun.perseus.j2d.RasterImage;
import com.sun.perseus.j2d.RenderGraphics;
import com.sun.perseus.j2d.Tile;
import com.sun.perseus.j2d.Transform;
import com.sun.perseus.model.AbstractRenderingNode;
import com.sun.perseus.model.AbstractRenderingNodeProxy;
import com.sun.perseus.model.DocumentNode;
import com.sun.perseus.model.ElementNode;
import com.sun.perseus.model.FloatTraitAnim;
import com.sun.perseus.model.ModelNode;
import com.sun.perseus.model.RasterImageConsumer;
import com.sun.perseus.model.StringTraitAnim;
import com.sun.perseus.model.TraitAnim;
import com.sun.perseus.util.RunnableQueue;
import org.w3c.dom.DOMException;

public class ImageNode
extends AbstractRenderingNode
implements RasterImageConsumer {
    static final String[] REQUIRED_TRAITS = new String[]{"width", "height"};
    static final String[][] REQUIRED_TRAITS_NS = new String[][]{{"http://www.w3.org/1999/xlink", "href"}};
    protected float x;
    protected float y;
    protected float width;
    protected float height;
    protected RasterImage image;
    protected boolean imageLoaded;
    protected String href;
    protected String absoluteURI;
    protected int align = 1;
    protected static final String BROKEN_URI = "broken uri";

    public ImageNode(DocumentNode ownerDocument) {
        super(ownerDocument);
        this.image = ownerDocument.getImageLoader().getLoadingImage();
        this.canRenderState |= 0x40;
        this.canRenderState |= 0x80;
    }

    public String getLocalName() {
        return "image";
    }

    public ElementNode newInstance(DocumentNode doc) {
        return new ImageNode(doc);
    }

    protected void computeRenderingTile(Tile tile, Transform t, GraphicsProperties gp) {
        tile.snapBox(this.addNodeBBox(null, t));
    }

    public void setX(float newX) {
        if (newX == this.x) {
            return;
        }
        this.modifyingNode();
        this.renderingDirty();
        this.x = newX;
        this.modifiedNode();
    }

    public void setY(float newY) {
        if (newY == this.y) {
            return;
        }
        this.modifyingNode();
        this.renderingDirty();
        this.y = newY;
        this.modifiedNode();
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public void setWidth(float newWidth) {
        if (newWidth < 0.0f) {
            throw new IllegalArgumentException();
        }
        if (newWidth == this.width) {
            return;
        }
        this.modifyingNode();
        this.renderingDirty();
        this.width = newWidth;
        this.computeCanRenderWidthBit(this.width);
        this.modifiedNode();
    }

    public float getWidth() {
        return this.width;
    }

    public void setHeight(float newHeight) {
        if (newHeight < 0.0f) {
            throw new IllegalArgumentException();
        }
        if (newHeight == this.height) {
            return;
        }
        this.modifyingNode();
        this.renderingDirty();
        this.height = newHeight;
        this.computeCanRenderHeightBit(this.height);
        this.modifiedNode();
    }

    public float getHeight() {
        return this.height;
    }

    protected void setParentQuiet(ModelNode newParent) {
        super.setParentQuiet(newParent);
        if (this.href != null && !this.href.equals(this.absoluteURI)) {
            this.willNeedImage();
        }
    }

    public void setHref(String newHref) {
        if (newHref == null) {
            throw new IllegalArgumentException();
        }
        if (ImageNode.equal(newHref, this.href)) {
            return;
        }
        this.modifyingNode();
        this.renderingDirty();
        this.href = newHref;
        this.image = this.ownerDocument.getImageLoader().getLoadingImage();
        this.ownerDocument.getImageLoader().removeRasterImageConsumer(this.absoluteURI, this);
        this.absoluteURI = null;
        this.imageLoaded = false;
        if (this.isInDocumentTree() && this.href != null) {
            this.willNeedImage();
        }
        this.modifiedNode();
    }

    void willNeedImage() {
        this.imageLoaded = false;
        this.image = this.ownerDocument.getImageLoader().getLoadingImage();
        this.absoluteURI = this.ownerDocument.getImageLoader().resolveURI(this.href, this.getURIBase());
        if (this.absoluteURI == null) {
            if (this.paintNeedsLoad) {
                throw new IllegalArgumentException();
            }
            this.absoluteURI = BROKEN_URI;
            this.imageLoaded = true;
            this.image = this.ownerDocument.getImageLoader().getBrokenImage();
            return;
        }
        this.ownerDocument.getImageLoader().addRasterImageConsumer(this.absoluteURI, this);
        this.ownerDocument.getImageLoader().needsURI(this.absoluteURI);
    }

    public String getHref() {
        return this.href;
    }

    public RasterImage getImage() {
        return this.image;
    }

    public void setImage(RasterImage image, String uri) {
        if (this.absoluteURI != null && this.absoluteURI.equals(uri) && this.image != image) {
            this.modifyingNode();
            this.image = image;
            this.modifiedNode();
        }
    }

    public RunnableQueue getUpdateQueue() {
        return this.ownerDocument.getUpdateQueue();
    }

    public RunnableQueue.RunnableHandler getRunnableHandler() {
        return this.ownerDocument.getRunnableHandler();
    }

    public void setAlign(int newAlign) {
        if (newAlign == this.align) {
            return;
        }
        this.modifyingNode();
        this.align = newAlign;
        this.modifiedNode();
    }

    public int getAlign() {
        return this.align;
    }

    void paintRendered(RenderGraphics rg, GraphicsProperties gp, PaintTarget pt, Transform tx) {
        if (!gp.getVisibility()) {
            return;
        }
        rg.setTransform(tx);
        if (!this.imageLoaded) {
            this.loadImage();
        }
        int iw = this.image.getWidth();
        int ih = this.image.getHeight();
        if (this.align == 0) {
            rg.drawImage(this.image, this.x, this.y, this.width, this.height);
        } else {
            float ws = this.width / (float)iw;
            float hs = this.height / (float)ih;
            float is = ws;
            if (hs < ws) {
                is = hs;
            }
            float oh = (float)ih * is;
            float ow = (float)iw * is;
            float dx = (this.width - ow) / 2.0f;
            float dy = (this.height - oh) / 2.0f;
            rg.drawImage(this.image, this.x + dx, this.y + dy, ow, oh);
        }
    }

    public void loadImage() {
        if (this.absoluteURI != null) {
            if (this.paintNeedsLoad) {
                this.image = this.ownerDocument.getImageLoader().getImageAndWait(this.absoluteURI);
                if (this.image == this.ownerDocument.getImageLoader().getBrokenImage()) {
                    throw new IllegalStateException();
                }
            } else {
                this.ownerDocument.getImageLoader().getImageLater(this.absoluteURI, this);
            }
        }
        this.imageLoaded = true;
    }

    public boolean hasNodeRendering() {
        return true;
    }

    protected boolean isHitVP(float[] pt) {
        if (!this.getVisibility()) {
            return false;
        }
        this.getInverseTransformState().transformPoint(pt, this.ownerDocument.upt);
        pt = this.ownerDocument.upt;
        return pt[0] > this.x && pt[0] < this.x + this.width && pt[1] > this.y && pt[1] < this.y + this.height;
    }

    protected boolean isProxyHitVP(float[] pt, AbstractRenderingNodeProxy proxy) {
        proxy.getInverseTransformState().transformPoint(pt, this.ownerDocument.upt);
        pt = this.ownerDocument.upt;
        return pt[0] > this.x && pt[0] < this.x + this.width && pt[1] > this.y && pt[1] < this.y + this.height;
    }

    boolean supportsTrait(String traitName) {
        if ("x" == traitName || "y" == traitName || "width" == traitName || "height" == traitName || "preserveAspectRatio" == traitName) {
            return true;
        }
        return super.supportsTrait(traitName);
    }

    public String[] getRequiredTraits() {
        return REQUIRED_TRAITS;
    }

    public String[][] getRequiredTraitsNS() {
        return REQUIRED_TRAITS_NS;
    }

    boolean supportsTraitNS(String namespaceURI, String traitName) {
        if ("http://www.w3.org/1999/xlink" == namespaceURI && "href" == traitName) {
            return true;
        }
        return super.supportsTraitNS(namespaceURI, traitName);
    }

    public String getTraitImpl(String name) throws DOMException {
        if ("x" == name) {
            return Float.toString(this.getX());
        }
        if ("y" == name) {
            return Float.toString(this.getY());
        }
        if ("width" == name) {
            return Float.toString(this.getWidth());
        }
        if ("height" == name) {
            return Float.toString(this.getHeight());
        }
        if ("preserveAspectRatio" == name) {
            return ImageNode.alignToStringTrait(this.align);
        }
        return super.getTraitImpl(name);
    }

    String getTraitNSImpl(String namespaceURI, String name) throws DOMException {
        if ("http://www.w3.org/1999/xlink" == namespaceURI && "href" == name) {
            if (this.href == null) {
                return "";
            }
            return this.href;
        }
        return super.getTraitNSImpl(namespaceURI, name);
    }

    float getFloatTraitImpl(String name) throws DOMException {
        if ("x" == name) {
            return this.getX();
        }
        if ("y" == name) {
            return this.getY();
        }
        if ("width" == name) {
            return this.getWidth();
        }
        if ("height" == name) {
            return this.getHeight();
        }
        return super.getFloatTraitImpl(name);
    }

    TraitAnim createTraitAnimImpl(String traitName) {
        if ("x" == traitName || "y" == traitName || "width" == traitName || "height" == traitName) {
            return new FloatTraitAnim(this, traitName, "float");
        }
        if ("preserveAspectRatio" == traitName) {
            return new StringTraitAnim(this, "#!null/ns@!", traitName);
        }
        return super.createTraitAnimImpl(traitName);
    }

    TraitAnim createTraitAnimNSImpl(String traitNamespace, String traitName) {
        if (traitNamespace == "http://www.w3.org/1999/xlink" && traitName == "href") {
            return new StringTraitAnim(this, traitNamespace, traitName);
        }
        return super.createTraitAnimNSImpl(traitNamespace, traitName);
    }

    void setFloatArrayTrait(String name, float[][] value) throws DOMException {
        if ("x" == name) {
            this.setX(value[0][0]);
        } else if ("y" == name) {
            this.setY(value[0][0]);
        } else if ("width" == name) {
            this.checkPositive(name, value[0][0]);
            this.setWidth(value[0][0]);
        } else if ("height" == name) {
            this.checkPositive(name, value[0][0]);
            this.setHeight(value[0][0]);
        } else {
            super.setFloatArrayTrait(name, value);
        }
    }

    public float[][] validateFloatArrayTrait(String traitName, String value, String reqNamespaceURI, String reqLocalName, String reqTraitNamespace, String reqTraitName) throws DOMException {
        if ("x" == traitName || "y" == traitName) {
            return new float[][]{{this.parseFloatTrait(traitName, value)}};
        }
        if ("width" == traitName || "height" == traitName) {
            return new float[][]{{this.parsePositiveFloatTrait(traitName, value)}};
        }
        return super.validateFloatArrayTrait(traitName, value, reqNamespaceURI, reqLocalName, reqTraitNamespace, reqTraitName);
    }

    String validateTraitNS(String namespaceURI, String traitName, String value, String reqNamespaceURI, String reqLocalName, String reqTraitNamespace, String reqTraitName) throws DOMException {
        if (namespaceURI != null) {
            return super.validateTraitNS(namespaceURI, traitName, value, reqNamespaceURI, reqLocalName, reqTraitNamespace, reqTraitName);
        }
        if ("preserveAspectRatio".equals(traitName)) {
            if (!"xMidYMid meet".equals(value) && !"none".equals(value)) {
                throw this.illegalTraitValue(traitName, value);
            }
            return value;
        }
        return super.validateTraitNS(namespaceURI, traitName, value, reqNamespaceURI, reqLocalName, reqTraitNamespace, reqTraitName);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setTraitImpl(String name, String value) throws DOMException {
        if ("x" == name) {
            this.setX(this.parseFloatTrait(name, value));
            return;
        } else if ("y" == name) {
            this.setY(this.parseFloatTrait(name, value));
            return;
        } else if ("width" == name) {
            this.setWidth(this.parsePositiveFloatTrait(name, value));
            return;
        } else if ("height" == name) {
            this.setHeight(this.parsePositiveFloatTrait(name, value));
            return;
        } else if ("preserveAspectRatio".equals(name)) {
            if ("xMidYMid meet".equals(value)) {
                this.setAlign(1);
                return;
            } else {
                if (!"none".equals(value)) throw this.illegalTraitValue(name, value);
                this.setAlign(0);
            }
            return;
        } else {
            super.setTraitImpl(name, value);
        }
    }

    public void setTraitNSImpl(String namespaceURI, String name, String value) throws DOMException {
        try {
            if ("http://www.w3.org/1999/xlink" == namespaceURI && "href" == name) {
                this.setHref(value);
            } else {
                super.setTraitNSImpl(namespaceURI, name, value);
            }
        }
        catch (IllegalArgumentException iae) {
            throw this.illegalTraitValue(name, value);
        }
    }

    public void setFloatTraitImpl(String name, float value) throws DOMException {
        try {
            if ("x" == name) {
                this.setX(value);
            } else if ("y" == name) {
                this.setY(value);
            } else if ("width" == name) {
                this.setWidth(value);
            } else if ("height" == name) {
                this.setHeight(value);
            } else {
                super.setFloatTraitImpl(name, value);
            }
        }
        catch (IllegalArgumentException iae) {
            throw this.illegalTraitValue(name, Float.toString(value));
        }
    }

    String toStringTrait(String name, float[][] value) {
        if ("x" == name || "y" == name || "width" == name || "height" == name) {
            return Float.toString(value[0][0]);
        }
        return super.toStringTrait(name, value);
    }

    Box addNodeBBox(Box bbox, Transform t) {
        return ImageNode.addTransformedBBox(bbox, this.x, this.y, this.width, this.height, t);
    }
}

