/*
 * Decompiled with CFR 0.152.
 */
package com.sun.perseus.model;

import com.sun.perseus.model.AnimateMotion;
import com.sun.perseus.model.Animation;
import com.sun.perseus.model.MotionSegment;
import com.sun.perseus.model.Segment;
import com.sun.perseus.platform.MathSupport;

final class LeafMotionSegment
implements MotionSegment {
    float[][] start;
    float[][] end;

    public LeafMotionSegment(LeafMotionSegment prevSegment, float x2, float y2, AnimateMotion motion) {
        this.start = prevSegment.end;
        this.end = new float[6][1];
        this.end[4][0] = x2;
        this.end[5][0] = y2;
        this.computeRotate(motion);
    }

    public LeafMotionSegment(float x1, float y1, float x2, float y2, AnimateMotion motion) {
        this.start = new float[6][1];
        this.end = new float[6][1];
        this.start[0][0] = 1.0f;
        this.start[3][0] = 1.0f;
        this.start[4][0] = x1;
        this.start[5][0] = y1;
        this.end[4][0] = x2;
        this.end[5][0] = y2;
        this.computeRotate(motion);
    }

    void computeRotate(AnimateMotion motion) {
        float cosRotate = motion.cosRotate;
        float sinRotate = motion.sinRotate;
        if (motion.rotateType != 1) {
            float dx = this.end[4][0] - this.start[4][0];
            float dy = this.end[5][0] - this.start[5][0];
            float theta = MathSupport.atan2(dy, dx);
            if (motion.rotateType == 3) {
                theta += (float)Math.PI;
            }
            cosRotate = MathSupport.cos(theta);
            sinRotate = MathSupport.sin(theta);
        }
        this.end[0][0] = cosRotate;
        this.end[1][0] = sinRotate;
        this.end[2][0] = -sinRotate;
        this.end[3][0] = cosRotate;
    }

    public Object[] getStart() {
        return this.start;
    }

    public Object[] getEnd() {
        return this.end;
    }

    public void compute(float p, float[][] w) {
        w[0][0] = this.end[0][0];
        w[1][0] = this.end[1][0];
        w[2][0] = this.end[2][0];
        w[3][0] = this.end[3][0];
        w[4][0] = p * this.end[4][0] + (1.0f - p) * this.start[4][0];
        w[5][0] = p * this.end[5][0] + (1.0f - p) * this.start[5][0];
    }

    public float getLength() {
        float dx = this.end[4][0] - this.start[4][0];
        float dy = this.end[5][0] - this.start[5][0];
        return MathSupport.sqrt(dx * dx + dy * dy);
    }

    public void collapse(Segment seg, Animation anim) {
        LeafMotionSegment mseg = (LeafMotionSegment)seg;
        this.end = mseg.end;
        this.computeRotate((AnimateMotion)anim);
    }

    public void addToEnd(Object[] by) {
        float[][] add = (float[][])by;
        float[][] tmpEnd = new float[6][1];
        tmpEnd[0][0] = this.end[0][0] * add[0][0] + this.end[2][0] * add[1][0];
        tmpEnd[1][0] = this.end[1][0] * add[0][0] + this.end[3][0] * add[1][0];
        tmpEnd[2][0] = this.end[0][0] * add[2][0] + this.end[2][0] * add[3][0];
        tmpEnd[3][0] = this.end[1][0] * add[2][0] + this.end[3][0] * add[3][0];
        tmpEnd[4][0] = this.end[0][0] * add[4][0] + this.end[2][0] * add[5][0] + this.end[4][0];
        tmpEnd[5][0] = this.end[1][0] * add[4][0] + this.end[3][0] * add[5][0] + this.end[5][0];
        this.end = tmpEnd;
    }

    public boolean isAdditive() {
        return true;
    }

    public void setZeroStart() {
        this.start[4][0] = 0.0f;
        this.start[5][0] = 0.0f;
    }

    public void setStart(Object[] newStart) {
        this.start = (float[][])newStart;
    }

    public void initialize() {
    }
}

