/*
 * Decompiled with CFR 0.152.
 */
package com.sun.perseus.model;

import com.sun.perseus.j2d.Box;
import com.sun.perseus.j2d.GraphicsProperties;
import com.sun.perseus.j2d.PathSupport;
import com.sun.perseus.j2d.RenderGraphics;
import com.sun.perseus.j2d.Transform;
import com.sun.perseus.model.AbstractShapeNode;
import com.sun.perseus.model.DocumentNode;
import com.sun.perseus.model.ElementNode;
import com.sun.perseus.model.FloatTraitAnim;
import com.sun.perseus.model.TraitAnim;
import org.w3c.dom.DOMException;

public class Line
extends AbstractShapeNode {
    protected float x1;
    protected float y1;
    protected float x2;
    protected float y2;

    public Line(DocumentNode ownerDocument) {
        super(ownerDocument);
    }

    public String getLocalName() {
        return "line";
    }

    public ElementNode newInstance(DocumentNode doc) {
        return new Line(doc);
    }

    public float getX1() {
        return this.x1;
    }

    public float getY1() {
        return this.y1;
    }

    public float getX2() {
        return this.x2;
    }

    public float getY2() {
        return this.y2;
    }

    public void setX1(float newX1) {
        if (newX1 == this.x1) {
            return;
        }
        this.modifyingNode();
        this.renderingDirty();
        this.x1 = newX1;
        this.modifiedNode();
    }

    public void setX2(float newX2) {
        if (newX2 == this.x2) {
            return;
        }
        this.modifyingNode();
        this.renderingDirty();
        this.x2 = newX2;
        this.modifiedNode();
    }

    public void setY1(float newY1) {
        if (newY1 == this.y1) {
            return;
        }
        this.modifyingNode();
        this.renderingDirty();
        this.y1 = newY1;
        this.modifiedNode();
    }

    public void setY2(float newY2) {
        if (newY2 == this.y2) {
            return;
        }
        this.modifyingNode();
        this.renderingDirty();
        this.y2 = newY2;
        this.modifiedNode();
    }

    public void fillShape(RenderGraphics rg) {
    }

    public void drawShape(RenderGraphics rg) {
        rg.drawLine(this.x1, this.y1, this.x2, this.y2);
    }

    public boolean contains(float x, float y, int fillRule) {
        return false;
    }

    Object getStrokedPath(GraphicsProperties gp) {
        return PathSupport.getStrokedLine(this.x1, this.y1, this.x2, this.y2, gp);
    }

    boolean supportsTrait(String traitName) {
        if ("x1".equals(traitName) || "x2".equals(traitName) || "y1".equals(traitName) || "y2".equals(traitName)) {
            return true;
        }
        return super.supportsTrait(traitName);
    }

    public String getTraitImpl(String name) throws DOMException {
        if ("x1" == name) {
            return Float.toString(this.x1);
        }
        if ("x2" == name) {
            return Float.toString(this.x2);
        }
        if ("y1" == name) {
            return Float.toString(this.y1);
        }
        if ("y2" == name) {
            return Float.toString(this.y2);
        }
        return super.getTraitImpl(name);
    }

    float getFloatTraitImpl(String name) throws DOMException {
        if ("x1" == name) {
            return this.x1;
        }
        if ("x2" == name) {
            return this.x2;
        }
        if ("y1" == name) {
            return this.y1;
        }
        if ("y2" == name) {
            return this.y2;
        }
        return super.getFloatTraitImpl(name);
    }

    TraitAnim createTraitAnimImpl(String traitName) {
        if ("x1" == traitName || "y1" == traitName || "x2" == traitName || "y2" == traitName) {
            return new FloatTraitAnim(this, traitName, "float");
        }
        return super.createTraitAnimImpl(traitName);
    }

    void setFloatArrayTrait(String name, float[][] value) throws DOMException {
        if ("x1" == name) {
            this.setX1(value[0][0]);
        } else if ("y1" == name) {
            this.setY1(value[0][0]);
        } else if ("x2" == name) {
            this.checkPositive(name, value[0][0]);
            this.setX2(value[0][0]);
        } else if ("y2" == name) {
            this.checkPositive(name, value[0][0]);
            this.setY2(value[0][0]);
        } else {
            super.setFloatArrayTrait(name, value);
        }
    }

    public float[][] validateFloatArrayTrait(String traitName, String value, String reqNamespaceURI, String reqLocalName, String reqTraitNamespace, String reqTraitName) throws DOMException {
        if ("x1" == traitName || "x2" == traitName || "y1" == traitName || "y2" == traitName) {
            return new float[][]{{this.parseFloatTrait(traitName, value)}};
        }
        return super.validateFloatArrayTrait(traitName, value, reqNamespaceURI, reqLocalName, reqTraitNamespace, reqTraitName);
    }

    public void setTraitImpl(String name, String value) throws DOMException {
        if ("x1" == name) {
            this.setX1(this.parseFloatTrait(name, value));
        } else if ("x2" == name) {
            this.setX2(this.parseFloatTrait(name, value));
        } else if ("y1" == name) {
            this.setY1(this.parseFloatTrait(name, value));
        } else if ("y2" == name) {
            this.setY2(this.parseFloatTrait(name, value));
        } else {
            super.setTraitImpl(name, value);
        }
    }

    public void setFloatTraitImpl(String name, float value) throws DOMException {
        if ("x1" == name) {
            this.setX1(value);
        } else if ("x2" == name) {
            this.setX2(value);
        } else if ("y1" == name) {
            this.setY1(value);
        } else if ("y2" == name) {
            this.setY2(value);
        } else {
            super.setFloatTraitImpl(name, value);
        }
    }

    String toStringTrait(String name, float[][] value) {
        if ("x1" == name || "x2" == name || "y1" == name || "y2" == name) {
            return Float.toString(value[0][0]);
        }
        return super.toStringTrait(name, value);
    }

    Box addNodeBBox(Box bbox, Transform t) {
        float x1 = this.x1;
        float x2 = this.x2;
        float y1 = this.y1;
        float y2 = this.y2;
        if (t != null) {
            x1 = t.getComponent(0) * this.x1 + t.getComponent(2) * this.y1 + t.getComponent(4);
            y1 = t.getComponent(1) * this.x1 + t.getComponent(3) * this.y1 + t.getComponent(5);
            x2 = t.getComponent(0) * this.x2 + t.getComponent(2) * this.y2 + t.getComponent(4);
            y2 = t.getComponent(1) * this.x2 + t.getComponent(3) * this.y2 + t.getComponent(5);
        }
        if (x1 > x2) {
            float x = x2;
            x2 = x1;
            x1 = x;
        }
        if (y1 > y2) {
            float y = y2;
            y2 = y1;
            y1 = y;
        }
        return Line.addBBox(bbox, x1, y1, x2 - x1, y2 - y1);
    }
}

