/*
 * Decompiled with CFR 0.152.
 */
package com.sun.perseus.model;

import com.sun.perseus.j2d.Path;
import com.sun.perseus.model.AbstractAnimate;
import com.sun.perseus.model.AnimateMotion;
import com.sun.perseus.model.Animation;
import com.sun.perseus.model.CompositeMotionSegment;
import com.sun.perseus.model.ElementNode;
import com.sun.perseus.model.LeafMotionSegment;
import com.sun.perseus.model.MotionRefValues;
import com.sun.perseus.model.MotionSegment;
import com.sun.perseus.model.RefValues;
import com.sun.perseus.model.TransformTraitAnim;
import java.util.Vector;
import org.w3c.dom.DOMException;

class MotionTraitAnim
extends TransformTraitAnim {
    public MotionTraitAnim(ElementNode targetElement, String traitName) {
        super(targetElement, traitName);
    }

    RefValues toRefValues(Animation anim, String[] values, String reqTraitNamespace, String reqTraitName) throws DOMException {
        AnimateMotion motion = (AnimateMotion)anim;
        MotionRefValues refValues = new MotionRefValues(motion);
        if (values.length < 1) {
            throw new IllegalArgumentException();
        }
        if (!"path".equals(reqTraitName) && !"d".equals(reqTraitName)) {
            if (values.length == 1) {
                String[] tmpValues = new String[]{values[0], values[0]};
                values = tmpValues;
            }
            int nSegments = values.length - 1;
            refValues.segments = new MotionSegment[nSegments];
            float[] startPt = new float[2];
            float[] endPt = new float[2];
            this.validateCoordinate(anim, reqTraitNamespace, reqTraitName, values[0], startPt);
            this.validateCoordinate(anim, reqTraitNamespace, reqTraitName, values[1], endPt);
            refValues.segments[0] = new LeafMotionSegment(startPt[0], startPt[1], endPt[0], endPt[1], motion);
            for (int i = 1; i < nSegments; ++i) {
                this.validateCoordinate(anim, reqTraitNamespace, reqTraitNamespace, values[i + 1], endPt);
                refValues.segments[i] = new LeafMotionSegment((LeafMotionSegment)refValues.segments[i - 1], endPt[0], endPt[1], motion);
            }
        } else {
            Path path = anim.parsePathTrait(anim.traitName, values[0]);
            short type = 0;
            float[] coords = new float[6];
            float[] curPos = new float[2];
            float[] endPos = new float[2];
            float[][] curve = new float[4][2];
            float[] lastMove = new float[2];
            Vector<LeafMotionSegment> segments = new Vector<LeafMotionSegment>();
            Vector curves = new Vector();
            LeafMotionSegment prevSegment = null;
            int nSegments = path.getNumberOfSegments();
            block7: for (int i = 0; i < nSegments; ++i) {
                type = path.getSegment(i);
                switch (type) {
                    case 77: {
                        curPos[0] = path.getSegmentParam(i, 0);
                        curPos[1] = path.getSegmentParam(i, 1);
                        lastMove[0] = curPos[0];
                        lastMove[1] = curPos[1];
                        continue block7;
                    }
                    case 76: {
                        prevSegment = prevSegment == null ? new LeafMotionSegment(curPos[0], curPos[1], path.getSegmentParam(i, 0), path.getSegmentParam(i, 1), motion) : new LeafMotionSegment(prevSegment, path.getSegmentParam(i, 0), path.getSegmentParam(i, 1), motion);
                        segments.addElement(prevSegment);
                        curPos[0] = path.getSegmentParam(i, 0);
                        curPos[1] = path.getSegmentParam(i, 1);
                        continue block7;
                    }
                    case 81: {
                        curve[0][0] = curPos[0];
                        curve[0][1] = curPos[1];
                        curve[1][0] = path.getSegmentParam(i, 0);
                        curve[1][1] = path.getSegmentParam(i, 1);
                        curve[2][0] = path.getSegmentParam(i, 0);
                        curve[2][1] = path.getSegmentParam(i, 1);
                        curve[3][0] = path.getSegmentParam(i, 2);
                        curve[3][1] = path.getSegmentParam(i, 3);
                        prevSegment = this.addCubicSegment(motion, curve, segments, curves, prevSegment);
                        curPos[0] = path.getSegmentParam(i, 2);
                        curPos[1] = path.getSegmentParam(i, 3);
                        continue block7;
                    }
                    case 67: {
                        curve[0][0] = curPos[0];
                        curve[0][1] = curPos[1];
                        curve[1][0] = path.getSegmentParam(i, 0);
                        curve[1][1] = path.getSegmentParam(i, 1);
                        curve[2][0] = path.getSegmentParam(i, 2);
                        curve[2][1] = path.getSegmentParam(i, 3);
                        curve[3][0] = path.getSegmentParam(i, 4);
                        curve[3][1] = path.getSegmentParam(i, 5);
                        prevSegment = this.addCubicSegment(motion, curve, segments, curves, prevSegment);
                        curPos[0] = path.getSegmentParam(i, 4);
                        curPos[1] = path.getSegmentParam(i, 5);
                        continue block7;
                    }
                    default: {
                        prevSegment = prevSegment == null ? new LeafMotionSegment(curPos[0], curPos[1], lastMove[0], lastMove[1], motion) : new LeafMotionSegment(prevSegment, lastMove[0], lastMove[1], motion);
                        segments.addElement(prevSegment);
                        curPos[0] = lastMove[0];
                        curPos[1] = lastMove[1];
                    }
                }
            }
            if (segments.size() == 0) {
                segments.addElement(new LeafMotionSegment(curPos[0], curPos[1], curPos[0], curPos[1], motion));
            }
            refValues.segments = new MotionSegment[segments.size()];
            segments.copyInto(refValues.segments);
        }
        return refValues;
    }

    LeafMotionSegment addCubicSegment(AnimateMotion motion, float[][] curve, Vector segments, Vector motionCoords, LeafMotionSegment prevSegment) {
        motionCoords.removeAllElements();
        motionCoords.addElement(new float[]{curve[0][0], curve[0][1]});
        AbstractAnimate.toRefSpline(curve, motionCoords);
        int nPoints = motionCoords.size();
        float[] curPos = (float[])motionCoords.elementAt(0);
        LeafMotionSegment[] subSegments = new LeafMotionSegment[nPoints - 1];
        if (nPoints > 1) {
            float[] endPos = (float[])motionCoords.elementAt(1);
            subSegments[0] = prevSegment == null ? new LeafMotionSegment(curPos[0], curPos[1], endPos[0], endPos[1], motion) : new LeafMotionSegment(prevSegment, endPos[0], endPos[1], motion);
            curPos = endPos;
            prevSegment = subSegments[0];
        }
        for (int i = 2; i < nPoints; ++i) {
            float[] endPos = (float[])motionCoords.elementAt(i);
            subSegments[i - 1] = new LeafMotionSegment(prevSegment, endPos[0], endPos[1], motion);
            curPos = endPos;
            prevSegment = subSegments[i - 1];
        }
        CompositeMotionSegment cSeg = new CompositeMotionSegment();
        cSeg.segments = subSegments;
        segments.addElement(cSeg);
        return prevSegment;
    }

    public void validateCoordinate(Animation anim, String traitNamespace, String traitName, String value, float[] pt) throws DOMException {
        float[] v = anim.parseFloatArrayTrait(traitName, value);
        if (v.length < 1 || v.length > 2) {
            throw anim.illegalTraitValue(traitName, value);
        }
        pt[0] = v[0];
        pt[1] = v.length > 1 ? v[1] : v[0];
    }
}

