/*
 * Decompiled with CFR 0.152.
 */
package com.sun.perseus.model;

import com.sun.perseus.j2d.Box;
import com.sun.perseus.j2d.GraphicsProperties;
import com.sun.perseus.j2d.PathSupport;
import com.sun.perseus.j2d.RenderGraphics;
import com.sun.perseus.j2d.Transform;
import com.sun.perseus.model.AbstractShapeNode;
import com.sun.perseus.model.DocumentNode;
import com.sun.perseus.model.ElementNode;
import com.sun.perseus.model.FloatTraitAnim;
import com.sun.perseus.model.TraitAnim;
import org.w3c.dom.DOMException;

public class Rect
extends AbstractShapeNode {
    static final String[] REQUIRED_TRAITS = new String[]{"width", "height"};
    protected float width = 0.0f;
    protected float height = 0.0f;
    protected float x = 0.0f;
    protected float y = 0.0f;
    protected float aw = 0.0f;
    protected float ah = 0.0f;

    public Rect(DocumentNode ownerDocument) {
        super(ownerDocument);
        this.canRenderState |= 0x40;
        this.canRenderState |= 0x80;
    }

    public String getLocalName() {
        return "rect";
    }

    public ElementNode newInstance(DocumentNode doc) {
        return new Rect(doc);
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public float getWidth() {
        return this.width;
    }

    public float getHeight() {
        return this.height;
    }

    public float getRx() {
        return this.aw / 2.0f;
    }

    public float getRy() {
        return this.ah / 2.0f;
    }

    public void setX(float x) {
        if (this.x == x) {
            return;
        }
        this.modifyingNode();
        this.renderingDirty();
        this.x = x;
        this.modifiedNode();
    }

    public void setY(float y) {
        if (this.y == y) {
            return;
        }
        this.modifyingNode();
        this.renderingDirty();
        this.y = y;
        this.modifiedNode();
    }

    public void setWidth(float width) {
        if (width < 0.0f) {
            throw new IllegalArgumentException();
        }
        if (this.width == width) {
            return;
        }
        this.modifyingNode();
        this.renderingDirty();
        this.width = width;
        this.computeCanRenderWidthBit(width);
        this.modifiedNode();
    }

    public void setHeight(float height) {
        if (height < 0.0f) {
            throw new IllegalArgumentException();
        }
        if (this.height == height) {
            return;
        }
        this.modifyingNode();
        this.renderingDirty();
        this.height = height;
        this.computeCanRenderHeightBit(height);
        this.modifiedNode();
    }

    public void setRx(float rx) {
        if (rx < 0.0f) {
            throw new IllegalArgumentException();
        }
        if (2.0f * rx == this.aw) {
            return;
        }
        this.modifyingNode();
        this.renderingDirty();
        this.aw = rx > 0.0f ? 2.0f * rx : 0.0f;
        this.modifiedNode();
    }

    public void setRy(float ry) {
        if (ry < 0.0f) {
            throw new IllegalArgumentException();
        }
        if (2.0f * ry == this.ah) {
            return;
        }
        this.modifyingNode();
        this.renderingDirty();
        this.ah = ry > 0.0f ? 2.0f * ry : 0.0f;
        this.modifiedNode();
    }

    public void setRect(float x, float y, float width, float height) {
        if (width < 0.0f || height < 0.0f) {
            throw new IllegalArgumentException();
        }
        if (this.x == x && this.y == y && this.width == width && this.height == height) {
            return;
        }
        this.modifyingNode();
        this.renderingDirty();
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.computeCanRenderWidthBit(width);
        this.computeCanRenderHeightBit(height);
        this.modifiedNode();
    }

    public void fillShape(RenderGraphics rg) {
        rg.fillRect(this.x, this.y, this.width, this.height, this.aw, this.ah);
    }

    public void drawShape(RenderGraphics rg) {
        rg.drawRect(this.x, this.y, this.width, this.height, this.aw, this.ah);
    }

    public boolean contains(float x, float y, int fillRule) {
        float f;
        float f2;
        if (this.aw == 0.0f && this.ah == 0.0f) {
            return x >= this.x && y >= this.y && x < this.x + this.width && y < this.y + this.height;
        }
        float rrx0 = this.x;
        float rry0 = this.y;
        float rrx1 = rrx0 + this.width;
        float rry1 = rry0 + this.height;
        if (x < rrx0 || y < rry0 || x >= rrx1 || y >= rry1) {
            return false;
        }
        float aw = Math.min(this.width, this.aw) / 2.0f;
        float ah = Math.min(this.height, this.ah) / 2.0f;
        rrx0 += aw;
        if (x >= f2) {
            float f3;
            rrx0 = rrx1 - aw;
            if (x < f3) {
                return true;
            }
        }
        rry0 += ah;
        if (y >= f) {
            float f4;
            rry0 = rry1 - ah;
            if (y < f4) {
                return true;
            }
        }
        return (double)((x = (x - rrx0) / aw) * x + (y = (y - rry0) / ah) * y) <= 1.0;
    }

    Object getStrokedPath(GraphicsProperties gp) {
        if (this.aw > 0.0f || this.ah > 0.0f) {
            return PathSupport.getStrokedRect(this.x, this.y, this.width, this.height, this.aw, this.ah, gp);
        }
        return PathSupport.getStrokedRect(this.x, this.y, this.width, this.height, gp);
    }

    boolean supportsTrait(String traitName) {
        if ("x" == traitName || "y" == traitName || "rx" == traitName || "ry" == traitName || "width" == traitName || "height" == traitName) {
            return true;
        }
        return super.supportsTrait(traitName);
    }

    public String[] getRequiredTraits() {
        return REQUIRED_TRAITS;
    }

    public String[][] getTraitAliases() {
        return new String[][]{{"rx", "ry"}, {"ry", "rx"}};
    }

    TraitAnim createTraitAnimImpl(String traitName) {
        if ("x" == traitName || "y" == traitName || "rx" == traitName || "ry" == traitName || "width" == traitName || "height" == traitName) {
            return new FloatTraitAnim(this, traitName, "float");
        }
        return super.createTraitAnimImpl(traitName);
    }

    public String getTraitImpl(String name) throws DOMException {
        if ("x" == name) {
            return Float.toString(this.x);
        }
        if ("y" == name) {
            return Float.toString(this.y);
        }
        if ("rx" == name) {
            return Float.toString(this.aw / 2.0f);
        }
        if ("ry" == name) {
            return Float.toString(this.ah / 2.0f);
        }
        if ("width" == name) {
            return Float.toString(this.width);
        }
        if ("height" == name) {
            return Float.toString(this.height);
        }
        return super.getTraitImpl(name);
    }

    float getFloatTraitImpl(String name) throws DOMException {
        if ("x" == name) {
            return this.x;
        }
        if ("y" == name) {
            return this.y;
        }
        if ("rx" == name) {
            return this.aw / 2.0f;
        }
        if ("ry" == name) {
            return this.ah / 2.0f;
        }
        if ("width" == name) {
            return this.width;
        }
        if ("height" == name) {
            return this.height;
        }
        return super.getFloatTraitImpl(name);
    }

    public float[][] validateFloatArrayTrait(String traitName, String value, String reqNamespaceURI, String reqLocalName, String reqTraitNamespace, String reqTraitName) throws DOMException {
        if ("x" == traitName || "y" == traitName) {
            return new float[][]{{this.parseFloatTrait(traitName, value)}};
        }
        if ("rx" == traitName || "ry" == traitName || "width" == traitName || "height" == traitName) {
            return new float[][]{{this.parsePositiveFloatTrait(traitName, value)}};
        }
        return super.validateFloatArrayTrait(traitName, value, reqNamespaceURI, reqLocalName, reqTraitNamespace, reqTraitName);
    }

    public void setTraitImpl(String name, String value) throws DOMException {
        if ("x" == name) {
            this.setX(this.parseFloatTrait(name, value));
        } else if ("y" == name) {
            this.setY(this.parseFloatTrait(name, value));
        } else if ("rx" == name) {
            this.setRx(this.parsePositiveFloatTrait(name, value));
        } else if ("ry" == name) {
            this.setRy(this.parsePositiveFloatTrait(name, value));
        } else if ("width" == name) {
            this.setWidth(this.parsePositiveFloatTrait(name, value));
        } else if ("height" == name) {
            this.setHeight(this.parsePositiveFloatTrait(name, value));
        } else {
            super.setTraitImpl(name, value);
        }
    }

    public void setFloatTraitImpl(String name, float value) throws DOMException {
        if ("x" == name) {
            this.setX(value);
        } else if ("y" == name) {
            this.setY(value);
        } else if ("rx" == name) {
            this.checkPositive(name, value);
            this.setRx(value);
        } else if ("ry" == name) {
            this.checkPositive(name, value);
            this.setRy(value);
        } else if ("width" == name) {
            this.checkPositive(name, value);
            this.setWidth(value);
        } else if ("height" == name) {
            this.checkPositive(name, value);
            this.setHeight(value);
        } else {
            super.setFloatTraitImpl(name, value);
        }
    }

    String toStringTrait(String name, float[][] value) {
        if ("x" == name || "y" == name || "rx" == name || "ry" == name || "width" == name || "height" == name) {
            return Float.toString(value[0][0]);
        }
        return super.toStringTrait(name, value);
    }

    void setFloatArrayTrait(String name, float[][] value) throws DOMException {
        if ("x" == name) {
            this.setX(value[0][0]);
        } else if ("y" == name) {
            this.setY(value[0][0]);
        } else if ("rx" == name) {
            this.checkPositive(name, value[0][0]);
            this.setRx(value[0][0]);
        } else if ("ry" == name) {
            this.checkPositive(name, value[0][0]);
            this.setRy(value[0][0]);
        } else if ("width" == name) {
            this.checkPositive(name, value[0][0]);
            this.setWidth(value[0][0]);
        } else if ("height" == name) {
            this.checkPositive(name, value[0][0]);
            this.setHeight(value[0][0]);
        } else {
            super.setFloatArrayTrait(name, value);
        }
    }

    Box addNodeBBox(Box bbox, Transform t) {
        return Rect.addTransformedBBox(bbox, this.x, this.y, this.width, this.height, t);
    }
}

